/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.ygm76.entity;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.pitan76.mcpitanlib.api.entity.CompatThrownItemEntity;
import net.pitan76.mcpitanlib.api.event.entity.CollisionEvent;
import net.pitan76.mcpitanlib.api.event.entity.EntityHitEvent;
import net.pitan76.mcpitanlib.api.util.EntityUtil;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.ParticleEffectUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.ygm76.entity.YGEntityType;
import net.pitan76.ygm76.item.YGItems;
import net.pitan76.ygm76.item.base.GunItem;

public class BulletEntity
extends CompatThrownItemEntity {
    public GunItem item;
    public float addedDamage = 0.0f;
    public LivingEntity owner;

    public BulletEntity(Level world, LivingEntity owner, GunItem item) {
        super((EntityType)YGEntityType.BULLET_ENTITY.get(), owner, world);
        this.item = item;
        this.owner = owner;
    }

    public BulletEntity(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    private ParticleOptions getParticleParameters() {
        ItemStack itemStack = this.callGetItem();
        return ParticleEffectUtil.itemStack.createTypedItem(ItemStackUtil.isEmpty((ItemStack)itemStack) ? ItemStackUtil.create((Item)this.getDefaultItemOverride()) : itemStack);
    }

    public void callHandleStatus(byte status) {
        if (status == 3) {
            ParticleOptions particleEffect = this.getParticleParameters();
            for (int i = 0; i < 8; ++i) {
                WorldUtil.addParticle((Level)EntityUtil.getWorld((Entity)this), (ParticleOptions)particleEffect, (double)this.getX(), (double)this.getY(), (double)this.getZ(), (double)0.0, (double)0.0, (double)0.0);
            }
        }
    }

    public void onEntityHit(EntityHitEvent e) {
        super.onEntityHit(e);
        Entity entity = e.getEntity();
        if (this.item == null) {
            return;
        }
        EntityUtil.damageWithThrownProjectile((Entity)entity, (float)(this.item.getShootDamage() + this.getAddedDamage()), (Entity)this, (Entity)(this.owner == null ? this : this.owner));
    }

    public float getAddedDamage() {
        return this.addedDamage;
    }

    public void setAddedDamage(float addedDamage) {
        this.addedDamage = addedDamage;
    }

    public void onCollision(CollisionEvent e) {
        super.onCollision(e);
        Level world = EntityUtil.getWorld((Entity)this);
        if (world != null && !WorldUtil.isClient((Level)world)) {
            WorldUtil.sendEntityStatus((Level)world, (Entity)this, (byte)3);
            try {
                EntityUtil.discard((Entity)this);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public Item getDefaultItemOverride() {
        return (Item)YGItems.BULLET_ITEM.get();
    }
}

