/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.ygm76.item.base;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.pitan76.mcpitanlib.api.entity.CompatThrownItemEntity;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.event.item.ItemBarStepArgs;
import net.pitan76.mcpitanlib.api.event.item.ItemBarVisibleArgs;
import net.pitan76.mcpitanlib.api.event.item.ItemUseEvent;
import net.pitan76.mcpitanlib.api.item.v2.CompatItem;
import net.pitan76.mcpitanlib.api.item.v2.CompatibleItemSettings;
import net.pitan76.mcpitanlib.api.sound.CompatSoundCategory;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvent;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvents;
import net.pitan76.mcpitanlib.api.util.CustomDataUtil;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.NbtUtil;
import net.pitan76.mcpitanlib.api.util.StackActionResult;
import net.pitan76.mcpitanlib.api.util.TimerUtil;
import net.pitan76.mcpitanlib.api.util.WorldRandomUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.api.util.entity.ThrownItemEntityUtil;
import net.pitan76.ygm76.entity.BulletEntity;
import net.pitan76.ygm76.fix.NbtFixer;
import net.pitan76.ygm76.item.YGItems;

public abstract class GunItem
extends CompatItem {
    public GunItem(CompatibleItemSettings settings) {
        super(settings);
    }

    public int getMaxBulletCount() {
        return 5;
    }

    public int getShootTick() {
        return 60;
    }

    public float getShootSpeed() {
        return 5.0f;
    }

    public int getReloadTick() {
        return 60;
    }

    public float getShootDamage() {
        return 1.0f;
    }

    public float getRightShootDamage() {
        return 5.0f;
    }

    public float getShootDivergence() {
        return 1.0f;
    }

    public float getShootRoll() {
        return 0.0f;
    }

    public static int getBulletCount(ItemStack stack) {
        if (stack == null || !(stack.m_41720_() instanceof GunItem)) {
            return 0;
        }
        return NbtUtil.getIntOrDefault((CompoundTag)CustomDataUtil.getOrCreateNbt((ItemStack)stack), (String)"bullet", (int)0);
    }

    public static void setBulletCount(ItemStack stack, int count) {
        if (stack == null || !(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        CustomDataUtil.set((ItemStack)stack, (String)"bullet", (Object)count);
    }

    public static void increaseBulletCount(ItemStack stack, int count) {
        GunItem.setBulletCount(stack, GunItem.getBulletCount(stack) + count);
    }

    public static void decreaseBulletCount(ItemStack stack, int count) {
        GunItem.setBulletCount(stack, GunItem.getBulletCount(stack) - count);
    }

    public static void increaseBulletCount(ItemStack stack) {
        GunItem.increaseBulletCount(stack, 1);
    }

    public static void decreaseBulletCount(ItemStack stack) {
        GunItem.decreaseBulletCount(stack, 1);
    }

    public static boolean isBulletCountEmpty(ItemStack stack) {
        return GunItem.getBulletCount(stack) == 0;
    }

    public Item getBulletItem() {
        return (Item)YGItems.BULLET_ITEM.get();
    }

    public void playSoundWithTimer(Player player, CompatSoundEvent soundEvent, float volume, float pitch, int ticks) {
        if (player.isClient()) {
            return;
        }
        TimerUtil.addTimer((ServerLevel)((ServerLevel)player.getWorld()), (long)ticks, () -> {
            net.pitan76.mcpitanlib.midohra.util.math.BlockPos $pos = net.pitan76.mcpitanlib.midohra.util.math.BlockPos.of((BlockPos)player.getBlockPos());
            player.getMidohraWorld().playSound($pos, soundEvent, CompatSoundCategory.NEUTRAL, volume, pitch);
            return true;
        });
    }

    public void playSoundOnReload(Player player) {
        this.playSoundWithTimer(player, CompatSoundEvents.ITEM_FLINTANDSTEEL_USE, 1.0f, 1.0f, 4);
        this.playSoundWithTimer(player, CompatSoundEvents.BLOCK_IRON_DOOR_OPEN, 1.0f, 2.0f, 6);
        this.playSoundWithTimer(player, CompatSoundEvents.ITEM_FLINTANDSTEEL_USE, 1.0f, 1.0f, 16);
        this.playSoundWithTimer(player, CompatSoundEvents.ENTITY_PLAYER_HURT, 1.0f, 0.0f, 17);
        this.playSoundWithTimer(player, CompatSoundEvents.BLOCK_IRON_DOOR_CLOSE, 1.0f, 2.0f, this.getReloadTick());
    }

    public void reload(ItemStack stack, Player player) {
        if (this.getMaxBulletCount() == GunItem.getBulletCount(stack)) {
            return;
        }
        if (player.getInventory().m_36063_(ItemStackUtil.create((Item)this.getBulletItem()))) {
            int $usableCount;
            this.playSoundOnReload(player);
            player.getItemCooldown().set((Item)this, this.getReloadTick());
            int $bulletCount = 0;
            ArrayList<ItemStack> $bulletList = new ArrayList<ItemStack>();
            ArrayList<ItemStack> $list = new ArrayList<ItemStack>((Collection<ItemStack>)player.getMain());
            $list.add(player.getMainHandStack());
            $list.add(player.getOffHandStack());
            for (ItemStack $invStack : $list) {
                if (!ItemStackUtil.getItem((ItemStack)$invStack).equals(this.getBulletItem())) continue;
                $bulletCount += ItemStackUtil.getCount((ItemStack)$invStack);
                $bulletList.add($invStack);
            }
            int $c = $usableCount = Math.min(this.getMaxBulletCount() - GunItem.getBulletCount(stack), $bulletCount);
            for (ItemStack $invStack : $bulletList) {
                if ($c == 0) break;
                int $r = Math.min($c, $invStack.m_41613_());
                ItemStackUtil.decrementCount((ItemStack)$invStack, (int)$r);
                $c -= $r;
            }
            GunItem.increaseBulletCount(stack, $usableCount);
        }
    }

    public void playSoundOnShoot(Player player) {
        if (player.isClient()) {
            return;
        }
        net.pitan76.mcpitanlib.midohra.util.math.BlockPos $pos = net.pitan76.mcpitanlib.midohra.util.math.BlockPos.of((BlockPos)player.getBlockPos());
        player.getMidohraWorld().playSound($pos, CompatSoundEvents.ENTITY_ZOMBIE_ATTACK_WOODEN_DOOR, CompatSoundCategory.NEUTRAL, 0.5f, 0.3f / (WorldRandomUtil.nextFloat((Level)player.getWorld()) * 0.4f + 0.8f));
    }

    public void playSoundOnRightShoot(Player player) {
        if (player.isClient()) {
            return;
        }
        net.pitan76.mcpitanlib.midohra.util.math.BlockPos $pos = net.pitan76.mcpitanlib.midohra.util.math.BlockPos.of((BlockPos)player.getBlockPos());
        player.getMidohraWorld().playSound($pos, CompatSoundEvents.ENTITY_ZOMBIE_ATTACK_WOODEN_DOOR, CompatSoundCategory.NEUTRAL, 0.5f, 0.3f / (WorldRandomUtil.nextFloat((Level)player.getWorld()) * 0.4f + 0.8f));
    }

    public void onLeftClick(Player $user, InteractionHand hand) {
        ItemStack $stack = $user.getStackInHand(hand);
        if (!ItemStackUtil.getItem((ItemStack)$stack).equals((Object)this)) {
            return;
        }
        Level $world = $user.getWorld();
        if (GunItem.isBulletCountEmpty($stack)) {
            this.reload($stack, $user);
            return;
        }
        if (!$user.isClient()) {
            CompoundTag nbt = NbtUtil.create();
            if (CustomDataUtil.hasNbt((ItemStack)$stack) && NbtUtil.has((CompoundTag)(nbt = CustomDataUtil.getNbt((ItemStack)$stack)), (String)"canUse") && !NbtUtil.getBoolean((CompoundTag)nbt, (String)"canUse")) {
                return;
            }
            NbtUtil.putBoolean((CompoundTag)nbt, (String)"canUse", (boolean)false);
            int $c = ItemStackUtil.getCount((ItemStack)$stack);
            ItemStackUtil.setCount((ItemStack)$stack, (int)0);
            CustomDataUtil.setNbt((ItemStack)$stack, (CompoundTag)nbt);
            ItemStackUtil.setCount((ItemStack)$stack, (int)$c);
            TimerUtil.addTimer((ServerLevel)((ServerLevel)$world), (long)this.getShootTick(), () -> {
                CompoundTag nbt2 = CustomDataUtil.getNbt((ItemStack)$stack);
                NbtUtil.putBoolean((CompoundTag)nbt2, (String)"canUse", (boolean)true);
                ItemStackUtil.setCount((ItemStack)$stack, (int)0);
                CustomDataUtil.setNbt((ItemStack)$stack, (CompoundTag)nbt2);
                ItemStackUtil.setCount((ItemStack)$stack, (int)$c);
                return true;
            });
            this.playSoundOnShoot($user);
            this.shoot($user, $stack);
        }
        $user.incrementStat(Stats.f_12982_, (Object)this);
    }

    public StackActionResult onRightClick(ItemUseEvent e) {
        Player $user = e.user;
        Level $world = e.world;
        ItemStack $stack = $user.getStackInHand(e.hand);
        NbtFixer.fix($stack);
        if (!this.isEnabledRightShoot()) {
            return e.fail();
        }
        if (GunItem.isBulletCountEmpty($stack)) {
            this.reload($stack, $user);
            return e.fail();
        }
        if (!e.isClient()) {
            CompoundTag nbt = NbtUtil.create();
            if (CustomDataUtil.hasNbt((ItemStack)$stack) && NbtUtil.has((CompoundTag)(nbt = CustomDataUtil.getNbt((ItemStack)$stack)), (String)"canUse") && !NbtUtil.getBoolean((CompoundTag)nbt, (String)"canUse")) {
                return e.fail();
            }
            NbtUtil.set((CompoundTag)nbt, (String)"canUse", (Object)false);
            int $c = ItemStackUtil.getCount((ItemStack)$stack);
            ItemStackUtil.setCount((ItemStack)$stack, (int)0);
            CustomDataUtil.setNbt((ItemStack)$stack, (CompoundTag)nbt);
            ItemStackUtil.setCount((ItemStack)$stack, (int)$c);
            TimerUtil.addTimer((ServerLevel)((ServerLevel)$world), (long)this.getShootTick(), () -> {
                CompoundTag nbt2 = CustomDataUtil.getNbt((ItemStack)$stack);
                NbtUtil.set((CompoundTag)nbt2, (String)"canUse", (Object)true);
                ItemStackUtil.setCount((ItemStack)$stack, (int)0);
                CustomDataUtil.setNbt((ItemStack)$stack, (CompoundTag)nbt2);
                ItemStackUtil.setCount((ItemStack)$stack, (int)$c);
                return true;
            });
            this.playSoundOnRightShoot($user);
            this.shootRight($user, $stack);
        }
        $user.incrementStat(Stats.f_12982_, (Object)this);
        return e.success();
    }

    public boolean isEnabledRightShoot() {
        return true;
    }

    public void shoot(Player $user, ItemStack $stack) {
        Level $world = $user.getWorld();
        BulletEntity bulletEntity = new BulletEntity($world, (LivingEntity)$user.getEntity(), this);
        ThrownItemEntityUtil.setItem((ThrowableItemProjectile)bulletEntity, (ItemStack)ItemStackUtil.create((Item)((Item)YGItems.BULLET_ITEM.get())));
        ThrownItemEntityUtil.setVelocity((CompatThrownItemEntity)bulletEntity, (Entity)$user.getEntity(), (float)$user.getPitch(), (float)$user.getYaw(), (float)this.getShootRoll(), (float)this.getShootSpeed(), (float)this.getShootDivergence());
        GunItem.decreaseBulletCount($stack);
        WorldUtil.spawnEntity((Level)$world, (Entity)bulletEntity);
    }

    public void shootRight(Player $user, ItemStack $stack) {
        if (!this.isEnabledRightShoot()) {
            return;
        }
        Level $world = $user.getWorld();
        BulletEntity bulletEntity = new BulletEntity($world, (LivingEntity)$user.getEntity(), this);
        ThrownItemEntityUtil.setItem((ThrowableItemProjectile)bulletEntity, (ItemStack)ItemStackUtil.create((Item)((Item)YGItems.BULLET_ITEM.get())));
        ThrownItemEntityUtil.setVelocity((CompatThrownItemEntity)bulletEntity, (Entity)$user.getEntity(), (float)$user.getPitch(), (float)$user.getYaw(), (float)this.getShootRoll(), (float)this.getShootSpeed(), (float)this.getShootDivergence());
        bulletEntity.setAddedDamage(this.getRightShootDamage());
        GunItem.decreaseBulletCount($stack);
        WorldUtil.spawnEntity((Level)$world, (Entity)bulletEntity);
    }

    public int getItemBarStep(ItemBarStepArgs args) {
        return Math.round((float)GunItem.getBulletCount(args.getStack()) * 13.0f / (float)this.getMaxBulletCount());
    }

    public boolean isItemBarVisible(ItemBarVisibleArgs args) {
        return CustomDataUtil.hasNbt((ItemStack)args.getStack());
    }
}

