/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.ygm76.item.base;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3468;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.event.item.ItemBarStepArgs;
import net.pitan76.mcpitanlib.api.event.item.ItemBarVisibleArgs;
import net.pitan76.mcpitanlib.api.event.item.ItemUseEvent;
import net.pitan76.mcpitanlib.api.item.v2.CompatItem;
import net.pitan76.mcpitanlib.api.item.v2.CompatibleItemSettings;
import net.pitan76.mcpitanlib.api.sound.CompatSoundCategory;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvent;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvents;
import net.pitan76.mcpitanlib.api.util.CustomDataUtil;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.NbtUtil;
import net.pitan76.mcpitanlib.api.util.StackActionResult;
import net.pitan76.mcpitanlib.api.util.TimerUtil;
import net.pitan76.mcpitanlib.api.util.WorldRandomUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.midohra.util.math.BlockPos;
import net.pitan76.ygm76.entity.BulletEntity;
import net.pitan76.ygm76.fix.NbtFixer;
import net.pitan76.ygm76.item.YGItems;

public abstract class GunItem
extends CompatItem {
    public GunItem(CompatibleItemSettings settings) {
        super(settings);
    }

    public int getMaxBulletCount() {
        return 5;
    }

    public int getShootTick() {
        return 60;
    }

    public float getShootSpeed() {
        return 5.0f;
    }

    public int getReloadTick() {
        return 60;
    }

    public float getShootDamage() {
        return 1.0f;
    }

    public float getRightShootDamage() {
        return 5.0f;
    }

    public float getShootDivergence() {
        return 1.0f;
    }

    public float getShootRoll() {
        return 0.0f;
    }

    public static int getBulletCount(class_1799 stack) {
        if (!(stack != null && stack.method_7909() instanceof GunItem && CustomDataUtil.hasNbt((class_1799)stack) && CustomDataUtil.contains((class_1799)stack, (String)"bullet"))) {
            return 0;
        }
        return NbtUtil.getInt((class_2487)CustomDataUtil.getNbt((class_1799)stack), (String)"bullet");
    }

    public static void setBulletCount(class_1799 stack, int count) {
        if (stack == null || !(stack.method_7909() instanceof GunItem)) {
            return;
        }
        CustomDataUtil.set((class_1799)stack, (String)"bullet", (Object)count);
    }

    public static void increaseBulletCount(class_1799 stack, int count) {
        GunItem.setBulletCount(stack, GunItem.getBulletCount(stack) + count);
    }

    public static void decreaseBulletCount(class_1799 stack, int count) {
        GunItem.setBulletCount(stack, GunItem.getBulletCount(stack) - count);
    }

    public static void increaseBulletCount(class_1799 stack) {
        GunItem.increaseBulletCount(stack, 1);
    }

    public static void decreaseBulletCount(class_1799 stack) {
        GunItem.decreaseBulletCount(stack, 1);
    }

    public static boolean isBulletCountEmpty(class_1799 stack) {
        return GunItem.getBulletCount(stack) == 0;
    }

    public class_1792 getBulletItem() {
        return (class_1792)YGItems.BULLET_ITEM.get();
    }

    public void playSoundWithTimer(Player player, CompatSoundEvent soundEvent, float volume, float pitch, int ticks) {
        if (player.isClient()) {
            return;
        }
        TimerUtil.addTimer((class_3218)((class_3218)player.getWorld()), (long)ticks, () -> {
            BlockPos $pos = BlockPos.of((class_2338)player.getBlockPos());
            player.getMidohraWorld().playSound($pos, soundEvent, CompatSoundCategory.NEUTRAL, volume, pitch);
            return true;
        });
    }

    public void playSoundOnReload(Player player) {
        this.playSoundWithTimer(player, CompatSoundEvents.ITEM_FLINTANDSTEEL_USE, 1.0f, 1.0f, 4);
        this.playSoundWithTimer(player, CompatSoundEvents.BLOCK_IRON_DOOR_OPEN, 1.0f, 2.0f, 6);
        this.playSoundWithTimer(player, CompatSoundEvents.ITEM_FLINTANDSTEEL_USE, 1.0f, 1.0f, 16);
        this.playSoundWithTimer(player, CompatSoundEvents.ENTITY_PLAYER_HURT, 1.0f, 0.0f, 17);
        this.playSoundWithTimer(player, CompatSoundEvents.BLOCK_IRON_DOOR_CLOSE, 1.0f, 2.0f, this.getReloadTick());
    }

    public void reload(class_1799 stack, Player player) {
        if (this.getMaxBulletCount() == GunItem.getBulletCount(stack)) {
            return;
        }
        if (player.getInventory().method_7379(ItemStackUtil.create((class_1792)this.getBulletItem()))) {
            int $usableCount;
            this.playSoundOnReload(player);
            player.getItemCooldown().set((class_1792)this, this.getReloadTick());
            int $bulletCount = 0;
            ArrayList<class_1799> $bulletList = new ArrayList<class_1799>();
            ArrayList<class_1799> $list = new ArrayList<class_1799>((Collection<class_1799>)player.getMain());
            $list.add(player.getMainHandStack());
            $list.add(player.getOffHandStack());
            for (class_1799 $invStack : $list) {
                if (!ItemStackUtil.getItem((class_1799)$invStack).equals(this.getBulletItem())) continue;
                $bulletCount += ItemStackUtil.getCount((class_1799)$invStack);
                $bulletList.add($invStack);
            }
            int $c = $usableCount = Math.min(this.getMaxBulletCount() - GunItem.getBulletCount(stack), $bulletCount);
            for (class_1799 $invStack : $bulletList) {
                if ($c == 0) break;
                int $r = Math.min($c, $invStack.method_7947());
                ItemStackUtil.decrementCount((class_1799)$invStack, (int)$r);
                $c -= $r;
            }
            GunItem.increaseBulletCount(stack, $usableCount);
        }
    }

    public void playSoundOnShoot(Player player) {
        if (player.isClient()) {
            return;
        }
        BlockPos $pos = BlockPos.of((class_2338)player.getBlockPos());
        player.getMidohraWorld().playSound($pos, CompatSoundEvents.ENTITY_ZOMBIE_ATTACK_WOODEN_DOOR, CompatSoundCategory.NEUTRAL, 0.5f, 0.3f / (WorldRandomUtil.nextFloat((class_1937)player.getWorld()) * 0.4f + 0.8f));
    }

    public void playSoundOnRightShoot(Player player) {
        if (player.isClient()) {
            return;
        }
        BlockPos $pos = BlockPos.of((class_2338)player.getBlockPos());
        player.getMidohraWorld().playSound($pos, CompatSoundEvents.ENTITY_ZOMBIE_ATTACK_WOODEN_DOOR, CompatSoundCategory.NEUTRAL, 0.5f, 0.3f / (WorldRandomUtil.nextFloat((class_1937)player.getWorld()) * 0.4f + 0.8f));
    }

    public void onLeftClick(Player $user, class_1268 hand) {
        class_1799 $stack = $user.getStackInHand(hand);
        if (!ItemStackUtil.getItem((class_1799)$stack).equals((Object)this)) {
            return;
        }
        class_1937 $world = $user.getWorld();
        if (GunItem.isBulletCountEmpty($stack)) {
            this.reload($stack, $user);
            return;
        }
        if (!$user.isClient()) {
            class_2487 nbt = NbtUtil.create();
            if (CustomDataUtil.hasNbt((class_1799)$stack) && NbtUtil.has((class_2487)(nbt = CustomDataUtil.getNbt((class_1799)$stack)), (String)"canUse") && !NbtUtil.getBoolean((class_2487)nbt, (String)"canUse")) {
                return;
            }
            NbtUtil.putBoolean((class_2487)nbt, (String)"canUse", (boolean)false);
            int $c = ItemStackUtil.getCount((class_1799)$stack);
            ItemStackUtil.setCount((class_1799)$stack, (int)0);
            CustomDataUtil.setNbt((class_1799)$stack, (class_2487)nbt);
            ItemStackUtil.setCount((class_1799)$stack, (int)$c);
            TimerUtil.addTimer((class_3218)((class_3218)$world), (long)this.getShootTick(), () -> {
                class_2487 nbt2 = CustomDataUtil.getNbt((class_1799)$stack);
                NbtUtil.putBoolean((class_2487)nbt2, (String)"canUse", (boolean)true);
                ItemStackUtil.setCount((class_1799)$stack, (int)0);
                CustomDataUtil.setNbt((class_1799)$stack, (class_2487)nbt2);
                ItemStackUtil.setCount((class_1799)$stack, (int)$c);
                return true;
            });
            this.playSoundOnShoot($user);
            this.shoot($user, $stack);
        }
        $user.incrementStat(class_3468.field_15372, (Object)this);
    }

    public StackActionResult onRightClick(ItemUseEvent e) {
        Player $user = e.user;
        class_1937 $world = e.world;
        class_1799 $stack = $user.getStackInHand(e.hand);
        NbtFixer.fix($stack);
        if (!this.isEnabledRightShoot()) {
            return e.fail();
        }
        if (GunItem.isBulletCountEmpty($stack)) {
            this.reload($stack, $user);
            return e.fail();
        }
        if (!e.isClient()) {
            class_2487 nbt = NbtUtil.create();
            if (CustomDataUtil.hasNbt((class_1799)$stack) && NbtUtil.has((class_2487)(nbt = CustomDataUtil.getNbt((class_1799)$stack)), (String)"canUse") && !NbtUtil.getBoolean((class_2487)nbt, (String)"canUse")) {
                return e.fail();
            }
            NbtUtil.set((class_2487)nbt, (String)"canUse", (Object)false);
            int $c = ItemStackUtil.getCount((class_1799)$stack);
            ItemStackUtil.setCount((class_1799)$stack, (int)0);
            CustomDataUtil.setNbt((class_1799)$stack, (class_2487)nbt);
            ItemStackUtil.setCount((class_1799)$stack, (int)$c);
            TimerUtil.addTimer((class_3218)((class_3218)$world), (long)this.getShootTick(), () -> {
                class_2487 nbt2 = CustomDataUtil.getNbt((class_1799)$stack);
                NbtUtil.set((class_2487)nbt2, (String)"canUse", (Object)true);
                ItemStackUtil.setCount((class_1799)$stack, (int)0);
                CustomDataUtil.setNbt((class_1799)$stack, (class_2487)nbt2);
                ItemStackUtil.setCount((class_1799)$stack, (int)$c);
                return true;
            });
            this.playSoundOnRightShoot($user);
            this.shootRight($user, $stack);
        }
        $user.incrementStat(class_3468.field_15372, (Object)this);
        return e.success();
    }

    public boolean isEnabledRightShoot() {
        return true;
    }

    public void shoot(Player $user, class_1799 $stack) {
        class_1937 $world = $user.getWorld();
        BulletEntity bulletEntity = new BulletEntity($world, (class_1309)$user.getEntity(), this);
        bulletEntity.callSetItem(ItemStackUtil.create((class_1792)((class_1792)YGItems.BULLET_ITEM.get())));
        bulletEntity.method_24919((class_1297)$user.getEntity(), $user.getPitch(), $user.getYaw(), this.getShootRoll(), this.getShootSpeed(), this.getShootDivergence());
        GunItem.decreaseBulletCount($stack);
        WorldUtil.spawnEntity((class_1937)$world, (class_1297)bulletEntity);
    }

    public void shootRight(Player $user, class_1799 $stack) {
        if (!this.isEnabledRightShoot()) {
            return;
        }
        class_1937 $world = $user.getWorld();
        BulletEntity bulletEntity = new BulletEntity($world, (class_1309)$user.getEntity(), this);
        bulletEntity.callSetItem(ItemStackUtil.create((class_1792)((class_1792)YGItems.BULLET_ITEM.get())));
        bulletEntity.method_24919((class_1297)$user.getEntity(), $user.getPitch(), $user.getYaw(), this.getShootRoll(), this.getShootSpeed(), this.getShootDivergence());
        bulletEntity.setAddedDamage(this.getRightShootDamage());
        GunItem.decreaseBulletCount($stack);
        WorldUtil.spawnEntity((class_1937)$world, (class_1297)bulletEntity);
    }

    public int getItemBarStep(ItemBarStepArgs args) {
        return Math.round((float)GunItem.getBulletCount(args.getStack()) * 13.0f / (float)this.getMaxBulletCount());
    }

    public boolean isItemBarVisible(ItemBarVisibleArgs args) {
        return CustomDataUtil.hasNbt((class_1799)args.getStack());
    }
}

