/*
 * Decompiled with CFR 0.152.
 */
package dzwdz.chat_heads.config;

import dzwdz.chat_heads.ChatHeads;
import dzwdz.chat_heads.config.AliasesGuiProvider;
import dzwdz.chat_heads.config.ChatHeadsConfig;
import dzwdz.chat_heads.config.ChatHeadsConfigData;
import dzwdz.chat_heads.config.RenderPositionGuiProvider;
import dzwdz.chat_heads.config.SenderDetectionGuiProvider;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import me.shedaniel.autoconfig.gui.registry.api.GuiProvider;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.minecraft.world.InteractionResult;

public class ClothConfigCommonImpl {
    private static ConfigHolder<ChatHeadsConfigData> CONFIG_HOLDER;

    public static void loadConfig() {
        ConfigHolder configHolder = AutoConfig.register(ChatHeadsConfigData.class, JanksonConfigSerializer::new);
        ChatHeads.CONFIG = (ChatHeadsConfig)configHolder.getConfig();
        CONFIG_HOLDER = configHolder;
        configHolder.registerSaveListener((manager, data) -> {
            try {
                data.validatePostLoad();
            }
            catch (ConfigData.ValidationException validationException) {
                // empty catch block
            }
            return InteractionResult.SUCCESS;
        });
        GuiRegistry guiRegistry = AutoConfig.getGuiRegistry(ChatHeadsConfigData.class);
        guiRegistry.registerPredicateProvider((GuiProvider)new SenderDetectionGuiProvider(), field -> field.getName().equals("senderDetection"));
        guiRegistry.registerPredicateProvider((GuiProvider)new RenderPositionGuiProvider(), field -> field.getName().equals("renderPosition"));
        guiRegistry.registerPredicateProvider((GuiProvider)new AliasesGuiProvider(), field -> field.getName().equals("nameAliases"));
    }

    public static void saveConfig() {
        CONFIG_HOLDER.save();
    }
}

