/*
 * Decompiled with CFR 0.152.
 */
package dzwdz.chat_heads;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import dzwdz.chat_heads.Compat;
import dzwdz.chat_heads.HeadData;
import dzwdz.chat_heads.config.ChatHeadsConfig;
import dzwdz.chat_heads.config.ChatHeadsConfigDefaults;
import dzwdz.chat_heads.config.ClothConfigCommonImpl;
import dzwdz.chat_heads.config.RenderPosition;
import dzwdz.chat_heads.config.SenderDetection;
import dzwdz.chat_heads.mixininterface.HeadRenderable;
import dzwdz.chat_heads.mixininterface.Ownable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ChatTypeDecoration;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatHeads {
    public static final String MOD_ID = "chat_heads";
    public static final String FORMAT_REGEX = "\u00a7.";
    public static final Logger LOGGER = LogManager.getLogger((String)"chat_heads");
    public static final ResourceLocation DISABLE_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"chat_heads", (String)"disable");
    public static ChatHeadsConfig CONFIG = new ChatHeadsConfigDefaults();
    @NotNull
    public static HeadData lastSenderData = HeadData.EMPTY;
    public static boolean refreshing;
    @NotNull
    public static HeadData lineData;
    @NotNull
    public static HeadData refreshingLineData;
    public static volatile boolean serverSentUuid;
    public static volatile boolean serverDisabledChatHeads;
    public static final Set<ResourceLocation> blendedHeadTextures;
    public static GuiGraphics guiGraphics;
    @NotNull
    public static HeadData renderHeadData;
    public static float renderHeadOpacity;
    public static boolean forceBeforeLine;
    private static final Map<String, BooleanSupplier> beforeNameIncompatibility;

    public static void init() {
        for (Map.Entry<String, BooleanSupplier> entry : beforeNameIncompatibility.entrySet()) {
            String modId = entry.getKey();
            if (!Compat.isModLoaded(modId) || !entry.getValue().getAsBoolean()) continue;
            forceBeforeLine = true;
            LOGGER.warn("disabled \"Before Name\" rendermode due to incompatibility with {}", (Object)modId);
        }
        if (Compat.isClothConfigLoaded()) {
            ClothConfigCommonImpl.loadConfig();
        }
    }

    @NotNull
    public static HeadData getLineData() {
        return refreshing ? refreshingLineData : lineData;
    }

    public static void setLineData(@NotNull HeadData headData) {
        if (refreshing) {
            refreshingLineData = headData;
        } else {
            lineData = headData;
        }
    }

    public static void autoDetectAlias(Component message) {
        String text = message.getString();
        int i = text.indexOf(" ");
        if (i == -1) {
            return;
        }
        String nickname = text.substring(0, i);
        if (!text.substring(i).startsWith(" is ")) {
            return;
        }
        String profileName = text.substring(i + " is ".length());
        if (profileName.contains(" ")) {
            return;
        }
        CONFIG.addNameAlias(nickname, profileName);
    }

    public static void handleAddedMessage(Component message, @Nullable ChatType.Bound bound, @Nullable PlayerInfo playerInfo) {
        if (CONFIG.detectNameAliases()) {
            ChatHeads.autoDetectAlias(message);
        }
        if (serverDisabledChatHeads) {
            lastSenderData = HeadData.EMPTY;
            return;
        }
        lastSenderData = ChatHeads.detectPlayer(message, bound, playerInfo);
    }

    @NotNull
    private static HeadData detectPlayer(Component message, @Nullable ChatType.Bound bound, @Nullable PlayerInfo playerInfo) {
        HeadData headData = ChatHeads.detectShowcaseItemMessage(message);
        if (headData != null) {
            return headData;
        }
        if (CONFIG.senderDetection() != SenderDetection.HEURISTIC_ONLY) {
            if (playerInfo != null) {
                serverSentUuid = true;
                return HeadData.of(playerInfo);
            }
            if (CONFIG.senderDetection() == SenderDetection.UUID_ONLY || serverSentUuid && CONFIG.smartHeuristics()) {
                return HeadData.EMPTY;
            }
        }
        return ChatHeads.detectPlayerByHeuristic(message, bound);
    }

    @Nullable
    private static HeadData detectShowcaseItemMessage(Component message) {
        TranslatableContents contents;
        ComponentContents componentContents = message.getContents();
        if (componentContents instanceof TranslatableContents && Objects.equals((contents = (TranslatableContents)componentContents).getKey(), "showcaseitem.misc.shared_item") && contents.getArgs().length > 0) {
            String playerName;
            ClientPacketListener connection = Minecraft.getInstance().getConnection();
            if (connection == null) {
                return null;
            }
            Object object = contents.getArgs()[0];
            if (object instanceof String) {
                String s;
                playerName = s = (String)object;
            } else {
                object = contents.getArgs()[0];
                if (object instanceof Component) {
                    Component c = (Component)object;
                    playerName = c.getString();
                } else {
                    return null;
                }
            }
            PlayerInfoCache playerInfoCache = new PlayerInfoCache(connection);
            playerInfoCache.collectAllNames();
            return HeadData.of(playerInfoCache.get(playerName));
        }
        return null;
    }

    @NotNull
    public static HeadData getHeadData(@NotNull GuiMessage.Line guiMessage) {
        return ((HeadRenderable)guiMessage).chatheads$getHeadData();
    }

    @NotNull
    public static HeadData getHeadData(@NotNull GuiMessage guiMessage) {
        return ((HeadRenderable)guiMessage).chatheads$getHeadData();
    }

    @Nullable
    public static PlayerInfo getOwner(@NotNull PlayerChatMessage message) {
        return ((Ownable)message).chatheads$getOwner();
    }

    public static void setHeadData(@NotNull GuiMessage guiMessage, @NotNull HeadData data) {
        ((HeadRenderable)guiMessage).chatheads$setHeadData(data);
    }

    public static void setOwner(@NotNull PlayerChatMessage message, PlayerInfo owner) {
        ((Ownable)message).chatheads$setOwner(owner);
    }

    public static int getChatOffset(@NotNull GuiMessage.Line guiMessage) {
        return ChatHeads.getChatOffset(ChatHeads.getHeadData(guiMessage));
    }

    public static int getChatOffset(@NotNull HeadData headData) {
        if (CONFIG.renderPosition() != RenderPosition.BEFORE_LINE) {
            return 0;
        }
        if (headData != HeadData.EMPTY || CONFIG.offsetNonPlayerText() && !serverDisabledChatHeads) {
            return ChatHeads.headWidth();
        }
        return 0;
    }

    public static int headWidth() {
        return ChatHeads.headWidth(CONFIG.drawShadow());
    }

    public static int headWidth(boolean drawShadow) {
        return 10 + (drawShadow ? 1 : 0);
    }

    @NotNull
    public static HeadData detectPlayerByHeuristic(Component message, @Nullable ChatType.Bound bound) {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        if (connection == null) {
            return HeadData.EMPTY;
        }
        Component sender = ChatHeads.getSenderDecoration(bound);
        PlayerInfoCache playerInfoCache = new PlayerInfoCache(connection);
        playerInfoCache.collectProfileNames();
        PlayerInfo player = ChatHeads.getTellReceiver(sender != null ? sender : message).map(playerInfoCache::get).orElse(null);
        if (player != null) {
            return HeadData.of(player);
        }
        playerInfoCache.collectAllNames();
        if (sender != null) {
            String cleanSender = sender.getString().replaceAll(FORMAT_REGEX, "");
            return HeadData.of(playerInfoCache.get(cleanSender));
        }
        return ChatHeads.scanForPlayerName(message.getString(), playerInfoCache);
    }

    private static Optional<String> getTellReceiver(Component component) {
        return component.visit((style, string) -> {
            String cmd;
            ClickEvent clickEvent = style.getClickEvent();
            if (clickEvent != null && clickEvent.getAction() == ClickEvent.Action.SUGGEST_COMMAND && (cmd = clickEvent.getValue()) != null && cmd.startsWith("/tell ")) {
                String name = cmd.substring("/tell ".length()).trim();
                return Optional.of(name);
            }
            return Optional.empty();
        }, Style.EMPTY);
    }

    @Nullable
    private static Component getSenderDecoration(@Nullable ChatType.Bound bound) {
        if (bound == null) {
            return null;
        }
        for (ChatTypeDecoration.Parameter param : ((ChatType)bound.chatType().value()).chat().parameters()) {
            if (param != ChatTypeDecoration.Parameter.SENDER) continue;
            return bound.name();
        }
        return null;
    }

    @NotNull
    public static HeadData scanForPlayerName(@NotNull String message, PlayerInfoCache playerInfoCache) {
        message = message.replaceAll(FORMAT_REGEX, "");
        Map<Integer, List<String>> namesByFirstCharacter = playerInfoCache.createNamesByFirstCharacterMap();
        boolean insideWord = false;
        int[] messageSeq = message.codePoints().toArray();
        for (int i = 0; i < messageSeq.length; ++i) {
            int c = messageSeq[i];
            if (insideWord && ChatHeads.isWordCharacter(c)) continue;
            for (String name : namesByFirstCharacter.getOrDefault(c, List.of())) {
                boolean nameIsFollowedByWord;
                int[] nameSeq = name.codePoints().toArray();
                if (i + nameSeq.length - 1 >= messageSeq.length) continue;
                boolean nameEndsAsWord = ChatHeads.isWordCharacter(nameSeq[nameSeq.length - 1]);
                boolean bl = nameIsFollowedByWord = i + nameSeq.length < messageSeq.length && ChatHeads.isWordCharacter(messageSeq[i + nameSeq.length]);
                if (nameEndsAsWord && nameIsFollowedByWord || !ChatHeads.containsSubsequenceAt(messageSeq, i, nameSeq)) continue;
                return new HeadData(playerInfoCache.get(name), i);
            }
            insideWord = ChatHeads.isWordCharacter(c);
        }
        return HeadData.EMPTY;
    }

    private static boolean isWordCharacter(int codePoint) {
        return Character.isLetterOrDigit(codePoint) || codePoint == 95 || Character.getNumericValue(codePoint) != -1;
    }

    private static boolean containsSubsequenceAt(int[] sequence, int startIndex, int[] subsequence) {
        for (int j = 0; j < subsequence.length; ++j) {
            if (sequence[startIndex + j] == subsequence[j]) continue;
            return false;
        }
        return true;
    }

    public static NativeImage extractBlendedHead(NativeImage skin) {
        boolean isLegacy = skin.getWidth() / 2 == skin.getHeight();
        int xScale = skin.getWidth() / 64;
        int yScale = skin.getHeight() / (isLegacy ? 32 : 64);
        NativeImage head = new NativeImage(8 * xScale, 8 * yScale, false);
        for (int y = 0; y < head.getHeight(); ++y) {
            for (int x = 0; x < head.getWidth(); ++x) {
                int headColor = skin.getPixelRGBA(8 * xScale + x, 8 * yScale + y);
                int hatColor = skin.getPixelRGBA(40 * xScale + x, 8 * yScale + y);
                head.setPixelRGBA(x, y, headColor);
                head.blendPixel(x, y, hatColor);
            }
        }
        return head;
    }

    public static ResourceLocation getBlendedHeadLocation(ResourceLocation skinLocation) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)skinLocation.getPath());
    }

    public static void renderChatHead(GuiGraphics guiGraphics, int x, int y, PlayerInfo owner, float opacity) {
        ChatHeads.renderChatHead(guiGraphics, x, y, owner, opacity, CONFIG.drawShadow());
    }

    public static void renderChatHead(GuiGraphics guiGraphics, int x, int y, PlayerInfo owner, float opacity, boolean drawShadow) {
        int yDirection;
        ResourceLocation skinLocation = owner.getSkin().texture();
        if (opacity != 1.0f) {
            RenderSystem.enableBlend();
        }
        int shadowOffset = drawShadow ? -1 : 0;
        ClientLevel level = Minecraft.getInstance().level;
        Player player = level != null ? level.getPlayerByUUID(owner.getProfile().getId()) : null;
        boolean upsideDown = player != null && LivingEntityRenderer.isEntityUpsideDown((LivingEntity)player);
        boolean showHat = player != null && player.isModelPartShown(PlayerModelPart.HAT);
        int yOffset = upsideDown ? 8 : 0;
        int n = yDirection = upsideDown ? -1 : 1;
        if (showHat && blendedHeadTextures.contains(skinLocation)) {
            if (drawShadow) {
                RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)opacity);
                guiGraphics.blit(ChatHeads.getBlendedHeadLocation(skinLocation), x + 1, y, 8, 8, 0.0f, (float)yOffset, 8, yDirection * 8, 8, 8);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
            guiGraphics.blit(ChatHeads.getBlendedHeadLocation(skinLocation), x, y + shadowOffset, 8, 8, 0.0f, (float)yOffset, 8, yDirection * 8, 8, 8);
        } else {
            if (drawShadow) {
                RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)opacity);
                guiGraphics.blit(skinLocation, x + 1, y, 8, 8, 8.0f, (float)(8 + yOffset), 8, yDirection * 8, 64, 64);
                if (showHat) {
                    guiGraphics.blit(skinLocation, x + 1, y, 8, 8, 40.0f, (float)(8 + yOffset), 8, yDirection * 8, 64, 64);
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
            guiGraphics.blit(skinLocation, x, y + shadowOffset, 8, 8, 8.0f, (float)(8 + yOffset), 8, yDirection * 8, 64, 64);
            if (showHat) {
                guiGraphics.blit(skinLocation, x, y + shadowOffset, 8, 8, 40.0f, (float)(8 + yOffset), 8, yDirection * 8, 64, 64);
            }
        }
        if (opacity != 1.0f) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
    }

    static {
        lineData = HeadData.EMPTY;
        refreshingLineData = HeadData.EMPTY;
        serverSentUuid = false;
        serverDisabledChatHeads = false;
        blendedHeadTextures = new HashSet<ResourceLocation>();
        renderHeadData = HeadData.EMPTY;
        beforeNameIncompatibility = Map.of("caxton", () -> true, "modernui", () -> {
            try {
                Class<?> modernUi;
                if (Compat.isModLoaded("emojiful")) {
                    return false;
                }
                try {
                    modernUi = Class.forName("icyllis.modernui.mc.ModernUIMod");
                }
                catch (ClassNotFoundException e) {
                    modernUi = Class.forName("icyllis.modernui.mc.forge.ModernUIForge");
                }
                return (Boolean)modernUi.getMethod("isTextEngineEnabled", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.warn("couldn't invoke isTextEngineEnabled: {}: {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
                return false;
            }
        });
    }

    public static class PlayerInfoCache {
        private final ClientPacketListener connection;
        private final Map<String, PlayerInfo> playerInfos = new HashMap<String, PlayerInfo>();
        private boolean collectedProfileNames = false;
        private boolean collectedEverything = false;

        public PlayerInfoCache(@NotNull ClientPacketListener connection) {
            this.connection = connection;
        }

        public void collectProfileNames() {
            if (this.collectedProfileNames) {
                return;
            }
            this.collectedProfileNames = true;
            for (PlayerInfo playerInfo : this.connection.getOnlinePlayers()) {
                this.addProfileName(playerInfo);
            }
        }

        private void addProfileName(PlayerInfo playerInfo) {
            String profileName = playerInfo.getProfile().getName().replaceAll(ChatHeads.FORMAT_REGEX, "");
            if (profileName.isEmpty()) {
                return;
            }
            this.playerInfos.put(profileName, playerInfo);
        }

        public void collectAllNames() {
            if (this.collectedEverything) {
                return;
            }
            this.collectedEverything = true;
            this.collectProfileNames();
            for (PlayerInfo playerInfo : this.connection.getOnlinePlayers()) {
                this.addDisplayName(playerInfo);
            }
            this.addNameAliases();
        }

        private void addNameAliases() {
            for (Map.Entry<String, String> entry : CONFIG.getNameAliases().entrySet()) {
                PlayerInfo playerInfo = this.playerInfos.get(entry.getValue());
                if (playerInfo == null) continue;
                this.playerInfos.putIfAbsent(entry.getKey(), playerInfo);
            }
        }

        private void addDisplayName(PlayerInfo playerInfo) {
            if (playerInfo.getTabListDisplayName() != null) {
                String displayName = playerInfo.getTabListDisplayName().getString().replaceAll(ChatHeads.FORMAT_REGEX, "");
                if (displayName.isEmpty()) {
                    return;
                }
                this.playerInfos.putIfAbsent(displayName, playerInfo);
            }
        }

        public void add(PlayerInfo playerInfo) {
            this.addProfileName(playerInfo);
            this.addDisplayName(playerInfo);
            this.addNameAliases();
        }

        public Map<Integer, List<String>> createNamesByFirstCharacterMap() {
            HashMap<Integer, List<String>> namesByFirstCharacter = new HashMap<Integer, List<String>>();
            for (String name : this.playerInfos.keySet()) {
                namesByFirstCharacter.compute(name.codePointAt(0), (key, value) -> {
                    if (value == null) {
                        value = new ArrayList<String>();
                    }
                    value.add(name);
                    return value;
                });
            }
            return namesByFirstCharacter;
        }

        @Nullable
        public PlayerInfo get(@NotNull String name) {
            return this.playerInfos.get(name);
        }

        public Set<String> getNames() {
            return this.playerInfos.keySet();
        }
    }
}

