/*
 * Decompiled with CFR 0.152.
 */
package dzwdz.chat_heads.config;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.gui.registry.api.GuiProvider;
import me.shedaniel.autoconfig.gui.registry.api.GuiRegistryAccess;
import me.shedaniel.autoconfig.util.Utils;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.StringListListEntry;
import net.minecraft.network.chat.Component;

public class AliasesGuiProvider
implements GuiProvider {
    public static Map<String, String> toAliases(List<String> aliasStrings) {
        LinkedHashMap<String, String> aliases = new LinkedHashMap<String, String>();
        for (String s : aliasStrings) {
            String[] names = s.split("\\s+->\\s+");
            if (names.length != 2) {
                throw new IllegalArgumentException();
            }
            String nickname = names[0].strip();
            String profileName = names[1].strip();
            if (nickname.isEmpty() || profileName.isEmpty()) {
                throw new IllegalArgumentException();
            }
            aliases.put(nickname, profileName);
        }
        return aliases;
    }

    public static List<String> toStrings(Map<String, String> aliases) {
        LinkedHashMap<String, Set> reverse = new LinkedHashMap<String, Set>();
        for (Map.Entry<String, String> entry2 : aliases.entrySet()) {
            String nickname = entry2.getKey();
            String profileName = entry2.getValue();
            reverse.compute(profileName, (k, v) -> {
                if (v == null) {
                    v = new LinkedHashSet<String>();
                }
                v.add(nickname);
                return v;
            });
        }
        return reverse.entrySet().stream().map(entry -> {
            String profilename = (String)entry.getKey();
            String nicks = (String)((Set)entry.getValue()).stream().reduce((a, b) -> a + " " + b).get();
            return nicks + " -> " + profilename;
        }).collect(Collectors.toList());
    }

    public List<AbstractConfigListEntry> get(String i13n, Field field, Object config, Object defaults, GuiRegistryAccess registry) {
        return Collections.singletonList(ConfigEntryBuilder.create().startStrList((Component)Component.translatable((String)i13n), AliasesGuiProvider.toStrings((Map)Utils.getUnsafely((Field)field, (Object)config))).setExpanded(true).setCreateNewInstance(entry -> new StringListListEntry.StringListCell("   ->   ", entry)).setDefaultValue(() -> AliasesGuiProvider.toStrings((Map)Utils.getUnsafely((Field)field, (Object)defaults))).setErrorSupplier(newValue -> {
            try {
                AliasesGuiProvider.toAliases(newValue);
                return Optional.empty();
            }
            catch (Exception e) {
                return Optional.of(Component.empty());
            }
        }).setSaveConsumer(newValue -> Utils.setUnsafely((Field)field, (Object)config, AliasesGuiProvider.toAliases(newValue))).build());
    }
}

