/*
 * Decompiled with CFR 0.152.
 */
package dzwdz.chat_heads;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import dzwdz.chat_heads.ChatHeads;
import dzwdz.chat_heads.HeadData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.ObjectContents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.chat.contents.objects.ObjectInfo;
import net.minecraft.network.chat.contents.objects.PlayerSprite;
import net.minecraft.util.StringDecomposer;
import net.minecraft.world.item.component.ResolvableProfile;
import org.jetbrains.annotations.Nullable;

public class ComponentProcessor {
    public static void walkTree(Component component, Style currentStyle, StyledComponentConsumer consumer) {
        currentStyle = component.getStyle().applyTo(currentStyle);
        consumer.accept(component, currentStyle);
        for (Component sibling : component.getSiblings()) {
            ComponentProcessor.walkTree(sibling, currentStyle, consumer);
        }
    }

    public static void walkTree(Component component, StyledComponentConsumer consumer) {
        ComponentProcessor.walkTree(component, Style.EMPTY, consumer);
    }

    public static ArrayList<Component> split(Component component) {
        ArrayList<Component> components = new ArrayList<Component>();
        ComponentProcessor.walkTree(component, (c, cStyle) -> {
            ComponentContents patt0$temp = c.getContents();
            if (patt0$temp instanceof PlainTextContents) {
                PlainTextContents literal = (PlainTextContents)patt0$temp;
                Style[] prevStyle = new Style[]{cStyle};
                StringBuilder b = new StringBuilder();
                StringDecomposer.iterateFormatted((String)literal.text(), (Style)prevStyle[0], (index, style, cp) -> {
                    if (!style.equals((Object)prevStyle[0])) {
                        if (!b.isEmpty()) {
                            components.add((Component)Component.literal((String)b.toString()).setStyle(prevStyle[0]));
                        }
                        b.setLength(0);
                        prevStyle[0] = style;
                    }
                    b.appendCodePoint(cp);
                    return true;
                });
                if (!b.isEmpty()) {
                    components.add((Component)Component.literal((String)b.toString()).setStyle(prevStyle[0]));
                }
            } else {
                MutableComponent copy = c.plainCopy().setStyle(cStyle);
                components.add((Component)copy);
            }
        });
        return components;
    }

    public static Component join(List<Component> components) {
        MutableComponent combined = Component.empty();
        for (Component c : components) {
            combined.getSiblings().add(c);
        }
        return combined;
    }

    public static void walkLiteralSequencesAndTranslatables(ArrayList<Component> components, Predicate<FoundLiteralSequence> literalsCallback, Predicate<FoundTranslatable> translatableCallback) {
        StringBuilder textSequence = new StringBuilder();
        int startIndex = -1;
        int endIndex = -1;
        for (int i = 0; i < components.size(); ++i) {
            TranslatableContents translatableContents;
            ComponentContents contents = components.get(i).getContents();
            if (contents instanceof PlainTextContents) {
                PlainTextContents textContents = (PlainTextContents)contents;
                if (startIndex == -1) {
                    startIndex = i;
                }
                endIndex = i;
                textSequence.append(textContents.text());
                continue;
            }
            if (!textSequence.isEmpty() && literalsCallback.test(new FoundLiteralSequence(textSequence.toString(), startIndex, endIndex))) {
                return;
            }
            textSequence = new StringBuilder();
            startIndex = -1;
            if (!(contents instanceof TranslatableContents) || !translatableCallback.test(new FoundTranslatable(translatableContents = (TranslatableContents)contents, i))) continue;
            return;
        }
        endIndex = components.size() - 1;
        if (!textSequence.isEmpty() && literalsCallback.test(new FoundLiteralSequence(textSequence.toString(), startIndex, endIndex))) {
            return;
        }
    }

    public static String codePointSubstring(String string, int start) {
        return string.substring(string.offsetByCodePoints(0, start));
    }

    public static String codePointSubstring(String string, int start, int end) {
        int i = string.offsetByCodePoints(0, start);
        int j = string.offsetByCodePoints(i, end - start);
        return string.substring(i, j);
    }

    @Nullable
    public static Pair<MutableComponent, MutableComponent> splitLiteral(Component literal, int i) {
        if (i == 0) {
            return null;
        }
        String text = ((PlainTextContents)literal.getContents()).text();
        String leftText = ComponentProcessor.codePointSubstring(text, 0, i);
        String rightText = ComponentProcessor.codePointSubstring(text, i);
        MutableComponent left = Component.literal((String)leftText).setStyle(literal.getStyle());
        MutableComponent right = Component.literal((String)rightText).setStyle(literal.getStyle());
        literal.getSiblings().forEach(arg_0 -> ((MutableComponent)right).append(arg_0));
        return new Pair((Object)left, (Object)right);
    }

    @Nullable
    public static PlayerInfo addChatHeadForClickTellCommand(ArrayList<Component> components, ChatHeads.PlayerInfoCache playerInfoCache) {
        for (int i = 0; i < components.size(); ++i) {
            int finalI;
            TranslatableContents translatable;
            PlayerInfo playerInfo;
            PlayerInfo playerInfo2;
            Component c = components.get(i);
            String profileName = ComponentProcessor.getTellReceiver(c);
            if (profileName != null && (playerInfo2 = playerInfoCache.get(profileName)) != null) {
                MutableComponent decorated = ComponentProcessor.createChatHeadComponent(playerInfo2).append(c);
                components.set(i, (Component)decorated);
                return playerInfo2;
            }
            ComponentContents decorated = c.getContents();
            if (!(decorated instanceof TranslatableContents) || (playerInfo = ComponentProcessor.processTranslatableArguments(translatable = (TranslatableContents)decorated, splitArg -> ComponentProcessor.addChatHeadForClickTellCommand(splitArg, playerInfoCache), arg_0 -> ComponentProcessor.lambda$addChatHeadForClickTellCommand$3(components, finalI = i, arg_0))) == null) continue;
            return playerInfo;
        }
        return null;
    }

    @Nullable
    public static <T> T processTranslatableArguments(TranslatableContents translatable, Function<ArrayList<Component>, @Nullable T> processSplitArg, Consumer<Component> processedCallback) {
        Object[] args = translatable.getArgs();
        int argsLength = Objects.equals(translatable.getKey(), "chat.type.text") ? 1 : args.length;
        for (int i = 0; i < argsLength; ++i) {
            Component argComponent;
            ArrayList<Component> splitArg;
            T returnValue;
            Object object = args[i];
            if (object instanceof String) {
                String text = (String)object;
                args[i] = Component.literal((String)text);
            }
            if (!((object = args[i]) instanceof Component) || (returnValue = processSplitArg.apply(splitArg = ComponentProcessor.split(argComponent = (Component)object))) == null) continue;
            Component processedArg = ComponentProcessor.join(splitArg);
            Object[] processedArgs = Arrays.copyOf(args, args.length);
            processedArgs[i] = processedArg;
            MutableComponent processed = Component.translatableWithFallback((String)translatable.getKey(), (String)translatable.getFallback(), (Object[])processedArgs);
            processedCallback.accept((Component)processed);
            return returnValue;
        }
        return null;
    }

    public static PlayerInfo addChatHeadForPlayerName(ArrayList<Component> components, ChatHeads.PlayerInfoCache playerInfoCache) {
        PlayerInfo[] returnValue = new PlayerInfo[1];
        ComponentProcessor.walkLiteralSequencesAndTranslatables(components, literals -> {
            HeadData headData = ChatHeads.scanForPlayerName(literals.text, playerInfoCache);
            if (headData == HeadData.EMPTY) {
                return false;
            }
            int codePointIndex = headData.codePointIndex();
            for (int i = literals.startIndex; i <= literals.endIndex; ++i) {
                MutableComponent decorated;
                Pair<MutableComponent, MutableComponent> pair;
                Component literal = (Component)components.get(i);
                PlainTextContents contents = (PlainTextContents)literal.getContents();
                int codePointCount = (int)contents.text().codePoints().count();
                if (codePointIndex >= codePointCount) {
                    codePointIndex -= codePointCount;
                    continue;
                }
                MutableComponent chatHead = ComponentProcessor.createChatHeadComponent(headData.playerInfo());
                if (literal.getStyle().isStrikethrough()) {
                    chatHead = chatHead.withStyle(ChatFormatting.STRIKETHROUGH);
                }
                if ((pair = ComponentProcessor.splitLiteral(literal, codePointIndex)) == null) {
                    decorated = chatHead.append(literal);
                } else {
                    MutableComponent left = (MutableComponent)pair.getFirst();
                    MutableComponent right = (MutableComponent)pair.getSecond();
                    decorated = Component.empty().append((Component)left).append((Component)chatHead).append((Component)right);
                }
                components.set(i, (Component)decorated);
                returnValue[0] = headData.playerInfo();
                return true;
            }
            return false;
        }, foundTranslatable -> {
            TranslatableContents translatable = foundTranslatable.contents;
            PlayerInfo foundPlayerInfo = ComponentProcessor.processTranslatableArguments(translatable, splitArg -> ComponentProcessor.addChatHeadForPlayerName(splitArg, playerInfoCache), decorated -> components.set(foundTranslatable.index, (Component)decorated));
            if (foundPlayerInfo != null) {
                returnValue[0] = foundPlayerInfo;
                return true;
            }
            return false;
        });
        return returnValue[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsPlayerSprite(ArrayList<Component> components) {
        Iterator<Component> iterator = components.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                return false;
            }
            Component c = iterator.next();
            ComponentContents componentContents = c.getContents();
            if (!(componentContents instanceof ObjectContents)) continue;
            ObjectContents objectContents = (ObjectContents)componentContents;
            try {
                // empty try
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            ObjectInfo objectInfo = objectContents.contents();
            ObjectInfo objectInfo2 = objectInfo;
            if (objectInfo2 instanceof PlayerSprite) break;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static String getTellReceiver(Component component) {
        ClickEvent clickEvent = component.getStyle().getClickEvent();
        if (!(clickEvent instanceof ClickEvent.SuggestCommand)) return null;
        ClickEvent.SuggestCommand suggestCommand = (ClickEvent.SuggestCommand)clickEvent;
        try {
            String string;
            String command = string = suggestCommand.command();
            if (command == null) return null;
            if (!command.startsWith("/tell ")) return null;
            return command.substring("/tell ".length()).trim();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public static MutableComponent createChatHeadComponent(PlayerInfo playerInfo) {
        return Component.object((ObjectInfo)new PlayerSprite(ResolvableProfile.createResolved((GameProfile)playerInfo.getProfile()), playerInfo.showHat()));
    }

    private static /* synthetic */ void lambda$addChatHeadForClickTellCommand$3(ArrayList components, int finalI, Component decorated) {
        components.set(finalI, decorated);
    }

    public static interface StyledComponentConsumer {
        public void accept(Component var1, Style var2);
    }

    public record FoundLiteralSequence(String text, int startIndex, int endIndex) {
    }

    public record FoundTranslatable(TranslatableContents contents, int index) {
    }
}

