/*
 * Decompiled with CFR 0.152.
 */
package org.trivait.statusplugin;

import java.io.File;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.trivait.statusplugin.command.StatusCommand;
import org.trivait.statusplugin.locale.LocaleManager;
import org.trivait.statusplugin.settings.PlayerSettingsManager;
import org.trivait.statusplugin.status.Status;
import org.trivait.statusplugin.status.StatusManager;
import org.trivait.statusplugin.tag.NametagService;

public class StatusPlugin
extends JavaPlugin
implements Listener {
    private LocaleManager locale;
    private StatusManager statusManager;
    private NametagService nametagService;
    private PlayerSettingsManager playerSettings;
    private final Map<UUID, Long> lastMove = new ConcurrentHashMap<UUID, Long>();

    public void onEnable() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.saveDefaultConfig();
        this.saveResourceIfMissing("messages_ru.yml");
        this.saveResourceIfMissing("messages_en.yml");
        this.locale = new LocaleManager((Plugin)this);
        this.statusManager = new StatusManager((Plugin)this);
        this.nametagService = new NametagService((Plugin)this);
        this.playerSettings = new PlayerSettingsManager((Plugin)this);
        this.nametagService.initTeams();
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.ensureDefaultStatus(p);
            this.applyAllDisplays(p);
            this.lastMove.put(p.getUniqueId(), System.currentTimeMillis());
        }
        StatusCommand statusCommand = new StatusCommand(this);
        this.getCommand("status").setExecutor((CommandExecutor)statusCommand);
        this.getCommand("status").setTabCompleter((TabCompleter)statusCommand);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.startAutoAfkTask();
    }

    public void onDisable() {
        this.statusManager.saveAll();
        this.lastMove.clear();
    }

    private void saveResourceIfMissing(String name) {
        File f = new File(this.getDataFolder(), name);
        if (!f.exists()) {
            this.saveResource(name, false);
        }
    }

    public LocaleManager locale() {
        return this.locale;
    }

    public StatusManager status() {
        return this.statusManager;
    }

    public NametagService tags() {
        return this.nametagService;
    }

    public PlayerSettingsManager playerSettings() {
        return this.playerSettings;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.ensureDefaultStatus(player);
        this.applyAllDisplays(player);
        this.lastMove.put(player.getUniqueId(), System.currentTimeMillis());
        TextComponent prefix = LegacyComponentSerializer.legacySection().deserialize(this.locale.msg("prefix"));
        String coloredStatusLegacy = this.formatColoredStatus(this.statusManager.getOrDefault(player.getUniqueId(), Status.NONE));
        TextComponent base = LegacyComponentSerializer.legacySection().deserialize(this.locale.msg("join_status").replace("%status_colored%", coloredStatusLegacy));
        Component actionText = ((TextComponent)LegacyComponentSerializer.legacySection().deserialize(this.locale.msg("join_action_text")).color((TextColor)NamedTextColor.AQUA)).clickEvent(ClickEvent.suggestCommand((String)"/status "));
        player.sendMessage(prefix.append((Component)Component.space()).append((Component)base).append((Component)Component.space()).append(actionText));
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        if (!this.getConfig().getBoolean("show.chat", true)) {
            return;
        }
        Player player = event.getPlayer();
        this.updateDisplayAndTab(player);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        boolean moved;
        Player p = event.getPlayer();
        boolean bl = moved = event.getFrom().getX() != event.getTo().getX() || event.getFrom().getY() != event.getTo().getY() || event.getFrom().getZ() != event.getTo().getZ() || event.getFrom().getYaw() != event.getTo().getYaw() || event.getFrom().getPitch() != event.getTo().getPitch();
        if (moved) {
            Status cur;
            this.lastMove.put(p.getUniqueId(), System.currentTimeMillis());
            if (this.playerSettings.isAutoAfkEnabled(p.getUniqueId()) && (cur = this.statusManager.getOrDefault(p.getUniqueId(), Status.NONE)) == Status.AFK) {
                this.statusManager.setStatus(p.getUniqueId(), Status.NONE);
                this.applyAllDisplays(p);
                this.sendActionBar(p, this.locale.msg("status_set").replace("%status_colored%", this.formatColoredStatus(Status.NONE)));
            }
        }
    }

    private void startAutoAfkTask() {
        new BukkitRunnable(){

            public void run() {
                long now = System.currentTimeMillis();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    Status cur;
                    if (!StatusPlugin.this.playerSettings.isAutoAfkEnabled(p.getUniqueId())) continue;
                    int idleSec = StatusPlugin.this.playerSettings.getIdleSeconds(p.getUniqueId());
                    long last = StatusPlugin.this.lastMove.getOrDefault(p.getUniqueId(), now);
                    long diffSec = (now - last) / 1000L;
                    if (diffSec < (long)idleSec || (cur = StatusPlugin.this.statusManager.getOrDefault(p.getUniqueId(), Status.NONE)) == Status.AFK) continue;
                    StatusPlugin.this.statusManager.setStatus(p.getUniqueId(), Status.AFK);
                    StatusPlugin.this.applyAllDisplays(p);
                    StatusPlugin.this.sendActionBar(p, StatusPlugin.this.locale.msg("status_set").replace("%status_colored%", StatusPlugin.this.formatColoredStatus(Status.AFK)));
                }
            }
        }.runTaskTimer((Plugin)this, 20L, 20L);
    }

    public void applyAllDisplays(Player player) {
        this.updateScoreboardTeam(player);
        this.updateDisplayAndTab(player);
    }

    public void updateDisplayAndTab(Player player) {
        Status status = this.statusManager.getOrDefault(player.getUniqueId(), Status.NONE);
        String baseName = player.getName();
        String emoji = this.getEmojiFor(status);
        String coloredEmoji = emoji == null || emoji.isEmpty() ? "" : this.getColorFor(status) + emoji + ChatColor.RESET + " ";
        String display = coloredEmoji + ChatColor.WHITE + baseName + ChatColor.RESET;
        if (this.getConfig().getBoolean("show.chat", true)) {
            player.setDisplayName(display);
        } else {
            player.setDisplayName(baseName);
        }
        if (this.getConfig().getBoolean("show.tab", true)) {
            player.setPlayerListName(display);
        } else {
            player.setPlayerListName(baseName);
        }
    }

    public void updateScoreboardTeam(Player player) {
        if (!this.getConfig().getBoolean("show.nametag", true)) {
            this.nametagService.clearPlayerTeam(player);
            return;
        }
        Status status = this.statusManager.getOrDefault(player.getUniqueId(), Status.NONE);
        String emoji = this.getEmojiFor(status);
        ChatColor color = this.getColorFor(status);
        this.nametagService.applyPlayerTeam(player, status, emoji, color);
    }

    public String formatColoredStatus(Status status) {
        return this.getColorFor(status) + status.key() + ChatColor.RESET;
    }

    public ChatColor getColorFor(Status status) {
        FileConfiguration cfg = this.getConfig();
        String path = "statuses." + status.key() + ".color";
        String colorName = cfg.getString(path, "WHITE");
        try {
            return ChatColor.valueOf((String)colorName.toUpperCase());
        }
        catch (Exception e) {
            return ChatColor.WHITE;
        }
    }

    public String getEmojiFor(Status status) {
        String path;
        FileConfiguration cfg = this.getConfig();
        String emoji = cfg.getString(path = "statuses." + status.key() + ".emoji", "");
        if (emoji != null) {
            emoji = emoji.replace("\ufe0f", "");
        }
        return emoji;
    }

    public void sendActionBar(Player player, String legacyText) {
        TextComponent comp = LegacyComponentSerializer.legacySection().deserialize(ChatColor.translateAlternateColorCodes((char)'&', (String)legacyText));
        player.sendActionBar((Component)comp);
    }

    private void ensureDefaultStatus(Player player) {
        Status current = this.statusManager.getStatus(player.getUniqueId());
        if (current == null) {
            this.statusManager.setStatus(player.getUniqueId(), Status.NONE);
        }
    }
}

