/*
 * Decompiled with CFR 0.152.
 */
package org.trivait.statusplugin.command;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.trivait.statusplugin.StatusPlugin;
import org.trivait.statusplugin.status.Status;

public class StatusCommand
implements CommandExecutor,
TabCompleter {
    private final StatusPlugin plugin;

    public StatusCommand(StatusPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Players only.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length < 1) {
            this.sendActionBar(player, this.plugin.locale().msg("error_usage"));
            return true;
        }
        if (args[0].equalsIgnoreCase("autoAFK")) {
            if (args.length == 2 && (args[1].equalsIgnoreCase("true") || args[1].equalsIgnoreCase("false"))) {
                boolean enable = Boolean.parseBoolean(args[1]);
                this.plugin.playerSettings().setAutoAfkEnabled(player.getUniqueId(), enable);
                this.sendActionBar(player, enable ? this.plugin.locale().msg("status_autoafk_on") : this.plugin.locale().msg("status_autoafk_off"));
                return true;
            }
            if (args.length == 2) {
                try {
                    int seconds = Integer.parseInt(args[1]);
                    this.plugin.playerSettings().setIdleSeconds(player.getUniqueId(), seconds);
                    this.sendActionBar(player, "AutoAFK \u0442\u0430\u0439\u043c\u0430\u0443\u0442 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d: " + seconds + " \u0441\u0435\u043a.");
                    return true;
                }
                catch (NumberFormatException e) {
                    this.sendActionBar(player, this.plugin.locale().msg("status_autoafk_usage"));
                    return true;
                }
            }
            this.sendActionBar(player, this.plugin.locale().msg("status_autoafk_usage"));
            return true;
        }
        Status st = Status.fromString(args[0]);
        if (st == null) {
            this.sendActionBar(player, this.plugin.locale().msg("error_invalid_status").replace("%input%", args[0]));
            return true;
        }
        this.plugin.status().setStatus(player.getUniqueId(), st);
        this.plugin.applyAllDisplays(player);
        this.sendActionBar(player, this.plugin.locale().msg("status_set").replace("%status_colored%", this.plugin.formatColoredStatus(st)));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1) {
            list.add("none");
            list.add("afk");
            list.add("streaming");
            list.add("busy");
            list.add("autoAFK");
        } else if (args.length == 2 && args[0].equalsIgnoreCase("autoAFK")) {
            list.add("true");
            list.add("false");
        }
        return list;
    }

    private void sendActionBar(Player player, String legacyText) {
        player.sendActionBar((Component)LegacyComponentSerializer.legacySection().deserialize(ChatColor.translateAlternateColorCodes((char)'&', (String)legacyText)));
    }
}

