/*
 * Decompiled with CFR 0.152.
 */
package org.trivait.statusplugin.locale;

import java.io.File;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class LocaleManager {
    private final Plugin plugin;
    private FileConfiguration messages;

    public LocaleManager(Plugin plugin) {
        this.plugin = plugin;
        this.loadLocale();
    }

    private void loadLocale() {
        String lang = this.plugin.getConfig().getString("language", "ru").toLowerCase();
        String fileName = "messages_" + (lang.equals("en") ? "en" : "ru") + ".yml";
        File langFile = new File(this.plugin.getDataFolder(), fileName);
        if (!langFile.exists()) {
            langFile = new File(this.plugin.getDataFolder(), "messages_ru.yml");
        }
        this.messages = YamlConfiguration.loadConfiguration((File)langFile);
        this.messages.options().parseComments(true);
    }

    public String msg(String key) {
        if (this.messages == null) {
            return key;
        }
        return this.messages.getString(key, key);
    }
}

