/*
 * Decompiled with CFR 0.152.
 */
package org.trivait.statusplugin.settings;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class PlayerSettingsManager {
    private final Plugin plugin;

    public PlayerSettingsManager(Plugin plugin) {
        this.plugin = plugin;
    }

    private File getFile(UUID uuid) {
        File dir = new File(this.plugin.getDataFolder(), "players");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, uuid.toString() + ".yml");
    }

    private FileConfiguration load(UUID uuid) {
        return YamlConfiguration.loadConfiguration((File)this.getFile(uuid));
    }

    public boolean isAutoAfkEnabled(UUID uuid) {
        FileConfiguration cfg = this.load(uuid);
        return cfg.getBoolean("autoAFK.enabled", true);
    }

    public void setAutoAfkEnabled(UUID uuid, boolean enabled) {
        FileConfiguration cfg = this.load(uuid);
        cfg.set("autoAFK.enabled", (Object)enabled);
        this.save(uuid, cfg);
    }

    public int getIdleSeconds(UUID uuid) {
        FileConfiguration cfg = this.load(uuid);
        return cfg.getInt("autoAFK.idleSeconds", this.plugin.getConfig().getInt("autoAFK.idleSeconds", 120));
    }

    public void setIdleSeconds(UUID uuid, int seconds) {
        FileConfiguration cfg = this.load(uuid);
        cfg.set("autoAFK.idleSeconds", (Object)seconds);
        this.save(uuid, cfg);
    }

    private void save(UUID uuid, FileConfiguration cfg) {
        try {
            cfg.save(this.getFile(uuid));
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save player settings for " + uuid + ": " + e.getMessage());
        }
    }
}

