/*
 * Decompiled with CFR 0.152.
 */
package org.trivait.statusplugin.status;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.trivait.statusplugin.status.Status;

public class StatusManager {
    private final Plugin plugin;
    private final Map<UUID, Status> statuses = new HashMap<UUID, Status>();
    private File storageFile;
    private FileConfiguration data;

    public StatusManager(Plugin plugin) {
        this.plugin = plugin;
        this.initStorage();
        this.loadAll();
    }

    private void initStorage() {
        String path = this.plugin.getConfig().getString("storage.file", "data.yml");
        this.storageFile = new File(this.plugin.getDataFolder(), path);
        if (!this.storageFile.getParentFile().exists()) {
            this.storageFile.getParentFile().mkdirs();
        }
        if (!this.storageFile.exists()) {
            try {
                this.storageFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to create storage file: " + e.getMessage());
            }
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.storageFile);
    }

    public void loadAll() {
        this.statuses.clear();
        if (this.data.isConfigurationSection("players")) {
            for (String uuidStr : this.data.getConfigurationSection("players").getKeys(false)) {
                String statusKey = this.data.getString("players." + uuidStr + ".status", "none");
                Status st = Status.fromString(statusKey);
                if (st == null) {
                    st = Status.NONE;
                }
                try {
                    UUID uuid = UUID.fromString(uuidStr);
                    this.statuses.put(uuid, st);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    public void saveAll() {
        for (Map.Entry<UUID, Status> e : this.statuses.entrySet()) {
            this.data.set("players." + e.getKey() + ".status", (Object)e.getValue().key());
        }
        try {
            this.data.save(this.storageFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save storage: " + e.getMessage());
        }
    }

    public Status getStatus(UUID uuid) {
        return this.statuses.get(uuid);
    }

    public Status getOrDefault(UUID uuid, Status def) {
        return this.statuses.getOrDefault(uuid, def);
    }

    public void setStatus(UUID uuid, Status status) {
        this.statuses.put(uuid, status == null ? Status.NONE : status);
        this.data.set("players." + uuid + ".status", (Object)this.statuses.get(uuid).key());
        try {
            this.data.save(this.storageFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save status: " + e.getMessage());
        }
    }
}

