/*
 * Decompiled with CFR 0.152.
 */
package org.trivait.statusplugin.tag;

import java.util.EnumMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;
import org.trivait.statusplugin.status.Status;

public class NametagService {
    private final Plugin plugin;
    private final Map<Status, Team> teams = new EnumMap<Status, Team>(Status.class);
    private Scoreboard scoreboard;

    public NametagService(Plugin plugin) {
        this.plugin = plugin;
    }

    public void initTeams() {
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        if (manager == null) {
            this.plugin.getLogger().warning("ScoreboardManager is null. Nametags will initialize when players are online.");
            return;
        }
        this.scoreboard = manager.getMainScoreboard();
        for (Status st : Status.values()) {
            String teamName = "status_" + st.key();
            Team team = this.scoreboard.getTeam(teamName);
            if (team == null) {
                team = this.scoreboard.registerNewTeam(teamName);
            }
            team.setCanSeeFriendlyInvisibles(false);
            team.setAllowFriendlyFire(true);
            team.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
            this.teams.put(st, team);
        }
    }

    public void applyPlayerTeam(Player player, Status status, String emoji, ChatColor color) {
        if (this.scoreboard == null) {
            ScoreboardManager manager = Bukkit.getScoreboardManager();
            if (manager == null) {
                return;
            }
            this.scoreboard = manager.getMainScoreboard();
        }
        this.clearPlayerTeam(player);
        Team team = this.teams.get((Object)status);
        if (team == null) {
            String teamName = "status_" + status.key();
            team = this.scoreboard.getTeam(teamName);
            if (team == null) {
                team = this.scoreboard.registerNewTeam(teamName);
            }
            this.teams.put(status, team);
        }
        String prefixEmoji = emoji == null || emoji.isEmpty() ? "" : (color == null ? ChatColor.WHITE.toString() : color.toString()) + emoji + ChatColor.RESET + " ";
        team.setPrefix(prefixEmoji);
        team.setSuffix("");
        team.addEntry(player.getName());
        player.setScoreboard(this.scoreboard);
    }

    public void clearPlayerTeam(Player player) {
        if (this.scoreboard == null) {
            return;
        }
        for (Team t : this.scoreboard.getTeams()) {
            if (!t.hasEntry(player.getName())) continue;
            t.removeEntry(player.getName());
        }
    }
}

