/*
 * Decompiled with CFR 0.152.
 */
package com.starmaster.statsplugin;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class StatsPlugin
extends JavaPlugin
implements Listener {
    private Map<UUID, Integer> currentPage = new HashMap<UUID, Integer>();
    private Map<String, List<PlayerStat>> cachedStats = new ConcurrentHashMap<String, List<PlayerStat>>();
    private final Map<UUID, ItemStack> headTextureCache = new ConcurrentHashMap<UUID, ItemStack>();
    private long lastCacheUpdate = 0L;
    private static final long CACHE_DURATION = 30000L;
    private long lastSkinCacheClear = System.currentTimeMillis();
    private static final long SKIN_CACHE_DURATION = 3600000L;

    public void onEnable() {
        this.getLogger().info("StatsPlugin has been enabled!");
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        new BukkitRunnable(){

            public void run() {
                StatsPlugin.this.updateStatsCache();
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    public void onDisable() {
        this.headTextureCache.clear();
        this.getLogger().info("StatsPlugin has been disabled!");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (command.getName().equalsIgnoreCase("stats")) {
            this.openMainMenu(player);
            player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private void updateStatsCache() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastSkinCacheClear > 3600000L) {
            this.headTextureCache.clear();
            this.lastSkinCacheClear = currentTime;
            this.getLogger().info("Cleared player head cache (1 hour passed)");
        }
        if (currentTime - this.lastCacheUpdate < 30000L) {
            return;
        }
        HashMap<String, List<PlayerStat>> newCache = new HashMap<String, List<PlayerStat>>();
        ArrayList<PlayerStat> killStats = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> deathStats = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> playtimeStats = new ArrayList<PlayerStat>();
        for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
            if (!offlinePlayer.hasPlayedBefore()) continue;
            try {
                int kills = offlinePlayer.getStatistic(Statistic.PLAYER_KILLS);
                int deaths = offlinePlayer.getStatistic(Statistic.DEATHS);
                int playtime = offlinePlayer.getStatistic(Statistic.PLAY_ONE_MINUTE) / 20 / 60;
                if (kills > 0) {
                    killStats.add(new PlayerStat(offlinePlayer, kills));
                }
                if (deaths > 0) {
                    deathStats.add(new PlayerStat(offlinePlayer, deaths));
                }
                if (playtime <= 0) continue;
                playtimeStats.add(new PlayerStat(offlinePlayer, playtime));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        killStats.sort((a, b) -> Integer.compare(b.value, a.value));
        deathStats.sort((a, b) -> Integer.compare(b.value, a.value));
        playtimeStats.sort((a, b) -> Integer.compare(b.value, a.value));
        newCache.put("Kills", killStats);
        newCache.put("Deaths", deathStats);
        newCache.put("Playtime", playtimeStats);
        this.cachedStats = newCache;
        this.lastCacheUpdate = currentTime;
    }

    private void openMainMenu(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)"\u00a76\u00a7lServer Statistics");
        ItemStack kills = new ItemStack(Material.DIAMOND_SWORD);
        ItemMeta killsMeta = kills.getItemMeta();
        killsMeta.setDisplayName("\u00a7c\u00a7lKills");
        killsMeta.setLore(Arrays.asList("\u00a77Click to view top killers"));
        kills.setItemMeta(killsMeta);
        ItemStack deaths = new ItemStack(Material.SKELETON_SKULL);
        ItemMeta deathsMeta = deaths.getItemMeta();
        deathsMeta.setDisplayName("\u00a74\u00a7lDeaths");
        deathsMeta.setLore(Arrays.asList("\u00a77Click to view most deaths"));
        deaths.setItemMeta(deathsMeta);
        ItemStack playtime = new ItemStack(Material.CLOCK);
        ItemMeta playtimeMeta = playtime.getItemMeta();
        playtimeMeta.setDisplayName("\u00a7a\u00a7lPlaytime");
        playtimeMeta.setLore(Arrays.asList("\u00a77Click to view top playtime"));
        playtime.setItemMeta(playtimeMeta);
        inv.setItem(11, kills);
        inv.setItem(13, deaths);
        inv.setItem(15, playtime);
        player.openInventory(inv);
    }

    private void openStatsMenu(final Player player, final String type, final int page) {
        this.currentPage.put(player.getUniqueId(), page);
        new BukkitRunnable(){

            public void run() {
                StatsPlugin.this.updateStatsCache();
                new BukkitRunnable(){

                    public void run() {
                        StatsPlugin.this.buildStatsInventory(player, type, page);
                    }
                }.runTask((Plugin)StatsPlugin.this);
            }
        }.runTaskAsynchronously((Plugin)this);
        this.showLoadingMenu(player, type);
    }

    private void showLoadingMenu(Player player, String type) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)("\u00a76\u00a7l" + type + " Leaderboard"));
        ItemStack loading = new ItemStack(Material.HOPPER);
        ItemMeta loadingMeta = loading.getItemMeta();
        loadingMeta.setDisplayName("\u00a7e\u00a7lLoading...");
        loadingMeta.setLore(Arrays.asList("\u00a77Please wait"));
        loading.setItemMeta(loadingMeta);
        inv.setItem(22, loading);
        player.openInventory(inv);
    }

    private void buildStatsInventory(Player player, String type, int page) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)("\u00a76\u00a7l" + type + " Leaderboard"));
        List stats = this.cachedStats.getOrDefault(type, new ArrayList());
        int itemsPerPage = 45;
        int totalPages = Math.max(1, (int)Math.ceil((double)stats.size() / (double)itemsPerPage));
        int startIndex = page * itemsPerPage;
        int endIndex = Math.min(startIndex + itemsPerPage, stats.size());
        int slot = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            PlayerStat stat = (PlayerStat)stats.get(i);
            ItemStack head = this.getCachedHead(stat.player);
            SkullMeta meta = (SkullMeta)head.getItemMeta();
            meta.setDisplayName("\u00a7e#" + (i + 1) + " \u00a7f" + stat.player.getName());
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            if (type.equals("Playtime")) {
                lore.add((CallSite)((Object)("\u00a77" + type + ": \u00a7a" + this.formatPlaytime(stat.value))));
            } else {
                lore.add((CallSite)((Object)("\u00a77" + type + ": \u00a7a" + stat.value)));
            }
            meta.setLore(lore);
            head.setItemMeta((ItemMeta)meta);
            inv.setItem(slot++, head);
        }
        if (page > 0) {
            ItemStack prevPage = new ItemStack(Material.ARROW);
            ItemMeta prevMeta = prevPage.getItemMeta();
            prevMeta.setDisplayName("\u00a7e\u00a7l\u2190 Previous Page");
            prevMeta.setLore(Arrays.asList("\u00a77Page " + page + " of " + totalPages));
            prevPage.setItemMeta(prevMeta);
            inv.setItem(48, prevPage);
        }
        ItemStack back = new ItemStack(Material.BARRIER);
        ItemMeta backMeta = back.getItemMeta();
        backMeta.setDisplayName("\u00a7c\u00a7lBack to Menu");
        back.setItemMeta(backMeta);
        inv.setItem(49, back);
        if (page < totalPages - 1) {
            ItemStack nextPage = new ItemStack(Material.ARROW);
            ItemMeta nextMeta = nextPage.getItemMeta();
            nextMeta.setDisplayName("\u00a7e\u00a7lNext Page \u2192");
            nextMeta.setLore(Arrays.asList("\u00a77Page " + (page + 2) + " of " + totalPages));
            nextPage.setItemMeta(nextMeta);
            inv.setItem(50, nextPage);
        }
        ItemStack pageIndicator = new ItemStack(Material.PAPER);
        ItemMeta pageMeta = pageIndicator.getItemMeta();
        pageMeta.setDisplayName("\u00a76\u00a7lPage " + (page + 1) + "/" + totalPages);
        pageMeta.setLore(Arrays.asList("\u00a77Showing " + (endIndex - startIndex) + " of " + stats.size() + " players"));
        pageIndicator.setItemMeta(pageMeta);
        inv.setItem(53, pageIndicator);
        player.openInventory(inv);
    }

    private ItemStack getCachedHead(OfflinePlayer target) {
        ItemStack cached = this.headTextureCache.get(target.getUniqueId());
        if (cached != null) {
            return cached.clone();
        }
        ItemStack newHead = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)newHead.getItemMeta();
        meta.setOwningPlayer(target);
        newHead.setItemMeta((ItemMeta)meta);
        this.headTextureCache.put(target.getUniqueId(), newHead);
        return newHead.clone();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getWhoClicked();
        String title = e.getView().getTitle();
        if (title.equals("\u00a76\u00a7lServer Statistics")) {
            e.setCancelled(true);
            if (e.getCurrentItem() == null || e.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            ItemStack clicked = e.getCurrentItem();
            String name = clicked.getItemMeta().getDisplayName();
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            if (name.contains("Kills")) {
                this.openStatsMenu(player, "Kills", 0);
            } else if (name.contains("Deaths")) {
                this.openStatsMenu(player, "Deaths", 0);
            } else if (name.contains("Playtime")) {
                this.openStatsMenu(player, "Playtime", 0);
            }
        } else if (title.contains("Leaderboard")) {
            e.setCancelled(true);
            if (e.getCurrentItem() == null || e.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            ItemStack clicked = e.getCurrentItem();
            Material type = clicked.getType();
            if (type == Material.BARRIER) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                this.openMainMenu(player);
                this.currentPage.remove(player.getUniqueId());
            } else if (type == Material.ARROW) {
                player.playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.0f);
                String displayName = clicked.getItemMeta().getDisplayName();
                String statType = title.replace("\u00a76\u00a7l", "").replace(" Leaderboard", "");
                int currentPlayerPage = this.currentPage.getOrDefault(player.getUniqueId(), 0);
                if (displayName.contains("Previous")) {
                    this.openStatsMenu(player, statType, currentPlayerPage - 1);
                } else if (displayName.contains("Next")) {
                    this.openStatsMenu(player, statType, currentPlayerPage + 1);
                }
            }
        }
    }

    private String formatPlaytime(int totalMinutes) {
        int days = totalMinutes / 1440;
        int hours = totalMinutes % 1440 / 60;
        int minutes = totalMinutes % 60;
        StringBuilder formatted = new StringBuilder();
        if (days > 0) {
            formatted.append(days).append("d ");
        }
        if (hours > 0 || days > 0) {
            formatted.append(hours).append("h ");
        }
        formatted.append(minutes).append("m");
        return formatted.toString().trim();
    }

    private static class PlayerStat {
        OfflinePlayer player;
        int value;

        PlayerStat(OfflinePlayer player, int value) {
            this.player = player;
            this.value = value;
        }
    }
}

