/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.holodisplays.api;

import dev.furq.holodisplays.HoloDisplays;
import dev.furq.holodisplays.api.HoloDisplaysAPI;
import dev.furq.holodisplays.config.DisplayConfig;
import dev.furq.holodisplays.data.DisplayData;
import dev.furq.holodisplays.data.HologramData;
import dev.furq.holodisplays.data.display.BaseDisplay;
import dev.furq.holodisplays.data.display.BlockDisplay;
import dev.furq.holodisplays.data.display.EntityDisplay;
import dev.furq.holodisplays.data.display.ItemDisplay;
import dev.furq.holodisplays.data.display.TextDisplay;
import dev.furq.holodisplays.handlers.ViewerHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_4050;
import net.minecraft.class_8113;
import net.minecraft.server.MinecraftServer;
import org.joml.Vector3f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoloDisplaysAPIImpl
implements HoloDisplaysAPI {
    public static final HoloDisplaysAPIImpl INSTANCE = new HoloDisplaysAPIImpl();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"HoloDisplaysAPI");
    public final Map<String, HologramData> apiHolograms = new HashMap<String, HologramData>();
    private final Map<String, DisplayData> apiDisplays = new HashMap<String, DisplayData>();

    private HoloDisplaysAPIImpl() {
    }

    @Override
    public boolean registerHologram(String id, HologramData hologram) {
        try {
            String stringId = this.validateId(id);
            if (this.apiHolograms.containsKey(stringId)) {
                throw new IllegalArgumentException("Hologram with ID " + id + " is already registered");
            }
            for (HologramData.DisplayLine display : hologram.getDisplays()) {
                if (DisplayConfig.INSTANCE.exists(display.getDisplayId()) || this.apiDisplays.containsKey(display.getDisplayId())) continue;
                throw new IllegalArgumentException("Display with ID " + display.getDisplayId() + " does not exist");
            }
            this.apiHolograms.put(stringId, hologram);
            ViewerHandler.INSTANCE.createTracker(stringId, hologram);
            MinecraftServer server = HoloDisplays.Companion.getSERVER();
            if (server != null && server.method_3760() != null) {
                server.method_3760().method_14571().forEach(ViewerHandler.INSTANCE::updatePlayerVisibility);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Error registering hologram with ID {}: {}", new Object[]{id, e.getMessage(), e});
            return false;
        }
    }

    @Override
    public boolean unregisterHologram(String id) {
        try {
            String stringId = this.validateId(id);
            if (!this.apiHolograms.containsKey(stringId)) {
                return false;
            }
            ViewerHandler.INSTANCE.removeHologramFromAllViewers(stringId);
            ViewerHandler.INSTANCE.removeTracker(stringId);
            this.apiHolograms.remove(stringId);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Error unregistering hologram with ID {}: {}", new Object[]{id, e.getMessage(), e});
            return false;
        }
    }

    @Override
    public boolean updateHologram(String id, HologramData hologram) {
        try {
            String stringId = this.validateId(id);
            if (!this.apiHolograms.containsKey(stringId)) {
                return false;
            }
            for (HologramData.DisplayLine display : hologram.getDisplays()) {
                if (DisplayConfig.INSTANCE.exists(display.getDisplayId()) || this.apiDisplays.containsKey(display.getDisplayId())) continue;
                throw new IllegalArgumentException("Display with ID " + display.getDisplayId() + " does not exist");
            }
            this.apiHolograms.put(stringId, hologram);
            ViewerHandler.INSTANCE.respawnForAllObservers(stringId);
            MinecraftServer server = HoloDisplays.Companion.getSERVER();
            if (server != null && server.method_3760() != null) {
                server.method_3760().method_14571().forEach(ViewerHandler.INSTANCE::updatePlayerVisibility);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Error updating hologram with ID {}: {}", new Object[]{id, e.getMessage(), e});
            return false;
        }
    }

    @Override
    public boolean isHologramRegistered(String id) {
        try {
            String stringId = this.validateId(id);
            return this.apiHolograms.containsKey(stringId);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public DisplayData createTextDisplay(String id, Consumer<HoloDisplaysAPI.TextDisplayBuilder> builder) {
        String stringId = this.validateId(id);
        TextDisplayBuilderImpl textBuilder = new TextDisplayBuilderImpl();
        builder.accept(textBuilder);
        TextDisplay display = textBuilder.build();
        this.apiDisplays.put(stringId, new DisplayData(display));
        return this.apiDisplays.get(stringId);
    }

    @Override
    public DisplayData createItemDisplay(String id, Consumer<HoloDisplaysAPI.ItemDisplayBuilder> builder) {
        String stringId = this.validateId(id);
        ItemDisplayBuilderImpl itemBuilder = new ItemDisplayBuilderImpl();
        builder.accept(itemBuilder);
        ItemDisplay display = itemBuilder.build();
        this.apiDisplays.put(stringId, new DisplayData(display));
        return this.apiDisplays.get(stringId);
    }

    @Override
    public DisplayData createBlockDisplay(String id, Consumer<HoloDisplaysAPI.BlockDisplayBuilder> builder) {
        String stringId = this.validateId(id);
        BlockDisplayBuilderImpl blockBuilder = new BlockDisplayBuilderImpl();
        builder.accept(blockBuilder);
        BlockDisplay display = blockBuilder.build();
        this.apiDisplays.put(stringId, new DisplayData(display));
        return this.apiDisplays.get(stringId);
    }

    @Override
    public DisplayData createEntityDisplay(String id, Consumer<HoloDisplaysAPI.EntityDisplayBuilder> builder) {
        String stringId = this.validateId(id);
        EntityDisplayBuilderImpl entityBuilder = new EntityDisplayBuilderImpl();
        builder.accept(entityBuilder);
        EntityDisplay display = entityBuilder.build();
        this.apiDisplays.put(stringId, new DisplayData(display));
        return this.apiDisplays.get(stringId);
    }

    @Override
    public HoloDisplaysAPI.HologramBuilder createHologramBuilder() {
        return new HologramBuilderImpl();
    }

    @Override
    public int unregisterAllHolograms(String namespace) {
        if ("minecraft".equals(namespace)) {
            throw new IllegalArgumentException("Cannot use 'minecraft' namespace for custom holograms");
        }
        ArrayList<String> hologramsToRemove = new ArrayList<String>();
        for (String id : this.apiHolograms.keySet()) {
            if (!id.startsWith(namespace + ":")) continue;
            hologramsToRemove.add(id);
        }
        for (String id : hologramsToRemove) {
            ViewerHandler.INSTANCE.removeHologramFromAllViewers(id);
            ViewerHandler.INSTANCE.removeTracker(id);
            this.apiHolograms.remove(id);
        }
        return hologramsToRemove.size();
    }

    @Override
    public DisplayData getDisplay(String id) {
        return this.apiDisplays.get(id);
    }

    @Override
    public void clearAll() {
        ArrayList<String> hologramIds = new ArrayList<String>(this.apiHolograms.keySet());
        for (String id : hologramIds) {
            ViewerHandler.INSTANCE.removeHologramFromAllViewers(id);
            ViewerHandler.INSTANCE.removeTracker(id);
        }
        this.apiHolograms.clear();
        this.apiDisplays.clear();
    }

    private String validateId(String id) {
        if (id == null) {
            throw new IllegalArgumentException("ID cannot be null");
        }
        String[] parts = id.split(":", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("ID must include namespace (e.g., 'mymod:my_hologram')");
        }
        if ("minecraft".equals(parts[0])) {
            throw new IllegalArgumentException("Cannot use 'minecraft' namespace for custom holograms");
        }
        return id;
    }

    private class_8113.class_8114 parseBillboardMode(String mode) {
        if (mode == null) {
            return class_8113.class_8114.field_42409;
        }
        return switch (mode.toLowerCase()) {
            case "fixed" -> class_8113.class_8114.field_42406;
            case "horizontal" -> class_8113.class_8114.field_42408;
            case "vertical" -> class_8113.class_8114.field_42407;
            default -> class_8113.class_8114.field_42409;
        };
    }

    private static class TextDisplayBuilderImpl
    extends BaseDisplayBuilder<TextDisplay.Builder>
    implements HoloDisplaysAPI.TextDisplayBuilder {
        public TextDisplayBuilderImpl() {
            super(new TextDisplay.Builder());
        }

        @Override
        public void text(String ... lines) {
            ((TextDisplay.Builder)this.builder).setLines(new ArrayList<String>(Arrays.asList(lines)));
        }

        @Override
        public void backgroundColor(String hexColor, int opacity) {
            if (hexColor == null || !hexColor.matches("^[0-9A-Fa-f]{6}$")) {
                throw new IllegalArgumentException("Color must be a valid 6-digit hexadecimal color code (e.g., 'FF0000')");
            }
            if (opacity < 1 || opacity > 100) {
                throw new IllegalArgumentException("Opacity must be between 1 and 100");
            }
            int opacityValue = (int)((double)opacity / 100.0 * 255.0);
            Object opacityHex = Integer.toString(opacityValue, 16).toUpperCase();
            if (((String)opacityHex).length() == 1) {
                opacityHex = "0" + (String)opacityHex;
            }
            ((TextDisplay.Builder)this.builder).setBackgroundColor((String)opacityHex + hexColor);
        }

        @Override
        public void shadow(boolean hasShadow) {
            ((TextDisplay.Builder)this.builder).setShadow(hasShadow);
        }

        @Override
        public void seeThrough(boolean seeThrough) {
            ((TextDisplay.Builder)this.builder).setSeeThrough(seeThrough);
        }

        @Override
        public void opacity(float opacity) {
            ((TextDisplay.Builder)this.builder).setTextOpacity((int)(opacity * 255.0f));
        }

        public TextDisplay build() {
            return ((TextDisplay.Builder)this.builder).build();
        }
    }

    private static class ItemDisplayBuilderImpl
    extends BaseDisplayBuilder<ItemDisplay.Builder>
    implements HoloDisplaysAPI.ItemDisplayBuilder {
        public ItemDisplayBuilderImpl() {
            super(new ItemDisplay.Builder());
        }

        @Override
        public void item(String itemId) {
            ((ItemDisplay.Builder)this.builder).setId(itemId);
        }

        public ItemDisplay build() {
            return ((ItemDisplay.Builder)this.builder).build();
        }
    }

    private static class BlockDisplayBuilderImpl
    extends BaseDisplayBuilder<BlockDisplay.Builder>
    implements HoloDisplaysAPI.BlockDisplayBuilder {
        public BlockDisplayBuilderImpl() {
            super(new BlockDisplay.Builder());
        }

        @Override
        public void block(String blockId) {
            ((BlockDisplay.Builder)this.builder).setId(blockId);
        }

        public BlockDisplay build() {
            return ((BlockDisplay.Builder)this.builder).build();
        }
    }

    private static class EntityDisplayBuilderImpl
    extends BaseDisplayBuilder<EntityDisplay.Builder>
    implements HoloDisplaysAPI.EntityDisplayBuilder {
        public EntityDisplayBuilderImpl() {
            super(new EntityDisplay.Builder());
        }

        @Override
        public void entity(String entityId) {
            ((EntityDisplay.Builder)this.builder).setId(entityId);
        }

        @Override
        public void glow(boolean glow) {
            ((EntityDisplay.Builder)this.builder).setGlow(glow);
        }

        @Override
        public void pose(String pose) {
            try {
                ((EntityDisplay.Builder)this.builder).setPose(class_4050.valueOf((String)pose.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid entity pose: " + pose + ". Valid poses include: standing, crouching, sneaking, etc.");
            }
        }

        public EntityDisplay build() {
            return ((EntityDisplay.Builder)this.builder).build();
        }
    }

    private static class HologramBuilderImpl
    implements HoloDisplaysAPI.HologramBuilder {
        private final List<HologramData.DisplayLine> displays = new ArrayList<HologramData.DisplayLine>();
        private Vector3f position = new Vector3f();
        private String world = "minecraft:overworld";
        private Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
        private class_8113.class_8114 billboardMode = class_8113.class_8114.field_42409;
        private int updateRate = 20;
        private double viewRange = 48.0;
        private Vector3f rotation = new Vector3f();
        private String conditionalPlaceholder = null;

        private HologramBuilderImpl() {
        }

        @Override
        public HoloDisplaysAPI.HologramBuilder position(float x, float y, float z) {
            this.position = new Vector3f(x, y, z);
            return this;
        }

        @Override
        public HoloDisplaysAPI.HologramBuilder world(String worldId) {
            this.world = worldId;
            return this;
        }

        @Override
        public HoloDisplaysAPI.HologramBuilder scale(float x, float y, float z) {
            this.scale = new Vector3f(x, y, z);
            return this;
        }

        @Override
        public HoloDisplaysAPI.HologramBuilder billboardMode(String mode) {
            this.billboardMode = INSTANCE.parseBillboardMode(mode);
            return this;
        }

        @Override
        public HoloDisplaysAPI.HologramBuilder updateRate(int ticks) {
            this.updateRate = ticks;
            return this;
        }

        @Override
        public HoloDisplaysAPI.HologramBuilder viewRange(double range) {
            this.viewRange = range;
            return this;
        }

        @Override
        public HoloDisplaysAPI.HologramBuilder rotation(float x, float y, float z) {
            this.rotation = new Vector3f(x, y, z);
            return this;
        }

        @Override
        public HoloDisplaysAPI.HologramBuilder condition(String placeholder) {
            this.conditionalPlaceholder = placeholder;
            return this;
        }

        @Override
        public HoloDisplaysAPI.HologramBuilder addDisplay(String displayId, float offsetX, float offsetY, float offsetZ) {
            this.displays.add(new HologramData.DisplayLine(displayId, new Vector3f(offsetX, offsetY, offsetZ)));
            return this;
        }

        @Override
        public HologramData build() {
            return new HologramData(this.displays, this.position, this.world, this.scale, this.billboardMode, this.updateRate, this.viewRange, this.rotation, this.conditionalPlaceholder);
        }
    }

    private static abstract class BaseDisplayBuilder<T extends BaseDisplay.Builder<?>> {
        protected final T builder;

        protected BaseDisplayBuilder(T builder) {
            this.builder = builder;
        }

        public void scale(float x, float y, float z) {
            this.builder.setScale(new Vector3f(x, y, z));
        }

        public void rotation(float x, float y, float z) {
            this.builder.setRotation(new Vector3f(x, y, z));
        }

        public void billboardMode(String mode) {
            this.builder.setBillboardMode(INSTANCE.parseBillboardMode(mode));
        }

        public void condition(String placeholder) {
            this.builder.setConditionalPlaceholder(placeholder);
        }
    }
}

