/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.holodisplays.config;

import dev.furq.holodisplays.config.Config;
import dev.furq.holodisplays.config.JsonUtils;
import dev.furq.holodisplays.data.AnimationData;
import dev.furq.holodisplays.handlers.ConfigException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.parsers.json.JsonReader;
import org.quiltmc.parsers.json.JsonWriter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010%\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\u0003J\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0019\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\f\u00a2\u0006\u0004\b\u0017\u0010\u0018J'\u0010\u001b\u001a\n \u001a*\u0004\u0018\u00010\u00190\u00192\u0006\u0010\u000b\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001d\u0010\u001eR\"\u0010\u001f\u001a\u00020\u00048\u0016@\u0016X\u0096.\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010\bR \u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Ldev/furq/holodisplays/config/AnimationConfig;", "Ldev/furq/holodisplays/config/Config;", "<init>", "()V", "Ljava/nio/file/Path;", "baseDir", "", "init", "(Ljava/nio/file/Path;)V", "reload", "Lorg/quiltmc/parsers/json/JsonReader;", "json", "Ldev/furq/holodisplays/data/AnimationData;", "parseAnimationData", "(Lorg/quiltmc/parsers/json/JsonReader;)Ldev/furq/holodisplays/data/AnimationData;", "", "name", "getAnimation", "(Ljava/lang/String;)Ldev/furq/holodisplays/data/AnimationData;", "", "getAnimations", "()Ljava/util/Map;", "animation", "saveAnimation", "(Ljava/lang/String;Ldev/furq/holodisplays/data/AnimationData;)V", "Lorg/quiltmc/parsers/json/JsonWriter;", "kotlin.jvm.PlatformType", "writeAnimation", "(Lorg/quiltmc/parsers/json/JsonWriter;Ldev/furq/holodisplays/data/AnimationData;)Lorg/quiltmc/parsers/json/JsonWriter;", "deleteAnimation", "(Ljava/lang/String;)V", "configDir", "Ljava/nio/file/Path;", "getConfigDir", "()Ljava/nio/file/Path;", "setConfigDir", "", "animations", "Ljava/util/Map;", "holodisplays"})
@SourceDebugExtension(value={"SMAP\nAnimationConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationConfig.kt\ndev/furq/holodisplays/config/AnimationConfig\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n13805#2,2:82\n1#3:84\n1563#4:85\n1634#4,3:86\n*S KotlinDebug\n*F\n+ 1 AnimationConfig.kt\ndev/furq/holodisplays/config/AnimationConfig\n*L\n21#1:82,2\n66#1:85\n66#1:86,3\n*E\n"})
public final class AnimationConfig
implements Config {
    @NotNull
    public static final AnimationConfig INSTANCE = new AnimationConfig();
    public static Path configDir;
    @NotNull
    private static final Map<String, AnimationData> animations;

    private AnimationConfig() {
    }

    @Override
    @NotNull
    public Path getConfigDir() {
        Path path = configDir;
        if (path != null) {
            return path;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"configDir");
        return null;
    }

    public void setConfigDir(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        configDir = path;
    }

    public void init(@NotNull Path baseDir) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Path path = baseDir.resolve("animations");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.setConfigDir(path);
        Config.super.init(baseDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        animations.clear();
        File[] fileArray = this.getConfigDir().toFile().listFiles(JsonUtils.INSTANCE.getJsonFilter());
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File file = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)file);
                Closeable closeable = new FileInputStream(file);
                Object object = Charsets.UTF_8;
                closeable = (Closeable)JsonReader.json5((Reader)new InputStreamReader((InputStream)closeable, (Charset)object));
                object = null;
                try {
                    JsonReader json = (JsonReader)closeable;
                    boolean bl2 = false;
                    String string = FilesKt.getNameWithoutExtension((File)file);
                    Intrinsics.checkNotNull((Object)json);
                    animations.put(string, INSTANCE.parseAnimationData(json));
                    Unit unit = Unit.INSTANCE;
                    continue;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
            }
        } else {
            throw new ConfigException("Failed to list animation config files");
        }
    }

    private final AnimationData parseAnimationData(JsonReader json) {
        JsonReader $this$parseAnimationData_u24lambda_u240 = json;
        boolean bl = false;
        AnimationData.Builder builder = new AnimationData.Builder();
        $this$parseAnimationData_u24lambda_u240.beginObject();
        while ($this$parseAnimationData_u24lambda_u240.hasNext()) {
            String string = $this$parseAnimationData_u24lambda_u240.nextName();
            if (Intrinsics.areEqual((Object)string, (Object)"frames")) {
                $this$parseAnimationData_u24lambda_u240.beginArray();
                while ($this$parseAnimationData_u24lambda_u240.hasNext()) {
                    String string2 = $this$parseAnimationData_u24lambda_u240.nextString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nextString(...)");
                    builder.addFrame(string2);
                }
                $this$parseAnimationData_u24lambda_u240.endArray();
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)"interval")) {
                builder.setInterval($this$parseAnimationData_u24lambda_u240.nextInt());
                continue;
            }
            $this$parseAnimationData_u24lambda_u240.skipValue();
        }
        $this$parseAnimationData_u24lambda_u240.endObject();
        return builder.build();
    }

    @Nullable
    public final AnimationData getAnimation(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return animations.get(name);
    }

    @NotNull
    public final Map<String, AnimationData> getAnimations() {
        return MapsKt.toMap(animations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveAnimation(@NotNull String name, @NotNull AnimationData animation) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        animations.put(name, animation);
        File file = this.getConfigDir().resolve(name + ".json").toFile();
        file.getParentFile().mkdirs();
        Intrinsics.checkNotNull((Object)file);
        Closeable closeable = new FileOutputStream(file);
        Object object = Charsets.UTF_8;
        closeable = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
        object = null;
        try {
            JsonWriter jsonWriter;
            OutputStreamWriter writer = (OutputStreamWriter)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)JsonWriter.json((Writer)writer);
            Throwable throwable = null;
            try {
                JsonWriter json = (JsonWriter)closeable2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)json);
                jsonWriter = INSTANCE.writeAnimation(json, animation);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
            }
            JsonWriter jsonWriter2 = jsonWriter;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final JsonWriter writeAnimation(JsonWriter json, AnimationData animation) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        JsonWriter $this$writeAnimation_u24lambda_u240 = json;
        boolean bl = false;
        $this$writeAnimation_u24lambda_u240.beginObject();
        Iterable iterable = animation.getFrames();
        String string = "frames";
        JsonWriter jsonWriter = $this$writeAnimation_u24lambda_u240;
        JsonUtils jsonUtils = JsonUtils.INSTANCE;
        boolean $i$f$map = false;
        void var10_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AnimationData.Frame frame = (AnimationData.Frame)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getText());
        }
        collection = (List)destination$iv$iv;
        jsonUtils.writeStringList(jsonWriter, string, (List<String>)collection);
        $this$writeAnimation_u24lambda_u240.name("interval").value((Number)animation.getInterval());
        return $this$writeAnimation_u24lambda_u240.endObject();
    }

    public final void deleteAnimation(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        File file = this.getConfigDir().resolve(name + ".json").toFile();
        if (!file.exists()) {
            throw new ConfigException("Animation config file for " + name + " does not exist");
        }
        if (!file.delete()) {
            throw new ConfigException("Failed to delete animation config file for " + name);
        }
        animations.remove(name);
    }

    static {
        animations = new LinkedHashMap();
    }
}

