/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.holodisplays.managers;

import dev.furq.holodisplays.config.DisplayConfig;
import dev.furq.holodisplays.config.HologramConfig;
import dev.furq.holodisplays.data.DisplayData;
import dev.furq.holodisplays.data.HologramData;
import dev.furq.holodisplays.data.display.BaseDisplay;
import dev.furq.holodisplays.data.display.BlockDisplay;
import dev.furq.holodisplays.data.display.EntityDisplay;
import dev.furq.holodisplays.data.display.ItemDisplay;
import dev.furq.holodisplays.data.display.TextDisplay;
import dev.furq.holodisplays.handlers.DisplayHandler;
import dev.furq.holodisplays.handlers.HologramHandler;
import dev.furq.holodisplays.managers.FeedbackManager;
import dev.furq.holodisplays.utils.ConditionEvaluator;
import dev.furq.holodisplays.utils.FeedbackType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.class_4050;
import net.minecraft.class_7923;
import net.minecraft.class_8113;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\nJ/\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J%\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0015\u0010\u0013J%\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0017\u0010\u0013J%\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0019\u0010\u0013J\u001d\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001b\u0010\u001cJ%\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001f\u0010 J\u001d\u0010!\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b!\u0010\u001cJ%\u0010#\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b#\u0010$J\u001d\u0010%\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b%\u0010\u001cJ5\u0010*\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020&2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b*\u0010+J\u001d\u0010,\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b,\u0010\u001cJ-\u00100\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00042\u0006\u0010/\u001a\u00020.2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b0\u00101J\u001d\u00102\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b2\u0010\u001cJ%\u00103\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010/\u001a\u00020.2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b3\u00104J%\u00106\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u00105\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b6\u00107J%\u00109\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b9\u0010$J%\u0010:\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b:\u0010$J'\u0010<\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010;\u001a\u0004\u0018\u00010.2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b<\u0010=J'\u0010?\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010>\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b?\u0010$J%\u0010B\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020\u00042\u0006\u0010A\u001a\u00020.2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\bB\u00104J%\u0010D\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020\u00042\u0006\u0010C\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\bD\u00107J%\u0010E\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\bE\u0010$J%\u0010F\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\bF\u0010$J%\u0010G\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\bG\u0010$J%\u0010I\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\bI\u00107J'\u0010L\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020\u00042\b\u0010K\u001a\u0004\u0018\u00010J2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\bL\u0010MJ\u001d\u0010N\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\bN\u0010\u001c\u00a8\u0006O"}, d2={"Ldev/furq/holodisplays/managers/DisplayManager;", "", "<init>", "()V", "", "name", "Lnet/minecraft/class_2168;", "source", "", "validateDisplayName", "(Ljava/lang/String;Lnet/minecraft/class_2168;)Z", "validateDisplayExists", "Ldev/furq/holodisplays/data/display/BaseDisplay;", "display", "type", "createDisplay", "(Ljava/lang/String;Ldev/furq/holodisplays/data/display/BaseDisplay;Ljava/lang/String;Lnet/minecraft/class_2168;)Z", "text", "createTextDisplay", "(Ljava/lang/String;Ljava/lang/String;Lnet/minecraft/class_2168;)Z", "itemId", "createItemDisplay", "blockId", "createBlockDisplay", "entityId", "createEntityDisplay", "", "deleteDisplay", "(Ljava/lang/String;Lnet/minecraft/class_2168;)V", "Lorg/joml/Vector3f;", "scale", "updateScale", "(Ljava/lang/String;Lorg/joml/Vector3f;Lnet/minecraft/class_2168;)V", "resetScale", "mode", "updateBillboard", "(Ljava/lang/String;Ljava/lang/String;Lnet/minecraft/class_2168;)V", "resetBillboard", "", "pitch", "yaw", "roll", "updateRotation", "(Ljava/lang/String;FFFLnet/minecraft/class_2168;)V", "resetRotation", "color", "", "opacity", "updateBackground", "(Ljava/lang/String;Ljava/lang/String;ILnet/minecraft/class_2168;)V", "resetBackground", "updateTextOpacity", "(Ljava/lang/String;ILnet/minecraft/class_2168;)V", "shadow", "updateShadow", "(Ljava/lang/String;ZLnet/minecraft/class_2168;)V", "alignment", "updateAlignment", "updateItemDisplayType", "customModelData", "updateCustomModelData", "(Ljava/lang/String;Ljava/lang/Integer;Lnet/minecraft/class_2168;)V", "condition", "updateCondition", "displayName", "width", "updateLineWidth", "seeThrough", "updateSeeThrough", "updateItemId", "updateBlockId", "updateEntityId", "glow", "updateEntityGlow", "Lnet/minecraft/class_4050;", "pose", "updateEntityPose", "(Ljava/lang/String;Lnet/minecraft/class_4050;Lnet/minecraft/class_2168;)V", "resetEntityPose", "holodisplays"})
@SourceDebugExtension(value={"SMAP\nDisplayManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisplayManager.kt\ndev/furq/holodisplays/managers/DisplayManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,345:1\n504#2,3:346\n507#2,4:352\n1761#3,3:349\n1583#3,11:357\n1878#3,2:368\n1880#3:372\n1594#3:373\n1869#3,2:374\n216#4:356\n217#4:376\n1#5:370\n1#5:371\n*S KotlinDebug\n*F\n+ 1 DisplayManager.kt\ndev/furq/holodisplays/managers/DisplayManager\n*L\n87#1:346,3\n87#1:352,4\n87#1:349,3\n89#1:357,11\n89#1:368,2\n89#1:372\n89#1:373\n90#1:374,2\n88#1:356\n88#1:376\n89#1:371\n*E\n"})
public final class DisplayManager {
    @NotNull
    public static final DisplayManager INSTANCE = new DisplayManager();

    private DisplayManager() {
    }

    private final boolean validateDisplayName(String name, class_2168 source) {
        boolean bl;
        boolean exists = bl = DisplayConfig.INSTANCE.exists(name);
        boolean bl2 = false;
        if (exists) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name)};
            FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_EXISTS, pairArray);
        }
        return !bl;
    }

    private final boolean validateDisplayExists(String name, class_2168 source) {
        boolean bl;
        boolean exists = bl = DisplayConfig.INSTANCE.exists(name);
        boolean bl2 = false;
        if (!exists) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name)};
            FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_NOT_FOUND, pairArray);
        }
        return bl;
    }

    private final boolean createDisplay(String name, BaseDisplay display, String type, class_2168 source) {
        if (!this.validateDisplayName(name, source)) {
            return false;
        }
        DisplayConfig.INSTANCE.saveDisplay(name, new DisplayData(display));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)type), TuplesKt.to((Object)"name", (Object)name)};
        FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_CREATED, pairArray);
        return true;
    }

    public final boolean createTextDisplay(@NotNull String name, @NotNull String text, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Object[] objectArray = new String[]{text};
        return this.createDisplay(name, new TextDisplay(CollectionsKt.mutableListOf((Object[])objectArray), null, null, null, null, null, null, null, null, null, null, 2046, null), "text", source);
    }

    public final boolean createItemDisplay(@NotNull String name, @NotNull String itemId, @NotNull class_2168 source) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayName(name, source)) {
            return false;
        }
        Object fullItemId = !StringsKt.contains$default((CharSequence)itemId, (CharSequence)":", (boolean)false, (int)2, null) ? "minecraft:" + itemId : itemId;
        class_2960 itemIdentifier = class_2960.method_12829((String)fullItemId);
        if (itemIdentifier == null || !class_7923.field_41178.method_10250(itemIdentifier)) {
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_ITEM, new Pair[0]);
            bl = false;
        } else {
            bl = this.createDisplay(name, new ItemDisplay((String)fullItemId, null, null, null, null, null, null, 126, null), "item", source);
        }
        return bl;
    }

    public final boolean createBlockDisplay(@NotNull String name, @NotNull String blockId, @NotNull class_2168 source) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayName(name, source)) {
            return false;
        }
        Object fullBlockId = !StringsKt.contains$default((CharSequence)blockId, (CharSequence)":", (boolean)false, (int)2, null) ? "minecraft:" + blockId : blockId;
        class_2960 blockIdentifier = class_2960.method_12829((String)fullBlockId);
        if (blockIdentifier == null || !class_7923.field_41175.method_10250(blockIdentifier)) {
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_BLOCK, new Pair[0]);
            bl = false;
        } else {
            bl = this.createDisplay(name, new BlockDisplay((String)fullBlockId, null, null, null, null, 30, null), "block", source);
        }
        return bl;
    }

    public final boolean createEntityDisplay(@NotNull String name, @NotNull String entityId, @NotNull class_2168 source) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayName(name, source)) {
            return false;
        }
        Object fullEntityId = !StringsKt.contains$default((CharSequence)entityId, (CharSequence)":", (boolean)false, (int)2, null) ? "minecraft:" + entityId : entityId;
        class_2960 entityIdentifier = class_2960.method_12829((String)fullEntityId);
        if (entityIdentifier == null || !class_7923.field_41177.method_10250(entityIdentifier)) {
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_ENTITY, new Pair[0]);
            bl = false;
        } else {
            bl = this.createDisplay(name, new EntityDisplay((String)fullEntityId, null, null, null, null, null, 62, null), "entity", source);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void deleteDisplay(@NotNull String name, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayExists(name, source)) {
            return;
        }
        Map<String, HologramData> $this$filterValues$iv = HologramConfig.INSTANCE.getHolograms();
        boolean $i$f$filterValues = false;
        LinkedHashMap<String, HologramData> result$iv = new LinkedHashMap<String, HologramData>();
        for (Map.Entry<String, HologramData> entry$iv : $this$filterValues$iv.entrySet()) {
            boolean bl;
            block9: {
                HologramData hologram = entry$iv.getValue();
                boolean bl2 = false;
                Iterable $this$any$iv = hologram.getDisplays();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        HologramData.DisplayLine it = (HologramData.DisplayLine)element$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getDisplayId(), (Object)name)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$forEach$iv = result$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapIndexedNotNullTo$iv$iv;
            Map.Entry element$iv;
            Object element$iv2;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String hologramName = (String)entry.getKey();
            HologramData hologram = (HologramData)entry.getValue();
            Iterable $this$mapIndexedNotNull$iv = hologram.getDisplays();
            boolean $i$f$mapIndexedNotNull = false;
            element$iv2 = $this$mapIndexedNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapIndexedNotNullTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                Integer it$iv$iv;
                void displayLine;
                void element$iv$iv;
                int n;
                if ((n = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl4 = false;
                HologramData.DisplayLine displayLine2 = (HologramData.DisplayLine)element$iv$iv;
                int index = index$iv$iv;
                boolean bl5 = false;
                Integer n2 = index;
                int it = ((Number)n2).intValue();
                boolean bl6 = false;
                if ((Intrinsics.areEqual((Object)displayLine.getDisplayId(), (Object)name) ? n2 : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List indicesToRemove = (List)destination$iv$iv;
            Iterable $this$forEach$iv2 = CollectionsKt.reversed((Iterable)indicesToRemove);
            boolean $i$f$forEach2 = false;
            for (Object element$iv3 : $this$forEach$iv2) {
                int index = ((Number)element$iv3).intValue();
                boolean bl8 = false;
                HologramHandler.INSTANCE.updateHologramProperty(hologramName, new HologramHandler.HologramProperty.RemoveLine(index));
            }
        }
        DisplayConfig.INSTANCE.deleteDisplay(name);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name)};
        FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_DELETED, pairArray);
    }

    public final void updateScale(@NotNull String name, @NotNull Vector3f scale, @NotNull class_2168 source) {
        boolean validScale;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayExists(name, source)) {
            return;
        }
        boolean bl = validScale = scale.x >= 0.1f && scale.y >= 0.1f && scale.z >= 0.1f;
        if (!validScale) {
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_SCALE, new Pair[0]);
            return;
        }
        DisplayHandler.INSTANCE.updateDisplayProperty(name, new DisplayHandler.DisplayProperty.Scale(scale));
        Pair<String, Object>[] pairArray = FeedbackManager.INSTANCE.formatVector3f(scale);
        FeedbackManager.INSTANCE.send(source, FeedbackType.SCALE_UPDATED, Arrays.copyOf(pairArray, pairArray.length));
    }

    public final void resetScale(@NotNull String name, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayExists(name, source)) {
            return;
        }
        DisplayHandler.INSTANCE.updateDisplayProperty(name, new DisplayHandler.DisplayProperty.Scale(null));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"detail", (Object)"scale reset to inherit from hologram")};
        FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_UPDATED, pairArray);
    }

    public final void updateBillboard(@NotNull String name, @NotNull String mode, @NotNull class_2168 source) {
        Pair[] pairArray;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayExists(name, source)) {
            return;
        }
        try {
            String string = mode.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            pairArray = class_8113.class_8114.valueOf((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_BILLBOARD, new Pair[0]);
            return;
        }
        Pair[] newMode = pairArray;
        DisplayHandler.INSTANCE.updateDisplayProperty(name, new DisplayHandler.DisplayProperty.BillboardMode((class_8113.class_8114)newMode));
        pairArray = new Pair[1];
        String string = mode.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        pairArray[0] = TuplesKt.to((Object)"mode", (Object)string);
        FeedbackManager.INSTANCE.send(source, FeedbackType.BILLBOARD_UPDATED, pairArray);
    }

    public final void resetBillboard(@NotNull String name, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayExists(name, source)) {
            return;
        }
        DisplayHandler.INSTANCE.updateDisplayProperty(name, new DisplayHandler.DisplayProperty.BillboardMode(null));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"detail", (Object)"billboard mode reset to inherit from hologram")};
        FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_UPDATED, pairArray);
    }

    public final void updateRotation(@NotNull String name, float pitch, float yaw, float roll, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayExists(name, source)) {
            return;
        }
        if (pitch < -180.0f || pitch > 180.0f || yaw < -180.0f || yaw > 180.0f || roll < -180.0f || roll > 180.0f) {
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_ROTATION, new Pair[0]);
            return;
        }
        DisplayHandler.INSTANCE.updateDisplayProperty(name, new DisplayHandler.DisplayProperty.Rotation(new Vector3f(pitch, yaw, roll)));
        Pair<String, Object>[] pairArray = FeedbackManager.INSTANCE.formatRotation(pitch, yaw, roll);
        FeedbackManager.INSTANCE.send(source, FeedbackType.ROTATION_UPDATED, Arrays.copyOf(pairArray, pairArray.length));
    }

    public final void resetRotation(@NotNull String name, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayExists(name, source)) {
            return;
        }
        DisplayHandler.INSTANCE.updateDisplayProperty(name, new DisplayHandler.DisplayProperty.Rotation(null));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"detail", (Object)"rotation reset to inherit from hologram")};
        FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_UPDATED, pairArray);
    }

    public final void updateBackground(@NotNull String name, @NotNull String color, int opacity, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayExists(name, source)) {
            return;
        }
        CharSequence charSequence = color;
        if (!new Regex("^[0-9A-Fa-f]{6}$").matches(charSequence)) {
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_COLOR, new Pair[0]);
            return;
        }
        String string = Integer.toString((int)((double)RangesKt.coerceIn((int)opacity, (int)1, (int)100) / 100.0 * (double)255), CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = StringsKt.padStart((String)string, (int)2, (char)'0').toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        String opacityHex = string2;
        DisplayHandler.INSTANCE.updateDisplayProperty(name, new DisplayHandler.DisplayProperty.TextBackgroundColor(opacityHex + color));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"color", (Object)color), TuplesKt.to((Object)"opacity", (Object)opacity)};
        FeedbackManager.INSTANCE.send(source, FeedbackType.BACKGROUND_UPDATED, pairArray);
    }

    public final void resetBackground(@NotNull String name, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayExists(name, source)) {
            return;
        }
        DisplayHandler.INSTANCE.updateDisplayProperty(name, new DisplayHandler.DisplayProperty.TextBackgroundColor(null));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"detail", (Object)"background reset to inherit from hologram")};
        FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_UPDATED, pairArray);
    }

    public final void updateTextOpacity(@NotNull String name, int opacity, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayExists(name, source)) {
            return;
        }
        if (!(1 <= opacity ? opacity < 101 : false)) {
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_TEXT_OPACITY, new Pair[0]);
            return;
        }
        DisplayHandler.INSTANCE.updateDisplayProperty(name, new DisplayHandler.DisplayProperty.TextOpacity(opacity));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"opacity", (Object)opacity)};
        FeedbackManager.INSTANCE.send(source, FeedbackType.OPACITY_UPDATED, pairArray);
    }

    public final void updateShadow(@NotNull String name, boolean shadow, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayExists(name, source)) {
            return;
        }
        DisplayHandler.INSTANCE.updateDisplayProperty(name, new DisplayHandler.DisplayProperty.TextShadow(shadow));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"detail", (Object)("shadow " + (shadow ? "enabled" : "disabled")))};
        FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_UPDATED, pairArray);
    }

    public final void updateAlignment(@NotNull String name, @NotNull String alignment, @NotNull class_2168 source) {
        Pair[] pairArray;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayExists(name, source)) {
            return;
        }
        try {
            String string = alignment.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            pairArray = TextDisplay.TextAlignment.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_ALIGNMENT, new Pair[0]);
            return;
        }
        Pair[] textAlignment = pairArray;
        DisplayHandler.INSTANCE.updateDisplayProperty(name, new DisplayHandler.DisplayProperty.TextAlignment((TextDisplay.TextAlignment)textAlignment));
        pairArray = new Pair[1];
        String string = alignment.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        pairArray[0] = TuplesKt.to((Object)"detail", (Object)("text alignment set to " + string));
        FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_UPDATED, pairArray);
    }

    public final void updateItemDisplayType(@NotNull String name, @NotNull String type, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayExists(name, source)) {
            return;
        }
        DisplayHandler.INSTANCE.updateDisplayProperty(name, new DisplayHandler.DisplayProperty.ItemDisplayType(type));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"detail", (Object)("item display type set to " + type))};
        FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_UPDATED, pairArray);
    }

    public final void updateCustomModelData(@NotNull String name, @Nullable Integer customModelData, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayExists(name, source)) {
            return;
        }
        DisplayHandler.INSTANCE.updateDisplayProperty(name, new DisplayHandler.DisplayProperty.ItemCustomModelData(customModelData));
        Pair[] pairArray = new Pair[1];
        Object object = customModelData;
        if (object == null) {
            object = "none";
        }
        pairArray[0] = TuplesKt.to((Object)"detail", (Object)("custom model data set to " + object));
        FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_UPDATED, pairArray);
    }

    public final void updateCondition(@NotNull String name, @Nullable String condition, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayExists(name, source)) {
            return;
        }
        if (condition != null && ConditionEvaluator.INSTANCE.parseCondition(condition) == null) {
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_CONDITION, new Pair[0]);
            return;
        }
        DisplayHandler.INSTANCE.updateDisplayProperty(name, new DisplayHandler.DisplayProperty.ConditionalPlaceholder(condition));
        Pair[] pairArray = new Pair[1];
        String string = condition;
        if (string == null) {
            string = "none";
        }
        pairArray[0] = TuplesKt.to((Object)"detail", (Object)("condition set to " + string));
        FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_UPDATED, pairArray);
    }

    public final void updateLineWidth(@NotNull String displayName, int width, @NotNull class_2168 source) {
        DisplayData display;
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayExists(displayName, source)) {
            return;
        }
        DisplayData displayData = display = DisplayConfig.INSTANCE.getDisplay(displayName);
        if (!((displayData != null ? displayData.getType() : null) instanceof TextDisplay)) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"text")};
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_DISPLAY_TYPE, pairArray);
            return;
        }
        DisplayHandler.INSTANCE.updateDisplayProperty(displayName, new DisplayHandler.DisplayProperty.TextLineWidth(width));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"width", (Object)String.valueOf(width))};
        FeedbackManager.INSTANCE.send(source, FeedbackType.LINE_WIDTH_UPDATED, pairArray);
    }

    public final void updateSeeThrough(@NotNull String displayName, boolean seeThrough, @NotNull class_2168 source) {
        DisplayData display;
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayExists(displayName, source)) {
            return;
        }
        DisplayData displayData = display = DisplayConfig.INSTANCE.getDisplay(displayName);
        if (!((displayData != null ? displayData.getType() : null) instanceof TextDisplay)) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"text")};
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_DISPLAY_TYPE, pairArray);
            return;
        }
        DisplayHandler.INSTANCE.updateDisplayProperty(displayName, new DisplayHandler.DisplayProperty.TextSeeThrough(seeThrough));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"enabled", (Object)String.valueOf(seeThrough))};
        FeedbackManager.INSTANCE.send(source, FeedbackType.SEE_THROUGH_UPDATED, pairArray);
    }

    public final void updateItemId(@NotNull String displayName, @NotNull String itemId, @NotNull class_2168 source) {
        DisplayData display;
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayExists(displayName, source)) {
            return;
        }
        DisplayData displayData = display = DisplayConfig.INSTANCE.getDisplay(displayName);
        if (!((displayData != null ? displayData.getType() : null) instanceof ItemDisplay)) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"item")};
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_DISPLAY_TYPE, pairArray);
            return;
        }
        DisplayHandler.INSTANCE.updateDisplayProperty(displayName, new DisplayHandler.DisplayProperty.ItemId(itemId));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)itemId)};
        FeedbackManager.INSTANCE.send(source, FeedbackType.ITEM_ID_UPDATED, pairArray);
    }

    public final void updateBlockId(@NotNull String displayName, @NotNull String blockId, @NotNull class_2168 source) {
        DisplayData display;
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayExists(displayName, source)) {
            return;
        }
        DisplayData displayData = display = DisplayConfig.INSTANCE.getDisplay(displayName);
        if (!((displayData != null ? displayData.getType() : null) instanceof BlockDisplay)) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"block")};
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_DISPLAY_TYPE, pairArray);
            return;
        }
        DisplayHandler.INSTANCE.updateDisplayProperty(displayName, new DisplayHandler.DisplayProperty.BlockId(blockId));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)blockId)};
        FeedbackManager.INSTANCE.send(source, FeedbackType.BLOCK_ID_UPDATED, pairArray);
    }

    public final void updateEntityId(@NotNull String displayName, @NotNull String entityId, @NotNull class_2168 source) {
        DisplayData display;
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayExists(displayName, source)) {
            return;
        }
        DisplayData displayData = display = DisplayConfig.INSTANCE.getDisplay(displayName);
        if (!((displayData != null ? displayData.getType() : null) instanceof EntityDisplay)) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"entity")};
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_DISPLAY_TYPE, pairArray);
            return;
        }
        DisplayHandler.INSTANCE.updateDisplayProperty(displayName, new DisplayHandler.DisplayProperty.EntityId(entityId));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)entityId)};
        FeedbackManager.INSTANCE.send(source, FeedbackType.ENTITY_ID_UPDATED, pairArray);
    }

    public final void updateEntityGlow(@NotNull String displayName, boolean glow, @NotNull class_2168 source) {
        DisplayData display;
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayExists(displayName, source)) {
            return;
        }
        DisplayData displayData = display = DisplayConfig.INSTANCE.getDisplay(displayName);
        if (!((displayData != null ? displayData.getType() : null) instanceof EntityDisplay)) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"entity")};
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_DISPLAY_TYPE, pairArray);
            return;
        }
        DisplayHandler.INSTANCE.updateDisplayProperty(displayName, new DisplayHandler.DisplayProperty.EntityGlow(glow));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"detail", (Object)("glow " + (glow ? "enabled" : "disabled")))};
        FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_UPDATED, pairArray);
    }

    public final void updateEntityPose(@NotNull String displayName, @Nullable class_4050 pose, @NotNull class_2168 source) {
        Object object;
        Pair[] pairArray;
        block6: {
            block5: {
                DisplayData display;
                Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                if (!this.validateDisplayExists(displayName, source)) {
                    return;
                }
                DisplayData displayData = display = DisplayConfig.INSTANCE.getDisplay(displayName);
                if (!((displayData != null ? displayData.getType() : null) instanceof EntityDisplay)) {
                    Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"type", (Object)"entity")};
                    FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_DISPLAY_TYPE, pairArray2);
                    return;
                }
                DisplayHandler.INSTANCE.updateDisplayProperty(displayName, new DisplayHandler.DisplayProperty.EntityPose(pose));
                pairArray = new Pair[1];
                object = pose;
                if (object == null || (object = object.name()) == null) break block5;
                String string = ((String)object).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                object = string;
                if (string != null) break block6;
            }
            object = "none";
        }
        pairArray[0] = TuplesKt.to((Object)"detail", (Object)("pose set to " + (String)object));
        FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_UPDATED, pairArray);
    }

    public final void resetEntityPose(@NotNull String displayName, @NotNull class_2168 source) {
        DisplayData display;
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateDisplayExists(displayName, source)) {
            return;
        }
        DisplayData displayData = display = DisplayConfig.INSTANCE.getDisplay(displayName);
        if (!((displayData != null ? displayData.getType() : null) instanceof EntityDisplay)) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"entity")};
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_DISPLAY_TYPE, pairArray);
            return;
        }
        DisplayHandler.INSTANCE.updateDisplayProperty(displayName, new DisplayHandler.DisplayProperty.EntityPose(null));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"detail", (Object)"pose reset to default")};
        FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_UPDATED, pairArray);
    }
}

