/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.holodisplays.api;

import dev.furq.holodisplays.api.HoloDisplaysAPIImpl;
import dev.furq.holodisplays.data.DisplayData;
import dev.furq.holodisplays.data.HologramData;
import java.util.function.Consumer;

public interface HoloDisplaysAPI {
    public static HoloDisplaysAPI get() {
        return HoloDisplaysAPIImpl.INSTANCE;
    }

    public void clearAll();

    public boolean registerHologram(String var1, HologramData var2);

    public boolean unregisterHologram(String var1);

    public boolean updateHologram(String var1, HologramData var2);

    public boolean isHologramRegistered(String var1);

    public DisplayData createTextDisplay(String var1, Consumer<TextDisplayBuilder> var2);

    public DisplayData createItemDisplay(String var1, Consumer<ItemDisplayBuilder> var2);

    public DisplayData createBlockDisplay(String var1, Consumer<BlockDisplayBuilder> var2);

    public DisplayData createEntityDisplay(String var1, Consumer<EntityDisplayBuilder> var2);

    public HologramBuilder createHologramBuilder();

    public int unregisterAllHolograms(String var1);

    public DisplayData getDisplay(String var1);

    public HologramData getHologram(String var1);

    public static interface HologramBuilder {
        public HologramBuilder position(float var1, float var2, float var3);

        public HologramBuilder world(String var1);

        public HologramBuilder scale(float var1, float var2, float var3);

        public HologramBuilder billboardMode(String var1);

        public HologramBuilder updateRate(int var1);

        public HologramBuilder viewRange(double var1);

        public HologramBuilder rotation(float var1, float var2, float var3);

        public HologramBuilder condition(String var1);

        public HologramBuilder addDisplay(String var1, float var2, float var3, float var4);

        default public HologramBuilder addDisplay(String displayId) {
            return this.addDisplay(displayId, 0.0f, 0.0f, 0.0f);
        }

        public HologramData build();
    }

    public static interface EntityDisplayBuilder {
        public void entity(String var1);

        public void glow(boolean var1);

        public void pose(String var1);

        public void scale(float var1, float var2, float var3);

        public void rotation(float var1, float var2, float var3);

        public void condition(String var1);
    }

    public static interface BlockDisplayBuilder {
        public void block(String var1);

        public void scale(float var1, float var2, float var3);

        public void rotation(float var1, float var2, float var3);

        public void billboardMode(String var1);

        public void condition(String var1);
    }

    public static interface ItemDisplayBuilder {
        public void item(String var1);

        public void scale(float var1, float var2, float var3);

        public void rotation(float var1, float var2, float var3);

        public void billboardMode(String var1);

        public void condition(String var1);
    }

    public static interface TextDisplayBuilder {
        public void text(String ... var1);

        public void scale(float var1, float var2, float var3);

        public void rotation(float var1, float var2, float var3);

        public void billboardMode(String var1);

        public void condition(String var1);

        public void backgroundColor(String var1, int var2);

        public void shadow(boolean var1);

        public void seeThrough(boolean var1);

        public void opacity(float var1);
    }
}

