/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.holodisplays.config;

import dev.furq.holodisplays.api.HoloDisplaysAPIInternal;
import dev.furq.holodisplays.config.Config;
import dev.furq.holodisplays.data.HologramData;
import dev.furq.holodisplays.handlers.ConfigException;
import dev.furq.holodisplays.handlers.ErrorHandler;
import java.io.File;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import net.minecraft.class_2168;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\u0003J\u0017\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0019\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\f\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0019\u0010\u000eR\"\u0010\u001a\u001a\u00020\u00048\u0016@\u0016X\u0096.\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\bR \u0010 \u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u001a\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\f\n\u0004\b#\u0010$\u0012\u0004\b%\u0010\u0003\u00a8\u0006&"}, d2={"Ldev/furq/holodisplays/config/HologramConfig;", "Ldev/furq/holodisplays/config/Config;", "<init>", "()V", "Ljava/nio/file/Path;", "baseDir", "", "init", "(Ljava/nio/file/Path;)V", "reload", "", "name", "Ldev/furq/holodisplays/data/HologramData;", "getHologram", "(Ljava/lang/String;)Ldev/furq/holodisplays/data/HologramData;", "getHologramOrAPI", "", "getHolograms", "()Ljava/util/Map;", "", "exists", "(Ljava/lang/String;)Z", "hologram", "saveHologram", "(Ljava/lang/String;Ldev/furq/holodisplays/data/HologramData;)Lkotlin/Unit;", "deleteHologram", "configDir", "Ljava/nio/file/Path;", "getConfigDir", "()Ljava/nio/file/Path;", "setConfigDir", "", "holograms", "Ljava/util/Map;", "Lkotlinx/serialization/json/Json;", "json", "Lkotlinx/serialization/json/Json;", "getJson$annotations", "holodisplays"})
@SourceDebugExtension(value={"SMAP\nHologramConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HologramConfig.kt\ndev/furq/holodisplays/config/HologramConfig\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 ErrorHandler.kt\ndev/furq/holodisplays/handlers/ErrorHandler\n*L\n1#1,65:1\n13805#2:66\n13806#2:68\n222#3:67\n205#3:76\n31#4,7:69\n38#4,3:77\n31#4,10:80\n*S KotlinDebug\n*F\n+ 1 HologramConfig.kt\ndev/furq/holodisplays/config/HologramConfig\n*L\n32#1:66\n32#1:68\n34#1:67\n51#1:76\n46#1:69,7\n46#1:77,3\n55#1:80,10\n*E\n"})
public final class HologramConfig
implements Config {
    @NotNull
    public static final HologramConfig INSTANCE = new HologramConfig();
    public static Path configDir;
    @NotNull
    private static final Map<String, HologramData> holograms;
    @NotNull
    private static final Json json;

    private HologramConfig() {
    }

    @Override
    @NotNull
    public Path getConfigDir() {
        Path path = configDir;
        if (path != null) {
            return path;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"configDir");
        return null;
    }

    public void setConfigDir(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        configDir = path;
    }

    private static /* synthetic */ void getJson$annotations() {
    }

    public void init(@NotNull Path baseDir) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Path path = baseDir.resolve("holograms");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.setConfigDir(path);
        Config.super.init(baseDir);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void reload() {
        holograms.clear();
        File[] fileArray = this.getConfigDir().toFile().listFiles(HologramConfig::reload$lambda$0);
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                void this_$iv;
                File element$iv;
                File file = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)file);
                String jsonContent = FilesKt.readText$default((File)file, null, (int)1, null);
                Json json = HologramConfig.json;
                String string$iv = jsonContent;
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                HologramData hologramData = (HologramData)this_$iv.decodeFromString((DeserializationStrategy)HologramData.Companion.serializer(), string$iv);
                holograms.put(FilesKt.getNameWithoutExtension((File)file), hologramData);
            }
        } else {
            throw new ConfigException("Failed to list hologram config files");
        }
    }

    @Nullable
    public final HologramData getHologram(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return holograms.get(name);
    }

    @Nullable
    public final HologramData getHologramOrAPI(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        HologramData hologramData = holograms.get(name);
        if (hologramData == null) {
            hologramData = HoloDisplaysAPIInternal.getHologram(name);
        }
        return hologramData;
    }

    @NotNull
    public final Map<String, HologramData> getHolograms() {
        return holograms;
    }

    public final boolean exists(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return holograms.containsKey(name);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Unit saveHologram(@NotNull String name, @NotNull HologramData hologram) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)hologram, (String)"hologram");
        ErrorHandler $this$iv = ErrorHandler.INSTANCE;
        class_2168 source$iv = null;
        Unit default$iv = null;
        boolean $i$f$safeCall = false;
        try {
            void this_$iv;
            boolean bl = false;
            holograms.put(name, hologram);
            File file = INSTANCE.getConfigDir().resolve(name + ".json").toFile();
            file.getParentFile().mkdirs();
            Json json = HologramConfig.json;
            HologramData value$iv = hologram;
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            String jsonContent = this_$iv.encodeToString((SerializationStrategy)HologramData.Companion.serializer(), (Object)value$iv);
            Intrinsics.checkNotNull((Object)file);
            FilesKt.writeText$default((File)file, (String)jsonContent, null, (int)2, null);
            unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            $this$iv.handle(e$iv, source$iv);
            unit = default$iv;
        }
        return unit;
    }

    @Nullable
    public final HologramData deleteHologram(@NotNull String name) {
        HologramData hologramData;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ErrorHandler $this$iv = ErrorHandler.INSTANCE;
        class_2168 source$iv = null;
        HologramData default$iv = null;
        boolean $i$f$safeCall = false;
        try {
            boolean bl = false;
            File file = INSTANCE.getConfigDir().resolve(name + ".json").toFile();
            if (!file.exists()) {
                throw new ConfigException("Hologram config file for " + name + " does not exist");
            }
            if (!file.delete()) {
                throw new ConfigException("Failed to delete hologram config file for " + name);
            }
            hologramData = holograms.remove(name);
        }
        catch (Exception e$iv) {
            $this$iv.handle(e$iv, source$iv);
            hologramData = default$iv;
        }
        return hologramData;
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setLenient(true);
        $this$Json.setPrettyPrint(true);
        $this$Json.setAllowTrailingComma(true);
        $this$Json.setAllowComments(true);
        return Unit.INSTANCE;
    }

    private static final boolean reload$lambda$0(File it) {
        Intrinsics.checkNotNull((Object)it);
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"json");
    }

    static {
        holograms = new LinkedHashMap();
        json = JsonKt.Json$default(null, HologramConfig::json$lambda$0, (int)1, null);
    }
}

