/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.holodisplays.managers;

import dev.furq.holodisplays.config.DisplayConfig;
import dev.furq.holodisplays.config.HologramConfig;
import dev.furq.holodisplays.data.DisplayData;
import dev.furq.holodisplays.data.HologramData;
import dev.furq.holodisplays.data.display.BaseDisplay;
import dev.furq.holodisplays.data.display.BlockDisplay;
import dev.furq.holodisplays.data.display.EntityDisplay;
import dev.furq.holodisplays.data.display.ItemDisplay;
import dev.furq.holodisplays.data.display.TextDisplay;
import dev.furq.holodisplays.handlers.DisplayHandler;
import dev.furq.holodisplays.handlers.HologramHandler;
import dev.furq.holodisplays.managers.FeedbackManager;
import dev.furq.holodisplays.utils.ConditionEvaluator;
import dev.furq.holodisplays.utils.FeedbackType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.class_4050;
import net.minecraft.class_7923;
import net.minecraft.class_8113;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0082\b\u00a2\u0006\u0004\b\u000b\u0010\fJ.\u0010\r\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0082\b\u00a2\u0006\u0004\b\r\u0010\fJ[\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102*\u0010\u0014\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u00130\u0012\"\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J/\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ%\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001e\u0010\u001fJ%\u0010!\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b!\u0010\u001fJ%\u0010#\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b#\u0010\u001fJ%\u0010%\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b%\u0010\u001fJ\u001d\u0010&\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b&\u0010'J'\u0010*\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010)\u001a\u0004\u0018\u00010(2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b*\u0010+J'\u0010-\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010,\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b-\u0010.J;\u00103\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\u00100\u001a\u0004\u0018\u00010/2\b\u00101\u001a\u0004\u0018\u00010/2\b\u00102\u001a\u0004\u0018\u00010/2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b3\u00104J1\u00108\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\u00105\u001a\u0004\u0018\u00010\u00042\b\u00107\u001a\u0004\u0018\u0001062\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b8\u00109J%\u0010:\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u00107\u001a\u0002062\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b:\u0010;J%\u0010=\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b=\u0010>J%\u0010@\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b@\u0010.J%\u0010A\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\bA\u0010.J'\u0010C\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010B\u001a\u0004\u0018\u0001062\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\bC\u0010DJ'\u0010F\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010E\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\bF\u0010.J%\u0010I\u001a\u00020\t2\u0006\u0010G\u001a\u00020\u00042\u0006\u0010H\u001a\u0002062\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\bI\u0010;J%\u0010K\u001a\u00020\t2\u0006\u0010G\u001a\u00020\u00042\u0006\u0010J\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\bK\u0010>J%\u0010L\u001a\u00020\t2\u0006\u0010G\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\bL\u0010.J%\u0010M\u001a\u00020\t2\u0006\u0010G\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\bM\u0010.J%\u0010N\u001a\u00020\t2\u0006\u0010G\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\bN\u0010.J%\u0010P\u001a\u00020\t2\u0006\u0010G\u001a\u00020\u00042\u0006\u0010O\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\bP\u0010>J'\u0010S\u001a\u00020\t2\u0006\u0010G\u001a\u00020\u00042\b\u0010R\u001a\u0004\u0018\u00010Q2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\bS\u0010T\u00a8\u0006U"}, d2={"Ldev/furq/holodisplays/managers/DisplayManager;", "", "<init>", "()V", "", "name", "Lnet/minecraft/class_2168;", "source", "Lkotlin/Function0;", "", "action", "requireDisplayExists", "(Ljava/lang/String;Lnet/minecraft/class_2168;Lkotlin/jvm/functions/Function0;)V", "requireDisplayNew", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;", "property", "Ldev/furq/holodisplays/utils/FeedbackType;", "feedbackType", "", "Lkotlin/Pair;", "details", "updateProperty", "(Ljava/lang/String;Lnet/minecraft/class_2168;Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;Ldev/furq/holodisplays/utils/FeedbackType;[Lkotlin/Pair;)V", "Ldev/furq/holodisplays/data/display/BaseDisplay;", "display", "type", "", "createDisplay", "(Ljava/lang/String;Ldev/furq/holodisplays/data/display/BaseDisplay;Ljava/lang/String;Lnet/minecraft/class_2168;)Z", "text", "createTextDisplay", "(Ljava/lang/String;Ljava/lang/String;Lnet/minecraft/class_2168;)Z", "itemId", "createItemDisplay", "blockId", "createBlockDisplay", "entityId", "createEntityDisplay", "deleteDisplay", "(Ljava/lang/String;Lnet/minecraft/class_2168;)V", "Lorg/joml/Vector3f;", "scale", "updateScale", "(Ljava/lang/String;Lorg/joml/Vector3f;Lnet/minecraft/class_2168;)V", "billboard", "updateBillboard", "(Ljava/lang/String;Ljava/lang/String;Lnet/minecraft/class_2168;)V", "", "pitch", "yaw", "roll", "updateRotation", "(Ljava/lang/String;Ljava/lang/Float;Ljava/lang/Float;Ljava/lang/Float;Lnet/minecraft/class_2168;)V", "color", "", "opacity", "updateBackground", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Lnet/minecraft/class_2168;)V", "updateTextOpacity", "(Ljava/lang/String;ILnet/minecraft/class_2168;)V", "shadow", "updateShadow", "(Ljava/lang/String;ZLnet/minecraft/class_2168;)V", "alignment", "updateAlignment", "updateItemDisplayType", "customModelData", "updateCustomModelData", "(Ljava/lang/String;Ljava/lang/Integer;Lnet/minecraft/class_2168;)V", "condition", "updateCondition", "displayName", "width", "updateLineWidth", "seeThrough", "updateSeeThrough", "updateItemId", "updateBlockId", "updateEntityId", "glow", "updateEntityGlow", "Lnet/minecraft/class_4050;", "pose", "updateEntityPose", "(Ljava/lang/String;Lnet/minecraft/class_4050;Lnet/minecraft/class_2168;)V", "holodisplays"})
@SourceDebugExtension(value={"SMAP\nDisplayManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisplayManager.kt\ndev/furq/holodisplays/managers/DisplayManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,309:1\n26#1,3:310\n35#1,3:313\n26#1:316\n27#1,2:348\n26#1,3:350\n26#1,3:353\n26#1:356\n27#1,2:360\n26#1,3:362\n26#1,3:365\n26#1,3:368\n26#1,3:371\n26#1,3:374\n26#1,3:377\n26#1,3:380\n26#1,3:383\n26#1,3:386\n26#1,3:389\n26#1,3:392\n504#2,3:317\n507#2,4:323\n1761#3,3:320\n1583#3,11:328\n1878#3,2:339\n1880#3:343\n1594#3:344\n1869#3,2:345\n1761#3,3:357\n216#4:327\n217#4:347\n1#5:341\n1#5:342\n*S KotlinDebug\n*F\n+ 1 DisplayManager.kt\ndev/furq/holodisplays/managers/DisplayManager\n*L\n45#1:310,3\n52#1:313,3\n99#1:316\n99#1:348,2\n114#1:350,3\n129#1:353,3\n148#1:356\n148#1:360,2\n162#1:362,3\n183#1:365,3\n197#1:368,3\n216#1:371,3\n227#1:374,3\n239#1:377,3\n251#1:380,3\n263#1:383,3\n275#1:386,3\n287#1:389,3\n299#1:392,3\n101#1:317,3\n101#1:323,4\n101#1:320,3\n103#1:328,11\n103#1:339,2\n103#1:343\n103#1:344\n104#1:345,2\n151#1:357,3\n102#1:327\n102#1:347\n103#1:342\n*E\n"})
public final class DisplayManager {
    @NotNull
    public static final DisplayManager INSTANCE = new DisplayManager();

    private DisplayManager() {
    }

    private final void requireDisplayExists(String name, class_2168 source, Function0<Unit> action) {
        boolean $i$f$requireDisplayExists = false;
        if (DisplayConfig.INSTANCE.exists(name)) {
            action.invoke();
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name)};
            FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_NOT_FOUND, pairArray);
        }
    }

    private final void requireDisplayNew(String name, class_2168 source, Function0<Unit> action) {
        boolean $i$f$requireDisplayNew = false;
        if (!DisplayConfig.INSTANCE.exists(name)) {
            action.invoke();
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name)};
            FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_EXISTS, pairArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateProperty(String name, class_2168 source, DisplayHandler.DisplayProperty property, FeedbackType feedbackType, Pair<String, ? extends Object> ... details) {
        void name$iv;
        DisplayManager displayManager = this;
        String string = name;
        class_2168 source$iv = source;
        boolean $i$f$requireDisplayExists = false;
        if (DisplayConfig.INSTANCE.exists((String)name$iv)) {
            boolean bl = false;
            DisplayHandler.INSTANCE.updateDisplayProperty(name, property);
            FeedbackManager.INSTANCE.send(source, feedbackType, Arrays.copyOf(details, details.length));
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.DISPLAY_NOT_FOUND, pairArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean createDisplay(String name, BaseDisplay display, String type, class_2168 source) {
        void name$iv;
        boolean created = false;
        DisplayManager displayManager = this;
        String string = name;
        class_2168 source$iv = source;
        boolean $i$f$requireDisplayNew = false;
        if (!DisplayConfig.INSTANCE.exists((String)name$iv)) {
            boolean bl = false;
            DisplayConfig.INSTANCE.saveDisplay(name, new DisplayData(display));
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)type), TuplesKt.to((Object)"name", (Object)name)};
            FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_CREATED, pairArray);
            created = true;
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.DISPLAY_EXISTS, pairArray);
        }
        return created;
    }

    public final boolean createTextDisplay(@NotNull String name, @NotNull String text, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Object[] objectArray = new String[]{text};
        return this.createDisplay(name, new TextDisplay(CollectionsKt.mutableListOf((Object[])objectArray), null, null, null, null, null, null, null, null, null, null, 2046, null), "text", source);
    }

    public final boolean createItemDisplay(@NotNull String name, @NotNull String itemId, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Object fullItemId = !StringsKt.contains$default((CharSequence)itemId, (CharSequence)":", (boolean)false, (int)2, null) ? "minecraft:" + itemId : itemId;
        class_2960 itemIdentifier = class_2960.method_12829((String)fullItemId);
        if (itemIdentifier == null || !class_7923.field_41178.method_10250(itemIdentifier)) {
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_ITEM, new Pair[0]);
            return false;
        }
        return this.createDisplay(name, new ItemDisplay((String)fullItemId, null, null, null, null, null, null, 126, null), "item", source);
    }

    public final boolean createBlockDisplay(@NotNull String name, @NotNull String blockId, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Object fullBlockId = !StringsKt.contains$default((CharSequence)blockId, (CharSequence)":", (boolean)false, (int)2, null) ? "minecraft:" + blockId : blockId;
        class_2960 blockIdentifier = class_2960.method_12829((String)fullBlockId);
        if (blockIdentifier == null || !class_7923.field_41175.method_10250(blockIdentifier)) {
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_BLOCK, new Pair[0]);
            return false;
        }
        return this.createDisplay(name, new BlockDisplay((String)fullBlockId, null, null, null, null, 30, null), "block", source);
    }

    public final boolean createEntityDisplay(@NotNull String name, @NotNull String entityId, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Object fullEntityId = !StringsKt.contains$default((CharSequence)entityId, (CharSequence)":", (boolean)false, (int)2, null) ? "minecraft:" + entityId : entityId;
        class_2960 entityIdentifier = class_2960.method_12829((String)fullEntityId);
        if (entityIdentifier == null || !class_7923.field_41177.method_10250(entityIdentifier)) {
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_ENTITY, new Pair[0]);
            return false;
        }
        return this.createDisplay(name, new EntityDisplay((String)fullEntityId, null, null, null, null, null, 62, null), "entity", source);
    }

    /*
     * WARNING - void declaration
     */
    public final void deleteDisplay(@NotNull String name, @NotNull class_2168 source) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        DisplayManager displayManager = this;
        String string = name;
        class_2168 source$iv = source;
        boolean $i$f$requireDisplayExists = false;
        if (DisplayConfig.INSTANCE.exists((String)name$iv)) {
            void $this$forEach$iv;
            Map $this$filterValues$iv;
            boolean bl = false;
            Pair[] pairArray = HologramConfig.INSTANCE.getHolograms();
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                boolean bl2;
                block10: {
                    HologramData hologram = (HologramData)entry$iv.getValue();
                    boolean bl3 = false;
                    Iterable $this$any$iv = hologram.getDisplays();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            HologramData.DisplayLine it = (HologramData.DisplayLine)element$iv2;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                            bl2 = true;
                            break block10;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterValues$iv = result$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void $this$mapIndexedNotNullTo$iv$iv;
                Map.Entry element$iv;
                Object element$iv2;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl5 = false;
                String hologramName = (String)entry.getKey();
                HologramData hologram = (HologramData)entry.getValue();
                Iterable $this$mapIndexedNotNull$iv = hologram.getDisplays();
                boolean $i$f$mapIndexedNotNull = false;
                element$iv2 = $this$mapIndexedNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapIndexedNotNullTo = false;
                void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv$iv$iv = 0;
                for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                    Integer it$iv$iv;
                    void displayLine;
                    void element$iv$iv;
                    int n;
                    if ((n = index$iv$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t = item$iv$iv$iv;
                    int index$iv$iv = n;
                    boolean bl6 = false;
                    HologramData.DisplayLine displayLine2 = (HologramData.DisplayLine)element$iv$iv;
                    int index = index$iv$iv;
                    boolean bl7 = false;
                    Integer n2 = index;
                    int it = ((Number)n2).intValue();
                    boolean bl8 = false;
                    if ((Intrinsics.areEqual((Object)displayLine.getName(), (Object)name) ? n2 : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl9 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List indicesToRemove = (List)destination$iv$iv;
                Iterable $this$forEach$iv2 = CollectionsKt.reversed((Iterable)indicesToRemove);
                boolean $i$f$forEach2 = false;
                for (Object element$iv3 : $this$forEach$iv2) {
                    int index = ((Number)element$iv3).intValue();
                    boolean bl10 = false;
                    HologramHandler.INSTANCE.updateHologramProperty(hologramName, new HologramHandler.HologramProperty.RemoveLine(index));
                }
            }
            DisplayConfig.INSTANCE.deleteDisplay(name);
            pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name)};
            FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_DELETED, pairArray);
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.DISPLAY_NOT_FOUND, pairArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateScale(@NotNull String name, @Nullable Vector3f scale, @NotNull class_2168 source) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        DisplayManager displayManager = this;
        String string = name;
        class_2168 source$iv = source;
        boolean $i$f$requireDisplayExists = false;
        if (DisplayConfig.INSTANCE.exists((String)name$iv)) {
            Vector3f newScale;
            boolean bl = false;
            Vector3f vector3f = scale;
            if (vector3f == null) {
                vector3f = newScale = new Vector3f(1.0f);
            }
            if (scale != null && (newScale.x < 0.1f || newScale.y < 0.1f || newScale.z < 0.1f)) {
                FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_SCALE, new Pair[0]);
                return;
            }
            Pair<String, Object>[] pairArray = FeedbackManager.INSTANCE.formatVector3f(newScale);
            INSTANCE.updateProperty(name, source, new DisplayHandler.DisplayProperty.Scale(newScale), FeedbackType.SCALE_UPDATED, Arrays.copyOf(pairArray, pairArray.length));
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.DISPLAY_NOT_FOUND, pairArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateBillboard(@NotNull String name, @Nullable String billboard, @NotNull class_2168 source) {
        block10: {
            void name$iv;
            class_2168 source$iv;
            block7: {
                String string;
                DisplayHandler.DisplayProperty displayProperty;
                Pair[] pairArray;
                block9: {
                    block8: {
                        class_8113.class_8114 class_81142;
                        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                        DisplayManager displayManager = this;
                        String string2 = name;
                        source$iv = source;
                        boolean $i$f$requireDisplayExists = false;
                        if (!DisplayConfig.INSTANCE.exists((String)name$iv)) break block7;
                        boolean bl = false;
                        if (billboard == null) {
                            class_81142 = class_8113.class_8114.field_42409;
                        } else {
                            try {
                                String string3 = billboard.toUpperCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
                                pairArray = class_8113.class_8114.valueOf((String)string3);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_BILLBOARD, new Pair[0]);
                                return;
                            }
                            class_81142 = pairArray;
                        }
                        class_8113.class_8114 newMode = class_81142;
                        displayProperty = new DisplayHandler.DisplayProperty.BillboardMode(newMode);
                        pairArray = new Pair[1];
                        string = billboard;
                        if (string == null) break block8;
                        String string4 = string.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                        string = string4;
                        if (string4 != null) break block9;
                    }
                    string = "center";
                }
                pairArray[0] = TuplesKt.to((Object)"mode", (Object)string);
                INSTANCE.updateProperty(name, source, displayProperty, FeedbackType.BILLBOARD_UPDATED, pairArray);
                break block10;
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.DISPLAY_NOT_FOUND, pairArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateRotation(@NotNull String name, @Nullable Float pitch, @Nullable Float yaw, @Nullable Float roll, @NotNull class_2168 source) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        DisplayManager displayManager = this;
        String string = name;
        class_2168 source$iv = source;
        boolean $i$f$requireDisplayExists = false;
        if (DisplayConfig.INSTANCE.exists((String)name$iv)) {
            boolean bl;
            Object[] objectArray;
            Vector3f rotation;
            block6: {
                boolean bl2 = false;
                rotation = pitch == null || yaw == null || roll == null ? new Vector3f() : new Vector3f(pitch.floatValue(), yaw.floatValue(), roll.floatValue());
                objectArray = new Float[]{Float.valueOf(rotation.x), Float.valueOf(rotation.y), Float.valueOf(rotation.z)};
                Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        float it = ((Number)element$iv).floatValue();
                        boolean bl3 = false;
                        boolean bl4 = -180.0f <= it ? it <= 180.0f : false;
                        if (!(!bl4)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_ROTATION, new Pair[0]);
                return;
            }
            objectArray = FeedbackManager.INSTANCE.formatRotation(rotation.x, rotation.y, rotation.z);
            INSTANCE.updateProperty(name, source, new DisplayHandler.DisplayProperty.Rotation(rotation), FeedbackType.ROTATION_UPDATED, (Pair[])Arrays.copyOf(objectArray, objectArray.length));
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.DISPLAY_NOT_FOUND, pairArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateBackground(@NotNull String name, @Nullable String color, @Nullable Integer opacity, @NotNull class_2168 source) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        DisplayManager displayManager = this;
        String string = name;
        class_2168 source$iv = source;
        boolean $i$f$requireDisplayExists = false;
        if (DisplayConfig.INSTANCE.exists((String)name$iv)) {
            boolean bl = false;
            if (color != null) {
                CharSequence charSequence = color;
                if (!new Regex("^[0-9A-Fa-f]{6}$").matches(charSequence)) {
                    FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_COLOR, new Pair[0]);
                    return;
                }
                Integer n = opacity;
                int n2 = ((Number)(n != null ? (Number)RangesKt.coerceIn((int)n, (int)0, (int)100) : (Number)255.0)).intValue();
                int n3 = 16;
                String string2 = Integer.toString(n2, CharsKt.checkRadix((int)n3));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                String string3 = StringsKt.padStart((String)string2, (int)2, (char)'0').toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
                String opacityHex = string3;
                DisplayHandler.DisplayProperty displayProperty = new DisplayHandler.DisplayProperty.TextBackgroundColor(opacityHex + color);
                Pair[] pairArray = new Pair[2];
                pairArray[0] = TuplesKt.to((Object)"color", (Object)color);
                Integer n4 = opacity;
                Intrinsics.checkNotNull((Object)n4);
                pairArray[1] = TuplesKt.to((Object)"opacity", (Object)n4);
                INSTANCE.updateProperty(name, source, displayProperty, FeedbackType.BACKGROUND_UPDATED, pairArray);
            } else {
                INSTANCE.updateProperty(name, source, new DisplayHandler.DisplayProperty.TextBackgroundColor(null), FeedbackType.BACKGROUND_UPDATED, new Pair[0]);
            }
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.DISPLAY_NOT_FOUND, pairArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateTextOpacity(@NotNull String name, int opacity, @NotNull class_2168 source) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        DisplayManager displayManager = this;
        String string = name;
        class_2168 source$iv = source;
        boolean $i$f$requireDisplayExists = false;
        if (DisplayConfig.INSTANCE.exists((String)name$iv)) {
            boolean bl = false;
            if (!(1 <= opacity ? opacity < 101 : false)) {
                FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_TEXT_OPACITY, new Pair[0]);
                return;
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"opacity", (Object)opacity)};
            INSTANCE.updateProperty(name, source, new DisplayHandler.DisplayProperty.TextOpacity(opacity), FeedbackType.OPACITY_UPDATED, pairArray);
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.DISPLAY_NOT_FOUND, pairArray);
        }
    }

    public final void updateShadow(@NotNull String name, boolean shadow, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"detail", (Object)("shadow " + (shadow ? "enabled" : "disabled")))};
        this.updateProperty(name, source, new DisplayHandler.DisplayProperty.TextShadow(shadow), FeedbackType.DISPLAY_UPDATED, pairArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateAlignment(@NotNull String name, @NotNull String alignment, @NotNull class_2168 source) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        DisplayManager displayManager = this;
        String string = name;
        class_2168 source$iv = source;
        boolean $i$f$requireDisplayExists = false;
        if (DisplayConfig.INSTANCE.exists((String)name$iv)) {
            Pair[] pairArray;
            boolean bl = false;
            try {
                String string2 = alignment.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                pairArray = TextDisplay.TextAlignment.valueOf(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_ALIGNMENT, new Pair[0]);
                return;
            }
            Pair[] textAlignment = pairArray;
            DisplayHandler.DisplayProperty displayProperty = new DisplayHandler.DisplayProperty.TextAlignment((TextDisplay.TextAlignment)textAlignment);
            pairArray = new Pair[1];
            String string3 = alignment.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            pairArray[0] = TuplesKt.to((Object)"detail", (Object)("text alignment set to " + string3));
            INSTANCE.updateProperty(name, source, displayProperty, FeedbackType.DISPLAY_UPDATED, pairArray);
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.DISPLAY_NOT_FOUND, pairArray);
        }
    }

    public final void updateItemDisplayType(@NotNull String name, @NotNull String type, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"detail", (Object)("item display type set to " + type))};
        this.updateProperty(name, source, new DisplayHandler.DisplayProperty.ItemDisplayType(type), FeedbackType.DISPLAY_UPDATED, pairArray);
    }

    public final void updateCustomModelData(@NotNull String name, @Nullable Integer customModelData, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        DisplayHandler.DisplayProperty displayProperty = new DisplayHandler.DisplayProperty.ItemCustomModelData(customModelData);
        Pair[] pairArray = new Pair[1];
        Object object = customModelData;
        if (object == null) {
            object = "none";
        }
        pairArray[0] = TuplesKt.to((Object)"detail", (Object)("custom model data set to " + object));
        this.updateProperty(name, source, displayProperty, FeedbackType.DISPLAY_UPDATED, pairArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateCondition(@NotNull String name, @Nullable String condition, @NotNull class_2168 source) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        DisplayManager displayManager = this;
        String string = name;
        class_2168 source$iv = source;
        boolean $i$f$requireDisplayExists = false;
        if (DisplayConfig.INSTANCE.exists((String)name$iv)) {
            boolean bl = false;
            if (condition != null && ConditionEvaluator.INSTANCE.parseCondition(condition) == null) {
                FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_CONDITION, new Pair[0]);
                return;
            }
            DisplayHandler.DisplayProperty displayProperty = new DisplayHandler.DisplayProperty.ConditionalPlaceholder(condition);
            Pair[] pairArray = new Pair[1];
            String string2 = condition;
            if (string2 == null) {
                string2 = "none";
            }
            pairArray[0] = TuplesKt.to((Object)"detail", (Object)("condition set to " + string2));
            INSTANCE.updateProperty(name, source, displayProperty, FeedbackType.DISPLAY_UPDATED, pairArray);
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.DISPLAY_NOT_FOUND, pairArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateLineWidth(@NotNull String displayName, int width, @NotNull class_2168 source) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        DisplayManager displayManager = this;
        String string = displayName;
        class_2168 source$iv = source;
        boolean $i$f$requireDisplayExists = false;
        if (DisplayConfig.INSTANCE.exists((String)name$iv)) {
            DisplayData display;
            boolean bl = false;
            DisplayData displayData = display = DisplayConfig.INSTANCE.getDisplay(displayName);
            if (!((displayData != null ? displayData.getType() : null) instanceof TextDisplay)) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"text")};
                FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_DISPLAY_TYPE, pairArray);
                return;
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"width", (Object)String.valueOf(width))};
            INSTANCE.updateProperty(displayName, source, new DisplayHandler.DisplayProperty.TextLineWidth(width), FeedbackType.LINE_WIDTH_UPDATED, pairArray);
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.DISPLAY_NOT_FOUND, pairArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateSeeThrough(@NotNull String displayName, boolean seeThrough, @NotNull class_2168 source) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        DisplayManager displayManager = this;
        String string = displayName;
        class_2168 source$iv = source;
        boolean $i$f$requireDisplayExists = false;
        if (DisplayConfig.INSTANCE.exists((String)name$iv)) {
            DisplayData display;
            boolean bl = false;
            DisplayData displayData = display = DisplayConfig.INSTANCE.getDisplay(displayName);
            if (!((displayData != null ? displayData.getType() : null) instanceof TextDisplay)) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"text")};
                FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_DISPLAY_TYPE, pairArray);
                return;
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"enabled", (Object)String.valueOf(seeThrough))};
            INSTANCE.updateProperty(displayName, source, new DisplayHandler.DisplayProperty.TextSeeThrough(seeThrough), FeedbackType.SEE_THROUGH_UPDATED, pairArray);
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.DISPLAY_NOT_FOUND, pairArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateItemId(@NotNull String displayName, @NotNull String itemId, @NotNull class_2168 source) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        DisplayManager displayManager = this;
        String string = displayName;
        class_2168 source$iv = source;
        boolean $i$f$requireDisplayExists = false;
        if (DisplayConfig.INSTANCE.exists((String)name$iv)) {
            DisplayData display;
            boolean bl = false;
            DisplayData displayData = display = DisplayConfig.INSTANCE.getDisplay(displayName);
            if (!((displayData != null ? displayData.getType() : null) instanceof ItemDisplay)) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"item")};
                FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_DISPLAY_TYPE, pairArray);
                return;
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)itemId)};
            INSTANCE.updateProperty(displayName, source, new DisplayHandler.DisplayProperty.ItemId(itemId), FeedbackType.ITEM_ID_UPDATED, pairArray);
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.DISPLAY_NOT_FOUND, pairArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateBlockId(@NotNull String displayName, @NotNull String blockId, @NotNull class_2168 source) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        DisplayManager displayManager = this;
        String string = displayName;
        class_2168 source$iv = source;
        boolean $i$f$requireDisplayExists = false;
        if (DisplayConfig.INSTANCE.exists((String)name$iv)) {
            DisplayData display;
            boolean bl = false;
            DisplayData displayData = display = DisplayConfig.INSTANCE.getDisplay(displayName);
            if (!((displayData != null ? displayData.getType() : null) instanceof BlockDisplay)) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"block")};
                FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_DISPLAY_TYPE, pairArray);
                return;
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)blockId)};
            INSTANCE.updateProperty(displayName, source, new DisplayHandler.DisplayProperty.BlockId(blockId), FeedbackType.BLOCK_ID_UPDATED, pairArray);
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.DISPLAY_NOT_FOUND, pairArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateEntityId(@NotNull String displayName, @NotNull String entityId, @NotNull class_2168 source) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        DisplayManager displayManager = this;
        String string = displayName;
        class_2168 source$iv = source;
        boolean $i$f$requireDisplayExists = false;
        if (DisplayConfig.INSTANCE.exists((String)name$iv)) {
            DisplayData display;
            boolean bl = false;
            DisplayData displayData = display = DisplayConfig.INSTANCE.getDisplay(displayName);
            if (!((displayData != null ? displayData.getType() : null) instanceof EntityDisplay)) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"entity")};
                FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_DISPLAY_TYPE, pairArray);
                return;
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)entityId)};
            INSTANCE.updateProperty(displayName, source, new DisplayHandler.DisplayProperty.EntityId(entityId), FeedbackType.ENTITY_ID_UPDATED, pairArray);
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.DISPLAY_NOT_FOUND, pairArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateEntityGlow(@NotNull String displayName, boolean glow, @NotNull class_2168 source) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        DisplayManager displayManager = this;
        String string = displayName;
        class_2168 source$iv = source;
        boolean $i$f$requireDisplayExists = false;
        if (DisplayConfig.INSTANCE.exists((String)name$iv)) {
            DisplayData display;
            boolean bl = false;
            DisplayData displayData = display = DisplayConfig.INSTANCE.getDisplay(displayName);
            if (!((displayData != null ? displayData.getType() : null) instanceof EntityDisplay)) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"entity")};
                FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_DISPLAY_TYPE, pairArray);
                return;
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"detail", (Object)("glow " + (glow ? "enabled" : "disabled")))};
            INSTANCE.updateProperty(displayName, source, new DisplayHandler.DisplayProperty.EntityGlow(glow), FeedbackType.DISPLAY_UPDATED, pairArray);
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.DISPLAY_NOT_FOUND, pairArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateEntityPose(@NotNull String displayName, @Nullable class_4050 pose, @NotNull class_2168 source) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        DisplayManager displayManager = this;
        String string = displayName;
        class_2168 source$iv = source;
        boolean $i$f$requireDisplayExists = false;
        if (DisplayConfig.INSTANCE.exists((String)name$iv)) {
            DisplayData display;
            boolean bl = false;
            DisplayData displayData = display = DisplayConfig.INSTANCE.getDisplay(displayName);
            if (!((displayData != null ? displayData.getType() : null) instanceof EntityDisplay)) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"entity")};
                FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_DISPLAY_TYPE, pairArray);
                return;
            }
            INSTANCE.updateProperty(displayName, source, new DisplayHandler.DisplayProperty.EntityPose(pose), FeedbackType.DISPLAY_UPDATED, new Pair[0]);
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.DISPLAY_NOT_FOUND, pairArray);
        }
    }
}

