/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.holodisplays.handlers;

import dev.furq.holodisplays.api.HoloDisplaysAPIImpl;
import dev.furq.holodisplays.config.AnimationConfig;
import dev.furq.holodisplays.config.DisplayConfig;
import dev.furq.holodisplays.config.HologramConfig;
import dev.furq.holodisplays.data.AnimationData;
import dev.furq.holodisplays.data.DisplayData;
import dev.furq.holodisplays.data.HologramData;
import dev.furq.holodisplays.data.display.BaseDisplay;
import dev.furq.holodisplays.data.display.TextDisplay;
import dev.furq.holodisplays.handlers.PacketHandler;
import dev.furq.holodisplays.handlers.ViewerHandler;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.api.parsers.TagParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001<B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001b\u0010\t\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000b\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\nJ-\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J!\u0010\u001c\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001d\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u00062\u0006\u0010\u0012\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010\"\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\"\u0010#J=\u0010&\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f2\u0006\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b&\u0010'J\u001d\u0010(\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u0007\u00a2\u0006\u0004\b(\u0010#R\u0016\u0010)\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*R,\u0010-\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00130,\u0012\u0004\u0012\u00020\f0+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R#\u00105\u001a\n 0*\u0004\u0018\u00010/0/8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b3\u00104R\u0014\u00107\u001a\u0002068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0014\u00109\u001a\u0002068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u00108R \u0010;\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020:0+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010.\u00a8\u0006="}, d2={"Ldev/furq/holodisplays/handlers/TickHandler;", "", "<init>", "()V", "", "init", "", "Lnet/minecraft/class_3222;", "players", "tick", "(Ljava/util/List;)V", "processHolograms", "", "name", "Ldev/furq/holodisplays/data/HologramData;", "hologram", "processHologramDisplays", "(Ljava/lang/String;Ldev/furq/holodisplays/data/HologramData;Ljava/util/List;)V", "text", "", "updateRate", "", "shouldUpdateDisplay", "(Ljava/lang/String;I)Z", "processAnimations", "(Ljava/lang/String;)Ljava/lang/String;", "animationName", "currentTick", "getAnimationFrame", "(Ljava/lang/String;I)Ljava/lang/String;", "findAnimationIntervals", "(Ljava/lang/String;)Ljava/util/List;", "player", "Lnet/minecraft/class_2561;", "processPlaceholders", "(Ljava/lang/String;Lnet/minecraft/class_3222;)Lnet/minecraft/class_2561;", "displayRef", "index", "updateDisplayForViewers", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/util/List;)V", "processText", "ticks", "I", "", "Lkotlin/Pair;", "animationCache", "Ljava/util/Map;", "Leu/pb4/placeholders/api/parsers/NodeParser;", "kotlin.jvm.PlatformType", "placeholderParser$delegate", "Lkotlin/Lazy;", "getPlaceholderParser", "()Leu/pb4/placeholders/api/parsers/NodeParser;", "placeholderParser", "Lkotlin/text/Regex;", "animationRegex", "Lkotlin/text/Regex;", "placeholderRegex", "Ldev/furq/holodisplays/handlers/TickHandler$CachedTextInfo;", "textCache", "CachedTextInfo", "holodisplays"})
@SourceDebugExtension(value={"SMAP\nTickHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TickHandler.kt\ndev/furq/holodisplays/handlers/TickHandler\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,128:1\n216#2,2:129\n216#2,2:131\n1878#3,3:133\n1761#3,3:143\n774#3:146\n865#3,2:147\n1869#3,2:149\n382#4,7:136\n382#4,7:151\n*S KotlinDebug\n*F\n+ 1 TickHandler.kt\ndev/furq/holodisplays/handlers/TickHandler\n*L\n44#1:129,2\n49#1:131,2\n56#1:133,3\n76#1:143,3\n117#1:146\n117#1:147,2\n118#1:149,2\n68#1:136,7\n89#1:151,7\n*E\n"})
public final class TickHandler {
    @NotNull
    public static final TickHandler INSTANCE = new TickHandler();
    private static int ticks;
    @NotNull
    private static final Map<Pair<String, Integer>, String> animationCache;
    @NotNull
    private static final Lazy placeholderParser$delegate;
    @NotNull
    private static final Regex animationRegex;
    @NotNull
    private static final Regex placeholderRegex;
    @NotNull
    private static final Map<String, CachedTextInfo> textCache;

    private TickHandler() {
    }

    private final NodeParser getPlaceholderParser() {
        Lazy lazy = placeholderParser$delegate;
        return (NodeParser)lazy.getValue();
    }

    public final void init() {
        animationCache.clear();
        textCache.clear();
        ticks = 0;
    }

    public final void tick(@NotNull List<? extends class_3222> players) {
        Intrinsics.checkNotNullParameter(players, (String)"players");
        this.processHolograms(players);
        int n = ticks;
        ticks = n + 1;
    }

    private final void processHolograms(List<? extends class_3222> players) {
        HologramData hologram;
        String name;
        Map.Entry<String, HologramData> entry;
        Map.Entry<String, HologramData> element$iv;
        Map<String, HologramData> $this$forEach$iv = HologramConfig.INSTANCE.getHolograms();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, HologramData>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            name = entry.getKey();
            hologram = entry.getValue();
            if (ViewerHandler.INSTANCE.getObserverCount(name) == 0) continue;
            INSTANCE.processHologramDisplays(name, hologram, players);
        }
        Map<String, HologramData> map = HoloDisplaysAPIImpl.INSTANCE.apiHolograms;
        Intrinsics.checkNotNullExpressionValue(map, (String)"apiHolograms");
        $this$forEach$iv = map;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            name = entry.getKey();
            hologram = entry.getValue();
            Intrinsics.checkNotNull((Object)name);
            if (ViewerHandler.INSTANCE.getObserverCount(name) == 0) continue;
            Intrinsics.checkNotNull((Object)hologram);
            INSTANCE.processHologramDisplays(name, hologram, players);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processHologramDisplays(String name, HologramData hologram, List<? extends class_3222> players) {
        Iterable $this$forEachIndexed$iv = hologram.getDisplays();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            TextDisplay display;
            String text;
            void displayLine;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            HologramData.DisplayLine displayLine2 = (HologramData.DisplayLine)item$iv;
            int index = n;
            boolean bl = false;
            DisplayData displayData = DisplayConfig.INSTANCE.getDisplayOrAPI(displayLine.getDisplayId());
            BaseDisplay baseDisplay = displayData != null ? displayData.getType() : null;
            TextDisplay textDisplay = baseDisplay instanceof TextDisplay ? (TextDisplay)baseDisplay : null;
            if (textDisplay == null || !INSTANCE.shouldUpdateDisplay(text = (display = textDisplay).getText(), hologram.getUpdateRate())) continue;
            INSTANCE.updateDisplayForViewers(name, displayLine.getDisplayId(), index, text, players);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean shouldUpdateDisplay(String text, int updateRate) {
        boolean bl;
        block9: {
            Object object;
            void $this$getOrPut$iv;
            Map<String, CachedTextInfo> map = textCache;
            String key$iv = text;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                boolean hasAnimation = animationRegex.containsMatchIn((CharSequence)text);
                boolean hasPlaceholder = placeholderRegex.containsMatchIn((CharSequence)text);
                List<Integer> intervals = hasAnimation ? INSTANCE.findAnimationIntervals(text) : null;
                CachedTextInfo answer$iv = new CachedTextInfo(hasAnimation, hasPlaceholder, intervals);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            CachedTextInfo info = (CachedTextInfo)object;
            if (info.getHasAnimation()) {
                List<Integer> list = info.getAnimationIntervals();
                if (list != null) {
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            int interval = ((Number)element$iv).intValue();
                            boolean bl3 = false;
                            if (!(ticks % interval == 0)) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            } else {
                bl = info.getHasPlaceholder() ? ticks % (updateRate <= 0 ? 20 : updateRate) == 0 : false;
            }
        }
        return bl;
    }

    private final String processAnimations(String text) {
        return animationRegex.replace((CharSequence)text, TickHandler::processAnimations$lambda$0);
    }

    private final String getAnimationFrame(String animationName, int currentTick) {
        AnimationData animationData = AnimationConfig.INSTANCE.getAnimation(animationName);
        if (animationData == null) {
            return null;
        }
        AnimationData animation = animationData;
        if (animation.getFrames().isEmpty()) {
            return null;
        }
        int currentIndex = currentTick / animation.getInterval() % animation.getFrames().size();
        return animation.getFrames().get(currentIndex).getText();
    }

    private final List<Integer> findAnimationIntervals(String text) {
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)Regex.findAll$default((Regex)animationRegex, (CharSequence)text, (int)0, (int)2, null), TickHandler::findAnimationIntervals$lambda$0));
    }

    private final class_2561 processPlaceholders(String text, class_3222 player) {
        TextNode node = this.getPlaceholderParser().parseNode(text);
        class_2561 class_25612 = node.toText(PlaceholderContext.of((class_3222)player));
        Intrinsics.checkNotNullExpressionValue((Object)class_25612, (String)"toText(...)");
        return class_25612;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateDisplayForViewers(String name, String displayRef, int index, String text, List<? extends class_3222> players) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = players;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            class_3222 it = (class_3222)element$iv$iv;
            boolean bl = false;
            if (!ViewerHandler.INSTANCE.isViewing(it, name)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List viewers = (List)destination$iv$iv;
        Iterable $this$forEach$iv = viewers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 player = (class_3222)element$iv;
            boolean bl = false;
            class_2561 processedText = INSTANCE.processText(text, player);
            PacketHandler.INSTANCE.updateTextMetadata(player, name, displayRef, index, processedText);
        }
    }

    @NotNull
    public final class_2561 processText(@NotNull String text, @NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        String processedAnimations = this.processAnimations(text);
        return this.processPlaceholders(processedAnimations, player);
    }

    private static final NodeParser placeholderParser_delegate$lambda$0() {
        NodeParser[] nodeParserArray = new NodeParser[]{TagParser.DEFAULT, Placeholders.DEFAULT_PLACEHOLDER_PARSER};
        return NodeParser.merge((NodeParser[])nodeParserArray);
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence processAnimations$lambda$0(MatchResult match) {
        Object object;
        void $this$getOrPut$iv;
        AnimationData animation;
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        String animationName = (String)match.getGroupValues().get(1);
        AnimationData animationData = animation = AnimationConfig.INSTANCE.getAnimation(animationName);
        Pair cacheKey = TuplesKt.to((Object)animationName, (Object)(ticks / (animationData != null ? animationData.getInterval() : 1)));
        Map<Pair<String, Integer>, String> map = animationCache;
        Pair key$iv = cacheKey;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Object object2 = INSTANCE.getAnimationFrame(animationName, ticks);
            if (object2 == null) {
                object2 = "<red>Invalid animation: " + animationName + "</red>";
            }
            String answer$iv = object2;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CharSequence)object;
    }

    private static final Integer findAnimationIntervals$lambda$0(MatchResult match) {
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        String animationName = (String)match.getGroupValues().get(1);
        AnimationData animationData = AnimationConfig.INSTANCE.getAnimation(animationName);
        return animationData != null ? Integer.valueOf(animationData.getInterval()) : null;
    }

    static {
        animationCache = new LinkedHashMap();
        placeholderParser$delegate = LazyKt.lazy(TickHandler::placeholderParser_delegate$lambda$0);
        animationRegex = new Regex("<animation:([^>]+)>");
        placeholderRegex = new Regex("%([^%:]+):([^%]+)%");
        textCache = new LinkedHashMap();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\u000bJ\u0018\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ6\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0012\u001a\u00020\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0019\u001a\u0004\b\u001a\u0010\u000bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0019\u001a\u0004\b\u001b\u0010\u000bR\u001f\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001c\u001a\u0004\b\u001d\u0010\u000e\u00a8\u0006\u001e"}, d2={"Ldev/furq/holodisplays/handlers/TickHandler$CachedTextInfo;", "", "", "hasAnimation", "hasPlaceholder", "", "", "animationIntervals", "<init>", "(ZZLjava/util/List;)V", "component1", "()Z", "component2", "component3", "()Ljava/util/List;", "copy", "(ZZLjava/util/List;)Ldev/furq/holodisplays/handlers/TickHandler$CachedTextInfo;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Z", "getHasAnimation", "getHasPlaceholder", "Ljava/util/List;", "getAnimationIntervals", "holodisplays"})
    public static final class CachedTextInfo {
        private final boolean hasAnimation;
        private final boolean hasPlaceholder;
        @Nullable
        private final List<Integer> animationIntervals;

        public CachedTextInfo(boolean hasAnimation, boolean hasPlaceholder, @Nullable List<Integer> animationIntervals) {
            this.hasAnimation = hasAnimation;
            this.hasPlaceholder = hasPlaceholder;
            this.animationIntervals = animationIntervals;
        }

        public /* synthetic */ CachedTextInfo(boolean bl, boolean bl2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = null;
            }
            this(bl, bl2, list);
        }

        public final boolean getHasAnimation() {
            return this.hasAnimation;
        }

        public final boolean getHasPlaceholder() {
            return this.hasPlaceholder;
        }

        @Nullable
        public final List<Integer> getAnimationIntervals() {
            return this.animationIntervals;
        }

        public final boolean component1() {
            return this.hasAnimation;
        }

        public final boolean component2() {
            return this.hasPlaceholder;
        }

        @Nullable
        public final List<Integer> component3() {
            return this.animationIntervals;
        }

        @NotNull
        public final CachedTextInfo copy(boolean hasAnimation, boolean hasPlaceholder, @Nullable List<Integer> animationIntervals) {
            return new CachedTextInfo(hasAnimation, hasPlaceholder, animationIntervals);
        }

        public static /* synthetic */ CachedTextInfo copy$default(CachedTextInfo cachedTextInfo, boolean bl, boolean bl2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                bl = cachedTextInfo.hasAnimation;
            }
            if ((n & 2) != 0) {
                bl2 = cachedTextInfo.hasPlaceholder;
            }
            if ((n & 4) != 0) {
                list = cachedTextInfo.animationIntervals;
            }
            return cachedTextInfo.copy(bl, bl2, list);
        }

        @NotNull
        public String toString() {
            return "CachedTextInfo(hasAnimation=" + this.hasAnimation + ", hasPlaceholder=" + this.hasPlaceholder + ", animationIntervals=" + this.animationIntervals + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.hasAnimation);
            result = result * 31 + Boolean.hashCode(this.hasPlaceholder);
            result = result * 31 + (this.animationIntervals == null ? 0 : ((Object)this.animationIntervals).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CachedTextInfo)) {
                return false;
            }
            CachedTextInfo cachedTextInfo = (CachedTextInfo)other;
            if (this.hasAnimation != cachedTextInfo.hasAnimation) {
                return false;
            }
            if (this.hasPlaceholder != cachedTextInfo.hasPlaceholder) {
                return false;
            }
            return Intrinsics.areEqual(this.animationIntervals, cachedTextInfo.animationIntervals);
        }
    }
}

