/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.holodisplays.config;

import dev.furq.holodisplays.api.HoloDisplaysAPI;
import dev.furq.holodisplays.config.Config;
import dev.furq.holodisplays.config.JsonUtils;
import dev.furq.holodisplays.data.DisplayData;
import dev.furq.holodisplays.data.display.BaseDisplay;
import dev.furq.holodisplays.data.display.BlockDisplay;
import dev.furq.holodisplays.data.display.EntityDisplay;
import dev.furq.holodisplays.data.display.ItemDisplay;
import dev.furq.holodisplays.data.display.TextDisplay;
import dev.furq.holodisplays.handlers.ConfigException;
import dev.furq.holodisplays.handlers.ErrorHandler;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import net.minecraft.class_2168;
import net.minecraft.class_4050;
import net.minecraft.class_8113;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.quiltmc.parsers.json.JsonReader;
import org.quiltmc.parsers.json.JsonWriter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\u0003J\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\f*\u00020\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0013\u0010\u0010\u001a\u00020\f*\u00020\nH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u0013\u0010\u0011\u001a\u00020\f*\u00020\nH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000eJ\u0013\u0010\u0012\u001a\u00020\f*\u00020\nH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u000eJ\u0017\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u0019\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\f0\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\f\u00a2\u0006\u0004\b \u0010!J'\u0010$\u001a\n #*\u0004\u0018\u00010\u001f0\u001f2\u0006\u0010\u000b\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010'\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020&H\u0002\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010)\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b)\u0010\u0016R\"\u0010*\u001a\u00020\u00048\u0016@\u0016X\u0096.\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-\"\u0004\b.\u0010\bR \u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\f0/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101\u00a8\u00062"}, d2={"Ldev/furq/holodisplays/config/DisplayConfig;", "Ldev/furq/holodisplays/config/Config;", "<init>", "()V", "Ljava/nio/file/Path;", "baseDir", "", "init", "(Ljava/nio/file/Path;)V", "reload", "Lorg/quiltmc/parsers/json/JsonReader;", "json", "Ldev/furq/holodisplays/data/DisplayData;", "parseDisplayData", "(Lorg/quiltmc/parsers/json/JsonReader;)Ldev/furq/holodisplays/data/DisplayData;", "parseTextDisplay", "parseItemDisplay", "parseBlockDisplay", "parseEntityDisplay", "", "name", "getDisplay", "(Ljava/lang/String;)Ldev/furq/holodisplays/data/DisplayData;", "getDisplayOrAPI", "", "getDisplays", "()Ljava/util/Map;", "", "exists", "(Ljava/lang/String;)Z", "display", "Lorg/quiltmc/parsers/json/JsonWriter;", "saveDisplay", "(Ljava/lang/String;Ldev/furq/holodisplays/data/DisplayData;)Lorg/quiltmc/parsers/json/JsonWriter;", "displayData", "kotlin.jvm.PlatformType", "writeDisplay", "(Lorg/quiltmc/parsers/json/JsonWriter;Ldev/furq/holodisplays/data/DisplayData;)Lorg/quiltmc/parsers/json/JsonWriter;", "Ldev/furq/holodisplays/data/display/BaseDisplay;", "writeCommonProperties", "(Lorg/quiltmc/parsers/json/JsonWriter;Ldev/furq/holodisplays/data/display/BaseDisplay;)V", "deleteDisplay", "configDir", "Ljava/nio/file/Path;", "getConfigDir", "()Ljava/nio/file/Path;", "setConfigDir", "", "displays", "Ljava/util/Map;", "holodisplays"})
@SourceDebugExtension(value={"SMAP\nDisplayConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisplayConfig.kt\ndev/furq/holodisplays/config/DisplayConfig\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ErrorHandler.kt\ndev/furq/holodisplays/handlers/ErrorHandler\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n13805#2,2:213\n31#3,7:215\n38#3,3:223\n31#3,10:226\n1#4:222\n*S KotlinDebug\n*F\n+ 1 DisplayConfig.kt\ndev/furq/holodisplays/config/DisplayConfig\n*L\n26#1:213,2\n140#1:215,7\n140#1:223,3\n202#1:226,10\n*E\n"})
public final class DisplayConfig
implements Config {
    @NotNull
    public static final DisplayConfig INSTANCE = new DisplayConfig();
    public static Path configDir;
    @NotNull
    private static final Map<String, DisplayData> displays;

    private DisplayConfig() {
    }

    @Override
    @NotNull
    public Path getConfigDir() {
        Path path = configDir;
        if (path != null) {
            return path;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"configDir");
        return null;
    }

    public void setConfigDir(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        configDir = path;
    }

    public void init(@NotNull Path baseDir) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Path path = baseDir.resolve("displays");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.setConfigDir(path);
        Config.super.init(baseDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        displays.clear();
        File[] fileArray = this.getConfigDir().toFile().listFiles(JsonUtils.INSTANCE.getJsonFilter());
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File file = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)file);
                Closeable closeable = new FileInputStream(file);
                Object object = Charsets.UTF_8;
                closeable = (Closeable)JsonReader.json5((Reader)new InputStreamReader((InputStream)closeable, (Charset)object));
                object = null;
                try {
                    JsonReader json = (JsonReader)closeable;
                    boolean bl2 = false;
                    String string = FilesKt.getNameWithoutExtension((File)file);
                    Intrinsics.checkNotNull((Object)json);
                    displays.put(string, INSTANCE.parseDisplayData(json));
                    Unit unit = Unit.INSTANCE;
                    continue;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
            }
        } else {
            throw new ConfigException("Failed to list display config files");
        }
    }

    private final DisplayData parseDisplayData(JsonReader json) {
        JsonReader $this$parseDisplayData_u24lambda_u240 = json;
        boolean bl = false;
        $this$parseDisplayData_u24lambda_u240.beginObject();
        DisplayData displayData = null;
        while ($this$parseDisplayData_u24lambda_u240.hasNext()) {
            block18: {
                String string;
                if (!Intrinsics.areEqual((Object)$this$parseDisplayData_u24lambda_u240.nextName(), (Object)"type")) break block18;
                String string2 = $this$parseDisplayData_u24lambda_u240.nextString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nextString(...)");
                Intrinsics.checkNotNullExpressionValue((Object)string2.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                int n = -1;
                switch (string.hashCode()) {
                    case 3242771: {
                        if (string.equals("item")) {
                            n = 1;
                        }
                        break;
                    }
                    case 93832333: {
                        if (string.equals("block")) {
                            n = 2;
                        }
                        break;
                    }
                    case 3556653: {
                        if (string.equals("text")) {
                            n = 3;
                        }
                        break;
                    }
                    case -1298275357: {
                        if (string.equals("entity")) {
                            n = 4;
                        }
                        break;
                    }
                }
                displayData = switch (n) {
                    case 3 -> INSTANCE.parseTextDisplay($this$parseDisplayData_u24lambda_u240);
                    case 1 -> INSTANCE.parseItemDisplay($this$parseDisplayData_u24lambda_u240);
                    case 2 -> INSTANCE.parseBlockDisplay($this$parseDisplayData_u24lambda_u240);
                    case 4 -> INSTANCE.parseEntityDisplay($this$parseDisplayData_u24lambda_u240);
                    default -> throw new IllegalArgumentException("Invalid display type");
                };
                continue;
            }
            $this$parseDisplayData_u24lambda_u240.skipValue();
        }
        $this$parseDisplayData_u24lambda_u240.endObject();
        DisplayData displayData2 = displayData;
        if (displayData2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"displayData");
            displayData2 = null;
        }
        return displayData2;
    }

    private final DisplayData parseTextDisplay(JsonReader $this$parseTextDisplay) {
        TextDisplay.Builder builder = new TextDisplay.Builder();
        block26: while ($this$parseTextDisplay.hasNext()) {
            block38: {
                String string = $this$parseTextDisplay.nextName();
                if (string == null) break block38;
                int n = -1;
                switch (string.hashCode()) {
                    case 1263694578: {
                        if (string.equals("seeThrough")) {
                            n = 1;
                        }
                        break;
                    }
                    case 886923021: {
                        if (string.equals("conditionalPlaceholder")) {
                            n = 2;
                        }
                        break;
                    }
                    case 1287124693: {
                        if (string.equals("backgroundColor")) {
                            n = 3;
                        }
                        break;
                    }
                    case -903579360: {
                        if (string.equals("shadow")) {
                            n = 4;
                        }
                        break;
                    }
                    case -40300674: {
                        if (string.equals("rotation")) {
                            n = 5;
                        }
                        break;
                    }
                    case 109250890: {
                        if (string.equals("scale")) {
                            n = 6;
                        }
                        break;
                    }
                    case -2107142626: {
                        if (string.equals("textOpacity")) {
                            n = 7;
                        }
                        break;
                    }
                    case 102977279: {
                        if (string.equals("lines")) {
                            n = 8;
                        }
                        break;
                    }
                    case 1767875043: {
                        if (string.equals("alignment")) {
                            n = 9;
                        }
                        break;
                    }
                    case -1803786702: {
                        if (string.equals("lineWidth")) {
                            n = 10;
                        }
                        break;
                    }
                    case -172216958: {
                        if (string.equals("billboardMode")) {
                            n = 11;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 8: {
                        builder.setLines(CollectionsKt.toMutableList((Collection)JsonUtils.INSTANCE.parseStringList($this$parseTextDisplay)));
                        continue block26;
                    }
                    case 5: {
                        builder.setRotation(JsonUtils.INSTANCE.parseVector3f($this$parseTextDisplay));
                        continue block26;
                    }
                    case 6: {
                        builder.setScale(JsonUtils.INSTANCE.parseVector3f($this$parseTextDisplay));
                        continue block26;
                    }
                    case 10: {
                        builder.setLineWidth($this$parseTextDisplay.nextInt());
                        continue block26;
                    }
                    case 3: {
                        builder.setBackgroundColor($this$parseTextDisplay.nextString());
                        continue block26;
                    }
                    case 7: {
                        builder.setTextOpacity($this$parseTextDisplay.nextInt());
                        continue block26;
                    }
                    case 4: {
                        builder.setShadow($this$parseTextDisplay.nextBoolean());
                        continue block26;
                    }
                    case 1: {
                        builder.setSeeThrough($this$parseTextDisplay.nextBoolean());
                        continue block26;
                    }
                    case 9: {
                        String string2 = $this$parseTextDisplay.nextString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nextString(...)");
                        String string3 = string2.toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
                        builder.setAlignment(TextDisplay.TextAlignment.valueOf(string3));
                        continue block26;
                    }
                    case 11: {
                        String string4 = $this$parseTextDisplay.nextString();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"nextString(...)");
                        String string5 = string4.toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
                        builder.setBillboardMode(class_8113.class_8114.valueOf((String)string5));
                        continue block26;
                    }
                    case 2: {
                        builder.setConditionalPlaceholder($this$parseTextDisplay.nextString());
                        continue block26;
                    }
                }
            }
            $this$parseTextDisplay.skipValue();
        }
        return new DisplayData(builder.build());
    }

    private final DisplayData parseItemDisplay(JsonReader $this$parseItemDisplay) {
        ItemDisplay.Builder builder = new ItemDisplay.Builder();
        block18: while ($this$parseItemDisplay.hasNext()) {
            block26: {
                String string = $this$parseItemDisplay.nextName();
                if (string == null) break block26;
                int n = -1;
                switch (string.hashCode()) {
                    case 886923021: {
                        if (string.equals("conditionalPlaceholder")) {
                            n = 1;
                        }
                        break;
                    }
                    case 764642818: {
                        if (string.equals("customModelData")) {
                            n = 2;
                        }
                        break;
                    }
                    case 1714350876: {
                        if (string.equals("displayType")) {
                            n = 3;
                        }
                        break;
                    }
                    case -40300674: {
                        if (string.equals("rotation")) {
                            n = 4;
                        }
                        break;
                    }
                    case 109250890: {
                        if (string.equals("scale")) {
                            n = 5;
                        }
                        break;
                    }
                    case 3355: {
                        if (string.equals("id")) {
                            n = 6;
                        }
                        break;
                    }
                    case -172216958: {
                        if (string.equals("billboardMode")) {
                            n = 7;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 6: {
                        String string2 = $this$parseItemDisplay.nextString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nextString(...)");
                        builder.setId(string2);
                        continue block18;
                    }
                    case 3: {
                        String string3 = $this$parseItemDisplay.nextString();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"nextString(...)");
                        String string4 = string3.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                        builder.setItemDisplayType(string4);
                        continue block18;
                    }
                    case 4: {
                        builder.setRotation(JsonUtils.INSTANCE.parseVector3f($this$parseItemDisplay));
                        continue block18;
                    }
                    case 5: {
                        builder.setScale(JsonUtils.INSTANCE.parseVector3f($this$parseItemDisplay));
                        continue block18;
                    }
                    case 7: {
                        String string5 = $this$parseItemDisplay.nextString();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"nextString(...)");
                        String string6 = string5.toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toUpperCase(...)");
                        builder.setBillboardMode(class_8113.class_8114.valueOf((String)string6));
                        continue block18;
                    }
                    case 2: {
                        builder.setCustomModelData($this$parseItemDisplay.nextInt());
                        continue block18;
                    }
                    case 1: {
                        builder.setConditionalPlaceholder($this$parseItemDisplay.nextString());
                        continue block18;
                    }
                }
            }
            $this$parseItemDisplay.skipValue();
        }
        return new DisplayData(builder.build());
    }

    private final DisplayData parseBlockDisplay(JsonReader $this$parseBlockDisplay) {
        BlockDisplay.Builder builder = new BlockDisplay.Builder();
        block14: while ($this$parseBlockDisplay.hasNext()) {
            block20: {
                String string = $this$parseBlockDisplay.nextName();
                if (string == null) break block20;
                int n = -1;
                switch (string.hashCode()) {
                    case 886923021: {
                        if (string.equals("conditionalPlaceholder")) {
                            n = 1;
                        }
                        break;
                    }
                    case -40300674: {
                        if (string.equals("rotation")) {
                            n = 2;
                        }
                        break;
                    }
                    case 109250890: {
                        if (string.equals("scale")) {
                            n = 3;
                        }
                        break;
                    }
                    case 3355: {
                        if (string.equals("id")) {
                            n = 4;
                        }
                        break;
                    }
                    case -172216958: {
                        if (string.equals("billboardMode")) {
                            n = 5;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 4: {
                        String string2 = $this$parseBlockDisplay.nextString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nextString(...)");
                        builder.setId(string2);
                        continue block14;
                    }
                    case 2: {
                        builder.setRotation(JsonUtils.INSTANCE.parseVector3f($this$parseBlockDisplay));
                        continue block14;
                    }
                    case 3: {
                        builder.setScale(JsonUtils.INSTANCE.parseVector3f($this$parseBlockDisplay));
                        continue block14;
                    }
                    case 5: {
                        String string3 = $this$parseBlockDisplay.nextString();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"nextString(...)");
                        String string4 = string3.toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
                        builder.setBillboardMode(class_8113.class_8114.valueOf((String)string4));
                        continue block14;
                    }
                    case 1: {
                        builder.setConditionalPlaceholder($this$parseBlockDisplay.nextString());
                        continue block14;
                    }
                }
            }
            $this$parseBlockDisplay.skipValue();
        }
        return new DisplayData(builder.build());
    }

    private final DisplayData parseEntityDisplay(JsonReader $this$parseEntityDisplay) {
        EntityDisplay.Builder builder = new EntityDisplay.Builder();
        block16: while ($this$parseEntityDisplay.hasNext()) {
            block23: {
                String string = $this$parseEntityDisplay.nextName();
                if (string == null) break block23;
                int n = -1;
                switch (string.hashCode()) {
                    case 886923021: {
                        if (string.equals("conditionalPlaceholder")) {
                            n = 1;
                        }
                        break;
                    }
                    case 3446929: {
                        if (string.equals("pose")) {
                            n = 2;
                        }
                        break;
                    }
                    case -40300674: {
                        if (string.equals("rotation")) {
                            n = 3;
                        }
                        break;
                    }
                    case 109250890: {
                        if (string.equals("scale")) {
                            n = 4;
                        }
                        break;
                    }
                    case 3355: {
                        if (string.equals("id")) {
                            n = 5;
                        }
                        break;
                    }
                    case 3175821: {
                        if (string.equals("glow")) {
                            n = 6;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 5: {
                        String string2 = $this$parseEntityDisplay.nextString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nextString(...)");
                        builder.setId(string2);
                        continue block16;
                    }
                    case 3: {
                        builder.setRotation(JsonUtils.INSTANCE.parseVector3f($this$parseEntityDisplay));
                        continue block16;
                    }
                    case 4: {
                        builder.setScale(JsonUtils.INSTANCE.parseVector3f($this$parseEntityDisplay));
                        continue block16;
                    }
                    case 6: {
                        builder.setGlow($this$parseEntityDisplay.nextBoolean());
                        continue block16;
                    }
                    case 2: {
                        String string3 = $this$parseEntityDisplay.nextString();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"nextString(...)");
                        String string4 = string3.toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
                        builder.setPose(class_4050.valueOf((String)string4));
                        continue block16;
                    }
                    case 1: {
                        builder.setConditionalPlaceholder($this$parseEntityDisplay.nextString());
                        continue block16;
                    }
                }
            }
            $this$parseEntityDisplay.skipValue();
        }
        return new DisplayData(builder.build());
    }

    @Nullable
    public final DisplayData getDisplay(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return displays.get(name);
    }

    @Nullable
    public final DisplayData getDisplayOrAPI(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        DisplayData displayData = displays.get(name);
        if (displayData == null) {
            displayData = HoloDisplaysAPI.get().getDisplay(name);
        }
        return displayData;
    }

    @NotNull
    public final Map<String, DisplayData> getDisplays() {
        return displays;
    }

    public final boolean exists(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return displays.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final JsonWriter saveDisplay(@NotNull String name, @NotNull DisplayData display) {
        JsonWriter jsonWriter;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        ErrorHandler $this$iv = ErrorHandler.INSTANCE;
        class_2168 source$iv = null;
        JsonWriter default$iv = null;
        boolean $i$f$safeCall = false;
        try {
            JsonWriter jsonWriter2;
            boolean bl = false;
            displays.put(name, display);
            File file = INSTANCE.getConfigDir().resolve(name + ".json").toFile();
            file.getParentFile().mkdirs();
            Intrinsics.checkNotNull((Object)file);
            Closeable closeable = new FileOutputStream(file);
            Object object = Charsets.UTF_8;
            closeable = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
            object = null;
            try {
                JsonWriter jsonWriter3;
                OutputStreamWriter writer = (OutputStreamWriter)closeable;
                boolean bl2 = false;
                Closeable closeable2 = (Closeable)JsonWriter.json((Writer)writer);
                Throwable throwable = null;
                try {
                    JsonWriter json = (JsonWriter)closeable2;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)json);
                    jsonWriter3 = INSTANCE.writeDisplay(json, display);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
                }
                jsonWriter2 = jsonWriter3;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            jsonWriter = jsonWriter2;
        }
        catch (Exception e$iv) {
            $this$iv.handle(e$iv, source$iv);
            jsonWriter = default$iv;
        }
        return jsonWriter;
    }

    private final JsonWriter writeDisplay(JsonWriter json, DisplayData displayData) {
        JsonWriter $this$writeDisplay_u24lambda_u240 = json;
        boolean bl = false;
        $this$writeDisplay_u24lambda_u240.beginObject();
        BaseDisplay display = displayData.getType();
        if (display instanceof TextDisplay) {
            $this$writeDisplay_u24lambda_u240.name("type").value("text");
            JsonUtils.INSTANCE.writeStringList($this$writeDisplay_u24lambda_u240, "lines", ((TextDisplay)display).getLines());
            Integer n = ((TextDisplay)display).getLineWidth();
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                $this$writeDisplay_u24lambda_u240.name("lineWidth").value((Number)it);
            }
            String string = ((TextDisplay)display).getBackgroundColor();
            if (string != null) {
                String it = string;
                boolean bl3 = false;
                $this$writeDisplay_u24lambda_u240.name("backgroundColor").value(it);
            }
            Integer n2 = ((TextDisplay)display).getTextOpacity();
            if (n2 != null) {
                int it = ((Number)n2).intValue();
                boolean bl4 = false;
                $this$writeDisplay_u24lambda_u240.name("textOpacity").value((Number)it);
            }
            Boolean bl5 = ((TextDisplay)display).getShadow();
            if (bl5 != null) {
                boolean it = bl5;
                boolean bl6 = false;
                $this$writeDisplay_u24lambda_u240.name("shadow").value(it);
            }
            Boolean bl7 = ((TextDisplay)display).getSeeThrough();
            if (bl7 != null) {
                boolean it = bl7;
                boolean bl8 = false;
                $this$writeDisplay_u24lambda_u240.name("seeThrough").value(it);
            }
            TextDisplay.TextAlignment textAlignment = ((TextDisplay)display).getAlignment();
            if (textAlignment != null) {
                TextDisplay.TextAlignment it = textAlignment;
                boolean bl9 = false;
                $this$writeDisplay_u24lambda_u240.name("alignment").value(it.name());
            }
            INSTANCE.writeCommonProperties($this$writeDisplay_u24lambda_u240, display);
        } else if (display instanceof ItemDisplay) {
            $this$writeDisplay_u24lambda_u240.name("type").value("item");
            $this$writeDisplay_u24lambda_u240.name("id").value(((ItemDisplay)display).getId());
            $this$writeDisplay_u24lambda_u240.name("displayType").value(((ItemDisplay)display).getItemDisplayType());
            Integer n = ((ItemDisplay)display).getCustomModelData();
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl10 = false;
                $this$writeDisplay_u24lambda_u240.name("customModelData").value((Number)it);
            }
            INSTANCE.writeCommonProperties($this$writeDisplay_u24lambda_u240, display);
        } else if (display instanceof BlockDisplay) {
            $this$writeDisplay_u24lambda_u240.name("type").value("block");
            $this$writeDisplay_u24lambda_u240.name("id").value(((BlockDisplay)display).getId());
            INSTANCE.writeCommonProperties($this$writeDisplay_u24lambda_u240, display);
        } else if (display instanceof EntityDisplay) {
            $this$writeDisplay_u24lambda_u240.name("type").value("entity");
            $this$writeDisplay_u24lambda_u240.name("id").value(((EntityDisplay)display).getId());
            Boolean bl11 = ((EntityDisplay)display).getGlow();
            if (bl11 != null) {
                boolean it = bl11;
                boolean bl12 = false;
                $this$writeDisplay_u24lambda_u240.name("glow").value(it);
            }
            class_4050 class_40502 = ((EntityDisplay)display).getPose();
            if (class_40502 != null) {
                class_4050 it = class_40502;
                boolean bl13 = false;
                $this$writeDisplay_u24lambda_u240.name("pose").value(it.name());
            }
            String string = ((EntityDisplay)display).getConditionalPlaceholder();
            if (string != null) {
                String it = string;
                boolean bl14 = false;
                $this$writeDisplay_u24lambda_u240.name("conditionalPlaceholder").value(it);
            }
            INSTANCE.writeCommonProperties($this$writeDisplay_u24lambda_u240, display);
        }
        return $this$writeDisplay_u24lambda_u240.endObject();
    }

    private final void writeCommonProperties(JsonWriter json, BaseDisplay display) {
        block4: {
            Object it;
            Vector3f vector3f = display.getRotation();
            if (vector3f != null) {
                it = vector3f;
                boolean bl = false;
                JsonUtils.INSTANCE.writeVector3f(json, "rotation", (Vector3f)it);
            }
            Vector3f vector3f2 = display.getScale();
            if (vector3f2 != null) {
                it = vector3f2;
                boolean bl = false;
                JsonUtils.INSTANCE.writeVector3f(json, "scale", (Vector3f)it);
            }
            if (!(display instanceof EntityDisplay)) {
                class_8113.class_8114 class_81142 = display.getBillboardMode();
                if (class_81142 != null) {
                    it = class_81142;
                    boolean bl = false;
                    json.name("billboardMode").value(it.name());
                }
            }
            String string = display.getConditionalPlaceholder();
            if (string == null) break block4;
            it = string;
            boolean bl = false;
            json.name("conditionalPlaceholder").value((String)it);
        }
    }

    @Nullable
    public final DisplayData deleteDisplay(@NotNull String name) {
        DisplayData displayData;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ErrorHandler $this$iv = ErrorHandler.INSTANCE;
        class_2168 source$iv = null;
        DisplayData default$iv = null;
        boolean $i$f$safeCall = false;
        try {
            boolean bl = false;
            File file = INSTANCE.getConfigDir().resolve(name + ".json").toFile();
            if (!file.exists()) {
                throw new ConfigException("Display config file for " + name + " does not exist");
            }
            if (!file.delete()) {
                throw new ConfigException("Failed to delete display config file for " + name);
            }
            displayData = displays.remove(name);
        }
        catch (Exception e$iv) {
            $this$iv.handle(e$iv, source$iv);
            displayData = default$iv;
        }
        return displayData;
    }

    static {
        displays = new LinkedHashMap();
    }
}

