/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.holodisplays.handlers;

import dev.furq.holodisplays.HoloDisplays;
import dev.furq.holodisplays.config.DisplayConfig;
import dev.furq.holodisplays.config.HologramConfig;
import dev.furq.holodisplays.data.DisplayData;
import dev.furq.holodisplays.data.HologramData;
import dev.furq.holodisplays.data.display.BaseDisplay;
import dev.furq.holodisplays.data.display.TextDisplay;
import dev.furq.holodisplays.handlers.ErrorHandler;
import dev.furq.holodisplays.handlers.HologramException;
import dev.furq.holodisplays.handlers.HologramHandler;
import dev.furq.holodisplays.handlers.PacketHandler;
import dev.furq.holodisplays.utils.ConditionEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\b\u00a2\u0006\u0004\b\r\u0010\u0003J\u001f\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\fJ\u0015\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001a\u0010\fJ\u0017\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001b\u0010\u001cJ)\u0010\u001e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010%\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0004\b%\u0010&J'\u0010'\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b'\u0010(J\u0015\u0010)\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b)\u0010\u0018J\u0015\u0010+\u001a\u00020*2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b+\u0010,R \u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020.0-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100\u00a8\u00062"}, d2={"Ldev/furq/holodisplays/handlers/ViewerHandler;", "", "<init>", "()V", "", "name", "Ldev/furq/holodisplays/data/HologramData;", "data", "", "createTracker", "(Ljava/lang/String;Ldev/furq/holodisplays/data/HologramData;)V", "removeTracker", "(Ljava/lang/String;)V", "resetHologramObservers", "Lnet/minecraft/class_3222;", "player", "addViewer", "(Lnet/minecraft/class_3222;Ljava/lang/String;)Lkotlin/Unit;", "removeViewer", "(Lnet/minecraft/class_3222;Ljava/lang/String;)V", "", "isViewing", "(Lnet/minecraft/class_3222;Ljava/lang/String;)Z", "clearViewers", "(Lnet/minecraft/class_3222;)V", "removeHologramFromAllViewers", "respawnForAllObservers", "updateForAllObservers", "(Ljava/lang/String;)Lkotlin/Unit;", "hologram", "showHologramToPlayer", "(Lnet/minecraft/class_3222;Ljava/lang/String;Ldev/furq/holodisplays/data/HologramData;)Lkotlin/Unit;", "Lnet/minecraft/class_243;", "hologramPosition", "(Ldev/furq/holodisplays/data/HologramData;)Lnet/minecraft/class_243;", "Ldev/furq/holodisplays/data/DisplayData;", "display", "processDisplayForPlayer", "(Ldev/furq/holodisplays/data/DisplayData;)Ldev/furq/holodisplays/data/DisplayData;", "updateHologramForPlayer", "(Lnet/minecraft/class_3222;Ljava/lang/String;Ldev/furq/holodisplays/data/HologramData;)V", "updatePlayerVisibility", "", "getObserverCount", "(Ljava/lang/String;)I", "", "Ldev/furq/holodisplays/handlers/ViewerHandler$TrackedHologram;", "trackedHolograms", "Ljava/util/Map;", "TrackedHologram", "holodisplays"})
@SourceDebugExtension(value={"SMAP\nViewerHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewerHandler.kt\ndev/furq/holodisplays/handlers/ViewerHandler\n+ 2 ErrorHandler.kt\ndev/furq/holodisplays/handlers/ErrorHandler\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n31#2,10:156\n31#2,7:181\n38#2,3:193\n31#2,7:196\n38#2,3:206\n774#3:166\n865#3,2:167\n1869#3,2:169\n774#3:171\n865#3,2:172\n1869#3,2:174\n774#3:176\n865#3,2:177\n1869#3,2:179\n774#3:188\n865#3,2:189\n1869#3,2:191\n1878#3,3:203\n1878#3,3:209\n1869#3,2:212\n*S KotlinDebug\n*F\n+ 1 ViewerHandler.kt\ndev/furq/holodisplays/handlers/ViewerHandler\n*L\n36#1:156,10\n85#1:181,7\n85#1:193,3\n95#1:196,7\n95#1:206,3\n56#1:166\n56#1:167,2\n57#1:169,2\n66#1:171\n66#1:172,2\n67#1:174,2\n77#1:176\n77#1:177,2\n78#1:179,2\n89#1:188\n89#1:189,2\n90#1:191,2\n98#1:203,3\n120#1:209,3\n134#1:212,2\n*E\n"})
public final class ViewerHandler {
    @NotNull
    public static final ViewerHandler INSTANCE = new ViewerHandler();
    @NotNull
    private static final Map<String, TrackedHologram> trackedHolograms = new LinkedHashMap();

    private ViewerHandler() {
    }

    public final void createTracker(@NotNull String name, @NotNull HologramData data) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        trackedHolograms.put(name, new TrackedHologram(name, data, null, 4, null));
    }

    public final void removeTracker(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        trackedHolograms.remove(name);
    }

    public final void resetHologramObservers() {
        trackedHolograms.clear();
    }

    @Nullable
    public final Unit addViewer(@NotNull class_3222 player, @NotNull String name) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ErrorHandler $this$iv = ErrorHandler.INSTANCE;
        class_2168 source$iv = null;
        Unit default$iv = null;
        boolean $i$f$safeCall = false;
        try {
            boolean bl = false;
            TrackedHologram trackedHologram = trackedHolograms.get(name);
            if (trackedHologram == null) {
                throw new HologramException("Hologram " + name + " not found");
            }
            TrackedHologram tracked = trackedHologram;
            Set<UUID> set = tracked.getObservers();
            UUID uUID = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
            if (set.add(uUID)) {
                INSTANCE.showHologramToPlayer(player, name, tracked.getHologramData());
            }
            unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            $this$iv.handle(e$iv, source$iv);
            unit = default$iv;
        }
        return unit;
    }

    private final void removeViewer(class_3222 player, String name) {
        block1: {
            TrackedHologram trackedHologram = trackedHolograms.get(name);
            if (trackedHologram == null) break block1;
            TrackedHologram tracked = trackedHologram;
            boolean bl = false;
            if (tracked.getObservers().remove(player.method_5667())) {
                PacketHandler.INSTANCE.destroyDisplayEntity(player, name);
            }
        }
    }

    public final boolean isViewing(@NotNull class_3222 player, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = trackedHolograms.get(name);
        if (object == null || (object = ((TrackedHologram)object).getObservers()) == null) {
            object = SetsKt.emptySet();
        }
        return object.contains(player.method_5667());
    }

    /*
     * WARNING - void declaration
     */
    public final void clearViewers(@NotNull class_3222 player) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Iterable $this$filter$iv = trackedHolograms.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TrackedHologram it = (TrackedHologram)element$iv$iv;
            boolean bl = false;
            if (!it.getObservers().contains(player.method_5667())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TrackedHologram tracked = (TrackedHologram)element$iv;
            boolean bl = false;
            tracked.getObservers().remove(player.method_5667());
            PacketHandler.INSTANCE.destroyDisplayEntity(player, tracked.getHologramName());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeHologramFromAllViewers(@NotNull String name) {
        block3: {
            List list;
            class_3324 class_33242;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            TrackedHologram trackedHologram = trackedHolograms.get(name);
            if (trackedHologram == null) break block3;
            TrackedHologram tracked = trackedHologram;
            boolean bl = false;
            MinecraftServer minecraftServer = HoloDisplays.Companion.getSERVER();
            if (minecraftServer != null && (class_33242 = minecraftServer.method_3760()) != null && (list = class_33242.method_14571()) != null) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable iterable = list;
                boolean $i$f$filter = false;
                Iterator iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    class_3222 it = (class_3222)element$iv$iv;
                    boolean bl2 = false;
                    if (!tracked.getObservers().contains(it.method_5667())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    class_3222 player = (class_3222)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)player);
                    INSTANCE.removeViewer(player, name);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void respawnForAllObservers(@NotNull String name) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            TrackedHologram trackedHologram = trackedHolograms.get(name);
            if (trackedHologram == null) break block4;
            TrackedHologram tracked = trackedHologram;
            boolean bl = false;
            HologramData hologramData = HologramConfig.INSTANCE.getHologram(name);
            if (hologramData != null) {
                List list;
                class_3324 class_33242;
                HologramData hologramData2 = hologramData;
                MinecraftServer minecraftServer = HoloDisplays.Companion.getSERVER();
                if (minecraftServer != null && (class_33242 = minecraftServer.method_3760()) != null && (list = class_33242.method_14571()) != null) {
                    void $this$forEach$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    Iterable iterable = list;
                    boolean $i$f$filter = false;
                    Iterator iterator = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        class_3222 it = (class_3222)element$iv$iv;
                        boolean bl2 = false;
                        if (!tracked.getObservers().contains(it.method_5667())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        class_3222 player = (class_3222)element$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)player);
                        PacketHandler.INSTANCE.destroyDisplayEntity(player, name);
                        INSTANCE.showHologramToPlayer(player, name, hologramData2);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Unit updateForAllObservers(@NotNull String name) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ErrorHandler $this$iv = ErrorHandler.INSTANCE;
        class_2168 source$iv = null;
        Unit default$iv = null;
        boolean $i$f$safeCall = false;
        try {
            Unit unit2;
            List list;
            class_3324 class_33242;
            boolean bl = false;
            TrackedHologram trackedHologram = trackedHolograms.get(name);
            if (trackedHologram == null) {
                throw new HologramException("Hologram " + name + " not found");
            }
            TrackedHologram tracked = trackedHologram;
            HologramData hologramData = HologramConfig.INSTANCE.getHologram(name);
            if (hologramData == null) {
                throw new HologramException("Hologram " + name + " not found in config");
            }
            HologramData hologramData2 = hologramData;
            MinecraftServer minecraftServer = HoloDisplays.Companion.getSERVER();
            if (minecraftServer != null && (class_33242 = minecraftServer.method_3760()) != null && (list = class_33242.method_14571()) != null) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable iterable = list;
                boolean $i$f$filter = false;
                Iterator iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    class_3222 it = (class_3222)element$iv$iv;
                    boolean bl2 = false;
                    if (!tracked.getObservers().contains(it.method_5667())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    class_3222 player = (class_3222)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)player);
                    INSTANCE.updateHologramForPlayer(player, name, hologramData2);
                }
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            unit = unit2;
        }
        catch (Exception e$iv) {
            $this$iv.handle(e$iv, source$iv);
            unit = default$iv;
        }
        return unit;
    }

    /*
     * WARNING - void declaration
     */
    private final Unit showHologramToPlayer(class_3222 player, String name, HologramData hologram) {
        Unit unit;
        ErrorHandler $this$iv = ErrorHandler.INSTANCE;
        class_2168 source$iv = null;
        Unit default$iv = null;
        boolean $i$f$safeCall = false;
        try {
            boolean bl = false;
            if (ConditionEvaluator.INSTANCE.evaluate(hologram.getConditionalPlaceholder(), player)) {
                Iterable $this$forEachIndexed$iv = hologram.getDisplays();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    DisplayData display;
                    void entity;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    HologramData.DisplayLine displayLine = (HologramData.DisplayLine)item$iv;
                    int index = n;
                    boolean bl2 = false;
                    if (DisplayConfig.INSTANCE.getDisplayOrAPI(entity.getDisplayId()) == null) {
                        throw new HologramException("Display " + entity.getDisplayId() + " not found");
                    }
                    if (!ConditionEvaluator.INSTANCE.evaluate(display.getType().getConditionalPlaceholder(), player)) continue;
                    PacketHandler.INSTANCE.spawnDisplayEntity(player, name, (HologramData.DisplayLine)entity, INSTANCE.processDisplayForPlayer(display), INSTANCE.hologramPosition(hologram), index, hologram);
                }
            }
            unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            $this$iv.handle(e$iv, source$iv);
            unit = default$iv;
        }
        return unit;
    }

    private final class_243 hologramPosition(HologramData hologram) {
        return new class_243((double)hologram.getPosition().x, (double)hologram.getPosition().y, (double)hologram.getPosition().z);
    }

    private final DisplayData processDisplayForPlayer(DisplayData display) {
        DisplayData displayData;
        BaseDisplay displayType = display.getType();
        if (displayType instanceof TextDisplay) {
            Object[] objectArray = new String[]{CollectionsKt.joinToString$default((Iterable)((TextDisplay)displayType).getLines(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)};
            displayData = display.copy(TextDisplay.copy$default((TextDisplay)displayType, CollectionsKt.mutableListOf((Object[])objectArray), null, null, null, null, null, null, null, null, null, null, 2046, null));
        } else {
            displayData = display;
        }
        return displayData;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateHologramForPlayer(class_3222 player, String name, HologramData hologram) {
        if (!ConditionEvaluator.INSTANCE.evaluate(hologram.getConditionalPlaceholder(), player)) {
            return;
        }
        Iterable $this$forEachIndexed$iv = hologram.getDisplays();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            DisplayData display;
            void entity;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            HologramData.DisplayLine displayLine = (HologramData.DisplayLine)item$iv;
            int index = n;
            boolean bl = false;
            if (DisplayConfig.INSTANCE.getDisplayOrAPI(entity.getDisplayId()) == null) continue;
            boolean bl2 = false;
            if (!ConditionEvaluator.INSTANCE.evaluate(display.getType().getConditionalPlaceholder(), player)) continue;
            PacketHandler.INSTANCE.updateDisplayMetadata(player, name, entity.getDisplayId(), index, INSTANCE.processDisplayForPlayer(display), hologram);
        }
    }

    public final void updatePlayerVisibility(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        String string = player.method_37908().method_27983().method_29177().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String playerWorld = string;
        Iterable $this$forEach$iv = trackedHolograms.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TrackedHologram tracked = (TrackedHologram)element$iv;
            boolean bl = false;
            HologramData hologram = tracked.getHologramData();
            boolean isCurrentlyViewing = tracked.getObservers().contains(player.method_5667());
            if (!Intrinsics.areEqual((Object)hologram.getWorld(), (Object)playerWorld)) {
                if (!isCurrentlyViewing) continue;
                INSTANCE.removeViewer(player, tracked.getHologramName());
                continue;
            }
            boolean shouldView = ConditionEvaluator.INSTANCE.evaluate(hologram.getConditionalPlaceholder(), player) && HologramHandler.INSTANCE.isPlayerInRange(player, hologram.getWorld(), hologram.getPosition(), hologram.getViewRange());
            if (shouldView && !isCurrentlyViewing) {
                INSTANCE.addViewer(player, tracked.getHologramName());
                continue;
            }
            if (shouldView || !isCurrentlyViewing) continue;
            INSTANCE.removeViewer(player, tracked.getHologramName());
        }
    }

    public final int getObserverCount(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = trackedHolograms.get(name);
        return object != null && (object = ((TrackedHologram)object).getObservers()) != null ? object.size() : 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J4\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001a\u0010\u0015\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b\u001e\u0010\u000eR\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001f\u001a\u0004\b \u0010\u0010\u00a8\u0006!"}, d2={"Ldev/furq/holodisplays/handlers/ViewerHandler$TrackedHologram;", "", "", "hologramName", "Ldev/furq/holodisplays/data/HologramData;", "hologramData", "", "Ljava/util/UUID;", "observers", "<init>", "(Ljava/lang/String;Ldev/furq/holodisplays/data/HologramData;Ljava/util/Set;)V", "component1", "()Ljava/lang/String;", "component2", "()Ldev/furq/holodisplays/data/HologramData;", "component3", "()Ljava/util/Set;", "copy", "(Ljava/lang/String;Ldev/furq/holodisplays/data/HologramData;Ljava/util/Set;)Ldev/furq/holodisplays/handlers/ViewerHandler$TrackedHologram;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getHologramName", "Ldev/furq/holodisplays/data/HologramData;", "getHologramData", "Ljava/util/Set;", "getObservers", "holodisplays"})
    private static final class TrackedHologram {
        @NotNull
        private final String hologramName;
        @NotNull
        private final HologramData hologramData;
        @NotNull
        private final Set<UUID> observers;

        public TrackedHologram(@NotNull String hologramName, @NotNull HologramData hologramData, @NotNull Set<UUID> observers) {
            Intrinsics.checkNotNullParameter((Object)hologramName, (String)"hologramName");
            Intrinsics.checkNotNullParameter((Object)hologramData, (String)"hologramData");
            Intrinsics.checkNotNullParameter(observers, (String)"observers");
            this.hologramName = hologramName;
            this.hologramData = hologramData;
            this.observers = observers;
        }

        public /* synthetic */ TrackedHologram(String string, HologramData hologramData, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                set = new LinkedHashSet();
            }
            this(string, hologramData, set);
        }

        @NotNull
        public final String getHologramName() {
            return this.hologramName;
        }

        @NotNull
        public final HologramData getHologramData() {
            return this.hologramData;
        }

        @NotNull
        public final Set<UUID> getObservers() {
            return this.observers;
        }

        @NotNull
        public final String component1() {
            return this.hologramName;
        }

        @NotNull
        public final HologramData component2() {
            return this.hologramData;
        }

        @NotNull
        public final Set<UUID> component3() {
            return this.observers;
        }

        @NotNull
        public final TrackedHologram copy(@NotNull String hologramName, @NotNull HologramData hologramData, @NotNull Set<UUID> observers) {
            Intrinsics.checkNotNullParameter((Object)hologramName, (String)"hologramName");
            Intrinsics.checkNotNullParameter((Object)hologramData, (String)"hologramData");
            Intrinsics.checkNotNullParameter(observers, (String)"observers");
            return new TrackedHologram(hologramName, hologramData, observers);
        }

        public static /* synthetic */ TrackedHologram copy$default(TrackedHologram trackedHologram, String string, HologramData hologramData, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                string = trackedHologram.hologramName;
            }
            if ((n & 2) != 0) {
                hologramData = trackedHologram.hologramData;
            }
            if ((n & 4) != 0) {
                set = trackedHologram.observers;
            }
            return trackedHologram.copy(string, hologramData, set);
        }

        @NotNull
        public String toString() {
            return "TrackedHologram(hologramName=" + this.hologramName + ", hologramData=" + this.hologramData + ", observers=" + this.observers + ")";
        }

        public int hashCode() {
            int result = this.hologramName.hashCode();
            result = result * 31 + this.hologramData.hashCode();
            result = result * 31 + ((Object)this.observers).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TrackedHologram)) {
                return false;
            }
            TrackedHologram trackedHologram = (TrackedHologram)other;
            if (!Intrinsics.areEqual((Object)this.hologramName, (Object)trackedHologram.hologramName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.hologramData, (Object)trackedHologram.hologramData)) {
                return false;
            }
            return Intrinsics.areEqual(this.observers, trackedHologram.observers);
        }
    }
}

