/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.holodisplays.managers;

import dev.furq.holodisplays.config.DisplayConfig;
import dev.furq.holodisplays.config.HologramConfig;
import dev.furq.holodisplays.data.DisplayData;
import dev.furq.holodisplays.data.HologramData;
import dev.furq.holodisplays.data.display.TextDisplay;
import dev.furq.holodisplays.handlers.HologramHandler;
import dev.furq.holodisplays.managers.FeedbackManager;
import dev.furq.holodisplays.utils.ConditionEvaluator;
import dev.furq.holodisplays.utils.FeedbackType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_8113;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0015\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0016\u0010\u0017J-\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ!\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b \u0010!J%\u0010\"\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\"\u0010#J\u001d\u0010$\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b$\u0010\u0017J%\u0010%\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b%\u0010&J\u001d\u0010'\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b'\u0010\u0017J%\u0010*\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010)\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b*\u0010+J\u001d\u0010,\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b,\u0010\u0017J%\u0010/\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010.\u001a\u00020-2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b/\u00100J\u001d\u00101\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b1\u0010\u0017J5\u00105\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u00102\u001a\u00020-2\u0006\u00103\u001a\u00020-2\u0006\u00104\u001a\u00020-2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b5\u00106J\u001d\u00107\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b7\u0010\u0017J'\u00109\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\b\u00108\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b9\u0010&J%\u0010<\u001a\u00020\b2\u0006\u0010:\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b<\u0010=J%\u0010>\u001a\u00020\b2\u0006\u0010:\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b>\u0010=J-\u0010@\u001a\u00020\u00132\u0006\u0010:\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b@\u0010A\u00a8\u0006B"}, d2={"Ldev/furq/holodisplays/managers/HologramManager;", "", "<init>", "()V", "", "name", "Lnet/minecraft/class_2168;", "source", "", "validateHologramName", "(Ljava/lang/String;Lnet/minecraft/class_2168;)Z", "validateHologramExists", "Lnet/minecraft/class_243;", "pos", "Lorg/joml/Vector3f;", "formatPosition", "(Lnet/minecraft/class_243;)Lorg/joml/Vector3f;", "Lnet/minecraft/class_3222;", "player", "", "createHologram", "(Ljava/lang/String;Lnet/minecraft/class_3222;)V", "deleteHologram", "(Ljava/lang/String;Lnet/minecraft/class_2168;)V", "worldId", "updatePosition", "(Ljava/lang/String;Lnet/minecraft/class_243;Ljava/lang/String;Lnet/minecraft/class_2168;)V", "scale", "validateScale", "(Lorg/joml/Vector3f;Lnet/minecraft/class_2168;)Z", "billboard", "Lnet/minecraft/class_8113$class_8114;", "validateBillboardMode", "(Ljava/lang/String;Lnet/minecraft/class_2168;)Lnet/minecraft/class_8113$class_8114;", "updateScale", "(Ljava/lang/String;Lorg/joml/Vector3f;Lnet/minecraft/class_2168;)V", "resetScale", "updateBillboard", "(Ljava/lang/String;Ljava/lang/String;Lnet/minecraft/class_2168;)V", "resetBillboard", "", "rate", "updateUpdateRate", "(Ljava/lang/String;ILnet/minecraft/class_2168;)V", "resetUpdateRate", "", "range", "updateViewRange", "(Ljava/lang/String;FLnet/minecraft/class_2168;)V", "resetViewRange", "pitch", "yaw", "roll", "updateRotation", "(Ljava/lang/String;FFFLnet/minecraft/class_2168;)V", "resetRotation", "condition", "updateCondition", "hologramName", "displayName", "addDisplayToHologram", "(Ljava/lang/String;Ljava/lang/String;Lnet/minecraft/class_2168;)Z", "removeDisplayFromHologram", "offset", "updateDisplayOffset", "(Ljava/lang/String;Ljava/lang/String;Lorg/joml/Vector3f;Lnet/minecraft/class_2168;)V", "holodisplays"})
@SourceDebugExtension(value={"SMAP\nHologramManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HologramManager.kt\ndev/furq/holodisplays/managers/HologramManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n1761#2,3:229\n360#2,7:232\n360#2,7:239\n*S KotlinDebug\n*F\n+ 1 HologramManager.kt\ndev/furq/holodisplays/managers/HologramManager\n*L\n188#1:229,3\n202#1:232,7\n218#1:239,7\n*E\n"})
public final class HologramManager {
    @NotNull
    public static final HologramManager INSTANCE = new HologramManager();

    private HologramManager() {
    }

    private final boolean validateHologramName(String name, class_2168 source) {
        boolean bl;
        boolean exists = bl = HologramConfig.INSTANCE.exists(name);
        boolean bl2 = false;
        if (exists) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name)};
            FeedbackManager.INSTANCE.send(source, FeedbackType.HOLOGRAM_EXISTS, pairArray);
        }
        return !bl;
    }

    private final boolean validateHologramExists(String name, class_2168 source) {
        boolean bl;
        boolean exists = bl = HologramConfig.INSTANCE.exists(name);
        boolean bl2 = false;
        if (!exists) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name)};
            FeedbackManager.INSTANCE.send(source, FeedbackType.HOLOGRAM_NOT_FOUND, pairArray);
        }
        return bl;
    }

    private final Vector3f formatPosition(class_243 pos) {
        String string = "%.3f";
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{pos.field_1352};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        float f = Float.parseFloat(string2);
        string = "%.3f";
        locale = Locale.US;
        objectArray = new Object[]{pos.field_1351};
        String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        float f2 = Float.parseFloat(string3);
        string = "%.3f";
        locale = Locale.US;
        objectArray = new Object[]{pos.field_1350};
        String string4 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        return new Vector3f(f, f2, Float.parseFloat(string4));
    }

    public final void createHologram(@NotNull String name, @NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        class_2168 class_21682 = player.method_64396();
        Intrinsics.checkNotNullExpressionValue((Object)class_21682, (String)"getCommandSource(...)");
        if (!this.validateHologramName(name, class_21682)) {
            return;
        }
        String defaultDisplayName = name + "_text";
        Object[] objectArray = new String[]{"<gr #ffffff #008000>Hello, %player:name%</gr>"};
        DisplayData defaultDisplay = new DisplayData(new TextDisplay(CollectionsKt.mutableListOf((Object[])objectArray), null, null, null, null, null, null, null, null, null, null, 2046, null));
        DisplayConfig.INSTANCE.saveDisplay(defaultDisplayName, defaultDisplay);
        HologramData.DisplayLine[] displayLineArray = new HologramData.DisplayLine[]{new HologramData.DisplayLine(defaultDisplayName, null, 2, null)};
        Pair[] pairArray = CollectionsKt.mutableListOf((Object[])displayLineArray);
        class_243 class_2432 = player.method_19538();
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"getPos(...)");
        displayLineArray = this.formatPosition(class_2432);
        String string = player.method_37908().method_27983().method_29177().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f(1.0f);
        class_8113.class_8114 class_81142 = class_8113.class_8114.field_42409;
        HologramData hologram = new HologramData((List)pairArray, (Vector3f)displayLineArray, string2, vector3f2, class_81142, 20, 16.0, vector3f, null, 256, null);
        HologramHandler.INSTANCE.createHologram(name, hologram);
        class_2168 class_21683 = player.method_64396();
        Intrinsics.checkNotNullExpressionValue((Object)class_21683, (String)"getCommandSource(...)");
        pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name)};
        FeedbackManager.INSTANCE.send(class_21683, FeedbackType.HOLOGRAM_CREATED, pairArray);
    }

    public final void deleteHologram(@NotNull String name, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateHologramExists(name, source)) {
            return;
        }
        HologramHandler.INSTANCE.deleteHologram(name);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name)};
        FeedbackManager.INSTANCE.send(source, FeedbackType.HOLOGRAM_DELETED, pairArray);
    }

    public final void updatePosition(@NotNull String name, @NotNull class_243 pos, @NotNull String worldId, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)worldId, (String)"worldId");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateHologramExists(name, source)) {
            return;
        }
        HologramHandler.INSTANCE.updateHologramProperty(name, new HologramHandler.HologramProperty.Position(this.formatPosition(pos), worldId));
        Pair<String, Object>[] pairArray = FeedbackManager.INSTANCE.formatVector3f(this.formatPosition(pos));
        FeedbackManager.INSTANCE.send(source, FeedbackType.POSITION_UPDATED, Arrays.copyOf(pairArray, pairArray.length));
    }

    private final boolean validateScale(Vector3f scale, class_2168 source) {
        boolean bl;
        boolean valid = bl = scale.x >= 0.1f && scale.y >= 0.1f && scale.z >= 0.1f;
        boolean bl2 = false;
        if (!valid) {
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_SCALE, new Pair[0]);
        }
        return bl;
    }

    private final class_8113.class_8114 validateBillboardMode(String billboard, class_2168 source) {
        class_8113.class_8114 class_81142;
        try {
            String string = billboard.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            class_81142 = class_8113.class_8114.valueOf((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_BILLBOARD, new Pair[0]);
            class_81142 = null;
        }
        return class_81142;
    }

    public final void updateScale(@NotNull String name, @NotNull Vector3f scale, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateHologramExists(name, source) || !this.validateScale(scale, source)) {
            return;
        }
        HologramHandler.INSTANCE.updateHologramProperty(name, new HologramHandler.HologramProperty.Scale(scale));
        Pair<String, Object>[] pairArray = FeedbackManager.INSTANCE.formatVector3f(scale);
        FeedbackManager.INSTANCE.send(source, FeedbackType.SCALE_UPDATED, Arrays.copyOf(pairArray, pairArray.length));
    }

    public final void resetScale(@NotNull String name, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateHologramExists(name, source)) {
            return;
        }
        HologramHandler.INSTANCE.updateHologramProperty(name, new HologramHandler.HologramProperty.Scale(new Vector3f(1.0f)));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"detail", (Object)"scale reset to default")};
        FeedbackManager.INSTANCE.send(source, FeedbackType.HOLOGRAM_UPDATED, pairArray);
    }

    public final void updateBillboard(@NotNull String name, @NotNull String billboard, @NotNull class_2168 source) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)billboard, (String)"billboard");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (!this.validateHologramExists(name, source)) {
                return;
            }
            class_8113.class_8114 class_81142 = this.validateBillboardMode(billboard, source);
            if (class_81142 == null) break block1;
            class_8113.class_8114 newMode = class_81142;
            boolean bl = false;
            HologramHandler.INSTANCE.updateHologramProperty(name, new HologramHandler.HologramProperty.BillboardMode(newMode));
            Pair[] pairArray = new Pair[1];
            String string = billboard.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            pairArray[0] = TuplesKt.to((Object)"mode", (Object)string);
            FeedbackManager.INSTANCE.send(source, FeedbackType.BILLBOARD_UPDATED, pairArray);
        }
    }

    public final void resetBillboard(@NotNull String name, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateHologramExists(name, source)) {
            return;
        }
        HologramHandler.INSTANCE.updateHologramProperty(name, new HologramHandler.HologramProperty.BillboardMode(class_8113.class_8114.field_42409));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"detail", (Object)"billboard mode reset to center")};
        FeedbackManager.INSTANCE.send(source, FeedbackType.HOLOGRAM_UPDATED, pairArray);
    }

    public final void updateUpdateRate(@NotNull String name, int rate, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateHologramExists(name, source)) {
            return;
        }
        if (!(1 <= rate ? rate < 101 : false)) {
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_UPDATE_RATE, new Pair[0]);
            return;
        }
        HologramHandler.INSTANCE.updateHologramProperty(name, new HologramHandler.HologramProperty.UpdateRate(rate));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"detail", (Object)("update rate set to " + rate + "t"))};
        FeedbackManager.INSTANCE.send(source, FeedbackType.HOLOGRAM_UPDATED, pairArray);
    }

    public final void resetUpdateRate(@NotNull String name, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateHologramExists(name, source)) {
            return;
        }
        HologramHandler.INSTANCE.updateHologramProperty(name, new HologramHandler.HologramProperty.UpdateRate(20));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"detail", (Object)"update rate reset to default")};
        FeedbackManager.INSTANCE.send(source, FeedbackType.HOLOGRAM_UPDATED, pairArray);
    }

    public final void updateViewRange(@NotNull String name, float range, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateHologramExists(name, source)) {
            return;
        }
        if (!(1.0f <= range ? range <= 128.0f : false)) {
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_VIEW_RANGE, new Pair[0]);
            return;
        }
        HologramHandler.INSTANCE.updateHologramProperty(name, new HologramHandler.HologramProperty.ViewRange(Double.valueOf(range)));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"detail", (Object)("view range set to " + range + " blocks"))};
        FeedbackManager.INSTANCE.send(source, FeedbackType.HOLOGRAM_UPDATED, pairArray);
    }

    public final void resetViewRange(@NotNull String name, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateHologramExists(name, source)) {
            return;
        }
        HologramHandler.INSTANCE.updateHologramProperty(name, new HologramHandler.HologramProperty.ViewRange(48.0));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"detail", (Object)"view range reset to default")};
        FeedbackManager.INSTANCE.send(source, FeedbackType.HOLOGRAM_UPDATED, pairArray);
    }

    public final void updateRotation(@NotNull String name, float pitch, float yaw, float roll, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateHologramExists(name, source)) {
            return;
        }
        if (pitch < -180.0f || pitch > 180.0f || yaw < -180.0f || yaw > 180.0f || roll < -180.0f || roll > 180.0f) {
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_ROTATION, new Pair[0]);
            return;
        }
        HologramHandler.INSTANCE.updateHologramProperty(name, new HologramHandler.HologramProperty.Rotation(new Vector3f(pitch, yaw, roll)));
        Pair<String, Object>[] pairArray = FeedbackManager.INSTANCE.formatRotation(pitch, yaw, roll);
        FeedbackManager.INSTANCE.send(source, FeedbackType.ROTATION_UPDATED, Arrays.copyOf(pairArray, pairArray.length));
    }

    public final void resetRotation(@NotNull String name, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateHologramExists(name, source)) {
            return;
        }
        HologramHandler.INSTANCE.updateHologramProperty(name, new HologramHandler.HologramProperty.Rotation(new Vector3f()));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"detail", (Object)"rotation reset to default")};
        FeedbackManager.INSTANCE.send(source, FeedbackType.HOLOGRAM_UPDATED, pairArray);
    }

    public final void updateCondition(@NotNull String name, @Nullable String condition, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.validateHologramExists(name, source)) {
            return;
        }
        if (condition != null && ConditionEvaluator.INSTANCE.parseCondition(condition) == null) {
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_CONDITION, new Pair[0]);
            return;
        }
        HologramHandler.INSTANCE.updateHologramProperty(name, new HologramHandler.HologramProperty.ConditionalPlaceholder(condition));
        Pair[] pairArray = new Pair[1];
        String string = condition;
        if (string == null) {
            string = "none";
        }
        pairArray[0] = TuplesKt.to((Object)"detail", (Object)("condition set to " + string));
        FeedbackManager.INSTANCE.send(source, FeedbackType.HOLOGRAM_UPDATED, pairArray);
    }

    public final boolean addDisplayToHologram(@NotNull String hologramName, @NotNull String displayName, @NotNull class_2168 source) {
        Pair[] pairArray;
        boolean bl;
        block5: {
            HologramData hologram;
            Intrinsics.checkNotNullParameter((Object)hologramName, (String)"hologramName");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (!this.validateHologramExists(hologramName, source)) {
                return false;
            }
            HologramData hologramData = hologram = HologramConfig.INSTANCE.getHologram(hologramName);
            Intrinsics.checkNotNull((Object)hologramData);
            Iterable $this$any$iv = hologramData.getDisplays();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    HologramData.DisplayLine it = (HologramData.DisplayLine)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getDisplayId(), (Object)displayName)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)displayName)};
            FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_ALREADY_ADDED, pairArray);
            return false;
        }
        HologramHandler.INSTANCE.updateHologramProperty(hologramName, new HologramHandler.HologramProperty.AddLine(displayName, null, 2, null));
        pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)displayName)};
        FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_ADDED, pairArray);
        return true;
    }

    public final boolean removeDisplayFromHologram(@NotNull String hologramName, @NotNull String displayName, @NotNull class_2168 source) {
        Pair[] pairArray;
        int displayIndex;
        block4: {
            int n;
            HologramData hologram;
            Intrinsics.checkNotNullParameter((Object)hologramName, (String)"hologramName");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (!this.validateHologramExists(hologramName, source)) {
                return false;
            }
            HologramData hologramData = hologram = HologramConfig.INSTANCE.getHologram(hologramName);
            Intrinsics.checkNotNull((Object)hologramData);
            List<HologramData.DisplayLine> $this$indexOfFirst$iv = hologramData.getDisplays();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<HologramData.DisplayLine> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                HologramData.DisplayLine item$iv;
                HologramData.DisplayLine it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getDisplayId(), (Object)displayName)) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = displayIndex = -1;
        }
        if (displayIndex == -1) {
            pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)displayName)};
            FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_NOT_FOUND, pairArray);
            return false;
        }
        HologramHandler.INSTANCE.updateHologramProperty(hologramName, new HologramHandler.HologramProperty.RemoveLine(displayIndex));
        pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)displayName)};
        FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_REMOVED, pairArray);
        return true;
    }

    public final void updateDisplayOffset(@NotNull String hologramName, @NotNull String displayName, @NotNull Vector3f offset, @NotNull class_2168 source) {
        Pair[] pairArray;
        int displayIndex;
        block4: {
            int n;
            HologramData hologram;
            Intrinsics.checkNotNullParameter((Object)hologramName, (String)"hologramName");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (!this.validateHologramExists(hologramName, source)) {
                return;
            }
            HologramData hologramData = hologram = HologramConfig.INSTANCE.getHologram(hologramName);
            Intrinsics.checkNotNull((Object)hologramData);
            List<HologramData.DisplayLine> $this$indexOfFirst$iv = hologramData.getDisplays();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<HologramData.DisplayLine> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                HologramData.DisplayLine item$iv;
                HologramData.DisplayLine it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getDisplayId(), (Object)displayName)) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = displayIndex = -1;
        }
        if (displayIndex == -1) {
            pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)displayName)};
            FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_NOT_FOUND, pairArray);
            return;
        }
        HologramHandler.INSTANCE.updateHologramProperty(hologramName, new HologramHandler.HologramProperty.LineOffset(displayIndex, offset));
        pairArray = FeedbackManager.INSTANCE.formatVector3f(offset);
        FeedbackManager.INSTANCE.send(source, FeedbackType.OFFSET_UPDATED, Arrays.copyOf(pairArray, pairArray.length));
    }
}

