/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.holodisplays.handlers;

import dev.furq.holodisplays.HoloDisplays;
import dev.furq.holodisplays.config.DisplayConfig;
import dev.furq.holodisplays.config.HologramConfig;
import dev.furq.holodisplays.data.DisplayData;
import dev.furq.holodisplays.data.HologramData;
import dev.furq.holodisplays.data.display.BaseDisplay;
import dev.furq.holodisplays.data.display.TextDisplay;
import dev.furq.holodisplays.handlers.ErrorHandler;
import dev.furq.holodisplays.handlers.HologramException;
import dev.furq.holodisplays.handlers.HologramHandler;
import dev.furq.holodisplays.handlers.PacketHandler;
import dev.furq.holodisplays.utils.ConditionEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0012\u0010\u0011J\r\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0003J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0018\u0010\u0003J\u001f\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001b\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001d\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010!\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b!\u0010 J\u0017\u0010\"\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\"\u0010#J)\u0010&\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010%\u001a\u00020$H\u0002\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010*\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0002\u00a2\u0006\u0004\b*\u0010+J'\u0010,\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010%\u001a\u00020$H\u0002\u00a2\u0006\u0004\b,\u0010-J\u0015\u0010.\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b.\u0010\u001eR&\u00100\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000f0/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0016\u00105\u001a\u0004\u0018\u0001028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u00066"}, d2={"Ldev/furq/holodisplays/handlers/ViewerHandler;", "", "<init>", "()V", "Ljava/util/UUID;", "uuid", "Lnet/minecraft/class_3222;", "getPlayer", "(Ljava/util/UUID;)Lnet/minecraft/class_3222;", "player", "", "name", "", "isViewing", "(Lnet/minecraft/class_3222;Ljava/lang/String;)Z", "", "createTracker", "(Ljava/lang/String;)Ljava/util/Set;", "removeTracker", "", "clearTrackers", "", "getObserverCount", "(Ljava/lang/String;)I", "resetAllObservers", "addViewer", "(Lnet/minecraft/class_3222;Ljava/lang/String;)Lkotlin/Unit;", "removeViewer", "(Lnet/minecraft/class_3222;Ljava/lang/String;)V", "clearViewers", "(Lnet/minecraft/class_3222;)V", "removeHologramFromAllViewers", "(Ljava/lang/String;)V", "respawnForAllObservers", "updateForAllObservers", "(Ljava/lang/String;)Lkotlin/Unit;", "Ldev/furq/holodisplays/data/HologramData;", "hologram", "showHologramToPlayer", "(Lnet/minecraft/class_3222;Ljava/lang/String;Ldev/furq/holodisplays/data/HologramData;)Lkotlin/Unit;", "Ldev/furq/holodisplays/data/DisplayData;", "display", "processDisplayForPlayer", "(Ldev/furq/holodisplays/data/DisplayData;)Ldev/furq/holodisplays/data/DisplayData;", "updateHologramForPlayer", "(Lnet/minecraft/class_3222;Ljava/lang/String;Ldev/furq/holodisplays/data/HologramData;)V", "updatePlayerVisibility", "", "observers", "Ljava/util/Map;", "Lnet/minecraft/class_3324;", "getPlayerManager", "()Lnet/minecraft/class_3324;", "playerManager", "holodisplays"})
@SourceDebugExtension(value={"SMAP\nViewerHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewerHandler.kt\ndev/furq/holodisplays/handlers/ViewerHandler\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ErrorHandler.kt\ndev/furq/holodisplays/handlers/ErrorHandler\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n382#2,7:130\n382#2,7:146\n1869#3,2:137\n1869#3,2:156\n1869#3,2:158\n1869#3,2:160\n1617#3,9:169\n1869#3:178\n1870#3:180\n1626#3:181\n1869#3,2:182\n1878#3,3:194\n1878#3,3:200\n1869#3,2:203\n31#4,7:139\n38#4,3:153\n31#4,7:162\n38#4,3:184\n31#4,7:187\n38#4,3:197\n1#5:179\n*S KotlinDebug\n*F\n+ 1 ViewerHandler.kt\ndev/furq/holodisplays/handlers/ViewerHandler\n*L\n20#1:130,7\n33#1:146,7\n26#1:137,2\n48#1:156,2\n52#1:158,2\n61#1:160,2\n71#1:169,9\n71#1:178\n71#1:180\n71#1:181\n71#1:182,2\n79#1:194,3\n95#1:200,3\n109#1:203,2\n31#1:139,7\n31#1:153,3\n69#1:162,7\n69#1:184,3\n76#1:187,7\n76#1:197,3\n71#1:179\n*E\n"})
public final class ViewerHandler {
    @NotNull
    public static final ViewerHandler INSTANCE = new ViewerHandler();
    @NotNull
    private static final Map<String, Set<UUID>> observers = new LinkedHashMap();

    private ViewerHandler() {
    }

    private final class_3324 getPlayerManager() {
        MinecraftServer minecraftServer = HoloDisplays.Companion.getSERVER();
        return minecraftServer != null ? minecraftServer.method_3760() : null;
    }

    private final class_3222 getPlayer(UUID uuid) {
        class_3324 class_33242 = this.getPlayerManager();
        return class_33242 != null ? class_33242.method_14602(uuid) : null;
    }

    public final boolean isViewing(@NotNull class_3222 player, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Set<UUID> set = observers.get(name);
        return set != null ? set.contains(player.method_5667()) : false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<UUID> createTracker(@NotNull String name) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, Set<UUID>> map = observers;
        String key$iv = name;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Set)object;
    }

    @Nullable
    public final Set<UUID> removeTracker(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return observers.remove(name);
    }

    public final void clearTrackers() {
        observers.clear();
    }

    public final int getObserverCount(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Set<UUID> set = observers.get(name);
        return set != null ? set.size() : 0;
    }

    public final void resetAllObservers() {
        Iterable $this$forEach$iv = HologramConfig.INSTANCE.getHolograms().keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name = (String)element$iv;
            boolean bl = false;
            INSTANCE.removeHologramFromAllViewers(name);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Unit addViewer(@NotNull class_3222 player, @NotNull String name) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ErrorHandler $this$iv = ErrorHandler.INSTANCE;
        class_2168 source$iv = null;
        Unit default$iv = null;
        boolean $i$f$safeCall = false;
        try {
            Object object;
            void $this$getOrPut$iv;
            boolean bl = false;
            HologramData hologramData = HologramConfig.INSTANCE.getHologramOrAPI(name);
            if (hologramData == null) {
                throw new HologramException("Hologram " + name + " not found");
            }
            HologramData hologramData2 = hologramData;
            Map<String, Set<UUID>> map = observers;
            String key$iv = name;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Set observerSet = (Set)object;
            UUID uUID = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
            if (observerSet.add(uUID)) {
                INSTANCE.showHologramToPlayer(player, name, hologramData2);
            }
            unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            $this$iv.handle(e$iv, source$iv);
            unit = default$iv;
        }
        return unit;
    }

    private final void removeViewer(class_3222 player, String name) {
        block1: {
            Set<UUID> set = observers.get(name);
            if (set == null) break block1;
            Set<UUID> observerSet = set;
            boolean bl = false;
            if (observerSet.remove(player.method_5667())) {
                PacketHandler.INSTANCE.destroyDisplayEntity(player, name);
            }
        }
    }

    public final void clearViewers(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Iterable $this$forEach$iv = observers.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name = (String)element$iv;
            boolean bl = false;
            INSTANCE.removeViewer(player, name);
        }
    }

    public final void removeHologramFromAllViewers(@NotNull String name) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Collection<UUID> collection = observers.get(name);
            if (collection == null || (collection = CollectionsKt.toList((Iterable)collection)) == null) break block1;
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_3222 player;
                UUID uuid = (UUID)element$iv;
                boolean bl = false;
                if (INSTANCE.getPlayer(uuid) == null) continue;
                boolean bl2 = false;
                INSTANCE.removeViewer(player, name);
            }
        }
    }

    public final void respawnForAllObservers(@NotNull String name) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            HologramData hologramData = HologramConfig.INSTANCE.getHologramOrAPI(name);
            if (hologramData == null) {
                return;
            }
            HologramData hologramData2 = hologramData;
            Collection<UUID> collection = observers.get(name);
            if (collection == null || (collection = CollectionsKt.toList((Iterable)collection)) == null) break block2;
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_3222 player;
                UUID uuid = (UUID)element$iv;
                boolean bl = false;
                if (INSTANCE.getPlayer(uuid) == null) continue;
                boolean bl2 = false;
                PacketHandler.INSTANCE.destroyDisplayEntity(player, name);
                INSTANCE.showHologramToPlayer(player, name, hologramData2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Unit updateForAllObservers(@NotNull String name) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ErrorHandler $this$iv = ErrorHandler.INSTANCE;
        class_2168 source$iv = null;
        Unit default$iv = null;
        boolean $i$f$safeCall = false;
        try {
            Unit unit2;
            boolean bl = false;
            HologramData hologramData = HologramConfig.INSTANCE.getHologramOrAPI(name);
            if (hologramData == null) {
                throw new HologramException("Hologram " + name + " not found");
            }
            HologramData hologramData2 = hologramData;
            Set<UUID> set = observers.get(name);
            if (set != null) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = set;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    class_3222 it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    UUID it = (UUID)element$iv$iv;
                    boolean bl3 = false;
                    if (INSTANCE.getPlayer(it) == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    class_3222 player = (class_3222)element$iv;
                    boolean bl5 = false;
                    INSTANCE.updateHologramForPlayer(player, name, hologramData2);
                }
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            unit = unit2;
        }
        catch (Exception e$iv) {
            $this$iv.handle(e$iv, source$iv);
            unit = default$iv;
        }
        return unit;
    }

    /*
     * WARNING - void declaration
     */
    private final Unit showHologramToPlayer(class_3222 player, String name, HologramData hologram) {
        Unit unit;
        ErrorHandler $this$iv = ErrorHandler.INSTANCE;
        class_2168 source$iv = null;
        Unit default$iv = null;
        boolean $i$f$safeCall = false;
        try {
            boolean bl = false;
            if (ConditionEvaluator.INSTANCE.evaluate(hologram.getConditionalPlaceholder(), player)) {
                Iterable $this$forEachIndexed$iv = hologram.getDisplays();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    DisplayData display;
                    void entity;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    HologramData.DisplayLine displayLine = (HologramData.DisplayLine)item$iv;
                    int index = n;
                    boolean bl2 = false;
                    if (DisplayConfig.INSTANCE.getDisplayOrAPI(entity.getName()) == null) {
                        throw new HologramException("Display " + entity.getName() + " not found");
                    }
                    if (!ConditionEvaluator.INSTANCE.evaluate(display.getType().getConditionalPlaceholder(), player)) continue;
                    PacketHandler.INSTANCE.spawnDisplayEntity(player, name, (HologramData.DisplayLine)entity, INSTANCE.processDisplayForPlayer(display), hologram.getPosition().toVec3f(), index, hologram);
                }
            }
            unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            $this$iv.handle(e$iv, source$iv);
            unit = default$iv;
        }
        return unit;
    }

    private final DisplayData processDisplayForPlayer(DisplayData display) {
        DisplayData displayData;
        BaseDisplay displayType = display.getType();
        if (displayType instanceof TextDisplay) {
            Object[] objectArray = new String[]{((TextDisplay)displayType).getText()};
            displayData = display.copy(TextDisplay.copy$default((TextDisplay)displayType, CollectionsKt.mutableListOf((Object[])objectArray), null, null, null, null, null, null, null, null, null, null, 2046, null));
        } else {
            displayData = display;
        }
        return displayData;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateHologramForPlayer(class_3222 player, String name, HologramData hologram) {
        if (!ConditionEvaluator.INSTANCE.evaluate(hologram.getConditionalPlaceholder(), player)) {
            return;
        }
        Iterable $this$forEachIndexed$iv = hologram.getDisplays();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            DisplayData display;
            void entity;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            HologramData.DisplayLine displayLine = (HologramData.DisplayLine)item$iv;
            int index = n;
            boolean bl = false;
            if (DisplayConfig.INSTANCE.getDisplayOrAPI(entity.getName()) == null) continue;
            boolean bl2 = false;
            if (!ConditionEvaluator.INSTANCE.evaluate(display.getType().getConditionalPlaceholder(), player)) continue;
            PacketHandler.INSTANCE.updateDisplayMetadata(player, name, entity.getName(), index, INSTANCE.processDisplayForPlayer(display), hologram);
        }
    }

    public final void updatePlayerVisibility(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        String string = player.field_6002.method_27983().method_29177().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String playerWorld = string;
        Iterable $this$forEach$iv = observers.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HologramData hologram;
            boolean isCurrentlyViewing;
            String name = (String)element$iv;
            boolean bl = false;
            if (HologramConfig.INSTANCE.getHologramOrAPI(name) == null) continue;
            Set<UUID> set = observers.get(name);
            boolean bl2 = set != null ? set.contains(player.method_5667()) : (isCurrentlyViewing = false);
            if (!Intrinsics.areEqual((Object)hologram.getWorld(), (Object)playerWorld)) {
                if (!isCurrentlyViewing) continue;
                INSTANCE.removeViewer(player, name);
                continue;
            }
            boolean shouldView = ConditionEvaluator.INSTANCE.evaluate(hologram.getConditionalPlaceholder(), player) && HologramHandler.INSTANCE.isPlayerInRange(player, hologram.getWorld(), hologram.getPosition().toVec3f(), hologram.getViewRange());
            if (shouldView && !isCurrentlyViewing) {
                INSTANCE.addViewer(player, name);
                continue;
            }
            if (shouldView || !isCurrentlyViewing) continue;
            INSTANCE.removeViewer(player, name);
        }
    }
}

