/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.holodisplays.managers;

import dev.furq.holodisplays.config.DisplayConfig;
import dev.furq.holodisplays.config.HologramConfig;
import dev.furq.holodisplays.data.DisplayData;
import dev.furq.holodisplays.data.HologramData;
import dev.furq.holodisplays.data.display.TextDisplay;
import dev.furq.holodisplays.handlers.HologramHandler;
import dev.furq.holodisplays.managers.FeedbackManager;
import dev.furq.holodisplays.utils.ConditionEvaluator;
import dev.furq.holodisplays.utils.FeedbackType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_8113;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0082\b\u00a2\u0006\u0004\b\u000b\u0010\fJ.\u0010\r\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0082\b\u00a2\u0006\u0004\b\r\u0010\fJ\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J[\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162*\u0010\u001a\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u00190\u0018\"\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0019H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001d\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001f\u0010 J\u001d\u0010!\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b!\u0010\"J-\u0010$\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b$\u0010%J'\u0010(\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010'\u001a\u0004\u0018\u00010&2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b(\u0010)J'\u0010+\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010*\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b+\u0010,J;\u00101\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010.\u001a\u0004\u0018\u00010-2\b\u0010/\u001a\u0004\u0018\u00010-2\b\u00100\u001a\u0004\u0018\u00010-2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b1\u00102J'\u00105\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\u00104\u001a\u0004\u0018\u0001032\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b5\u00106J'\u00108\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\u00107\u001a\u0004\u0018\u00010-2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b8\u00109J'\u0010;\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010:\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b;\u0010,J%\u0010?\u001a\u00020>2\u0006\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b?\u0010@J%\u0010A\u001a\u00020>2\u0006\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\bA\u0010@J-\u0010C\u001a\u00020\t2\u0006\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u00042\u0006\u0010B\u001a\u00020&2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\bC\u0010D\u00a8\u0006E"}, d2={"Ldev/furq/holodisplays/managers/HologramManager;", "", "<init>", "()V", "", "name", "Lnet/minecraft/class_2168;", "source", "Lkotlin/Function0;", "", "action", "requireHologramExists", "(Ljava/lang/String;Lnet/minecraft/class_2168;Lkotlin/jvm/functions/Function0;)V", "requireHologramNew", "Lnet/minecraft/class_243;", "pos", "world", "Ldev/furq/holodisplays/data/HologramData$Position;", "createPosition", "(Lnet/minecraft/class_243;Ljava/lang/String;)Ldev/furq/holodisplays/data/HologramData$Position;", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty;", "property", "Ldev/furq/holodisplays/utils/FeedbackType;", "feedbackType", "", "Lkotlin/Pair;", "details", "updateProperty", "(Ljava/lang/String;Lnet/minecraft/class_2168;Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty;Ldev/furq/holodisplays/utils/FeedbackType;[Lkotlin/Pair;)V", "Lnet/minecraft/class_3222;", "player", "createHologram", "(Ljava/lang/String;Lnet/minecraft/class_3222;)V", "deleteHologram", "(Ljava/lang/String;Lnet/minecraft/class_2168;)V", "worldId", "updatePosition", "(Ljava/lang/String;Lnet/minecraft/class_243;Ljava/lang/String;Lnet/minecraft/class_2168;)V", "Lorg/joml/Vector3f;", "scale", "updateScale", "(Ljava/lang/String;Lorg/joml/Vector3f;Lnet/minecraft/class_2168;)V", "billboard", "updateBillboard", "(Ljava/lang/String;Ljava/lang/String;Lnet/minecraft/class_2168;)V", "", "pitch", "yaw", "roll", "updateRotation", "(Ljava/lang/String;Ljava/lang/Float;Ljava/lang/Float;Ljava/lang/Float;Lnet/minecraft/class_2168;)V", "", "rate", "updateUpdateRate", "(Ljava/lang/String;Ljava/lang/Integer;Lnet/minecraft/class_2168;)V", "range", "updateViewRange", "(Ljava/lang/String;Ljava/lang/Float;Lnet/minecraft/class_2168;)V", "condition", "updateCondition", "hologramName", "displayName", "", "addDisplayToHologram", "(Ljava/lang/String;Ljava/lang/String;Lnet/minecraft/class_2168;)Z", "removeDisplayFromHologram", "offset", "updateDisplayOffset", "(Ljava/lang/String;Ljava/lang/String;Lorg/joml/Vector3f;Lnet/minecraft/class_2168;)V", "holodisplays"})
@SourceDebugExtension(value={"SMAP\nHologramManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HologramManager.kt\ndev/furq/holodisplays/managers/HologramManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n26#1,3:192\n35#1,3:195\n26#1,3:198\n26#1,3:201\n26#1,3:204\n26#1:207\n27#1,2:211\n1761#2,3:208\n1761#2,3:213\n360#2,7:216\n360#2,7:223\n*S KotlinDebug\n*F\n+ 1 HologramManager.kt\ndev/furq/holodisplays/managers/HologramManager\n*L\n50#1:192,3\n55#1:195,3\n74#1:198,3\n85#1:201,3\n100#1:204,3\n119#1:207\n119#1:211,2\n122#1:208,3\n160#1:213,3\n170#1:216,7\n183#1:223,7\n*E\n"})
public final class HologramManager {
    @NotNull
    public static final HologramManager INSTANCE = new HologramManager();

    private HologramManager() {
    }

    private final void requireHologramExists(String name, class_2168 source, Function0<Unit> action) {
        boolean $i$f$requireHologramExists = false;
        if (HologramConfig.INSTANCE.exists(name)) {
            action.invoke();
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name)};
            FeedbackManager.INSTANCE.send(source, FeedbackType.HOLOGRAM_NOT_FOUND, pairArray);
        }
    }

    private final void requireHologramNew(String name, class_2168 source, Function0<Unit> action) {
        boolean $i$f$requireHologramNew = false;
        if (!HologramConfig.INSTANCE.exists(name)) {
            action.invoke();
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name)};
            FeedbackManager.INSTANCE.send(source, FeedbackType.HOLOGRAM_EXISTS, pairArray);
        }
    }

    private final HologramData.Position createPosition(class_243 pos, String world) {
        class_243 $this$createPosition_u24lambda_u240 = pos;
        boolean bl = false;
        return new HologramData.Position(world, HologramManager.createPosition$lambda$0$r($this$createPosition_u24lambda_u240.field_1352), HologramManager.createPosition$lambda$0$r($this$createPosition_u24lambda_u240.field_1351), HologramManager.createPosition$lambda$0$r($this$createPosition_u24lambda_u240.field_1350));
    }

    /*
     * WARNING - void declaration
     */
    private final void updateProperty(String name, class_2168 source, HologramHandler.HologramProperty property, FeedbackType feedbackType, Pair<String, ? extends Object> ... details) {
        void name$iv;
        HologramManager hologramManager = this;
        String string = name;
        class_2168 source$iv = source;
        boolean $i$f$requireHologramExists = false;
        if (HologramConfig.INSTANCE.exists((String)name$iv)) {
            boolean bl = false;
            HologramHandler.INSTANCE.updateHologramProperty(name, property);
            FeedbackManager.INSTANCE.send(source, feedbackType, Arrays.copyOf(details, details.length));
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.HOLOGRAM_NOT_FOUND, pairArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void createHologram(@NotNull String name, @NotNull class_3222 player) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        HologramManager hologramManager = this;
        String string = name;
        class_2168 class_21682 = player.method_64396();
        Intrinsics.checkNotNullExpressionValue((Object)class_21682, (String)"getCommandSource(...)");
        class_2168 source$iv = class_21682;
        boolean $i$f$requireHologramNew = false;
        if (!HologramConfig.INSTANCE.exists((String)name$iv)) {
            boolean bl = false;
            String defaultDisplayName = name + "_text";
            Object[] objectArray = new String[]{"<gr #ffffff #008000>Hello, %player:name%</gr>"};
            DisplayData defaultDisplay = new DisplayData(new TextDisplay(CollectionsKt.mutableListOf((Object[])objectArray), null, null, null, null, null, null, null, null, null, null, 2046, null));
            DisplayConfig.INSTANCE.saveDisplay(defaultDisplayName, defaultDisplay);
            Object[] objectArray2 = new HologramData.DisplayLine[]{new HologramData.DisplayLine(defaultDisplayName, null, 2, null)};
            List list = CollectionsKt.mutableListOf((Object[])objectArray2);
            class_243 class_2432 = player.field_22467;
            Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"pos");
            String string2 = player.field_6002.method_27983().method_29177().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            HologramData hologram = new HologramData(list, INSTANCE.createPosition(class_2432, string2), new Vector3f(), new Vector3f(1.0f), class_8113.class_8114.field_42409, 20, 16.0, null, 128, null);
            HologramHandler.INSTANCE.createHologram(name, hologram);
            class_2168 class_21683 = player.method_64396();
            Intrinsics.checkNotNullExpressionValue((Object)class_21683, (String)"getCommandSource(...)");
            objectArray2 = new Pair[]{TuplesKt.to((Object)"name", (Object)name)};
            FeedbackManager.INSTANCE.send(class_21683, FeedbackType.HOLOGRAM_CREATED, (Pair<String, ? extends Object>[])objectArray2);
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.HOLOGRAM_EXISTS, pairArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void deleteHologram(@NotNull String name, @NotNull class_2168 source) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        HologramManager hologramManager = this;
        String string = name;
        class_2168 source$iv = source;
        boolean $i$f$requireHologramExists = false;
        if (HologramConfig.INSTANCE.exists((String)name$iv)) {
            boolean bl = false;
            HologramHandler.INSTANCE.deleteHologram(name);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name)};
            FeedbackManager.INSTANCE.send(source, FeedbackType.HOLOGRAM_DELETED, pairArray);
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.HOLOGRAM_NOT_FOUND, pairArray);
        }
    }

    public final void updatePosition(@NotNull String name, @NotNull class_243 pos, @NotNull String worldId, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)worldId, (String)"worldId");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        HologramHandler.HologramProperty.Position property = new HologramHandler.HologramProperty.Position(this.createPosition(pos, worldId));
        HologramHandler.HologramProperty hologramProperty = property;
        Vector3f vector3f = pos.method_46409();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"toVector3f(...)");
        Pair<String, Object>[] pairArray = FeedbackManager.INSTANCE.formatVector3f(vector3f);
        this.updateProperty(name, source, hologramProperty, FeedbackType.POSITION_UPDATED, Arrays.copyOf(pairArray, pairArray.length));
    }

    /*
     * WARNING - void declaration
     */
    public final void updateScale(@NotNull String name, @Nullable Vector3f scale, @NotNull class_2168 source) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        HologramManager hologramManager = this;
        String string = name;
        class_2168 source$iv = source;
        boolean $i$f$requireHologramExists = false;
        if (HologramConfig.INSTANCE.exists((String)name$iv)) {
            Vector3f newScale;
            boolean bl = false;
            Vector3f vector3f = scale;
            if (vector3f == null) {
                vector3f = newScale = new Vector3f(1.0f);
            }
            if (scale != null && (newScale.x < 0.1f || newScale.y < 0.1f || newScale.z < 0.1f)) {
                FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_SCALE, new Pair[0]);
                return;
            }
            Pair<String, Object>[] pairArray = FeedbackManager.INSTANCE.formatVector3f(newScale);
            INSTANCE.updateProperty(name, source, new HologramHandler.HologramProperty.Scale(newScale), FeedbackType.SCALE_UPDATED, Arrays.copyOf(pairArray, pairArray.length));
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.HOLOGRAM_NOT_FOUND, pairArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateBillboard(@NotNull String name, @Nullable String billboard, @NotNull class_2168 source) {
        block10: {
            void name$iv;
            class_2168 source$iv;
            block7: {
                String string;
                HologramHandler.HologramProperty hologramProperty;
                Pair[] pairArray;
                block9: {
                    block8: {
                        class_8113.class_8114 class_81142;
                        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                        HologramManager hologramManager = this;
                        String string2 = name;
                        source$iv = source;
                        boolean $i$f$requireHologramExists = false;
                        if (!HologramConfig.INSTANCE.exists((String)name$iv)) break block7;
                        boolean bl = false;
                        if (billboard == null) {
                            class_81142 = class_8113.class_8114.field_42409;
                        } else {
                            try {
                                String string3 = billboard.toUpperCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
                                pairArray = class_8113.class_8114.valueOf((String)string3);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_BILLBOARD, new Pair[0]);
                                return;
                            }
                            class_81142 = pairArray;
                        }
                        class_8113.class_8114 newMode = class_81142;
                        hologramProperty = new HologramHandler.HologramProperty.BillboardMode(newMode);
                        pairArray = new Pair[1];
                        string = billboard;
                        if (string == null) break block8;
                        String string4 = string.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                        string = string4;
                        if (string4 != null) break block9;
                    }
                    string = "center";
                }
                pairArray[0] = TuplesKt.to((Object)"mode", (Object)string);
                INSTANCE.updateProperty(name, source, hologramProperty, FeedbackType.BILLBOARD_UPDATED, pairArray);
                break block10;
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.HOLOGRAM_NOT_FOUND, pairArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateRotation(@NotNull String name, @Nullable Float pitch, @Nullable Float yaw, @Nullable Float roll, @NotNull class_2168 source) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        HologramManager hologramManager = this;
        String string = name;
        class_2168 source$iv = source;
        boolean $i$f$requireHologramExists = false;
        if (HologramConfig.INSTANCE.exists((String)name$iv)) {
            boolean bl;
            Object[] objectArray;
            Vector3f rotation;
            block6: {
                boolean bl2 = false;
                rotation = pitch == null || yaw == null || roll == null ? new Vector3f() : new Vector3f(pitch.floatValue(), yaw.floatValue(), roll.floatValue());
                objectArray = new Float[]{Float.valueOf(rotation.x), Float.valueOf(rotation.y), Float.valueOf(rotation.z)};
                Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        float it = ((Number)element$iv).floatValue();
                        boolean bl3 = false;
                        boolean bl4 = -180.0f <= it ? it <= 180.0f : false;
                        if (!(!bl4)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_ROTATION, new Pair[0]);
                return;
            }
            objectArray = FeedbackManager.INSTANCE.formatRotation(rotation.x, rotation.y, rotation.z);
            INSTANCE.updateProperty(name, source, new HologramHandler.HologramProperty.Rotation(rotation), FeedbackType.ROTATION_UPDATED, (Pair[])Arrays.copyOf(objectArray, objectArray.length));
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name$iv)};
            FeedbackManager.INSTANCE.send(source$iv, FeedbackType.HOLOGRAM_NOT_FOUND, pairArray);
        }
    }

    public final void updateUpdateRate(@NotNull String name, @Nullable Integer rate, @NotNull class_2168 source) {
        int newRate;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Integer n = rate;
        int n2 = newRate = n != null ? n : 20;
        if (rate != null && newRate < 1) {
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_UPDATE_RATE, new Pair[0]);
            return;
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"detail", (Object)("update rate set to " + newRate + "t"))};
        this.updateProperty(name, source, new HologramHandler.HologramProperty.UpdateRate(newRate), FeedbackType.HOLOGRAM_UPDATED, pairArray);
    }

    public final void updateViewRange(@NotNull String name, @Nullable Float range, @NotNull class_2168 source) {
        float newRange;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Float f = range;
        float f2 = newRange = f != null ? f.floatValue() : 48.0f;
        if (range != null) {
            if (!(1.0f <= newRange ? newRange <= 128.0f : false)) {
                FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_VIEW_RANGE, new Pair[0]);
                return;
            }
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"detail", (Object)("view range set to " + newRange + " blocks"))};
        this.updateProperty(name, source, new HologramHandler.HologramProperty.ViewRange(Double.valueOf(newRange)), FeedbackType.HOLOGRAM_UPDATED, pairArray);
    }

    public final void updateCondition(@NotNull String name, @Nullable String condition, @NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (condition != null && ConditionEvaluator.INSTANCE.parseCondition(condition) == null) {
            FeedbackManager.INSTANCE.send(source, FeedbackType.INVALID_CONDITION, new Pair[0]);
            return;
        }
        HologramHandler.HologramProperty hologramProperty = new HologramHandler.HologramProperty.ConditionalPlaceholder(condition);
        Pair[] pairArray = new Pair[1];
        String string = condition;
        if (string == null) {
            string = "none";
        }
        pairArray[0] = TuplesKt.to((Object)"detail", (Object)("condition set to " + string));
        this.updateProperty(name, source, hologramProperty, FeedbackType.HOLOGRAM_UPDATED, pairArray);
    }

    public final boolean addDisplayToHologram(@NotNull String hologramName, @NotNull String displayName, @NotNull class_2168 source) {
        Pair[] pairArray;
        boolean bl;
        block4: {
            HologramData hologram;
            Intrinsics.checkNotNullParameter((Object)hologramName, (String)"hologramName");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            HologramData hologramData = hologram = HologramConfig.INSTANCE.getHologram(hologramName);
            Intrinsics.checkNotNull((Object)hologramData);
            Iterable $this$any$iv = hologramData.getDisplays();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    HologramData.DisplayLine it = (HologramData.DisplayLine)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)displayName)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)displayName)};
            FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_ALREADY_ADDED, pairArray);
            return false;
        }
        pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)displayName)};
        this.updateProperty(hologramName, source, new HologramHandler.HologramProperty.AddLine(displayName, null, 2, null), FeedbackType.DISPLAY_ADDED, pairArray);
        return true;
    }

    public final boolean removeDisplayFromHologram(@NotNull String hologramName, @NotNull String displayName, @NotNull class_2168 source) {
        Pair[] pairArray;
        int index;
        block3: {
            int n;
            HologramData hologram;
            Intrinsics.checkNotNullParameter((Object)hologramName, (String)"hologramName");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            HologramData hologramData = hologram = HologramConfig.INSTANCE.getHologram(hologramName);
            Intrinsics.checkNotNull((Object)hologramData);
            List<HologramData.DisplayLine> $this$indexOfFirst$iv = hologramData.getDisplays();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<HologramData.DisplayLine> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                HologramData.DisplayLine item$iv;
                HologramData.DisplayLine it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getName(), (Object)displayName)) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (index == -1) {
            pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)displayName)};
            FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_NOT_FOUND, pairArray);
            return false;
        }
        pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)displayName)};
        this.updateProperty(hologramName, source, new HologramHandler.HologramProperty.RemoveLine(index), FeedbackType.DISPLAY_REMOVED, pairArray);
        return true;
    }

    public final void updateDisplayOffset(@NotNull String hologramName, @NotNull String displayName, @NotNull Vector3f offset, @NotNull class_2168 source) {
        Pair[] pairArray;
        int index;
        block3: {
            int n;
            HologramData hologram;
            Intrinsics.checkNotNullParameter((Object)hologramName, (String)"hologramName");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            HologramData hologramData = hologram = HologramConfig.INSTANCE.getHologram(hologramName);
            Intrinsics.checkNotNull((Object)hologramData);
            List<HologramData.DisplayLine> $this$indexOfFirst$iv = hologramData.getDisplays();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<HologramData.DisplayLine> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                HologramData.DisplayLine item$iv;
                HologramData.DisplayLine it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getName(), (Object)displayName)) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (index == -1) {
            pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)displayName)};
            FeedbackManager.INSTANCE.send(source, FeedbackType.DISPLAY_NOT_FOUND, pairArray);
            return;
        }
        pairArray = FeedbackManager.INSTANCE.formatVector3f(offset);
        this.updateProperty(hologramName, source, new HologramHandler.HologramProperty.LineOffset(index, offset), FeedbackType.OFFSET_UPDATED, Arrays.copyOf(pairArray, pairArray.length));
    }

    private static final float createPosition$lambda$0$r(double $this$createPosition_u24lambda_u240_u24r) {
        Locale locale = Locale.US;
        String string = "%.3f";
        Object[] objectArray = new Object[]{$this$createPosition_u24lambda_u240_u24r};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return Float.parseFloat(string2);
    }
}

