/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.holodisplays.config;

import dev.furq.holodisplays.api.HoloDisplaysAPIInternal;
import dev.furq.holodisplays.config.Config;
import dev.furq.holodisplays.data.DisplayData;
import dev.furq.holodisplays.data.display.BaseDisplay;
import dev.furq.holodisplays.data.display.BlockDisplay;
import dev.furq.holodisplays.data.display.EntityDisplay;
import dev.furq.holodisplays.data.display.ItemDisplay;
import dev.furq.holodisplays.data.display.TextDisplay;
import dev.furq.holodisplays.handlers.ConfigException;
import dev.furq.holodisplays.handlers.ErrorHandler;
import java.io.File;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import net.minecraft.class_2168;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\u0003J\u0017\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0019\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\f\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u000eJ\u0017\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u001e\u0010\u000eR\"\u0010\u001f\u001a\u00020\u00048\u0016@\u0016X\u0096.\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010\bR \u0010%\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u001a\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\f\n\u0004\b(\u0010)\u0012\u0004\b*\u0010\u0003\u00a8\u0006+"}, d2={"Ldev/furq/holodisplays/config/DisplayConfig;", "Ldev/furq/holodisplays/config/Config;", "<init>", "()V", "Ljava/nio/file/Path;", "baseDir", "", "init", "(Ljava/nio/file/Path;)V", "reload", "", "name", "Ldev/furq/holodisplays/data/DisplayData;", "getDisplay", "(Ljava/lang/String;)Ldev/furq/holodisplays/data/DisplayData;", "getDisplayOrAPI", "", "getDisplays", "()Ljava/util/Map;", "", "exists", "(Ljava/lang/String;)Z", "display", "saveDisplay", "(Ljava/lang/String;Ldev/furq/holodisplays/data/DisplayData;)Lkotlin/Unit;", "jsonContent", "deserializeDisplayData", "displayData", "serializeDisplayData", "(Ldev/furq/holodisplays/data/DisplayData;)Ljava/lang/String;", "deleteDisplay", "configDir", "Ljava/nio/file/Path;", "getConfigDir", "()Ljava/nio/file/Path;", "setConfigDir", "", "displays", "Ljava/util/Map;", "Lkotlinx/serialization/json/Json;", "json", "Lkotlinx/serialization/json/Json;", "getJson$annotations", "holodisplays"})
@SourceDebugExtension(value={"SMAP\nDisplayConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisplayConfig.kt\ndev/furq/holodisplays/config/DisplayConfig\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ErrorHandler.kt\ndev/furq/holodisplays/handlers/ErrorHandler\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,95:1\n13805#2,2:96\n31#3,10:98\n31#3,10:117\n222#4:108\n222#4:109\n222#4:110\n222#4:111\n205#4:112\n205#4:113\n205#4:114\n205#4:115\n205#4:116\n*S KotlinDebug\n*F\n+ 1 DisplayConfig.kt\ndev/furq/holodisplays/config/DisplayConfig\n*L\n35#1:96,2\n49#1:98,10\n85#1:117,10\n63#1:108\n64#1:109\n65#1:110\n66#1:111\n75#1:112\n76#1:113\n77#1:114\n78#1:115\n82#1:116\n*E\n"})
public final class DisplayConfig
implements Config {
    @NotNull
    public static final DisplayConfig INSTANCE = new DisplayConfig();
    public static Path configDir;
    @NotNull
    private static final Map<String, DisplayData> displays;
    @NotNull
    private static final Json json;

    private DisplayConfig() {
    }

    @Override
    @NotNull
    public Path getConfigDir() {
        Path path = configDir;
        if (path != null) {
            return path;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"configDir");
        return null;
    }

    public void setConfigDir(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        configDir = path;
    }

    private static /* synthetic */ void getJson$annotations() {
    }

    public void init(@NotNull Path baseDir) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Path path = baseDir.resolve("displays");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.setConfigDir(path);
        Config.super.init(baseDir);
    }

    @Override
    public void reload() {
        displays.clear();
        File[] fileArray = this.getConfigDir().toFile().listFiles(DisplayConfig::reload$lambda$0);
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File file = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)file);
                String jsonContent = FilesKt.readText$default((File)file, null, (int)1, null);
                DisplayData displayData = INSTANCE.deserializeDisplayData(jsonContent);
                displays.put(FilesKt.getNameWithoutExtension((File)file), displayData);
            }
        } else {
            throw new ConfigException("Failed to list display config files");
        }
    }

    @Nullable
    public final DisplayData getDisplay(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return displays.get(name);
    }

    @Nullable
    public final DisplayData getDisplayOrAPI(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        DisplayData displayData = displays.get(name);
        if (displayData == null) {
            displayData = HoloDisplaysAPIInternal.getDisplay(name);
        }
        return displayData;
    }

    @NotNull
    public final Map<String, DisplayData> getDisplays() {
        return displays;
    }

    public final boolean exists(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return displays.containsKey(name);
    }

    @Nullable
    public final Unit saveDisplay(@NotNull String name, @NotNull DisplayData display) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        ErrorHandler $this$iv = ErrorHandler.INSTANCE;
        class_2168 source$iv = null;
        Unit default$iv = null;
        boolean $i$f$safeCall = false;
        try {
            boolean bl = false;
            displays.put(name, display);
            File file = INSTANCE.getConfigDir().resolve(name + ".json").toFile();
            file.getParentFile().mkdirs();
            String jsonContent = INSTANCE.serializeDisplayData(display);
            Intrinsics.checkNotNull((Object)file);
            FilesKt.writeText$default((File)file, (String)jsonContent, null, (int)2, null);
            unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            $this$iv.handle(e$iv, source$iv);
            unit = default$iv;
        }
        return unit;
    }

    private final DisplayData deserializeDisplayData(String jsonContent) {
        JsonElement jsonElement = json.parseToJsonElement(jsonContent);
        Object object = (JsonElement)JsonElementKt.getJsonObject((JsonElement)jsonElement).get((Object)"type");
        if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = object.getContent()) == null) {
            throw new ConfigException("Display config missing 'type' field");
        }
        Object type = object;
        String string = ((String)type).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        BaseDisplay display = switch (string) {
            case "text" -> {
                Json this_$iv;
                Json var6_5 = json;
                String string$iv = jsonContent;
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                yield (BaseDisplay)this_$iv.decodeFromString((DeserializationStrategy)TextDisplay.Companion.serializer(), string$iv);
            }
            case "item" -> {
                Json this_$iv = json;
                String string$iv = jsonContent;
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                yield (BaseDisplay)this_$iv.decodeFromString((DeserializationStrategy)ItemDisplay.Companion.serializer(), string$iv);
            }
            case "block" -> {
                Json this_$iv = json;
                String string$iv = jsonContent;
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                yield (BaseDisplay)this_$iv.decodeFromString((DeserializationStrategy)BlockDisplay.Companion.serializer(), string$iv);
            }
            case "entity" -> {
                Json this_$iv = json;
                String string$iv = jsonContent;
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                yield (BaseDisplay)this_$iv.decodeFromString((DeserializationStrategy)EntityDisplay.Companion.serializer(), string$iv);
            }
            default -> throw new ConfigException("Unknown display type: " + (String)type);
        };
        return new DisplayData(display);
    }

    /*
     * WARNING - void declaration
     */
    private final String serializeDisplayData(DisplayData displayData) {
        void this_$iv;
        String string;
        BaseDisplay display = displayData.getType();
        if (display instanceof TextDisplay) {
            Json json = DisplayConfig.json;
            value$iv = display;
            $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            string = this_$iv.encodeToString((SerializationStrategy)TextDisplay.Companion.serializer(), (Object)value$iv);
        } else if (display instanceof ItemDisplay) {
            this_$iv = json;
            value$iv = display;
            $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            string = this_$iv.encodeToString((SerializationStrategy)ItemDisplay.Companion.serializer(), (Object)value$iv);
        } else if (display instanceof BlockDisplay) {
            this_$iv = json;
            value$iv = display;
            $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            string = this_$iv.encodeToString((SerializationStrategy)BlockDisplay.Companion.serializer(), (Object)value$iv);
        } else if (display instanceof EntityDisplay) {
            this_$iv = json;
            value$iv = display;
            $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            string = this_$iv.encodeToString((SerializationStrategy)EntityDisplay.Companion.serializer(), (Object)value$iv);
        } else {
            throw new ConfigException("Unknown display type: " + Reflection.getOrCreateKotlinClass(display.getClass()).getSimpleName());
        }
        String displayJson = string;
        display = json;
        JsonElement value$iv = json.parseToJsonElement(displayJson);
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        return this_$iv.encodeToString((SerializationStrategy)JsonElement.Companion.serializer(), (Object)value$iv);
    }

    @Nullable
    public final DisplayData deleteDisplay(@NotNull String name) {
        DisplayData displayData;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ErrorHandler $this$iv = ErrorHandler.INSTANCE;
        class_2168 source$iv = null;
        DisplayData default$iv = null;
        boolean $i$f$safeCall = false;
        try {
            boolean bl = false;
            File file = INSTANCE.getConfigDir().resolve(name + ".json").toFile();
            if (!file.exists()) {
                throw new ConfigException("Display config file for " + name + " does not exist");
            }
            if (!file.delete()) {
                throw new ConfigException("Failed to delete display config file for " + name);
            }
            displayData = displays.remove(name);
        }
        catch (Exception e$iv) {
            $this$iv.handle(e$iv, source$iv);
            displayData = default$iv;
        }
        return displayData;
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setLenient(true);
        $this$Json.setPrettyPrint(true);
        $this$Json.setAllowTrailingComma(true);
        $this$Json.setAllowComments(true);
        return Unit.INSTANCE;
    }

    private static final boolean reload$lambda$0(File it) {
        Intrinsics.checkNotNull((Object)it);
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"json");
    }

    static {
        displays = new LinkedHashMap();
        json = JsonKt.Json$default(null, DisplayConfig::json$lambda$0, (int)1, null);
    }
}

