/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.holodisplays.api;

import dev.furq.holodisplays.api.HoloDisplaysAPIImpl;
import dev.furq.holodisplays.data.DisplayData;
import dev.furq.holodisplays.data.HologramData;
import java.util.function.BiConsumer;

public final class HoloDisplaysAPIInternal {
    private HoloDisplaysAPIInternal() {
    }

    private static void validateCaller() {
        StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        Class<?> callerClass = walker.getCallerClass();
        String callerPackage = callerClass.getPackageName();
        if (!callerPackage.startsWith("dev.furq.holodisplays")) {
            throw new SecurityException("HoloDisplaysAPIInternal is for internal use only. External mods should use HoloDisplaysAPI.get(modId) instead. Caller: " + callerClass.getName());
        }
    }

    public static boolean hasApiHolograms() {
        HoloDisplaysAPIInternal.validateCaller();
        return HoloDisplaysAPIImpl.hasApiHolograms();
    }

    public static void forEachApiHologram(BiConsumer<String, HologramData> consumer) {
        HoloDisplaysAPIInternal.validateCaller();
        HoloDisplaysAPIImpl.forEachApiHologram(consumer);
    }

    public static void clearAll() {
        HoloDisplaysAPIInternal.validateCaller();
        HoloDisplaysAPIImpl.clearAllStatic();
    }

    public static DisplayData getDisplay(String id) {
        HoloDisplaysAPIInternal.validateCaller();
        return HoloDisplaysAPIImpl.getDisplayStatic(id);
    }

    public static HologramData getHologram(String id) {
        HoloDisplaysAPIInternal.validateCaller();
        return HoloDisplaysAPIImpl.getHologramStatic(id);
    }
}

