/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.holodisplays.api;

import dev.furq.holodisplays.HoloDisplays;
import dev.furq.holodisplays.api.HoloDisplaysAPI;
import dev.furq.holodisplays.config.DisplayConfig;
import dev.furq.holodisplays.config.HologramConfig;
import dev.furq.holodisplays.data.DisplayData;
import dev.furq.holodisplays.data.HologramData;
import dev.furq.holodisplays.data.display.BaseDisplay;
import dev.furq.holodisplays.data.display.BlockDisplay;
import dev.furq.holodisplays.data.display.EntityDisplay;
import dev.furq.holodisplays.data.display.ItemDisplay;
import dev.furq.holodisplays.data.display.TextDisplay;
import dev.furq.holodisplays.handlers.ViewerHandler;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_4050;
import net.minecraft.class_8113;
import net.minecraft.server.MinecraftServer;
import org.joml.Vector3f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record HoloDisplaysAPIImpl(String modId) implements HoloDisplaysAPI
{
    private static final Logger LOGGER = LoggerFactory.getLogger(HoloDisplaysAPIImpl.class);
    private static final Map<String, HologramData> apiHolograms = new HashMap<String, HologramData>();
    private static final Map<String, DisplayData> apiDisplays = new HashMap<String, DisplayData>();

    public HoloDisplaysAPIImpl {
        if (modId == null || modId.isEmpty()) {
            throw new IllegalArgumentException("Mod ID cannot be null or empty");
        }
        if ("minecraft".equals(modId)) {
            throw new IllegalArgumentException("Cannot use 'minecraft' as mod ID");
        }
    }

    static boolean hasApiHolograms() {
        return !apiHolograms.isEmpty();
    }

    static void forEachApiHologram(BiConsumer<String, HologramData> consumer) {
        apiHolograms.forEach(consumer);
    }

    static void clearAllStatic() {
        apiHolograms.keySet().forEach(id -> {
            ViewerHandler.INSTANCE.removeHologramFromAllViewers((String)id);
            ViewerHandler.INSTANCE.removeTracker((String)id);
        });
        apiHolograms.clear();
        apiDisplays.clear();
    }

    static DisplayData getDisplayStatic(String id) {
        return apiDisplays.get(id);
    }

    static HologramData getHologramStatic(String id) {
        return apiHolograms.get(id);
    }

    private static class_8113.class_8114 parseBillboardMode(String mode) {
        if (mode == null) {
            return class_8113.class_8114.field_42409;
        }
        return switch (mode.toLowerCase()) {
            case "fixed" -> class_8113.class_8114.field_42406;
            case "horizontal" -> class_8113.class_8114.field_42408;
            case "vertical" -> class_8113.class_8114.field_42407;
            default -> class_8113.class_8114.field_42409;
        };
    }

    @Override
    public boolean registerHologram(String id, HologramData hologram) {
        try {
            String fullId = this.toFullId(id);
            if (apiHolograms.containsKey(fullId)) {
                throw new IllegalArgumentException("Hologram with ID " + id + " is already registered");
            }
            for (HologramData.DisplayLine display : hologram.getDisplays()) {
                if (DisplayConfig.INSTANCE.exists(display.getName()) || apiDisplays.containsKey(display.getName())) continue;
                throw new IllegalArgumentException("Display with ID " + display.getName() + " does not exist");
            }
            apiHolograms.put(fullId, hologram);
            ViewerHandler.INSTANCE.createTracker(fullId);
            MinecraftServer server = HoloDisplays.Companion.getSERVER();
            if (server != null && server.method_3760() != null) {
                server.method_3760().method_14571().forEach(ViewerHandler.INSTANCE::updatePlayerVisibility);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to register hologram {}: {}", (Object)id, (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public boolean unregisterHologram(String id) {
        try {
            String fullId = this.toFullId(id);
            if (!apiHolograms.containsKey(fullId)) {
                return false;
            }
            ViewerHandler.INSTANCE.removeHologramFromAllViewers(fullId);
            ViewerHandler.INSTANCE.removeTracker(fullId);
            apiHolograms.remove(fullId);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to unregister hologram {}: {}", (Object)id, (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public boolean updateHologram(String id, HologramData hologram) {
        try {
            String fullId = this.toFullId(id);
            if (!apiHolograms.containsKey(fullId)) {
                return false;
            }
            for (HologramData.DisplayLine display : hologram.getDisplays()) {
                if (DisplayConfig.INSTANCE.exists(display.getName()) || apiDisplays.containsKey(display.getName())) continue;
                throw new IllegalArgumentException("Display with ID " + display.getName() + " does not exist");
            }
            apiHolograms.put(fullId, hologram);
            ViewerHandler.INSTANCE.respawnForAllObservers(fullId);
            MinecraftServer server = HoloDisplays.Companion.getSERVER();
            if (server != null && server.method_3760() != null) {
                server.method_3760().method_14571().forEach(ViewerHandler.INSTANCE::updatePlayerVisibility);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to update hologram {}: {}", (Object)id, (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public boolean isHologramRegistered(String id) {
        return apiHolograms.containsKey(this.toFullId(id));
    }

    @Override
    public DisplayData createTextDisplay(String id, Consumer<HoloDisplaysAPI.TextDisplayBuilder> builder) {
        TextDisplayBuilderImpl textBuilder = new TextDisplayBuilderImpl();
        builder.accept(textBuilder);
        TextDisplay display = textBuilder.build();
        return this.registerDisplay(id, display);
    }

    @Override
    public DisplayData createItemDisplay(String id, Consumer<HoloDisplaysAPI.ItemDisplayBuilder> builder) {
        ItemDisplayBuilderImpl itemBuilder = new ItemDisplayBuilderImpl();
        builder.accept(itemBuilder);
        ItemDisplay display = itemBuilder.build();
        return this.registerDisplay(id, display);
    }

    @Override
    public DisplayData createBlockDisplay(String id, Consumer<HoloDisplaysAPI.BlockDisplayBuilder> builder) {
        BlockDisplayBuilderImpl blockBuilder = new BlockDisplayBuilderImpl();
        builder.accept(blockBuilder);
        BlockDisplay display = blockBuilder.build();
        return this.registerDisplay(id, display);
    }

    @Override
    public DisplayData createEntityDisplay(String id, Consumer<HoloDisplaysAPI.EntityDisplayBuilder> builder) {
        EntityDisplayBuilderImpl entityBuilder = new EntityDisplayBuilderImpl();
        builder.accept(entityBuilder);
        EntityDisplay display = entityBuilder.build();
        return this.registerDisplay(id, display);
    }

    @Override
    public HoloDisplaysAPI.HologramBuilder createHologramBuilder() {
        return new HologramBuilderImpl(this.modId);
    }

    @Override
    public int unregisterAllHolograms() {
        String prefix = this.modId + ":";
        List<String> hologramsToRemove = apiHolograms.keySet().stream().filter(id -> id.startsWith(prefix)).toList();
        hologramsToRemove.forEach(id -> {
            ViewerHandler.INSTANCE.removeHologramFromAllViewers((String)id);
            ViewerHandler.INSTANCE.removeTracker((String)id);
            apiHolograms.remove(id);
        });
        return hologramsToRemove.size();
    }

    @Override
    public int unregisterAllDisplays() {
        String prefix = this.modId + ":";
        List<String> displaysToRemove = apiDisplays.keySet().stream().filter(id -> id.startsWith(prefix)).toList();
        displaysToRemove.forEach(id -> {
            List<String> affectedHolograms = this.findHologramsUsingDisplay((String)id);
            apiDisplays.remove(id);
            for (String hologramId : affectedHolograms) {
                if (!apiHolograms.containsKey(hologramId)) continue;
                ViewerHandler.INSTANCE.respawnForAllObservers(hologramId);
            }
        });
        return displaysToRemove.size();
    }

    @Override
    public DisplayData getDisplay(String id) {
        return apiDisplays.get(this.toFullId(id));
    }

    @Override
    public HologramData getHologram(String id) {
        return apiHolograms.get(this.toFullId(id));
    }

    @Override
    public boolean isDisplayRegistered(String id) {
        return apiDisplays.containsKey(this.toFullId(id));
    }

    @Override
    public boolean updateDisplay(String id, DisplayData display) {
        try {
            String fullId = this.toFullId(id);
            if (!apiDisplays.containsKey(fullId) || display == null) {
                return false;
            }
            DisplayData oldDisplay = apiDisplays.get(fullId);
            apiDisplays.put(fullId, display);
            this.updateAffectedHolograms(fullId, oldDisplay, display);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to update display {}: {}", (Object)id, (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public boolean unregisterDisplay(String id) {
        try {
            String fullId = this.toFullId(id);
            if (!apiDisplays.containsKey(fullId)) {
                return false;
            }
            List<String> affectedHolograms = this.findHologramsUsingDisplay(fullId);
            apiDisplays.remove(fullId);
            for (String hologramId : affectedHolograms) {
                if (!apiHolograms.containsKey(hologramId)) continue;
                ViewerHandler.INSTANCE.respawnForAllObservers(hologramId);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to unregister display {}: {}", (Object)id, (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public void clearAll() {
        apiHolograms.keySet().forEach(id -> {
            ViewerHandler.INSTANCE.removeHologramFromAllViewers((String)id);
            ViewerHandler.INSTANCE.removeTracker((String)id);
        });
        apiHolograms.clear();
        apiDisplays.clear();
    }

    private String toFullId(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("ID cannot be null or empty");
        }
        return id.contains(":") ? id : this.modId + ":" + id;
    }

    private DisplayData registerDisplay(String id, BaseDisplay display) {
        String fullId = this.toFullId(id);
        if (apiDisplays.containsKey(fullId)) {
            throw new IllegalArgumentException("Display with ID " + id + " is already registered");
        }
        DisplayData displayData = new DisplayData(display);
        apiDisplays.put(fullId, displayData);
        return displayData;
    }

    private List<String> findHologramsUsingDisplay(String displayId) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, HologramData> entry : apiHolograms.entrySet()) {
            if (!entry.getValue().getDisplays().stream().anyMatch(line -> line.getName().equals(displayId))) continue;
            result.add(entry.getKey());
        }
        if (apiDisplays.containsKey(displayId)) {
            for (Map.Entry<String, HologramData> entry : HologramConfig.INSTANCE.getHolograms().entrySet()) {
                if (!entry.getValue().getDisplays().stream().anyMatch(line -> line.getName().equals(displayId))) continue;
                result.add(entry.getKey());
            }
        }
        return result;
    }

    private boolean requiresRespawn(DisplayData oldDisplay, DisplayData newDisplay) {
        BaseDisplay oldType = oldDisplay.getType();
        BaseDisplay newType = newDisplay.getType();
        if (!oldType.getClass().equals(newType.getClass())) {
            return true;
        }
        BaseDisplay baseDisplay = oldType;
        Objects.requireNonNull(baseDisplay);
        BaseDisplay baseDisplay2 = baseDisplay;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextDisplay.class, ItemDisplay.class, BlockDisplay.class, EntityDisplay.class}, (Object)baseDisplay2, n)) {
            case 0 -> {
                TextDisplay ignored = (TextDisplay)baseDisplay2;
                if (!Objects.equals(oldType.getRotation(), newType.getRotation()) || !Objects.equals(oldType.getConditionalPlaceholder(), newType.getConditionalPlaceholder())) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                ItemDisplay oldItem = (ItemDisplay)baseDisplay2;
                ItemDisplay newItem = (ItemDisplay)newType;
                if (!(oldItem.getId().equals(newItem.getId()) && Objects.equals(oldType.getRotation(), newType.getRotation()) && Objects.equals(oldType.getConditionalPlaceholder(), newType.getConditionalPlaceholder()))) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                BlockDisplay oldBlock = (BlockDisplay)baseDisplay2;
                BlockDisplay newBlock = (BlockDisplay)newType;
                if (!(oldBlock.getId().equals(newBlock.getId()) && Objects.equals(oldType.getRotation(), newType.getRotation()) && Objects.equals(oldType.getConditionalPlaceholder(), newType.getConditionalPlaceholder()))) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                EntityDisplay oldEntity = (EntityDisplay)baseDisplay2;
                EntityDisplay newEntity = (EntityDisplay)newType;
                if (!(oldEntity.getId().equals(newEntity.getId()) && Objects.equals(oldType.getScale(), newType.getScale()) && Objects.equals(oldType.getRotation(), newType.getRotation()) && Objects.equals(oldType.getConditionalPlaceholder(), newType.getConditionalPlaceholder()))) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private void updateAffectedHolograms(String displayId, DisplayData oldDisplay, DisplayData newDisplay) {
        List<String> affectedHolograms = this.findHologramsUsingDisplay(displayId);
        boolean needsRespawn = this.requiresRespawn(oldDisplay, newDisplay);
        affectedHolograms.forEach(hologramId -> {
            if (needsRespawn) {
                ViewerHandler.INSTANCE.respawnForAllObservers((String)hologramId);
            } else {
                ViewerHandler.INSTANCE.updateForAllObservers((String)hologramId);
            }
        });
    }

    private static class TextDisplayBuilderImpl
    extends BaseDisplayBuilderImpl<TextDisplay.Builder>
    implements HoloDisplaysAPI.TextDisplayBuilder {
        public TextDisplayBuilderImpl() {
            super(new TextDisplay.Builder());
        }

        @Override
        public void text(String ... lines) {
            ((TextDisplay.Builder)this.builder).setLines(lines == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(lines)));
        }

        @Override
        public void backgroundColor(String hexColor, int opacity) {
            if (hexColor == null || !hexColor.matches("^[0-9A-Fa-f]{6}$")) {
                throw new IllegalArgumentException("Color must be a valid 6-digit hexadecimal color code");
            }
            if (opacity < 0 || opacity > 100) {
                throw new IllegalArgumentException("Opacity must be between 0 and 100");
            }
            int opacityValue = (int)((double)opacity / 100.0 * 255.0);
            String opacityHex = String.format("%02X", opacityValue);
            ((TextDisplay.Builder)this.builder).setBackgroundColor(opacityHex + hexColor);
        }

        @Override
        public void shadow(boolean hasShadow) {
            ((TextDisplay.Builder)this.builder).setShadow(hasShadow);
        }

        @Override
        public void seeThrough(boolean seeThrough) {
            ((TextDisplay.Builder)this.builder).setSeeThrough(seeThrough);
        }

        @Override
        public void opacity(float opacity) {
            ((TextDisplay.Builder)this.builder).setTextOpacity((int)(opacity * 255.0f));
        }

        public TextDisplay build() {
            return ((TextDisplay.Builder)this.builder).build();
        }
    }

    private static class ItemDisplayBuilderImpl
    extends BaseDisplayBuilderImpl<ItemDisplay.Builder>
    implements HoloDisplaysAPI.ItemDisplayBuilder {
        public ItemDisplayBuilderImpl() {
            super(new ItemDisplay.Builder());
        }

        @Override
        public void item(String itemId) {
            if (itemId == null || itemId.isEmpty()) {
                throw new IllegalArgumentException("Item ID cannot be null or empty");
            }
            ((ItemDisplay.Builder)this.builder).setId(itemId);
        }

        public ItemDisplay build() {
            return ((ItemDisplay.Builder)this.builder).build();
        }
    }

    private static class BlockDisplayBuilderImpl
    extends BaseDisplayBuilderImpl<BlockDisplay.Builder>
    implements HoloDisplaysAPI.BlockDisplayBuilder {
        public BlockDisplayBuilderImpl() {
            super(new BlockDisplay.Builder());
        }

        @Override
        public void block(String blockId) {
            if (blockId == null || blockId.isEmpty()) {
                throw new IllegalArgumentException("Block ID cannot be null or empty");
            }
            ((BlockDisplay.Builder)this.builder).setId(blockId);
        }

        public BlockDisplay build() {
            return ((BlockDisplay.Builder)this.builder).build();
        }
    }

    private static class EntityDisplayBuilderImpl
    extends BaseDisplayBuilderImpl<EntityDisplay.Builder>
    implements HoloDisplaysAPI.EntityDisplayBuilder {
        public EntityDisplayBuilderImpl() {
            super(new EntityDisplay.Builder());
        }

        @Override
        public void entity(String entityId) {
            if (entityId == null || entityId.isEmpty()) {
                throw new IllegalArgumentException("Entity ID cannot be null or empty");
            }
            ((EntityDisplay.Builder)this.builder).setId(entityId);
        }

        @Override
        public void glow(boolean glow) {
            ((EntityDisplay.Builder)this.builder).setGlow(glow);
        }

        @Override
        public void pose(String pose) {
            if (pose == null || pose.isEmpty()) {
                throw new IllegalArgumentException("Entity pose cannot be null or empty");
            }
            try {
                ((EntityDisplay.Builder)this.builder).setPose(class_4050.valueOf((String)pose.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid entity pose: " + pose);
            }
        }

        public EntityDisplay build() {
            return ((EntityDisplay.Builder)this.builder).build();
        }
    }

    private static class HologramBuilderImpl
    implements HoloDisplaysAPI.HologramBuilder {
        private final String modId;
        private final List<HologramData.DisplayLine> displays = new ArrayList<HologramData.DisplayLine>();
        private HologramData.Position position = new HologramData.Position("minecraft:overworld", 0.0f, 0.0f, 0.0f);
        private Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
        private class_8113.class_8114 billboardMode = class_8113.class_8114.field_42409;
        private int updateRate = 20;
        private double viewRange = 48.0;
        private Vector3f rotation = new Vector3f();
        private String conditionalPlaceholder = null;

        HologramBuilderImpl(String modId) {
            this.modId = modId;
        }

        @Override
        public HoloDisplaysAPI.HologramBuilder position(float x, float y, float z) {
            this.position = new HologramData.Position(this.position.getWorld(), x, y, z);
            return this;
        }

        @Override
        public HoloDisplaysAPI.HologramBuilder world(String worldId) {
            if (worldId == null || worldId.isEmpty()) {
                throw new IllegalArgumentException("World ID cannot be null or empty");
            }
            this.position = new HologramData.Position(worldId, this.position.getX(), this.position.getY(), this.position.getZ());
            return this;
        }

        @Override
        public HoloDisplaysAPI.HologramBuilder scale(float x, float y, float z) {
            this.scale = new Vector3f(x, y, z);
            return this;
        }

        @Override
        public HoloDisplaysAPI.HologramBuilder billboardMode(String mode) {
            this.billboardMode = HoloDisplaysAPIImpl.parseBillboardMode(mode);
            return this;
        }

        @Override
        public HoloDisplaysAPI.HologramBuilder updateRate(int ticks) {
            this.updateRate = ticks;
            return this;
        }

        @Override
        public HoloDisplaysAPI.HologramBuilder viewRange(double range) {
            this.viewRange = range;
            return this;
        }

        @Override
        public HoloDisplaysAPI.HologramBuilder rotation(float x, float y, float z) {
            this.rotation = new Vector3f(x, y, z);
            return this;
        }

        @Override
        public HoloDisplaysAPI.HologramBuilder condition(String placeholder) {
            this.conditionalPlaceholder = placeholder;
            return this;
        }

        @Override
        public HoloDisplaysAPI.HologramBuilder addDisplay(String displayId, float offsetX, float offsetY, float offsetZ) {
            if (displayId == null || displayId.isEmpty()) {
                throw new IllegalArgumentException("Display ID cannot be null or empty");
            }
            String fullId = displayId.contains(":") ? displayId : this.modId + ":" + displayId;
            this.displays.add(new HologramData.DisplayLine(fullId, new Vector3f(offsetX, offsetY, offsetZ)));
            return this;
        }

        @Override
        public HologramData build() {
            return new HologramData(this.displays, this.position, this.rotation, this.scale, this.billboardMode, this.updateRate, this.viewRange, this.conditionalPlaceholder);
        }
    }

    private static abstract class BaseDisplayBuilderImpl<T extends BaseDisplay.Builder<?>> {
        protected final T builder;

        protected BaseDisplayBuilderImpl(T builder) {
            this.builder = builder;
        }

        public void scale(float x, float y, float z) {
            this.builder.setScale(new Vector3f(x, y, z));
        }

        public void rotation(float x, float y, float z) {
            this.builder.setRotation(new Vector3f(x, y, z));
        }

        public void billboardMode(String mode) {
            this.builder.setBillboardMode(HoloDisplaysAPIImpl.parseBillboardMode(mode));
        }

        public void condition(String placeholder) {
            this.builder.setConditionalPlaceholder(placeholder);
        }
    }
}

