/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.holodisplays.config;

import dev.furq.holodisplays.api.HoloDisplaysAPI;
import dev.furq.holodisplays.config.Config;
import dev.furq.holodisplays.config.JsonUtils;
import dev.furq.holodisplays.data.HologramData;
import dev.furq.holodisplays.handlers.ConfigException;
import dev.furq.holodisplays.handlers.ErrorHandler;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import net.minecraft.class_2168;
import net.minecraft.class_8113;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.quiltmc.parsers.json.JsonReader;
import org.quiltmc.parsers.json.JsonWriter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\u0003J\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0019\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\nH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013*\u00020\nH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u0014\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u0019\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u001c\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010 \u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0014\u00a2\u0006\u0004\b \u0010!J\u001f\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\f\u00a2\u0006\u0004\b$\u0010%J'\u0010'\u001a\n &*\u0004\u0018\u00010#0#2\u0006\u0010\u000b\u001a\u00020#2\u0006\u0010\"\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010)\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u0014\u00a2\u0006\u0004\b)\u0010\u001aR\"\u0010*\u001a\u00020\u00048\u0016@\u0016X\u0096.\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-\"\u0004\b.\u0010\bR \u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101\u00a8\u00062"}, d2={"Ldev/furq/holodisplays/config/HologramConfig;", "Ldev/furq/holodisplays/config/Config;", "<init>", "()V", "Ljava/nio/file/Path;", "baseDir", "", "init", "(Ljava/nio/file/Path;)V", "reload", "Lorg/quiltmc/parsers/json/JsonReader;", "json", "Ldev/furq/holodisplays/data/HologramData;", "parseHologramData", "(Lorg/quiltmc/parsers/json/JsonReader;)Ldev/furq/holodisplays/data/HologramData;", "", "Ldev/furq/holodisplays/data/HologramData$DisplayLine;", "parseDisplayLines", "(Lorg/quiltmc/parsers/json/JsonReader;)Ljava/util/List;", "Lkotlin/Pair;", "", "Lorg/joml/Vector3f;", "parsePosition", "(Lorg/quiltmc/parsers/json/JsonReader;)Lkotlin/Pair;", "name", "getHologram", "(Ljava/lang/String;)Ldev/furq/holodisplays/data/HologramData;", "getHologramOrAPI", "", "getHolograms", "()Ljava/util/Map;", "", "exists", "(Ljava/lang/String;)Z", "hologram", "Lorg/quiltmc/parsers/json/JsonWriter;", "saveHologram", "(Ljava/lang/String;Ldev/furq/holodisplays/data/HologramData;)Lorg/quiltmc/parsers/json/JsonWriter;", "kotlin.jvm.PlatformType", "writeHologram", "(Lorg/quiltmc/parsers/json/JsonWriter;Ldev/furq/holodisplays/data/HologramData;)Lorg/quiltmc/parsers/json/JsonWriter;", "deleteHologram", "configDir", "Ljava/nio/file/Path;", "getConfigDir", "()Ljava/nio/file/Path;", "setConfigDir", "", "holograms", "Ljava/util/Map;", "holodisplays"})
@SourceDebugExtension(value={"SMAP\nHologramConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HologramConfig.kt\ndev/furq/holodisplays/config/HologramConfig\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ErrorHandler.kt\ndev/furq/holodisplays/handlers/ErrorHandler\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n13805#2,2:157\n1#3:159\n31#4,10:160\n31#4,10:172\n1869#5,2:170\n*S KotlinDebug\n*F\n+ 1 HologramConfig.kt\ndev/furq/holodisplays/config/HologramConfig\n*L\n25#1:157,2\n107#1:160,10\n146#1:172,10\n121#1:170,2\n*E\n"})
public final class HologramConfig
implements Config {
    @NotNull
    public static final HologramConfig INSTANCE = new HologramConfig();
    public static Path configDir;
    @NotNull
    private static final Map<String, HologramData> holograms;

    private HologramConfig() {
    }

    @Override
    @NotNull
    public Path getConfigDir() {
        Path path = configDir;
        if (path != null) {
            return path;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"configDir");
        return null;
    }

    public void setConfigDir(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        configDir = path;
    }

    public void init(@NotNull Path baseDir) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Path path = baseDir.resolve("holograms");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.setConfigDir(path);
        Config.super.init(baseDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        holograms.clear();
        File[] fileArray = this.getConfigDir().toFile().listFiles(JsonUtils.INSTANCE.getJsonFilter());
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File file = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)file);
                Closeable closeable = new FileInputStream(file);
                Object object = Charsets.UTF_8;
                closeable = (Closeable)JsonReader.json5((Reader)new InputStreamReader((InputStream)closeable, (Charset)object));
                object = null;
                try {
                    JsonReader json = (JsonReader)closeable;
                    boolean bl2 = false;
                    String string = FilesKt.getNameWithoutExtension((File)file);
                    Intrinsics.checkNotNull((Object)json);
                    holograms.put(string, INSTANCE.parseHologramData(json));
                    Unit unit = Unit.INSTANCE;
                    continue;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
            }
        } else {
            throw new ConfigException("Failed to list hologram config files");
        }
    }

    private final HologramData parseHologramData(JsonReader json) {
        JsonReader $this$parseHologramData_u24lambda_u240 = json;
        boolean bl = false;
        HologramData.Builder builder = new HologramData.Builder();
        $this$parseHologramData_u24lambda_u240.beginObject();
        block20: while ($this$parseHologramData_u24lambda_u240.hasNext()) {
            block29: {
                String string = $this$parseHologramData_u24lambda_u240.nextName();
                if (string == null) break block29;
                int n = -1;
                switch (string.hashCode()) {
                    case 886923021: {
                        if (string.equals("conditionalPlaceholder")) {
                            n = 1;
                        }
                        break;
                    }
                    case -295998135: {
                        if (string.equals("updateRate")) {
                            n = 2;
                        }
                        break;
                    }
                    case -1585582696: {
                        if (string.equals("viewRange")) {
                            n = 3;
                        }
                        break;
                    }
                    case -40300674: {
                        if (string.equals("rotation")) {
                            n = 4;
                        }
                        break;
                    }
                    case 109250890: {
                        if (string.equals("scale")) {
                            n = 5;
                        }
                        break;
                    }
                    case 0x2C929929: {
                        if (string.equals("position")) {
                            n = 6;
                        }
                        break;
                    }
                    case 285081585: {
                        if (string.equals("displays")) {
                            n = 7;
                        }
                        break;
                    }
                    case -172216958: {
                        if (string.equals("billboardMode")) {
                            n = 8;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 7: {
                        builder.setDisplays(INSTANCE.parseDisplayLines($this$parseHologramData_u24lambda_u240));
                        continue block20;
                    }
                    case 6: {
                        Pair<String, Vector3f> pair = INSTANCE.parsePosition($this$parseHologramData_u24lambda_u240);
                        boolean bl2 = false;
                        String world = (String)pair.component1();
                        Vector3f position = (Vector3f)pair.component2();
                        builder.setWorld(world);
                        builder.setPosition(position);
                        continue block20;
                    }
                    case 4: {
                        builder.setRotation(JsonUtils.INSTANCE.parseVector3f($this$parseHologramData_u24lambda_u240));
                        continue block20;
                    }
                    case 5: {
                        builder.setScale(JsonUtils.INSTANCE.parseVector3f($this$parseHologramData_u24lambda_u240));
                        continue block20;
                    }
                    case 8: {
                        String string2 = $this$parseHologramData_u24lambda_u240.nextString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nextString(...)");
                        String string3 = string2.toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
                        builder.setBillboardMode(class_8113.class_8114.valueOf((String)string3));
                        continue block20;
                    }
                    case 2: {
                        builder.setUpdateRate($this$parseHologramData_u24lambda_u240.nextInt());
                        continue block20;
                    }
                    case 3: {
                        builder.setViewRange($this$parseHologramData_u24lambda_u240.nextDouble());
                        continue block20;
                    }
                    case 1: {
                        builder.setConditionalPlaceholder($this$parseHologramData_u24lambda_u240.nextString());
                        continue block20;
                    }
                }
            }
            $this$parseHologramData_u24lambda_u240.skipValue();
        }
        $this$parseHologramData_u24lambda_u240.endObject();
        return builder.build();
    }

    private final List<HologramData.DisplayLine> parseDisplayLines(JsonReader $this$parseDisplayLines) {
        List lines = new ArrayList();
        $this$parseDisplayLines.beginArray();
        while ($this$parseDisplayLines.hasNext()) {
            String string;
            $this$parseDisplayLines.beginObject();
            String name = "";
            Vector3f offset = null;
            offset = new Vector3f();
            while ($this$parseDisplayLines.hasNext()) {
                String string2 = $this$parseDisplayLines.nextName();
                if (Intrinsics.areEqual((Object)string2, (Object)"name")) {
                    Intrinsics.checkNotNullExpressionValue((Object)$this$parseDisplayLines.nextString(), (String)"nextString(...)");
                    continue;
                }
                if (Intrinsics.areEqual((Object)string2, (Object)"offset")) {
                    offset = JsonUtils.INSTANCE.parseVector3f($this$parseDisplayLines);
                    continue;
                }
                $this$parseDisplayLines.skipValue();
            }
            $this$parseDisplayLines.endObject();
            String it = string = name;
            boolean bl = false;
            String string3 = ((CharSequence)it).length() > 0 ? string : null;
            if (string3 == null) continue;
            it = string3;
            boolean bl2 = false;
            lines.add(new HologramData.DisplayLine(it, offset));
        }
        $this$parseDisplayLines.endArray();
        return lines;
    }

    private final Pair<String, Vector3f> parsePosition(JsonReader $this$parsePosition) {
        String world = "minecraft:overworld";
        Vector3f position = new Vector3f();
        $this$parsePosition.beginObject();
        block12: while ($this$parsePosition.hasNext()) {
            block17: {
                String string = $this$parsePosition.nextName();
                if (string == null) break block17;
                int n = -1;
                switch (string.hashCode()) {
                    case 113318802: {
                        if (string.equals("world")) {
                            n = 1;
                        }
                        break;
                    }
                    case 120: {
                        if (string.equals("x")) {
                            n = 2;
                        }
                        break;
                    }
                    case 121: {
                        if (string.equals("y")) {
                            n = 3;
                        }
                        break;
                    }
                    case 122: {
                        if (string.equals("z")) {
                            n = 4;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        Intrinsics.checkNotNullExpressionValue((Object)$this$parsePosition.nextString(), (String)"nextString(...)");
                        continue block12;
                    }
                    case 2: {
                        position.x = (float)$this$parsePosition.nextDouble();
                        continue block12;
                    }
                    case 3: {
                        position.y = (float)$this$parsePosition.nextDouble();
                        continue block12;
                    }
                    case 4: {
                        position.z = (float)$this$parsePosition.nextDouble();
                        continue block12;
                    }
                }
            }
            $this$parsePosition.skipValue();
        }
        $this$parsePosition.endObject();
        return TuplesKt.to((Object)world, (Object)position);
    }

    @Nullable
    public final HologramData getHologram(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return holograms.get(name);
    }

    @Nullable
    public final HologramData getHologramOrAPI(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        HologramData hologramData = holograms.get(name);
        if (hologramData == null) {
            hologramData = HoloDisplaysAPI.get().getHologram(name);
        }
        return hologramData;
    }

    @NotNull
    public final Map<String, HologramData> getHolograms() {
        return holograms;
    }

    public final boolean exists(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return holograms.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final JsonWriter saveHologram(@NotNull String name, @NotNull HologramData hologram) {
        JsonWriter jsonWriter;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)hologram, (String)"hologram");
        ErrorHandler $this$iv = ErrorHandler.INSTANCE;
        class_2168 source$iv = null;
        JsonWriter default$iv = null;
        boolean $i$f$safeCall = false;
        try {
            JsonWriter jsonWriter2;
            boolean bl = false;
            holograms.put(name, hologram);
            File file = INSTANCE.getConfigDir().resolve(name + ".json").toFile();
            file.getParentFile().mkdirs();
            Intrinsics.checkNotNull((Object)file);
            Closeable closeable = new FileOutputStream(file);
            Object object = Charsets.UTF_8;
            closeable = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
            object = null;
            try {
                JsonWriter jsonWriter3;
                OutputStreamWriter writer = (OutputStreamWriter)closeable;
                boolean bl2 = false;
                Closeable closeable2 = (Closeable)JsonWriter.json((Writer)writer);
                Throwable throwable = null;
                try {
                    JsonWriter json = (JsonWriter)closeable2;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)json);
                    jsonWriter3 = INSTANCE.writeHologram(json, hologram);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
                }
                jsonWriter2 = jsonWriter3;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            jsonWriter = jsonWriter2;
        }
        catch (Exception e$iv) {
            $this$iv.handle(e$iv, source$iv);
            jsonWriter = default$iv;
        }
        return jsonWriter;
    }

    private final JsonWriter writeHologram(JsonWriter json, HologramData hologram) {
        JsonWriter $this$writeHologram_u24lambda_u240;
        block1: {
            $this$writeHologram_u24lambda_u240 = json;
            boolean bl = false;
            $this$writeHologram_u24lambda_u240.beginObject();
            $this$writeHologram_u24lambda_u240.name("displays").beginArray();
            Iterable $this$forEach$iv = hologram.getDisplays();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HologramData.DisplayLine line = (HologramData.DisplayLine)element$iv;
                boolean bl2 = false;
                $this$writeHologram_u24lambda_u240.beginObject();
                $this$writeHologram_u24lambda_u240.name("name").value(line.getDisplayId());
                JsonUtils.INSTANCE.writeVector3f($this$writeHologram_u24lambda_u240, "offset", line.getOffset());
                $this$writeHologram_u24lambda_u240.endObject();
            }
            $this$writeHologram_u24lambda_u240.endArray();
            $this$writeHologram_u24lambda_u240.name("position").beginObject();
            $this$writeHologram_u24lambda_u240.name("world").value(hologram.getWorld());
            $this$writeHologram_u24lambda_u240.name("x").value((Number)Float.valueOf(hologram.getPosition().x));
            $this$writeHologram_u24lambda_u240.name("y").value((Number)Float.valueOf(hologram.getPosition().y));
            $this$writeHologram_u24lambda_u240.name("z").value((Number)Float.valueOf(hologram.getPosition().z));
            $this$writeHologram_u24lambda_u240.endObject();
            JsonUtils.INSTANCE.writeVector3f($this$writeHologram_u24lambda_u240, "rotation", hologram.getRotation());
            JsonUtils.INSTANCE.writeVector3f($this$writeHologram_u24lambda_u240, "scale", hologram.getScale());
            $this$writeHologram_u24lambda_u240.name("billboardMode").value(hologram.getBillboardMode().name());
            $this$writeHologram_u24lambda_u240.name("updateRate").value((Number)hologram.getUpdateRate());
            $this$writeHologram_u24lambda_u240.name("viewRange").value(hologram.getViewRange());
            String string = hologram.getConditionalPlaceholder();
            if (string == null) break block1;
            String it = string;
            boolean bl3 = false;
            $this$writeHologram_u24lambda_u240.name("conditionalPlaceholder").value(it);
        }
        return $this$writeHologram_u24lambda_u240.endObject();
    }

    @Nullable
    public final HologramData deleteHologram(@NotNull String name) {
        HologramData hologramData;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ErrorHandler $this$iv = ErrorHandler.INSTANCE;
        class_2168 source$iv = null;
        HologramData default$iv = null;
        boolean $i$f$safeCall = false;
        try {
            boolean bl = false;
            File file = INSTANCE.getConfigDir().resolve(name + ".json").toFile();
            if (!file.exists()) {
                throw new ConfigException("Hologram config file for " + name + " does not exist");
            }
            if (!file.delete()) {
                throw new ConfigException("Failed to delete hologram config file for " + name);
            }
            hologramData = holograms.remove(name);
        }
        catch (Exception e$iv) {
            $this$iv.handle(e$iv, source$iv);
            hologramData = default$iv;
        }
        return hologramData;
    }

    static {
        holograms = new LinkedHashMap();
    }
}

