/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.holodisplays;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.brigadier.CommandDispatcher;
import dev.furq.holodisplays.api.HoloDisplaysAPI;
import dev.furq.holodisplays.api.HoloDisplaysAPIImpl;
import dev.furq.holodisplays.commands.MainCommand;
import dev.furq.holodisplays.config.ConfigManager;
import dev.furq.holodisplays.config.HologramConfig;
import dev.furq.holodisplays.data.HologramData;
import dev.furq.holodisplays.handlers.ErrorHandler;
import dev.furq.holodisplays.handlers.HologramHandler;
import dev.furq.holodisplays.handlers.TickHandler;
import dev.furq.holodisplays.handlers.ViewerHandler;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0011\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\u000bJ\u0011\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\r\u0010\u000b\u00a8\u0006\u000f"}, d2={"Ldev/furq/holodisplays/HoloDisplays;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "", "onInitialize", "Lnet/minecraft/server/MinecraftServer;", "server", "handleServerTick", "(Lnet/minecraft/server/MinecraftServer;)V", "registerServerEvents", "()Lkotlin/Unit;", "initializeHandlers", "registerCommands", "Companion", "holodisplays"})
@SourceDebugExtension(value={"SMAP\nHoloDisplays.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HoloDisplays.kt\ndev/furq/holodisplays/HoloDisplays\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ErrorHandler.kt\ndev/furq/holodisplays/handlers/ErrorHandler\n*L\n1#1,92:1\n1869#2,2:93\n31#3,10:95\n31#3,10:105\n31#3,10:115\n*S KotlinDebug\n*F\n+ 1 HoloDisplays.kt\ndev/furq/holodisplays/HoloDisplays\n*L\n55#1:93,2\n62#1:95,10\n80#1:105,10\n87#1:115,10\n*E\n"})
public final class HoloDisplays
implements ModInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String MOD_ID = "HoloDisplays";
    @NotNull
    public static final String VERSION = "0.4.1";
    @NotNull
    private static final Logger LOGGER;
    @Nullable
    private static MinecraftServer SERVER;
    @NotNull
    private static Executor EXECUTOR_HOLODISPLAYS;

    public void onInitialize() {
        this.registerServerEvents();
        this.initializeHandlers();
        this.registerCommands();
        LOGGER.info("Initialized HoloDisplays v0.4.1");
    }

    private final void handleServerTick(MinecraftServer server) {
        TickHandler.INSTANCE.tick();
        List list = server.method_3760().method_14571();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayerList(...)");
        if (!((Collection)list).isEmpty()) {
            boolean hasApiHolograms;
            boolean hasConfigHolograms = !HologramConfig.INSTANCE.getHolograms().isEmpty();
            Map<String, HologramData> map = HoloDisplaysAPIImpl.INSTANCE.apiHolograms;
            Intrinsics.checkNotNullExpressionValue(map, (String)"apiHolograms");
            boolean bl = hasApiHolograms = !map.isEmpty();
            if (hasConfigHolograms || hasApiHolograms) {
                List list2 = server.method_3760().method_14571();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getPlayerList(...)");
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    class_3222 player = (class_3222)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)player);
                    ViewerHandler.INSTANCE.updatePlayerVisibility(player);
                }
            }
        }
    }

    private final Unit registerServerEvents() {
        Unit unit;
        ErrorHandler $this$iv = ErrorHandler.INSTANCE;
        class_2168 source$iv = null;
        Unit default$iv = null;
        boolean $i$f$safeCall = false;
        try {
            boolean bl = false;
            ServerLifecycleEvents.SERVER_STARTING.register(HoloDisplays::registerServerEvents$lambda$0$0);
            ServerTickEvents.END_SERVER_TICK.register(arg_0 -> HoloDisplays.registerServerEvents$lambda$0$1(this, arg_0));
            ServerPlayConnectionEvents.JOIN.register(HoloDisplays::registerServerEvents$lambda$0$2);
            ServerPlayConnectionEvents.DISCONNECT.register(HoloDisplays::registerServerEvents$lambda$0$3);
            ServerLifecycleEvents.SERVER_STOPPING.register(HoloDisplays::registerServerEvents$lambda$0$4);
            unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            $this$iv.handle(e$iv, source$iv);
            unit = default$iv;
        }
        return unit;
    }

    private final Unit initializeHandlers() {
        Unit unit;
        ErrorHandler $this$iv = ErrorHandler.INSTANCE;
        class_2168 source$iv = null;
        Unit default$iv = null;
        boolean $i$f$safeCall = false;
        try {
            boolean bl = false;
            Path configDir = FabricLoader.getInstance().getConfigDir().resolve(MOD_ID);
            Intrinsics.checkNotNull((Object)configDir);
            ConfigManager.INSTANCE.init(configDir);
            HologramHandler.INSTANCE.init();
            TickHandler.INSTANCE.init();
            unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            $this$iv.handle(e$iv, source$iv);
            unit = default$iv;
        }
        return unit;
    }

    private final Unit registerCommands() {
        Unit unit;
        ErrorHandler $this$iv = ErrorHandler.INSTANCE;
        class_2168 source$iv = null;
        Unit default$iv = null;
        boolean $i$f$safeCall = false;
        try {
            boolean bl = false;
            CommandRegistrationCallback.EVENT.register(HoloDisplays::registerCommands$lambda$0$0);
            unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            $this$iv.handle(e$iv, source$iv);
            unit = default$iv;
        }
        return unit;
    }

    private static final void registerServerEvents$lambda$0$0(MinecraftServer it) {
        SERVER = it;
    }

    private static final void registerServerEvents$lambda$0$1(HoloDisplays this$0, MinecraftServer server) {
        CompletableFuture.runAsync(() -> HoloDisplays.registerServerEvents$lambda$0$1$0(this$0, server), EXECUTOR_HOLODISPLAYS);
    }

    private static final void registerServerEvents$lambda$0$1$0(HoloDisplays this$0, MinecraftServer $server) {
        Intrinsics.checkNotNull((Object)$server);
        this$0.handleServerTick($server);
    }

    private static final void registerServerEvents$lambda$0$2(class_3244 handler, PacketSender packetSender, MinecraftServer minecraftServer) {
        class_3222 class_32222 = handler.field_14140;
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"player");
        ViewerHandler.INSTANCE.updatePlayerVisibility(class_32222);
    }

    private static final void registerServerEvents$lambda$0$3(class_3244 handler, MinecraftServer minecraftServer) {
        class_3222 class_32222 = handler.field_14140;
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"player");
        ViewerHandler.INSTANCE.clearViewers(class_32222);
    }

    private static final void registerServerEvents$lambda$0$4(MinecraftServer it) {
        HoloDisplaysAPI.get().clearAll();
    }

    private static final void registerCommands$lambda$0$0(CommandDispatcher dispatcher, class_7157 class_71572, class_2170.class_5364 class_53642) {
        Intrinsics.checkNotNull((Object)dispatcher);
        MainCommand.INSTANCE.register((CommandDispatcher<class_2168>)dispatcher);
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)MOD_ID);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        ExecutorService executorService = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("HoloDisplays-Executor-%d").setDaemon(true).build());
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newFixedThreadPool(...)");
        EXECUTOR_HOLODISPLAYS = executorService;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR(\u0010\u000f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0014\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Ldev/furq/holodisplays/HoloDisplays$Companion;", "", "<init>", "()V", "", "MOD_ID", "Ljava/lang/String;", "VERSION", "Lorg/slf4j/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "Lnet/minecraft/server/MinecraftServer;", "value", "SERVER", "Lnet/minecraft/server/MinecraftServer;", "getSERVER", "()Lnet/minecraft/server/MinecraftServer;", "Ljava/util/concurrent/Executor;", "EXECUTOR_HOLODISPLAYS", "Ljava/util/concurrent/Executor;", "getEXECUTOR_HOLODISPLAYS", "()Ljava/util/concurrent/Executor;", "setEXECUTOR_HOLODISPLAYS", "(Ljava/util/concurrent/Executor;)V", "holodisplays"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        @Nullable
        public final MinecraftServer getSERVER() {
            return SERVER;
        }

        @NotNull
        public final Executor getEXECUTOR_HOLODISPLAYS() {
            return EXECUTOR_HOLODISPLAYS;
        }

        public final void setEXECUTOR_HOLODISPLAYS(@NotNull Executor executor) {
            Intrinsics.checkNotNullParameter((Object)executor, (String)"<set-?>");
            EXECUTOR_HOLODISPLAYS = executor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

