/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.holodisplays.handlers;

import dev.furq.holodisplays.HoloDisplays;
import dev.furq.holodisplays.config.HologramConfig;
import dev.furq.holodisplays.data.HologramData;
import dev.furq.holodisplays.handlers.ErrorHandler;
import dev.furq.holodisplays.handlers.HologramException;
import dev.furq.holodisplays.handlers.ViewerHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8113;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001.B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u001f\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ-\u0010&\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020#\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010)\u001a\u00020(2\u0006\u0010 \u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b)\u0010*R \u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020(0+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-\u00a8\u0006/"}, d2={"Ldev/furq/holodisplays/handlers/HologramHandler;", "", "<init>", "()V", "", "init", "reinitialize", "", "name", "Ldev/furq/holodisplays/data/HologramData;", "data", "createHologram", "(Ljava/lang/String;Ldev/furq/holodisplays/data/HologramData;)Lkotlin/Unit;", "showHologramToPlayers", "(Ljava/lang/String;Ldev/furq/holodisplays/data/HologramData;)V", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty;", "property", "updateHologramProperty", "(Ljava/lang/String;Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty;)Lkotlin/Unit;", "hologram", "updateHologramData", "(Ldev/furq/holodisplays/data/HologramData;Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty;)Ldev/furq/holodisplays/data/HologramData;", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$LineOffset;", "updateLineOffset", "(Ldev/furq/holodisplays/data/HologramData;Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$LineOffset;)Ldev/furq/holodisplays/data/HologramData;", "deleteHologram", "(Ljava/lang/String;)Lkotlin/Unit;", "", "Lnet/minecraft/class_3222;", "getPlayersInRange", "(Ldev/furq/holodisplays/data/HologramData;)Ljava/util/List;", "player", "world", "Lorg/joml/Vector3f;", "position", "", "viewRange", "", "isPlayerInRange", "(Lnet/minecraft/class_3222;Ljava/lang/String;Lorg/joml/Vector3f;D)Z", "Lnet/minecraft/class_1937;", "getWorld", "(Ljava/lang/String;)Lnet/minecraft/class_1937;", "Ljava/util/concurrent/ConcurrentHashMap;", "worldCache", "Ljava/util/concurrent/ConcurrentHashMap;", "HologramProperty", "holodisplays"})
@SourceDebugExtension(value={"SMAP\nHologramHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HologramHandler.kt\ndev/furq/holodisplays/handlers/HologramHandler\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 ErrorHandler.kt\ndev/furq/holodisplays/handlers/ErrorHandler\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n216#2,2:154\n216#2,2:156\n31#3,10:158\n31#3,10:170\n31#3,10:194\n1869#4,2:168\n785#4:180\n796#4:181\n1878#4,2:182\n797#4,2:184\n1880#4:186\n799#4:187\n1573#4:189\n1604#4,4:190\n808#4,11:204\n774#4:215\n865#4,2:216\n1#5:188\n*S KotlinDebug\n*F\n+ 1 HologramHandler.kt\ndev/furq/holodisplays/handlers/HologramHandler\n*L\n33#1:154,2\n39#1:156,2\n45#1:158,10\n58#1:170,10\n113#1:194,10\n53#1:168,2\n96#1:180\n96#1:181\n96#1:182,2\n96#1:184,2\n96#1:186\n96#1:187\n107#1:189\n107#1:190,4\n124#1:204,11\n125#1:215\n125#1:216,2\n*E\n"})
public final class HologramHandler {
    @NotNull
    public static final HologramHandler INSTANCE = new HologramHandler();
    @NotNull
    private static final ConcurrentHashMap<String, class_1937> worldCache = new ConcurrentHashMap();

    private HologramHandler() {
    }

    public final void init() {
        Map<String, HologramData> $this$forEach$iv = HologramConfig.INSTANCE.getHolograms();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, HologramData>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, HologramData> element$iv;
            Map.Entry<String, HologramData> entry = element$iv = iterator.next();
            boolean bl = false;
            String name = entry.getKey();
            HologramData data = entry.getValue();
            ViewerHandler.INSTANCE.createTracker(name);
        }
    }

    public final void reinitialize() {
        Map<String, HologramData> $this$forEach$iv = HologramConfig.INSTANCE.getHolograms();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, HologramData>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, HologramData> element$iv;
            Map.Entry<String, HologramData> entry = element$iv = iterator.next();
            boolean bl = false;
            String name = entry.getKey();
            HologramData data = entry.getValue();
            ViewerHandler.INSTANCE.createTracker(name);
            ViewerHandler.INSTANCE.respawnForAllObservers(name);
        }
    }

    @Nullable
    public final Unit createHologram(@NotNull String name, @NotNull HologramData data) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ErrorHandler $this$iv = ErrorHandler.INSTANCE;
        class_2168 source$iv = null;
        Unit default$iv = null;
        boolean $i$f$safeCall = false;
        try {
            boolean bl = false;
            if (HologramConfig.INSTANCE.exists(name)) {
                throw new HologramException("Hologram with name " + name + " already exists");
            }
            HologramConfig.INSTANCE.saveHologram(name, data);
            ViewerHandler.INSTANCE.createTracker(name);
            INSTANCE.showHologramToPlayers(name, data);
            unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            $this$iv.handle(e$iv, source$iv);
            unit = default$iv;
        }
        return unit;
    }

    private final void showHologramToPlayers(String name, HologramData data) {
        Iterable $this$forEach$iv = this.getPlayersInRange(data);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 player = (class_3222)element$iv;
            boolean bl = false;
            ViewerHandler.INSTANCE.addViewer(player, name);
        }
    }

    @Nullable
    public final Unit updateHologramProperty(@NotNull String name, @NotNull HologramProperty property) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        ErrorHandler $this$iv = ErrorHandler.INSTANCE;
        class_2168 source$iv = null;
        Unit default$iv = null;
        boolean $i$f$safeCall = false;
        try {
            Unit unit2;
            boolean needsRespawn;
            boolean bl = false;
            HologramData hologramData = HologramConfig.INSTANCE.getHologram(name);
            if (hologramData == null) {
                throw new HologramException("Hologram " + name + " not found");
            }
            HologramData hologram = hologramData;
            HologramData updatedHologram = INSTANCE.updateHologramData(hologram, property);
            HologramConfig.INSTANCE.saveHologram(name, updatedHologram);
            HologramProperty hologramProperty = property;
            boolean bl2 = needsRespawn = hologramProperty instanceof HologramProperty.Position || hologramProperty instanceof HologramProperty.Rotation || hologramProperty instanceof HologramProperty.ConditionalPlaceholder || hologramProperty instanceof HologramProperty.LineOffset || hologramProperty instanceof HologramProperty.AddLine || hologramProperty instanceof HologramProperty.RemoveLine;
            if (needsRespawn) {
                ViewerHandler.INSTANCE.respawnForAllObservers(name);
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = ViewerHandler.INSTANCE.updateForAllObservers(name);
            }
            unit = unit2;
        }
        catch (Exception e$iv) {
            $this$iv.handle(e$iv, source$iv);
            unit = default$iv;
        }
        return unit;
    }

    /*
     * WARNING - void declaration
     */
    private final HologramData updateHologramData(HologramData hologram, HologramProperty property) {
        Object object;
        HologramProperty hologramProperty = property;
        if (hologramProperty instanceof HologramProperty.Scale) {
            Vector3f vector3f = ((HologramProperty.Scale)property).getValue();
            if (vector3f == null) {
                vector3f = new Vector3f(1.0f);
            }
            object = HologramData.copy$default(hologram, null, null, null, vector3f, null, 0, 0.0, null, null, 503, null);
        } else if (hologramProperty instanceof HologramProperty.BillboardMode) {
            class_8113.class_8114 class_81142 = ((HologramProperty.BillboardMode)property).getMode();
            if (class_81142 == null) {
                class_81142 = class_8113.class_8114.field_42409;
            }
            object = HologramData.copy$default(hologram, null, null, null, null, class_81142, 0, 0.0, null, null, 495, null);
        } else if (hologramProperty instanceof HologramProperty.ViewRange) {
            Double d = ((HologramProperty.ViewRange)property).getValue();
            object = HologramData.copy$default(hologram, null, null, null, null, null, 0, d != null ? d : 48.0, null, null, 447, null);
        } else if (hologramProperty instanceof HologramProperty.UpdateRate) {
            Integer n = ((HologramProperty.UpdateRate)property).getValue();
            object = HologramData.copy$default(hologram, null, null, null, null, null, n != null ? n : 20, 0.0, null, null, 479, null);
        } else if (hologramProperty instanceof HologramProperty.ConditionalPlaceholder) {
            object = HologramData.copy$default(hologram, null, null, null, null, null, 0, 0.0, null, ((HologramProperty.ConditionalPlaceholder)property).getValue(), 255, null);
        } else if (hologramProperty instanceof HologramProperty.Position) {
            object = HologramData.copy$default(hologram, null, ((HologramProperty.Position)property).getPosition(), ((HologramProperty.Position)property).getWorld(), null, null, 0, 0.0, null, null, 505, null);
        } else if (hologramProperty instanceof HologramProperty.Rotation) {
            Vector3f vector3f = ((HologramProperty.Rotation)property).getValue();
            if (vector3f == null) {
                vector3f = new Vector3f();
            }
            object = HologramData.copy$default(hologram, null, null, null, null, null, 0, 0.0, vector3f, null, 383, null);
        } else if (hologramProperty instanceof HologramProperty.LineOffset) {
            object = this.updateLineOffset(hologram, (HologramProperty.LineOffset)property);
        } else if (hologramProperty instanceof HologramProperty.AddLine) {
            object = HologramData.copy$default(hologram, CollectionsKt.plus((Collection)hologram.getDisplays(), (Object)new HologramData.DisplayLine(((HologramProperty.AddLine)property).getDisplayId(), ((HologramProperty.AddLine)property).getOffset())), null, null, null, null, 0, 0.0, null, null, 510, null);
        } else if (hologramProperty instanceof HologramProperty.RemoveLine) {
            void $this$filterIndexedTo$iv$iv;
            void $this$filterIndexed$iv;
            Object object2 = hologram.getDisplays();
            HologramData hologramData = hologram;
            boolean $i$f$filterIndexed = false;
            void var6_8 = $this$filterIndexed$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIndexedTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                void element$iv$iv;
                int n;
                if ((n = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl = false;
                HologramData.DisplayLine cfr_ignored_0 = (HologramData.DisplayLine)element$iv$iv;
                int index = index$iv$iv;
                boolean bl2 = false;
                if (!(index != ((HologramProperty.RemoveLine)property).getIndex())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Object it = object2 = HologramData.copy$default(hologramData, (List)destination$iv$iv, null, null, null, null, 0, 0.0, null, null, 510, null);
            boolean bl = false;
            int n = ((Collection)hologram.getDisplays()).size();
            int n2 = ((HologramProperty.RemoveLine)property).getIndex();
            if (!(0 <= n2 ? n2 < n : false)) {
                throw new HologramException("Invalid line index: " + ((HologramProperty.RemoveLine)property).getIndex());
            }
            object = object2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final HologramData updateLineOffset(HologramData hologram, HologramProperty.LineOffset property) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        int n = ((Collection)hologram.getDisplays()).size();
        int n2 = property.getIndex();
        if (!(0 <= n2 ? n2 < n : false)) {
            boolean $i$a$-require-HologramHandler$updateLineOffset$22 = false;
            String $i$a$-require-HologramHandler$updateLineOffset$22 = "Invalid line index: " + property.getIndex();
            throw new IllegalArgumentException($i$a$-require-HologramHandler$updateLineOffset$22.toString());
        }
        Iterable iterable = hologram.getDisplays();
        HologramData hologramData = hologram;
        boolean $i$f$mapIndexed = false;
        void var5_8 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void displayLine;
            void index;
            int n3;
            if ((n3 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            HologramData.DisplayLine displayLine2 = (HologramData.DisplayLine)item$iv$iv;
            int n4 = n3;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(index == property.getIndex() ? HologramData.DisplayLine.copy$default((HologramData.DisplayLine)displayLine, null, property.getOffset(), 1, null) : displayLine);
        }
        return HologramData.copy$default(hologramData, (List)destination$iv$iv, null, null, null, null, 0, 0.0, null, null, 510, null);
    }

    @Nullable
    public final Unit deleteHologram(@NotNull String name) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ErrorHandler $this$iv = ErrorHandler.INSTANCE;
        class_2168 source$iv = null;
        Unit default$iv = null;
        boolean $i$f$safeCall = false;
        try {
            boolean bl = false;
            if (!HologramConfig.INSTANCE.exists(name)) {
                throw new HologramException("Hologram " + name + " not found");
            }
            ViewerHandler.INSTANCE.removeHologramFromAllViewers(name);
            HologramConfig.INSTANCE.deleteHologram(name);
            ViewerHandler.INSTANCE.removeTracker(name);
            unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            $this$iv.handle(e$iv, source$iv);
            unit = default$iv;
        }
        return unit;
    }

    /*
     * WARNING - void declaration
     */
    private final List<class_3222> getPlayersInRange(HologramData data) {
        List list;
        List list2 = this.getWorld(data.getWorld()).method_18456();
        if (list2 != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = list2;
            boolean $i$f$filterIsInstance22 = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof class_3222)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filterIsInstance22 = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                class_3222 it = (class_3222)element$iv$iv;
                boolean bl = false;
                if (!INSTANCE.isPlayerInRange(it, data.getWorld(), data.getPosition(), data.getViewRange())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            list = (List)destination$iv$iv2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final boolean isPlayerInRange(@NotNull class_3222 player, @NotNull String world, @NotNull Vector3f position, double viewRange) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (Intrinsics.areEqual((Object)player.method_51469(), (Object)this.getWorld(world))) {
            return player.method_19538().method_1028((double)position.x, (double)position.y, (double)position.z) <= viewRange * viewRange;
        }
        return false;
    }

    private final class_1937 getWorld(String world) {
        class_1937 class_19372 = worldCache.computeIfAbsent(world, arg_0 -> HologramHandler.getWorld$lambda$1(HologramHandler::getWorld$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)class_19372, (String)"computeIfAbsent(...)");
        return class_19372;
    }

    private static final class_1937 getWorld$lambda$0(String w) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        class_2960 class_29602 = class_2960.method_12829((String)w);
        if (class_29602 == null) {
            throw new HologramException("Invalid world identifier: " + w);
        }
        class_2960 worldId = class_29602;
        MinecraftServer minecraftServer = HoloDisplays.Companion.getSERVER();
        if (minecraftServer == null || (minecraftServer = minecraftServer.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)worldId))) == null) {
            throw new HologramException("World not found: " + w);
        }
        return (class_1937)minecraftServer;
    }

    private static final class_1937 getWorld$lambda$1(Function1 $tmp0, Object p0) {
        return (class_1937)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\n\u0004\u0005\u0006\u0007\b\t\n\u000b\f\rB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\n\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u00a8\u0006\u0018"}, d2={"Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty;", "", "<init>", "()V", "Scale", "BillboardMode", "ViewRange", "UpdateRate", "Position", "Rotation", "LineOffset", "AddLine", "RemoveLine", "ConditionalPlaceholder", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$AddLine;", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$BillboardMode;", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$ConditionalPlaceholder;", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$LineOffset;", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$Position;", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$RemoveLine;", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$Rotation;", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$Scale;", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$UpdateRate;", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$ViewRange;", "holodisplays"})
    public static abstract sealed class HologramProperty {
        private HologramProperty() {
        }

        public /* synthetic */ HologramProperty(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\tR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0018\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0019\u001a\u0004\b\u001a\u0010\u000b\u00a8\u0006\u001b"}, d2={"Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$AddLine;", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty;", "", "displayId", "Lorg/joml/Vector3f;", "offset", "<init>", "(Ljava/lang/String;Lorg/joml/Vector3f;)V", "component1", "()Ljava/lang/String;", "component2", "()Lorg/joml/Vector3f;", "copy", "(Ljava/lang/String;Lorg/joml/Vector3f;)Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$AddLine;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getDisplayId", "Lorg/joml/Vector3f;", "getOffset", "holodisplays"})
        public static final class AddLine
        extends HologramProperty {
            @NotNull
            private final String displayId;
            @NotNull
            private final Vector3f offset;

            public AddLine(@NotNull String displayId, @NotNull Vector3f offset) {
                Intrinsics.checkNotNullParameter((Object)displayId, (String)"displayId");
                Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
                super(null);
                this.displayId = displayId;
                this.offset = offset;
            }

            public /* synthetic */ AddLine(String string, Vector3f vector3f, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    vector3f = new Vector3f();
                }
                this(string, vector3f);
            }

            @NotNull
            public final String getDisplayId() {
                return this.displayId;
            }

            @NotNull
            public final Vector3f getOffset() {
                return this.offset;
            }

            @NotNull
            public final String component1() {
                return this.displayId;
            }

            @NotNull
            public final Vector3f component2() {
                return this.offset;
            }

            @NotNull
            public final AddLine copy(@NotNull String displayId, @NotNull Vector3f offset) {
                Intrinsics.checkNotNullParameter((Object)displayId, (String)"displayId");
                Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
                return new AddLine(displayId, offset);
            }

            public static /* synthetic */ AddLine copy$default(AddLine addLine, String string, Vector3f vector3f, int n, Object object) {
                if ((n & 1) != 0) {
                    string = addLine.displayId;
                }
                if ((n & 2) != 0) {
                    vector3f = addLine.offset;
                }
                return addLine.copy(string, vector3f);
            }

            @NotNull
            public String toString() {
                return "AddLine(displayId=" + this.displayId + ", offset=" + this.offset + ")";
            }

            public int hashCode() {
                int result = this.displayId.hashCode();
                result = result * 31 + this.offset.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AddLine)) {
                    return false;
                }
                AddLine addLine = (AddLine)other;
                if (!Intrinsics.areEqual((Object)this.displayId, (Object)addLine.displayId)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.offset, (Object)addLine.offset);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\u0017"}, d2={"Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$BillboardMode;", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty;", "Lnet/minecraft/class_8113$class_8114;", "mode", "<init>", "(Lnet/minecraft/class_8113$class_8114;)V", "component1", "()Lnet/minecraft/class_8113$class_8114;", "copy", "(Lnet/minecraft/class_8113$class_8114;)Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$BillboardMode;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_8113$class_8114;", "getMode", "holodisplays"})
        public static final class BillboardMode
        extends HologramProperty {
            @Nullable
            private final class_8113.class_8114 mode;

            public BillboardMode(@Nullable class_8113.class_8114 mode) {
                super(null);
                this.mode = mode;
            }

            @Nullable
            public final class_8113.class_8114 getMode() {
                return this.mode;
            }

            @Nullable
            public final class_8113.class_8114 component1() {
                return this.mode;
            }

            @NotNull
            public final BillboardMode copy(@Nullable class_8113.class_8114 mode) {
                return new BillboardMode(mode);
            }

            public static /* synthetic */ BillboardMode copy$default(BillboardMode billboardMode, class_8113.class_8114 class_81142, int n, Object object) {
                if ((n & 1) != 0) {
                    class_81142 = billboardMode.mode;
                }
                return billboardMode.copy(class_81142);
            }

            @NotNull
            public String toString() {
                return "BillboardMode(mode=" + this.mode + ")";
            }

            public int hashCode() {
                return this.mode == null ? 0 : this.mode.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof BillboardMode)) {
                    return false;
                }
                BillboardMode billboardMode = (BillboardMode)other;
                return this.mode == billboardMode.mode;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0007R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u0007\u00a8\u0006\u0015"}, d2={"Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$ConditionalPlaceholder;", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty;", "", "value", "<init>", "(Ljava/lang/String;)V", "component1", "()Ljava/lang/String;", "copy", "(Ljava/lang/String;)Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$ConditionalPlaceholder;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getValue", "holodisplays"})
        public static final class ConditionalPlaceholder
        extends HologramProperty {
            @Nullable
            private final String value;

            public ConditionalPlaceholder(@Nullable String value) {
                super(null);
                this.value = value;
            }

            @Nullable
            public final String getValue() {
                return this.value;
            }

            @Nullable
            public final String component1() {
                return this.value;
            }

            @NotNull
            public final ConditionalPlaceholder copy(@Nullable String value) {
                return new ConditionalPlaceholder(value);
            }

            public static /* synthetic */ ConditionalPlaceholder copy$default(ConditionalPlaceholder conditionalPlaceholder, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = conditionalPlaceholder.value;
                }
                return conditionalPlaceholder.copy(string);
            }

            @NotNull
            public String toString() {
                return "ConditionalPlaceholder(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value == null ? 0 : this.value.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ConditionalPlaceholder)) {
                    return false;
                }
                ConditionalPlaceholder conditionalPlaceholder = (ConditionalPlaceholder)other;
                return Intrinsics.areEqual((Object)this.value, (Object)conditionalPlaceholder.value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0018\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0019\u001a\u0004\b\u001a\u0010\u000b\u00a8\u0006\u001b"}, d2={"Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$LineOffset;", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty;", "", "index", "Lorg/joml/Vector3f;", "offset", "<init>", "(ILorg/joml/Vector3f;)V", "component1", "()I", "component2", "()Lorg/joml/Vector3f;", "copy", "(ILorg/joml/Vector3f;)Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$LineOffset;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getIndex", "Lorg/joml/Vector3f;", "getOffset", "holodisplays"})
        public static final class LineOffset
        extends HologramProperty {
            private final int index;
            @NotNull
            private final Vector3f offset;

            public LineOffset(int index, @NotNull Vector3f offset) {
                Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
                super(null);
                this.index = index;
                this.offset = offset;
            }

            public final int getIndex() {
                return this.index;
            }

            @NotNull
            public final Vector3f getOffset() {
                return this.offset;
            }

            public final int component1() {
                return this.index;
            }

            @NotNull
            public final Vector3f component2() {
                return this.offset;
            }

            @NotNull
            public final LineOffset copy(int index, @NotNull Vector3f offset) {
                Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
                return new LineOffset(index, offset);
            }

            public static /* synthetic */ LineOffset copy$default(LineOffset lineOffset, int n, Vector3f vector3f, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = lineOffset.index;
                }
                if ((n2 & 2) != 0) {
                    vector3f = lineOffset.offset;
                }
                return lineOffset.copy(n, vector3f);
            }

            @NotNull
            public String toString() {
                return "LineOffset(index=" + this.index + ", offset=" + this.offset + ")";
            }

            public int hashCode() {
                int result = Integer.hashCode(this.index);
                result = result * 31 + this.offset.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LineOffset)) {
                    return false;
                }
                LineOffset lineOffset = (LineOffset)other;
                if (this.index != lineOffset.index) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.offset, (Object)lineOffset.offset);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u000bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0018\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0019\u001a\u0004\b\u001a\u0010\u000b\u00a8\u0006\u001b"}, d2={"Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$Position;", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty;", "Lorg/joml/Vector3f;", "position", "", "world", "<init>", "(Lorg/joml/Vector3f;Ljava/lang/String;)V", "component1", "()Lorg/joml/Vector3f;", "component2", "()Ljava/lang/String;", "copy", "(Lorg/joml/Vector3f;Ljava/lang/String;)Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$Position;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Lorg/joml/Vector3f;", "getPosition", "Ljava/lang/String;", "getWorld", "holodisplays"})
        public static final class Position
        extends HologramProperty {
            @NotNull
            private final Vector3f position;
            @NotNull
            private final String world;

            public Position(@NotNull Vector3f position, @NotNull String world) {
                Intrinsics.checkNotNullParameter((Object)position, (String)"position");
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                super(null);
                this.position = position;
                this.world = world;
            }

            @NotNull
            public final Vector3f getPosition() {
                return this.position;
            }

            @NotNull
            public final String getWorld() {
                return this.world;
            }

            @NotNull
            public final Vector3f component1() {
                return this.position;
            }

            @NotNull
            public final String component2() {
                return this.world;
            }

            @NotNull
            public final Position copy(@NotNull Vector3f position, @NotNull String world) {
                Intrinsics.checkNotNullParameter((Object)position, (String)"position");
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                return new Position(position, world);
            }

            public static /* synthetic */ Position copy$default(Position position, Vector3f vector3f, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    vector3f = position.position;
                }
                if ((n & 2) != 0) {
                    string = position.world;
                }
                return position.copy(vector3f, string);
            }

            @NotNull
            public String toString() {
                return "Position(position=" + this.position + ", world=" + this.world + ")";
            }

            public int hashCode() {
                int result = this.position.hashCode();
                result = result * 31 + this.world.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Position)) {
                    return false;
                }
                Position position = (Position)other;
                if (!Intrinsics.areEqual((Object)this.position, (Object)position.position)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.world, (Object)position.world);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u0007\u00a8\u0006\u0015"}, d2={"Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$RemoveLine;", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty;", "", "index", "<init>", "(I)V", "component1", "()I", "copy", "(I)Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$RemoveLine;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getIndex", "holodisplays"})
        public static final class RemoveLine
        extends HologramProperty {
            private final int index;

            public RemoveLine(int index) {
                super(null);
                this.index = index;
            }

            public final int getIndex() {
                return this.index;
            }

            public final int component1() {
                return this.index;
            }

            @NotNull
            public final RemoveLine copy(int index) {
                return new RemoveLine(index);
            }

            public static /* synthetic */ RemoveLine copy$default(RemoveLine removeLine, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = removeLine.index;
                }
                return removeLine.copy(n);
            }

            @NotNull
            public String toString() {
                return "RemoveLine(index=" + this.index + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.index);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RemoveLine)) {
                    return false;
                }
                RemoveLine removeLine = (RemoveLine)other;
                return this.index == removeLine.index;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\u0017"}, d2={"Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$Rotation;", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty;", "Lorg/joml/Vector3f;", "value", "<init>", "(Lorg/joml/Vector3f;)V", "component1", "()Lorg/joml/Vector3f;", "copy", "(Lorg/joml/Vector3f;)Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$Rotation;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lorg/joml/Vector3f;", "getValue", "holodisplays"})
        public static final class Rotation
        extends HologramProperty {
            @Nullable
            private final Vector3f value;

            public Rotation(@Nullable Vector3f value) {
                super(null);
                this.value = value;
            }

            @Nullable
            public final Vector3f getValue() {
                return this.value;
            }

            @Nullable
            public final Vector3f component1() {
                return this.value;
            }

            @NotNull
            public final Rotation copy(@Nullable Vector3f value) {
                return new Rotation(value);
            }

            public static /* synthetic */ Rotation copy$default(Rotation rotation, Vector3f vector3f, int n, Object object) {
                if ((n & 1) != 0) {
                    vector3f = rotation.value;
                }
                return rotation.copy(vector3f);
            }

            @NotNull
            public String toString() {
                return "Rotation(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value == null ? 0 : this.value.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Rotation)) {
                    return false;
                }
                Rotation rotation = (Rotation)other;
                return Intrinsics.areEqual((Object)this.value, (Object)rotation.value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\u0017"}, d2={"Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$Scale;", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty;", "Lorg/joml/Vector3f;", "value", "<init>", "(Lorg/joml/Vector3f;)V", "component1", "()Lorg/joml/Vector3f;", "copy", "(Lorg/joml/Vector3f;)Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$Scale;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lorg/joml/Vector3f;", "getValue", "holodisplays"})
        public static final class Scale
        extends HologramProperty {
            @Nullable
            private final Vector3f value;

            public Scale(@Nullable Vector3f value) {
                super(null);
                this.value = value;
            }

            @Nullable
            public final Vector3f getValue() {
                return this.value;
            }

            @Nullable
            public final Vector3f component1() {
                return this.value;
            }

            @NotNull
            public final Scale copy(@Nullable Vector3f value) {
                return new Scale(value);
            }

            public static /* synthetic */ Scale copy$default(Scale scale, Vector3f vector3f, int n, Object object) {
                if ((n & 1) != 0) {
                    vector3f = scale.value;
                }
                return scale.copy(vector3f);
            }

            @NotNull
            public String toString() {
                return "Scale(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value == null ? 0 : this.value.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Scale)) {
                    return false;
                }
                Scale scale = (Scale)other;
                return Intrinsics.areEqual((Object)this.value, (Object)scale.value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0007\u00a8\u0006\u0016"}, d2={"Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$UpdateRate;", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty;", "", "value", "<init>", "(Ljava/lang/Integer;)V", "component1", "()Ljava/lang/Integer;", "copy", "(Ljava/lang/Integer;)Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$UpdateRate;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/lang/Integer;", "getValue", "holodisplays"})
        public static final class UpdateRate
        extends HologramProperty {
            @Nullable
            private final Integer value;

            public UpdateRate(@Nullable Integer value) {
                super(null);
                this.value = value;
            }

            @Nullable
            public final Integer getValue() {
                return this.value;
            }

            @Nullable
            public final Integer component1() {
                return this.value;
            }

            @NotNull
            public final UpdateRate copy(@Nullable Integer value) {
                return new UpdateRate(value);
            }

            public static /* synthetic */ UpdateRate copy$default(UpdateRate updateRate, Integer n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = updateRate.value;
                }
                return updateRate.copy(n);
            }

            @NotNull
            public String toString() {
                return "UpdateRate(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value == null ? 0 : ((Object)this.value).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UpdateRate)) {
                    return false;
                }
                UpdateRate updateRate = (UpdateRate)other;
                return Intrinsics.areEqual((Object)this.value, (Object)updateRate.value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\u0017"}, d2={"Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$ViewRange;", "Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty;", "", "value", "<init>", "(Ljava/lang/Double;)V", "component1", "()Ljava/lang/Double;", "copy", "(Ljava/lang/Double;)Ldev/furq/holodisplays/handlers/HologramHandler$HologramProperty$ViewRange;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/lang/Double;", "getValue", "holodisplays"})
        public static final class ViewRange
        extends HologramProperty {
            @Nullable
            private final Double value;

            public ViewRange(@Nullable Double value) {
                super(null);
                this.value = value;
            }

            @Nullable
            public final Double getValue() {
                return this.value;
            }

            @Nullable
            public final Double component1() {
                return this.value;
            }

            @NotNull
            public final ViewRange copy(@Nullable Double value) {
                return new ViewRange(value);
            }

            public static /* synthetic */ ViewRange copy$default(ViewRange viewRange, Double d, int n, Object object) {
                if ((n & 1) != 0) {
                    d = viewRange.value;
                }
                return viewRange.copy(d);
            }

            @NotNull
            public String toString() {
                return "ViewRange(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value == null ? 0 : ((Object)this.value).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ViewRange)) {
                    return false;
                }
                ViewRange viewRange = (ViewRange)other;
                return Intrinsics.areEqual((Object)this.value, (Object)viewRange.value);
            }
        }
    }
}

