/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.holodisplays.utils;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.api.parsers.TagParser;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ:\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\rH\u0082\b\u00a2\u0006\u0004\b\u0010\u0010\u0011J)\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00122\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR#\u0010!\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Ldev/furq/holodisplays/utils/ConditionEvaluator;", "", "<init>", "()V", "", "condition", "Lnet/minecraft/class_3222;", "player", "", "evaluate", "(Ljava/lang/String;Lnet/minecraft/class_3222;)Z", "left", "right", "Lkotlin/Function2;", "", "comparator", "compareNumbers", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function2;)Z", "Lkotlin/Triple;", "parseCondition", "(Ljava/lang/String;)Lkotlin/Triple;", "placeholder", "resolvePlaceholder", "(Ljava/lang/String;Lnet/minecraft/class_3222;)Ljava/lang/String;", "Lkotlin/text/Regex;", "operatorRegex", "Lkotlin/text/Regex;", "Leu/pb4/placeholders/api/parsers/NodeParser;", "kotlin.jvm.PlatformType", "placeholderParser$delegate", "Lkotlin/Lazy;", "getPlaceholderParser", "()Leu/pb4/placeholders/api/parsers/NodeParser;", "placeholderParser", "holodisplays"})
@SourceDebugExtension(value={"SMAP\nConditionEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConditionEvaluator.kt\ndev/furq/holodisplays/utils/ConditionEvaluator\n*L\n1#1,51:1\n37#1,3:52\n37#1,3:55\n37#1,3:58\n37#1,3:61\n*S KotlinDebug\n*F\n+ 1 ConditionEvaluator.kt\ndev/furq/holodisplays/utils/ConditionEvaluator\n*L\n24#1:52,3\n25#1:55,3\n26#1:58,3\n27#1:61,3\n*E\n"})
public final class ConditionEvaluator {
    @NotNull
    public static final ConditionEvaluator INSTANCE = new ConditionEvaluator();
    @NotNull
    private static final Regex operatorRegex = new Regex("\\s(=|!=|>|<|>=|<=|contains|!contains|startsWith|endsWith)\\s");
    @NotNull
    private static final Lazy placeholderParser$delegate = LazyKt.lazy(ConditionEvaluator::placeholderParser_delegate$lambda$0);

    private ConditionEvaluator() {
    }

    private final NodeParser getPlaceholderParser() {
        Lazy lazy = placeholderParser$delegate;
        return (NodeParser)lazy.getValue();
    }

    public final boolean evaluate(@Nullable String condition, @NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (condition == null) {
            return true;
        }
        Triple<String, String, String> triple = this.parseCondition(condition);
        if (triple == null) {
            return true;
        }
        Triple<String, String, String> triple2 = triple;
        String placeholder = (String)triple2.component1();
        String operator = (String)triple2.component2();
        String value = (String)triple2.component3();
        String resolvedValue = this.resolvePlaceholder(((Object)StringsKt.trim((CharSequence)placeholder)).toString(), player);
        return switch (((Object)StringsKt.trim((CharSequence)operator)).toString()) {
            case "=" -> Intrinsics.areEqual((Object)resolvedValue, (Object)value);
            case "!=" -> {
                if (!Intrinsics.areEqual((Object)resolvedValue, (Object)value)) {
                    yield true;
                }
                yield false;
            }
            case ">" -> {
                void b;
                double rightNum$iv;
                void left$iv;
                ConditionEvaluator var9_9 = this;
                String var10_13 = resolvedValue;
                String right$iv = value;
                boolean $i$f$compareNumbers = false;
                Double v2 = StringsKt.toDoubleOrNull((String)left$iv);
                if (v2 == null) {
                    yield false;
                }
                double leftNum$iv = v2;
                Double v3 = StringsKt.toDoubleOrNull((String)right$iv);
                if (v3 == null) {
                    yield false;
                }
                double var17_33 = rightNum$iv = v3.doubleValue();
                double a = leftNum$iv;
                boolean $i$a$-compareNumbers-ConditionEvaluator$evaluate$1 = false;
                if (a > b) {
                    yield true;
                }
                yield false;
            }
            case "<" -> {
                double rightNum$iv;
                ConditionEvaluator this_$iv = this;
                String left$iv = resolvedValue;
                String right$iv = value;
                boolean $i$f$compareNumbers = false;
                Double v4 = StringsKt.toDoubleOrNull((String)left$iv);
                if (v4 == null) {
                    yield false;
                }
                double leftNum$iv = v4;
                Double v5 = StringsKt.toDoubleOrNull((String)right$iv);
                if (v5 == null) {
                    yield false;
                }
                double b = rightNum$iv = v5.doubleValue();
                double a = leftNum$iv;
                boolean $i$a$-compareNumbers-ConditionEvaluator$evaluate$2 = false;
                if (a < b) {
                    yield true;
                }
                yield false;
            }
            case ">=" -> {
                double rightNum$iv;
                ConditionEvaluator this_$iv = this;
                String left$iv = resolvedValue;
                String right$iv = value;
                boolean $i$f$compareNumbers = false;
                Double v6 = StringsKt.toDoubleOrNull((String)left$iv);
                if (v6 == null) {
                    yield false;
                }
                double leftNum$iv = v6;
                Double v7 = StringsKt.toDoubleOrNull((String)right$iv);
                if (v7 == null) {
                    yield false;
                }
                double b = rightNum$iv = v7.doubleValue();
                double a = leftNum$iv;
                boolean $i$a$-compareNumbers-ConditionEvaluator$evaluate$3 = false;
                if (a >= b) {
                    yield true;
                }
                yield false;
            }
            case "<=" -> {
                double rightNum$iv;
                ConditionEvaluator this_$iv = this;
                String left$iv = resolvedValue;
                String right$iv = value;
                boolean $i$f$compareNumbers = false;
                Double v8 = StringsKt.toDoubleOrNull((String)left$iv);
                if (v8 == null) {
                    yield false;
                }
                double leftNum$iv = v8;
                Double v9 = StringsKt.toDoubleOrNull((String)right$iv);
                if (v9 == null) {
                    yield false;
                }
                double b = rightNum$iv = v9.doubleValue();
                double a = leftNum$iv;
                boolean $i$a$-compareNumbers-ConditionEvaluator$evaluate$4 = false;
                if (a <= b) {
                    yield true;
                }
                yield false;
            }
            case "contains" -> StringsKt.contains$default((CharSequence)resolvedValue, (CharSequence)value, (boolean)false, (int)2, null);
            case "!contains" -> {
                if (!StringsKt.contains$default((CharSequence)resolvedValue, (CharSequence)value, (boolean)false, (int)2, null)) {
                    yield true;
                }
                yield false;
            }
            case "startsWith" -> StringsKt.startsWith$default((String)resolvedValue, (String)value, (boolean)false, (int)2, null);
            case "endsWith" -> StringsKt.endsWith$default((String)resolvedValue, (String)value, (boolean)false, (int)2, null);
            default -> true;
        };
    }

    private final boolean compareNumbers(String left, String right, Function2<? super Double, ? super Double, Boolean> comparator) {
        boolean $i$f$compareNumbers = false;
        Double d = StringsKt.toDoubleOrNull((String)left);
        if (d == null) {
            return false;
        }
        double leftNum = d;
        Double d2 = StringsKt.toDoubleOrNull((String)right);
        if (d2 == null) {
            return false;
        }
        double rightNum = d2;
        return (Boolean)comparator.invoke((Object)leftNum, (Object)rightNum);
    }

    @Nullable
    public final Triple<String, String, String> parseCondition(@NotNull String condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        MatchResult matchResult = Regex.find$default((Regex)operatorRegex, (CharSequence)condition, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        String operator = (String)match.getGroupValues().get(1);
        String[] stringArray = new String[]{" " + operator + " "};
        List parts = StringsKt.split$default((CharSequence)condition, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return parts.size() == 2 ? new Triple(parts.get(0), (Object)operator, parts.get(1)) : null;
    }

    private final String resolvePlaceholder(String placeholder, class_3222 player) {
        String string = this.getPlaceholderParser().parseNode(placeholder).toText(PlaceholderContext.of((class_3222)player)).getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    private static final NodeParser placeholderParser_delegate$lambda$0() {
        NodeParser[] nodeParserArray = new NodeParser[]{TagParser.DEFAULT, Placeholders.DEFAULT_PLACEHOLDER_PARSER};
        return NodeParser.merge((NodeParser[])nodeParserArray);
    }
}

