/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.holodisplays.handlers;

import dev.furq.holodisplays.config.DisplayConfig;
import dev.furq.holodisplays.config.HologramConfig;
import dev.furq.holodisplays.data.DisplayData;
import dev.furq.holodisplays.data.HologramData;
import dev.furq.holodisplays.data.display.BaseDisplay;
import dev.furq.holodisplays.data.display.BlockDisplay;
import dev.furq.holodisplays.data.display.EntityDisplay;
import dev.furq.holodisplays.data.display.ItemDisplay;
import dev.furq.holodisplays.data.display.TextDisplay;
import dev.furq.holodisplays.handlers.DisplayException;
import dev.furq.holodisplays.handlers.ErrorHandler;
import dev.furq.holodisplays.handlers.ViewerHandler;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2168;
import net.minecraft.class_4050;
import net.minecraft.class_8113;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J!\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J!\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\f\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J!\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\f\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Ldev/furq/holodisplays/handlers/DisplayHandler;", "", "<init>", "()V", "", "displayId", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;", "property", "", "updateDisplayProperty", "(Ljava/lang/String;Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;)Lkotlin/Unit;", "Ldev/furq/holodisplays/data/DisplayData;", "display", "updateDisplayData", "(Ldev/furq/holodisplays/data/DisplayData;Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;)Ldev/furq/holodisplays/data/DisplayData;", "Ldev/furq/holodisplays/data/display/TextDisplay;", "updateTextDisplay", "(Ldev/furq/holodisplays/data/display/TextDisplay;Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;)Ldev/furq/holodisplays/data/display/TextDisplay;", "Ldev/furq/holodisplays/data/display/ItemDisplay;", "updateItemDisplay", "(Ldev/furq/holodisplays/data/display/ItemDisplay;Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;)Ldev/furq/holodisplays/data/display/ItemDisplay;", "Ldev/furq/holodisplays/data/display/BlockDisplay;", "updateBlockDisplay", "(Ldev/furq/holodisplays/data/display/BlockDisplay;Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;)Ldev/furq/holodisplays/data/display/BlockDisplay;", "Ldev/furq/holodisplays/data/display/EntityDisplay;", "updateEntityDisplay", "(Ldev/furq/holodisplays/data/display/EntityDisplay;Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;)Ldev/furq/holodisplays/data/display/EntityDisplay;", "DisplayProperty", "holodisplays"})
@SourceDebugExtension(value={"SMAP\nDisplayHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisplayHandler.kt\ndev/furq/holodisplays/handlers/DisplayHandler\n+ 2 ErrorHandler.kt\ndev/furq/holodisplays/handlers/ErrorHandler\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,125:1\n31#2,7:126\n38#2,3:145\n536#3:133\n521#3,2:134\n523#3,4:139\n1761#4,3:136\n216#5,2:143\n*S KotlinDebug\n*F\n+ 1 DisplayHandler.kt\ndev/furq/holodisplays/handlers/DisplayHandler\n*L\n37#1:126,7\n37#1:145,3\n47#1:133\n47#1:134,2\n47#1:139,4\n48#1:136,3\n60#1:143,2\n*E\n"})
public final class DisplayHandler {
    @NotNull
    public static final DisplayHandler INSTANCE = new DisplayHandler();

    private DisplayHandler() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Unit updateDisplayProperty(@NotNull String displayId, @NotNull DisplayProperty property) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)displayId, (String)"displayId");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        ErrorHandler $this$iv = ErrorHandler.INSTANCE;
        class_2168 source$iv = null;
        Unit default$iv = null;
        boolean $i$f$safeCall = false;
        try {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            boolean bl = false;
            DisplayData displayData = DisplayConfig.INSTANCE.getDisplay(displayId);
            if (displayData == null) {
                throw new DisplayException("Display " + displayId + " not found");
            }
            DisplayData display = displayData;
            DisplayData displayData2 = INSTANCE.updateDisplayData(display, property);
            if (displayData2 == null) {
                throw new DisplayException("Failed to update display data");
            }
            DisplayData updatedDisplay = displayData2;
            DisplayConfig.INSTANCE.saveDisplay(displayId, updatedDisplay);
            Map<String, HologramData> map = HologramConfig.INSTANCE.getHolograms();
            boolean $i$f$filter22 = false;
            void var12_14 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Object object = $this$filterTo$iv$iv.entrySet().iterator();
            while (object.hasNext()) {
                boolean bl2;
                Map.Entry element$iv$iv;
                block10: {
                    Map.Entry entry = element$iv$iv = object.next();
                    boolean bl3 = false;
                    HologramData hologram = (HologramData)entry.getValue();
                    Iterable $this$any$iv = hologram.getDisplays();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            HologramData.DisplayLine it = (HologramData.DisplayLine)element$iv;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)displayId)) continue;
                            bl2 = true;
                            break block10;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map affectedHolograms = destination$iv$iv;
            DisplayProperty $i$f$filter22 = property;
            boolean needsRespawn = $i$f$filter22 instanceof DisplayProperty.ConditionalPlaceholder || $i$f$filter22 instanceof DisplayProperty.Rotation || $i$f$filter22 instanceof DisplayProperty.EntityId ? true : ($i$f$filter22 instanceof DisplayProperty.Scale ? display.getType() instanceof EntityDisplay : false);
            Map $this$forEach$iv = affectedHolograms;
            boolean $i$f$forEach = false;
            for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
                object = element$iv;
                boolean bl5 = false;
                String name = (String)object.getKey();
                if (needsRespawn) {
                    ViewerHandler.INSTANCE.respawnForAllObservers(name);
                    continue;
                }
                ViewerHandler.INSTANCE.updateForAllObservers(name);
            }
            unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            $this$iv.handle(e$iv, source$iv);
            unit = default$iv;
        }
        return unit;
    }

    private final DisplayData updateDisplayData(DisplayData display, DisplayProperty property) {
        BaseDisplay baseDisplay;
        BaseDisplay currentDisplay = display.getType();
        if (currentDisplay instanceof TextDisplay) {
            baseDisplay = this.updateTextDisplay((TextDisplay)currentDisplay, property);
        } else if (currentDisplay instanceof ItemDisplay) {
            baseDisplay = this.updateItemDisplay((ItemDisplay)currentDisplay, property);
        } else if (currentDisplay instanceof BlockDisplay) {
            baseDisplay = this.updateBlockDisplay((BlockDisplay)currentDisplay, property);
        } else if (currentDisplay instanceof EntityDisplay) {
            baseDisplay = this.updateEntityDisplay((EntityDisplay)currentDisplay, property);
        } else {
            return null;
        }
        if (baseDisplay == null) {
            return null;
        }
        BaseDisplay updatedDisplay = baseDisplay;
        return new DisplayData(updatedDisplay);
    }

    private final TextDisplay updateTextDisplay(TextDisplay display, DisplayProperty property) {
        DisplayProperty displayProperty = property;
        return displayProperty instanceof DisplayProperty.Scale ? TextDisplay.copy$default(display, null, null, null, null, null, null, null, null, ((DisplayProperty.Scale)property).getValue(), null, null, 1791, null) : (displayProperty instanceof DisplayProperty.BillboardMode ? TextDisplay.copy$default(display, null, null, null, null, null, null, null, null, null, ((DisplayProperty.BillboardMode)property).getMode(), null, 1535, null) : (displayProperty instanceof DisplayProperty.Rotation ? TextDisplay.copy$default(display, null, null, null, null, null, null, null, ((DisplayProperty.Rotation)property).getValue(), null, null, null, 1919, null) : (displayProperty instanceof DisplayProperty.TextLines ? TextDisplay.copy$default(display, ((DisplayProperty.TextLines)property).getValue(), null, null, null, null, null, null, null, null, null, null, 2046, null) : (displayProperty instanceof DisplayProperty.TextLineWidth ? TextDisplay.copy$default(display, null, ((DisplayProperty.TextLineWidth)property).getValue(), null, null, null, null, null, null, null, null, null, 2045, null) : (displayProperty instanceof DisplayProperty.TextBackgroundColor ? TextDisplay.copy$default(display, null, null, ((DisplayProperty.TextBackgroundColor)property).getValue(), null, null, null, null, null, null, null, null, 2043, null) : (displayProperty instanceof DisplayProperty.TextOpacity ? TextDisplay.copy$default(display, null, null, null, ((DisplayProperty.TextOpacity)property).getValue(), null, null, null, null, null, null, null, 2039, null) : (displayProperty instanceof DisplayProperty.TextShadow ? TextDisplay.copy$default(display, null, null, null, null, ((DisplayProperty.TextShadow)property).getValue(), null, null, null, null, null, null, 2031, null) : (displayProperty instanceof DisplayProperty.TextSeeThrough ? TextDisplay.copy$default(display, null, null, null, null, null, ((DisplayProperty.TextSeeThrough)property).getValue(), null, null, null, null, null, 2015, null) : (displayProperty instanceof DisplayProperty.TextAlignment ? TextDisplay.copy$default(display, null, null, null, null, null, null, ((DisplayProperty.TextAlignment)property).getValue(), null, null, null, null, 1983, null) : (displayProperty instanceof DisplayProperty.ConditionalPlaceholder ? TextDisplay.copy$default(display, null, null, null, null, null, null, null, null, null, null, ((DisplayProperty.ConditionalPlaceholder)property).getValue(), 1023, null) : null))))))))));
    }

    private final ItemDisplay updateItemDisplay(ItemDisplay display, DisplayProperty property) {
        DisplayProperty displayProperty = property;
        return displayProperty instanceof DisplayProperty.Scale ? ItemDisplay.copy$default(display, null, null, null, null, ((DisplayProperty.Scale)property).getValue(), null, null, 111, null) : (displayProperty instanceof DisplayProperty.BillboardMode ? ItemDisplay.copy$default(display, null, null, null, null, null, ((DisplayProperty.BillboardMode)property).getMode(), null, 95, null) : (displayProperty instanceof DisplayProperty.Rotation ? ItemDisplay.copy$default(display, null, null, null, ((DisplayProperty.Rotation)property).getValue(), null, null, null, 119, null) : (displayProperty instanceof DisplayProperty.ItemId ? ItemDisplay.copy$default(display, ((DisplayProperty.ItemId)property).getValue(), null, null, null, null, null, null, 126, null) : (displayProperty instanceof DisplayProperty.ItemDisplayType ? ItemDisplay.copy$default(display, null, ((DisplayProperty.ItemDisplayType)property).getValue(), null, null, null, null, null, 125, null) : (displayProperty instanceof DisplayProperty.ItemCustomModelData ? ItemDisplay.copy$default(display, null, null, ((DisplayProperty.ItemCustomModelData)property).getValue(), null, null, null, null, 123, null) : (displayProperty instanceof DisplayProperty.ConditionalPlaceholder ? ItemDisplay.copy$default(display, null, null, null, null, null, null, ((DisplayProperty.ConditionalPlaceholder)property).getValue(), 63, null) : null))))));
    }

    private final BlockDisplay updateBlockDisplay(BlockDisplay display, DisplayProperty property) {
        DisplayProperty displayProperty = property;
        return displayProperty instanceof DisplayProperty.Scale ? BlockDisplay.copy$default(display, null, null, ((DisplayProperty.Scale)property).getValue(), null, null, 27, null) : (displayProperty instanceof DisplayProperty.BillboardMode ? BlockDisplay.copy$default(display, null, null, null, ((DisplayProperty.BillboardMode)property).getMode(), null, 23, null) : (displayProperty instanceof DisplayProperty.Rotation ? BlockDisplay.copy$default(display, null, ((DisplayProperty.Rotation)property).getValue(), null, null, null, 29, null) : (displayProperty instanceof DisplayProperty.BlockId ? BlockDisplay.copy$default(display, ((DisplayProperty.BlockId)property).getValue(), null, null, null, null, 30, null) : (displayProperty instanceof DisplayProperty.ConditionalPlaceholder ? BlockDisplay.copy$default(display, null, null, null, null, ((DisplayProperty.ConditionalPlaceholder)property).getValue(), 15, null) : null))));
    }

    private final EntityDisplay updateEntityDisplay(EntityDisplay display, DisplayProperty property) {
        DisplayProperty displayProperty = property;
        return displayProperty instanceof DisplayProperty.Scale ? EntityDisplay.copy$default(display, null, null, ((DisplayProperty.Scale)property).getValue(), null, null, null, 59, null) : (displayProperty instanceof DisplayProperty.Rotation ? EntityDisplay.copy$default(display, null, ((DisplayProperty.Rotation)property).getValue(), null, null, null, null, 61, null) : (displayProperty instanceof DisplayProperty.EntityId ? EntityDisplay.copy$default(display, ((DisplayProperty.EntityId)property).getValue(), null, null, null, null, null, 62, null) : (displayProperty instanceof DisplayProperty.EntityGlow ? EntityDisplay.copy$default(display, null, null, null, ((DisplayProperty.EntityGlow)property).getValue(), null, null, 55, null) : (displayProperty instanceof DisplayProperty.EntityPose ? EntityDisplay.copy$default(display, null, null, null, null, ((DisplayProperty.EntityPose)property).getValue(), null, 47, null) : (displayProperty instanceof DisplayProperty.ConditionalPlaceholder ? EntityDisplay.copy$default(display, null, null, null, null, null, ((DisplayProperty.ConditionalPlaceholder)property).getValue(), 31, null) : null)))));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0012\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0012\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'\u00a8\u0006("}, d2={"Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;", "", "<init>", "()V", "Scale", "BillboardMode", "Rotation", "TextLines", "TextLineWidth", "TextBackgroundColor", "TextOpacity", "TextShadow", "TextSeeThrough", "TextAlignment", "ItemId", "ItemDisplayType", "ItemCustomModelData", "BlockId", "EntityId", "EntityGlow", "EntityPose", "ConditionalPlaceholder", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$BillboardMode;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$BlockId;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$ConditionalPlaceholder;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$EntityGlow;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$EntityId;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$EntityPose;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$ItemCustomModelData;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$ItemDisplayType;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$ItemId;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$Rotation;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$Scale;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$TextAlignment;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$TextBackgroundColor;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$TextLineWidth;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$TextLines;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$TextOpacity;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$TextSeeThrough;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$TextShadow;", "holodisplays"})
    public static abstract sealed class DisplayProperty {
        private DisplayProperty() {
        }

        public /* synthetic */ DisplayProperty(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\u0017"}, d2={"Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$BillboardMode;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;", "Lnet/minecraft/class_8113$class_8114;", "mode", "<init>", "(Lnet/minecraft/class_8113$class_8114;)V", "component1", "()Lnet/minecraft/class_8113$class_8114;", "copy", "(Lnet/minecraft/class_8113$class_8114;)Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$BillboardMode;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_8113$class_8114;", "getMode", "holodisplays"})
        public static final class BillboardMode
        extends DisplayProperty {
            @Nullable
            private final class_8113.class_8114 mode;

            public BillboardMode(@Nullable class_8113.class_8114 mode) {
                super(null);
                this.mode = mode;
            }

            @Nullable
            public final class_8113.class_8114 getMode() {
                return this.mode;
            }

            @Nullable
            public final class_8113.class_8114 component1() {
                return this.mode;
            }

            @NotNull
            public final BillboardMode copy(@Nullable class_8113.class_8114 mode) {
                return new BillboardMode(mode);
            }

            public static /* synthetic */ BillboardMode copy$default(BillboardMode billboardMode, class_8113.class_8114 class_81142, int n, Object object) {
                if ((n & 1) != 0) {
                    class_81142 = billboardMode.mode;
                }
                return billboardMode.copy(class_81142);
            }

            @NotNull
            public String toString() {
                return "BillboardMode(mode=" + this.mode + ")";
            }

            public int hashCode() {
                return this.mode == null ? 0 : this.mode.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof BillboardMode)) {
                    return false;
                }
                BillboardMode billboardMode = (BillboardMode)other;
                return this.mode == billboardMode.mode;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u0007\u00a8\u0006\u0015"}, d2={"Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$BlockId;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;", "", "value", "<init>", "(Ljava/lang/String;)V", "component1", "()Ljava/lang/String;", "copy", "(Ljava/lang/String;)Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$BlockId;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getValue", "holodisplays"})
        public static final class BlockId
        extends DisplayProperty {
            @NotNull
            private final String value;

            public BlockId(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super(null);
                this.value = value;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }

            @NotNull
            public final String component1() {
                return this.value;
            }

            @NotNull
            public final BlockId copy(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new BlockId(value);
            }

            public static /* synthetic */ BlockId copy$default(BlockId blockId, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = blockId.value;
                }
                return blockId.copy(string);
            }

            @NotNull
            public String toString() {
                return "BlockId(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof BlockId)) {
                    return false;
                }
                BlockId blockId = (BlockId)other;
                return Intrinsics.areEqual((Object)this.value, (Object)blockId.value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0007R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u0007\u00a8\u0006\u0015"}, d2={"Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$ConditionalPlaceholder;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;", "", "value", "<init>", "(Ljava/lang/String;)V", "component1", "()Ljava/lang/String;", "copy", "(Ljava/lang/String;)Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$ConditionalPlaceholder;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getValue", "holodisplays"})
        public static final class ConditionalPlaceholder
        extends DisplayProperty {
            @Nullable
            private final String value;

            public ConditionalPlaceholder(@Nullable String value) {
                super(null);
                this.value = value;
            }

            @Nullable
            public final String getValue() {
                return this.value;
            }

            @Nullable
            public final String component1() {
                return this.value;
            }

            @NotNull
            public final ConditionalPlaceholder copy(@Nullable String value) {
                return new ConditionalPlaceholder(value);
            }

            public static /* synthetic */ ConditionalPlaceholder copy$default(ConditionalPlaceholder conditionalPlaceholder, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = conditionalPlaceholder.value;
                }
                return conditionalPlaceholder.copy(string);
            }

            @NotNull
            public String toString() {
                return "ConditionalPlaceholder(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value == null ? 0 : this.value.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ConditionalPlaceholder)) {
                    return false;
                }
                ConditionalPlaceholder conditionalPlaceholder = (ConditionalPlaceholder)other;
                return Intrinsics.areEqual((Object)this.value, (Object)conditionalPlaceholder.value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u000eH\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0007\u00a8\u0006\u0016"}, d2={"Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$EntityGlow;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;", "", "value", "<init>", "(Ljava/lang/Boolean;)V", "component1", "()Ljava/lang/Boolean;", "copy", "(Ljava/lang/Boolean;)Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$EntityGlow;", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/lang/Boolean;", "getValue", "holodisplays"})
        public static final class EntityGlow
        extends DisplayProperty {
            @Nullable
            private final Boolean value;

            public EntityGlow(@Nullable Boolean value) {
                super(null);
                this.value = value;
            }

            @Nullable
            public final Boolean getValue() {
                return this.value;
            }

            @Nullable
            public final Boolean component1() {
                return this.value;
            }

            @NotNull
            public final EntityGlow copy(@Nullable Boolean value) {
                return new EntityGlow(value);
            }

            public static /* synthetic */ EntityGlow copy$default(EntityGlow entityGlow, Boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = entityGlow.value;
                }
                return entityGlow.copy(bl);
            }

            @NotNull
            public String toString() {
                return "EntityGlow(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value == null ? 0 : ((Object)this.value).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof EntityGlow)) {
                    return false;
                }
                EntityGlow entityGlow = (EntityGlow)other;
                return Intrinsics.areEqual((Object)this.value, (Object)entityGlow.value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u0007\u00a8\u0006\u0015"}, d2={"Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$EntityId;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;", "", "value", "<init>", "(Ljava/lang/String;)V", "component1", "()Ljava/lang/String;", "copy", "(Ljava/lang/String;)Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$EntityId;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getValue", "holodisplays"})
        public static final class EntityId
        extends DisplayProperty {
            @NotNull
            private final String value;

            public EntityId(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super(null);
                this.value = value;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }

            @NotNull
            public final String component1() {
                return this.value;
            }

            @NotNull
            public final EntityId copy(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new EntityId(value);
            }

            public static /* synthetic */ EntityId copy$default(EntityId entityId, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = entityId.value;
                }
                return entityId.copy(string);
            }

            @NotNull
            public String toString() {
                return "EntityId(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof EntityId)) {
                    return false;
                }
                EntityId entityId = (EntityId)other;
                return Intrinsics.areEqual((Object)this.value, (Object)entityId.value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\u0017"}, d2={"Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$EntityPose;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;", "Lnet/minecraft/class_4050;", "value", "<init>", "(Lnet/minecraft/class_4050;)V", "component1", "()Lnet/minecraft/class_4050;", "copy", "(Lnet/minecraft/class_4050;)Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$EntityPose;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_4050;", "getValue", "holodisplays"})
        public static final class EntityPose
        extends DisplayProperty {
            @Nullable
            private final class_4050 value;

            public EntityPose(@Nullable class_4050 value) {
                super(null);
                this.value = value;
            }

            @Nullable
            public final class_4050 getValue() {
                return this.value;
            }

            @Nullable
            public final class_4050 component1() {
                return this.value;
            }

            @NotNull
            public final EntityPose copy(@Nullable class_4050 value) {
                return new EntityPose(value);
            }

            public static /* synthetic */ EntityPose copy$default(EntityPose entityPose, class_4050 class_40502, int n, Object object) {
                if ((n & 1) != 0) {
                    class_40502 = entityPose.value;
                }
                return entityPose.copy(class_40502);
            }

            @NotNull
            public String toString() {
                return "EntityPose(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value == null ? 0 : this.value.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof EntityPose)) {
                    return false;
                }
                EntityPose entityPose = (EntityPose)other;
                return this.value == entityPose.value;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0007\u00a8\u0006\u0016"}, d2={"Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$ItemCustomModelData;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;", "", "value", "<init>", "(Ljava/lang/Integer;)V", "component1", "()Ljava/lang/Integer;", "copy", "(Ljava/lang/Integer;)Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$ItemCustomModelData;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/lang/Integer;", "getValue", "holodisplays"})
        public static final class ItemCustomModelData
        extends DisplayProperty {
            @Nullable
            private final Integer value;

            public ItemCustomModelData(@Nullable Integer value) {
                super(null);
                this.value = value;
            }

            @Nullable
            public final Integer getValue() {
                return this.value;
            }

            @Nullable
            public final Integer component1() {
                return this.value;
            }

            @NotNull
            public final ItemCustomModelData copy(@Nullable Integer value) {
                return new ItemCustomModelData(value);
            }

            public static /* synthetic */ ItemCustomModelData copy$default(ItemCustomModelData itemCustomModelData, Integer n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = itemCustomModelData.value;
                }
                return itemCustomModelData.copy(n);
            }

            @NotNull
            public String toString() {
                return "ItemCustomModelData(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value == null ? 0 : ((Object)this.value).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ItemCustomModelData)) {
                    return false;
                }
                ItemCustomModelData itemCustomModelData = (ItemCustomModelData)other;
                return Intrinsics.areEqual((Object)this.value, (Object)itemCustomModelData.value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u0007\u00a8\u0006\u0015"}, d2={"Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$ItemDisplayType;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;", "", "value", "<init>", "(Ljava/lang/String;)V", "component1", "()Ljava/lang/String;", "copy", "(Ljava/lang/String;)Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$ItemDisplayType;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getValue", "holodisplays"})
        public static final class ItemDisplayType
        extends DisplayProperty {
            @NotNull
            private final String value;

            public ItemDisplayType(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super(null);
                this.value = value;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }

            @NotNull
            public final String component1() {
                return this.value;
            }

            @NotNull
            public final ItemDisplayType copy(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new ItemDisplayType(value);
            }

            public static /* synthetic */ ItemDisplayType copy$default(ItemDisplayType itemDisplayType, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = itemDisplayType.value;
                }
                return itemDisplayType.copy(string);
            }

            @NotNull
            public String toString() {
                return "ItemDisplayType(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ItemDisplayType)) {
                    return false;
                }
                ItemDisplayType itemDisplayType = (ItemDisplayType)other;
                return Intrinsics.areEqual((Object)this.value, (Object)itemDisplayType.value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u0007\u00a8\u0006\u0015"}, d2={"Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$ItemId;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;", "", "value", "<init>", "(Ljava/lang/String;)V", "component1", "()Ljava/lang/String;", "copy", "(Ljava/lang/String;)Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$ItemId;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getValue", "holodisplays"})
        public static final class ItemId
        extends DisplayProperty {
            @NotNull
            private final String value;

            public ItemId(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super(null);
                this.value = value;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }

            @NotNull
            public final String component1() {
                return this.value;
            }

            @NotNull
            public final ItemId copy(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new ItemId(value);
            }

            public static /* synthetic */ ItemId copy$default(ItemId itemId, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = itemId.value;
                }
                return itemId.copy(string);
            }

            @NotNull
            public String toString() {
                return "ItemId(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ItemId)) {
                    return false;
                }
                ItemId itemId = (ItemId)other;
                return Intrinsics.areEqual((Object)this.value, (Object)itemId.value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\u0017"}, d2={"Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$Rotation;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;", "Lorg/joml/Vector3f;", "value", "<init>", "(Lorg/joml/Vector3f;)V", "component1", "()Lorg/joml/Vector3f;", "copy", "(Lorg/joml/Vector3f;)Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$Rotation;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lorg/joml/Vector3f;", "getValue", "holodisplays"})
        public static final class Rotation
        extends DisplayProperty {
            @Nullable
            private final Vector3f value;

            public Rotation(@Nullable Vector3f value) {
                super(null);
                this.value = value;
            }

            @Nullable
            public final Vector3f getValue() {
                return this.value;
            }

            @Nullable
            public final Vector3f component1() {
                return this.value;
            }

            @NotNull
            public final Rotation copy(@Nullable Vector3f value) {
                return new Rotation(value);
            }

            public static /* synthetic */ Rotation copy$default(Rotation rotation, Vector3f vector3f, int n, Object object) {
                if ((n & 1) != 0) {
                    vector3f = rotation.value;
                }
                return rotation.copy(vector3f);
            }

            @NotNull
            public String toString() {
                return "Rotation(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value == null ? 0 : this.value.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Rotation)) {
                    return false;
                }
                Rotation rotation = (Rotation)other;
                return Intrinsics.areEqual((Object)this.value, (Object)rotation.value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\u0017"}, d2={"Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$Scale;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;", "Lorg/joml/Vector3f;", "value", "<init>", "(Lorg/joml/Vector3f;)V", "component1", "()Lorg/joml/Vector3f;", "copy", "(Lorg/joml/Vector3f;)Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$Scale;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lorg/joml/Vector3f;", "getValue", "holodisplays"})
        public static final class Scale
        extends DisplayProperty {
            @Nullable
            private final Vector3f value;

            public Scale(@Nullable Vector3f value) {
                super(null);
                this.value = value;
            }

            @Nullable
            public final Vector3f getValue() {
                return this.value;
            }

            @Nullable
            public final Vector3f component1() {
                return this.value;
            }

            @NotNull
            public final Scale copy(@Nullable Vector3f value) {
                return new Scale(value);
            }

            public static /* synthetic */ Scale copy$default(Scale scale, Vector3f vector3f, int n, Object object) {
                if ((n & 1) != 0) {
                    vector3f = scale.value;
                }
                return scale.copy(vector3f);
            }

            @NotNull
            public String toString() {
                return "Scale(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value == null ? 0 : this.value.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Scale)) {
                    return false;
                }
                Scale scale = (Scale)other;
                return Intrinsics.areEqual((Object)this.value, (Object)scale.value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\u0017"}, d2={"Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$TextAlignment;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;", "Ldev/furq/holodisplays/data/display/TextDisplay$TextAlignment;", "value", "<init>", "(Ldev/furq/holodisplays/data/display/TextDisplay$TextAlignment;)V", "component1", "()Ldev/furq/holodisplays/data/display/TextDisplay$TextAlignment;", "copy", "(Ldev/furq/holodisplays/data/display/TextDisplay$TextAlignment;)Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$TextAlignment;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ldev/furq/holodisplays/data/display/TextDisplay$TextAlignment;", "getValue", "holodisplays"})
        public static final class TextAlignment
        extends DisplayProperty {
            @Nullable
            private final TextDisplay.TextAlignment value;

            public TextAlignment(@Nullable TextDisplay.TextAlignment value) {
                super(null);
                this.value = value;
            }

            @Nullable
            public final TextDisplay.TextAlignment getValue() {
                return this.value;
            }

            @Nullable
            public final TextDisplay.TextAlignment component1() {
                return this.value;
            }

            @NotNull
            public final TextAlignment copy(@Nullable TextDisplay.TextAlignment value) {
                return new TextAlignment(value);
            }

            public static /* synthetic */ TextAlignment copy$default(TextAlignment textAlignment, TextDisplay.TextAlignment textAlignment2, int n, Object object) {
                if ((n & 1) != 0) {
                    textAlignment2 = textAlignment.value;
                }
                return textAlignment.copy(textAlignment2);
            }

            @NotNull
            public String toString() {
                return "TextAlignment(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value == null ? 0 : this.value.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TextAlignment)) {
                    return false;
                }
                TextAlignment textAlignment = (TextAlignment)other;
                return this.value == textAlignment.value;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0007R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u0007\u00a8\u0006\u0015"}, d2={"Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$TextBackgroundColor;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;", "", "value", "<init>", "(Ljava/lang/String;)V", "component1", "()Ljava/lang/String;", "copy", "(Ljava/lang/String;)Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$TextBackgroundColor;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getValue", "holodisplays"})
        public static final class TextBackgroundColor
        extends DisplayProperty {
            @Nullable
            private final String value;

            public TextBackgroundColor(@Nullable String value) {
                super(null);
                this.value = value;
            }

            @Nullable
            public final String getValue() {
                return this.value;
            }

            @Nullable
            public final String component1() {
                return this.value;
            }

            @NotNull
            public final TextBackgroundColor copy(@Nullable String value) {
                return new TextBackgroundColor(value);
            }

            public static /* synthetic */ TextBackgroundColor copy$default(TextBackgroundColor textBackgroundColor, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = textBackgroundColor.value;
                }
                return textBackgroundColor.copy(string);
            }

            @NotNull
            public String toString() {
                return "TextBackgroundColor(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value == null ? 0 : this.value.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TextBackgroundColor)) {
                    return false;
                }
                TextBackgroundColor textBackgroundColor = (TextBackgroundColor)other;
                return Intrinsics.areEqual((Object)this.value, (Object)textBackgroundColor.value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0007\u00a8\u0006\u0016"}, d2={"Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$TextLineWidth;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;", "", "value", "<init>", "(Ljava/lang/Integer;)V", "component1", "()Ljava/lang/Integer;", "copy", "(Ljava/lang/Integer;)Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$TextLineWidth;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/lang/Integer;", "getValue", "holodisplays"})
        public static final class TextLineWidth
        extends DisplayProperty {
            @Nullable
            private final Integer value;

            public TextLineWidth(@Nullable Integer value) {
                super(null);
                this.value = value;
            }

            @Nullable
            public final Integer getValue() {
                return this.value;
            }

            @Nullable
            public final Integer component1() {
                return this.value;
            }

            @NotNull
            public final TextLineWidth copy(@Nullable Integer value) {
                return new TextLineWidth(value);
            }

            public static /* synthetic */ TextLineWidth copy$default(TextLineWidth textLineWidth, Integer n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = textLineWidth.value;
                }
                return textLineWidth.copy(n);
            }

            @NotNull
            public String toString() {
                return "TextLineWidth(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value == null ? 0 : ((Object)this.value).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TextLineWidth)) {
                    return false;
                }
                TextLineWidth textLineWidth = (TextLineWidth)other;
                return Intrinsics.areEqual((Object)this.value, (Object)textLineWidth.value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0015\u001a\u0004\b\u0016\u0010\b\u00a8\u0006\u0017"}, d2={"Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$TextLines;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;", "", "", "value", "<init>", "(Ljava/util/List;)V", "component1", "()Ljava/util/List;", "copy", "(Ljava/util/List;)Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$TextLines;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Ljava/util/List;", "getValue", "holodisplays"})
        public static final class TextLines
        extends DisplayProperty {
            @NotNull
            private final List<String> value;

            public TextLines(@NotNull List<String> value) {
                Intrinsics.checkNotNullParameter(value, (String)"value");
                super(null);
                this.value = value;
            }

            @NotNull
            public final List<String> getValue() {
                return this.value;
            }

            @NotNull
            public final List<String> component1() {
                return this.value;
            }

            @NotNull
            public final TextLines copy(@NotNull List<String> value) {
                Intrinsics.checkNotNullParameter(value, (String)"value");
                return new TextLines(value);
            }

            public static /* synthetic */ TextLines copy$default(TextLines textLines, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = textLines.value;
                }
                return textLines.copy(list);
            }

            @NotNull
            public String toString() {
                return "TextLines(value=" + this.value + ")";
            }

            public int hashCode() {
                return ((Object)this.value).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TextLines)) {
                    return false;
                }
                TextLines textLines = (TextLines)other;
                return Intrinsics.areEqual(this.value, textLines.value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0007\u00a8\u0006\u0016"}, d2={"Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$TextOpacity;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;", "", "value", "<init>", "(Ljava/lang/Integer;)V", "component1", "()Ljava/lang/Integer;", "copy", "(Ljava/lang/Integer;)Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$TextOpacity;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/lang/Integer;", "getValue", "holodisplays"})
        public static final class TextOpacity
        extends DisplayProperty {
            @Nullable
            private final Integer value;

            public TextOpacity(@Nullable Integer value) {
                super(null);
                this.value = value;
            }

            @Nullable
            public final Integer getValue() {
                return this.value;
            }

            @Nullable
            public final Integer component1() {
                return this.value;
            }

            @NotNull
            public final TextOpacity copy(@Nullable Integer value) {
                return new TextOpacity(value);
            }

            public static /* synthetic */ TextOpacity copy$default(TextOpacity textOpacity, Integer n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = textOpacity.value;
                }
                return textOpacity.copy(n);
            }

            @NotNull
            public String toString() {
                return "TextOpacity(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value == null ? 0 : ((Object)this.value).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TextOpacity)) {
                    return false;
                }
                TextOpacity textOpacity = (TextOpacity)other;
                return Intrinsics.areEqual((Object)this.value, (Object)textOpacity.value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u000eH\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0007\u00a8\u0006\u0016"}, d2={"Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$TextSeeThrough;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;", "", "value", "<init>", "(Ljava/lang/Boolean;)V", "component1", "()Ljava/lang/Boolean;", "copy", "(Ljava/lang/Boolean;)Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$TextSeeThrough;", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/lang/Boolean;", "getValue", "holodisplays"})
        public static final class TextSeeThrough
        extends DisplayProperty {
            @Nullable
            private final Boolean value;

            public TextSeeThrough(@Nullable Boolean value) {
                super(null);
                this.value = value;
            }

            @Nullable
            public final Boolean getValue() {
                return this.value;
            }

            @Nullable
            public final Boolean component1() {
                return this.value;
            }

            @NotNull
            public final TextSeeThrough copy(@Nullable Boolean value) {
                return new TextSeeThrough(value);
            }

            public static /* synthetic */ TextSeeThrough copy$default(TextSeeThrough textSeeThrough, Boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = textSeeThrough.value;
                }
                return textSeeThrough.copy(bl);
            }

            @NotNull
            public String toString() {
                return "TextSeeThrough(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value == null ? 0 : ((Object)this.value).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TextSeeThrough)) {
                    return false;
                }
                TextSeeThrough textSeeThrough = (TextSeeThrough)other;
                return Intrinsics.areEqual((Object)this.value, (Object)textSeeThrough.value);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u000eH\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0007\u00a8\u0006\u0016"}, d2={"Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$TextShadow;", "Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty;", "", "value", "<init>", "(Ljava/lang/Boolean;)V", "component1", "()Ljava/lang/Boolean;", "copy", "(Ljava/lang/Boolean;)Ldev/furq/holodisplays/handlers/DisplayHandler$DisplayProperty$TextShadow;", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/lang/Boolean;", "getValue", "holodisplays"})
        public static final class TextShadow
        extends DisplayProperty {
            @Nullable
            private final Boolean value;

            public TextShadow(@Nullable Boolean value) {
                super(null);
                this.value = value;
            }

            @Nullable
            public final Boolean getValue() {
                return this.value;
            }

            @Nullable
            public final Boolean component1() {
                return this.value;
            }

            @NotNull
            public final TextShadow copy(@Nullable Boolean value) {
                return new TextShadow(value);
            }

            public static /* synthetic */ TextShadow copy$default(TextShadow textShadow, Boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = textShadow.value;
                }
                return textShadow.copy(bl);
            }

            @NotNull
            public String toString() {
                return "TextShadow(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value == null ? 0 : ((Object)this.value).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TextShadow)) {
                    return false;
                }
                TextShadow textShadow = (TextShadow)other;
                return Intrinsics.areEqual((Object)this.value, (Object)textShadow.value);
            }
        }
    }
}

