/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.limitedafk;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.borisshoes.limitedafk.callbacks.CommandRegisterCallback;
import net.borisshoes.limitedafk.callbacks.InteractionsCallback;
import net.borisshoes.limitedafk.callbacks.PlayerConnectionCallback;
import net.borisshoes.limitedafk.callbacks.TickCallback;
import net.borisshoes.limitedafk.callbacks.TickTimerCallback;
import net.borisshoes.limitedafk.cca.IPlayerProfileComponent;
import net.borisshoes.limitedafk.cca.PlayerComponentInitializer;
import net.borisshoes.limitedafk.mixins.EntityAccessor;
import net.borisshoes.limitedafk.utils.ConfigUtils;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_11560;
import net.minecraft.class_11561;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_3324;
import net.minecraft.class_3542;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8791;
import net.minecraft.class_8942;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LimitedAFK
implements ModInitializer {
    private static final Logger logger = LogManager.getLogger((String)"Limited AFK");
    private static final String CONFIG_NAME = "LimitedAFK.properties";
    public static ConfigUtils config;
    public static final ArrayList<TickTimerCallback> SERVER_TIMER_CALLBACKS;

    public void onInitialize() {
        ServerTickEvents.END_SERVER_TICK.register(TickCallback::onTick);
        CommandRegistrationCallback.EVENT.register(CommandRegisterCallback::registerCommands);
        ServerPlayConnectionEvents.JOIN.register(PlayerConnectionCallback::onPlayerJoin);
        UseItemCallback.EVENT.register(InteractionsCallback::useItem);
        UseEntityCallback.EVENT.register(InteractionsCallback::useEntity);
        UseBlockCallback.EVENT.register(InteractionsCallback::useBlock);
        AttackEntityCallback.EVENT.register(InteractionsCallback::attackEntity);
        config = new ConfigUtils(FabricLoader.getInstance().getConfigDir().resolve(CONFIG_NAME).toFile(), logger, Arrays.asList(new ConfigUtils.BooleanConfigValue("enabled", true, "Is Limited AFK enabled", new ConfigUtils.Command("Limiting AFK: %s", "Limiting AFK is now %s")), new ConfigUtils.IntegerConfigValue("allowedAfkPercentage", 50, new ConfigUtils.IntegerConfigValue.IntLimits(0, 100), "How long can people AFK", new ConfigUtils.Command("Permitted Time AFK'ing is %s percent", "Permitted Time AFK'ing is now %s percent")), new ConfigUtils.BooleanConfigValue("announceAfk", true, "Does Limited AFK announce when people go AFK", new ConfigUtils.Command("Announcing AFK is %s", "Announcing AFK is now %s")), new ConfigUtils.IntegerConfigValue("afkTimer", 900, new ConfigUtils.IntegerConfigValue.IntLimits(60), "How long until someone is AFK", new ConfigUtils.Command("Time till AFK is %s seconds", "Time till AFK is now %s seconds")), new ConfigUtils.BooleanConfigValue("ignoreCreativeAndSpectator", true, "Does Limited AFK track creative and spectator players", new ConfigUtils.Command("Ignoring Creative and Spectators: %s", "Ignoring Creative and Spectators is now: %s")), new ConfigUtils.EnumConfigValue<AFKLevel>("defaultAfkDetectionLevel", AFKLevel.LOW, "How aggressive is the AFK detection (LOW and MEDIUM require various levels of activity, and HIGH requires a captcha)", new ConfigUtils.Command("Default AFK detection level: %s", "Default AFK detection level is now: %s"), AFKLevel.class), new ConfigUtils.IntegerConfigValue("captchaTimer", 600, new ConfigUtils.IntegerConfigValue.IntLimits(120), "Interval between when someone suspected of being AFK is given a captcha", new ConfigUtils.Command("The captcha timer is %s seconds", "The captcha timer is now %s seconds"))));
    }

    public static void log(int level, String msg) {
        switch (level) {
            case 0: {
                logger.info(msg);
                break;
            }
            case 1: {
                logger.warn(msg);
                break;
            }
            case 2: {
                logger.error(msg);
                break;
            }
            case 3: {
                logger.fatal(msg);
                break;
            }
            default: {
                logger.debug(msg);
            }
        }
    }

    public static int listAfkCmd(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        class_3324 playerManager = server.method_3760();
        List players = playerManager.method_14571();
        int afkCount = 0;
        source.method_9226(() -> class_2561.method_43470((String)"===== Players ====="), false);
        for (class_3222 player : players) {
            IPlayerProfileComponent profile = (IPlayerProfileComponent)PlayerComponentInitializer.PLAYER_DATA.get((Object)player);
            boolean afk = profile.isAfk();
            if (afk) {
                ++afkCount;
            }
            source.method_9226(() -> class_2561.method_43470((String)"").method_10852(player.method_5476()).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)(afk ? "AFK" : "Active")).method_27692(afk ? class_124.field_1061 : class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" for [").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)LimitedAFK.timeToStr(System.currentTimeMillis() - profile.getStateChangeTime())).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"]").method_27692(class_124.field_1068)), false);
        }
        source.method_9226(() -> class_2561.method_43470((String)"==================="), false);
        return afkCount;
    }

    public static int playtimeCmd(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Command must be executed by a player").method_27692(class_124.field_1061));
        }
        DecimalFormat df = new DecimalFormat("#.00");
        class_3222 player = source.method_44023();
        IPlayerProfileComponent profile = (IPlayerProfileComponent)PlayerComponentInitializer.PLAYER_DATA.get((Object)player);
        source.method_9226(() -> class_2561.method_43470((String)"").method_10852(player.method_5476()).method_10852((class_2561)class_2561.method_43470((String)" has played for [").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)LimitedAFK.timeToStr(profile.getTotalTime())).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"]").method_27692(class_124.field_1068)), false);
        source.method_9226(() -> class_2561.method_43470((String)"").method_10852(player.method_5476()).method_10852((class_2561)class_2561.method_43470((String)" has AFK'd a total of [").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)LimitedAFK.timeToStr(profile.getAfkTime())).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"]").method_27692(class_124.field_1061)), false);
        source.method_9226(() -> class_2561.method_43470((String)"").method_10852(player.method_5476()).method_10852((class_2561)class_2561.method_43470((String)" has been Active for a total of [").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)LimitedAFK.timeToStr(profile.getActiveTime())).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"]").method_27692(class_124.field_1060)), false);
        source.method_9226(() -> class_2561.method_43470((String)"").method_10852(player.method_5476()).method_10852((class_2561)class_2561.method_43470((String)" has an AFK percentage of ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)df.format(100L * profile.getAfkTime() / (profile.getTotalTime() + 1L))).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"%").method_27692(class_124.field_1075)), false);
        return 1;
    }

    public static int playtimeAllCmd(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        class_11561 baseCache = server.method_73550().comp_4407();
        ArrayList<class_3222> allPlayers = new ArrayList<class_3222>();
        if (baseCache instanceof class_3312) {
            class_3312 userCache = (class_3312)baseCache;
            List cacheEntries = userCache.method_14517();
            for (class_3312.class_3313 cacheEntry : cacheEntries) {
                Optional opt = server.method_73550().comp_4624().method_73290(cacheEntry.method_72369().comp_4422());
                if (opt.isEmpty()) continue;
                GameProfile reqProfile = (GameProfile)opt.get();
                class_3222 reqPlayer = LimitedAFK.getRequestedPlayer(server, reqProfile);
                allPlayers.add(reqPlayer);
            }
        } else {
            LimitedAFK.log(2, "Was unable to pull player data");
        }
        DecimalFormat df = new DecimalFormat("#.00");
        LimitedAFK.log(0, "An Operator has initiated a playtime dump:");
        StringBuilder masterString = new StringBuilder("===== Full Playtime List =====");
        ArrayList<IPlayerProfileComponent> allPlaytime = new ArrayList<IPlayerProfileComponent>();
        for (class_3222 player : allPlayers) {
            IPlayerProfileComponent profile = (IPlayerProfileComponent)PlayerComponentInitializer.PLAYER_DATA.get((Object)player);
            allPlaytime.add(profile);
        }
        Collections.sort(allPlaytime);
        for (IPlayerProfileComponent profile : allPlaytime) {
            if (profile == null) {
                LimitedAFK.log(1, "An error occurred loading a null profile");
                continue;
            }
            String str = "\n" + profile.getPlayer().method_5820() + " has played for a total of [" + LimitedAFK.timeToStr(profile.getTotalTime()) + "] - (" + LimitedAFK.timeToStr(profile.getActiveTime()) + " Active | " + LimitedAFK.timeToStr(profile.getAfkTime()) + " AFK) - <" + df.format(100L * profile.getAfkTime() / (profile.getTotalTime() + 1L)) + "%>";
            masterString.append(str);
        }
        source.method_9226(() -> class_2561.method_43470((String)"Click to copy full dump").method_27694(s -> s.method_10958((class_2558)new class_2558.class_10606(masterString.toString()))), false);
        LimitedAFK.log(0, masterString.toString());
        return allPlayers.size();
    }

    public static int playtimePlayerCmd(CommandContext<class_2168> context, class_3222 player) {
        class_2168 source = (class_2168)context.getSource();
        DecimalFormat df = new DecimalFormat("#.00");
        IPlayerProfileComponent profile = (IPlayerProfileComponent)PlayerComponentInitializer.PLAYER_DATA.get((Object)player);
        source.method_9226(() -> class_2561.method_43470((String)"").method_10852(player.method_5476()).method_10852((class_2561)class_2561.method_43470((String)" has played for [").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)LimitedAFK.timeToStr(profile.getTotalTime())).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"]").method_27692(class_124.field_1068)), false);
        source.method_9226(() -> class_2561.method_43470((String)"").method_10852(player.method_5476()).method_10852((class_2561)class_2561.method_43470((String)" has AFK'd a total of [").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)LimitedAFK.timeToStr(profile.getAfkTime())).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"]").method_27692(class_124.field_1061)), false);
        source.method_9226(() -> class_2561.method_43470((String)"").method_10852(player.method_5476()).method_10852((class_2561)class_2561.method_43470((String)" has been Active for a total of [").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)LimitedAFK.timeToStr(profile.getActiveTime())).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"]").method_27692(class_124.field_1060)), false);
        source.method_9226(() -> class_2561.method_43470((String)"").method_10852(player.method_5476()).method_10852((class_2561)class_2561.method_43470((String)" has an AFK percentage of ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)df.format(100L * profile.getAfkTime() / (profile.getTotalTime() + 1L))).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"%").method_27692(class_124.field_1075)), false);
        return 1;
    }

    public static int actionsPlayerCmd(CommandContext<class_2168> context, class_3222 player) {
        class_2168 source = (class_2168)context.getSource();
        IPlayerProfileComponent profile = (IPlayerProfileComponent)PlayerComponentInitializer.PLAYER_DATA.get((Object)player);
        long curTime = System.currentTimeMillis();
        source.method_9226(() -> class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Player Actions for: ")).method_10852(player.method_5476()), false);
        for (Map.Entry<String, Long> entry : profile.getLastActionTimes().entrySet()) {
            source.method_9226(() -> class_2561.method_43470((String)(" - " + (String)entry.getKey() + ": " + LimitedAFK.timeToStr(curTime - (Long)entry.getValue()))), false);
        }
        return 1;
    }

    public static String timeToStr(long millis) {
        long time = millis / 1000L;
        if (time <= 0L) {
            return "0 Seconds";
        }
        long subtract = time;
        long hoursDif = subtract / 3600L;
        long minutesDif = (subtract -= hoursDif * 3600L) / 60L;
        long secondsDiff = subtract -= minutesDif * 60L;
        Object diff = "";
        if (hoursDif > 0L) {
            diff = (String)diff + hoursDif + " Hours ";
        }
        if (minutesDif > 0L) {
            diff = (String)diff + minutesDif + " Minutes ";
        }
        if (secondsDiff > 0L) {
            diff = (String)diff + secondsDiff + " Seconds ";
        }
        diff = ((String)diff).substring(0, ((String)diff).length() - 1);
        return diff;
    }

    public static int setAfkLevel(CommandContext<class_2168> context, class_3222 player, AFKLevel level) {
        if (level == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid AFK Level"));
            return -1;
        }
        ((IPlayerProfileComponent)PlayerComponentInitializer.PLAYER_DATA.get((Object)player)).setAfkLevel(level);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(player.method_5820() + "'s AFK Level is now " + ((IPlayerProfileComponent)PlayerComponentInitializer.PLAYER_DATA.get((Object)player)).getAfkLevel().method_15434())), false);
        return 1;
    }

    public static int getAfkLevel(CommandContext<class_2168> context, class_3222 player) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(player.method_5820() + "'s AFK Level is " + ((IPlayerProfileComponent)PlayerComponentInitializer.PLAYER_DATA.get((Object)player)).getAfkLevel().method_15434())), false);
        return 1;
    }

    public static int resetAfkLevel(CommandContext<class_2168> context, class_3222 player) {
        ((IPlayerProfileComponent)PlayerComponentInitializer.PLAYER_DATA.get((Object)player)).resetLevel();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Reset " + player.method_5820() + "'s AFK Level")), false);
        return 1;
    }

    public static boolean addTickTimerCallback(TickTimerCallback callback) {
        return SERVER_TIMER_CALLBACKS.add(callback);
    }

    public static class_3222 getRequestedPlayer(MinecraftServer server, GameProfile requestedProfile) {
        class_3222 requestedPlayer = server.method_3760().method_14566(requestedProfile.name());
        if (requestedPlayer == null) {
            class_3218 world;
            class_11368 readView;
            Optional dimension;
            requestedPlayer = new class_3222(server, server.method_30002(), requestedProfile, class_8791.method_53821());
            Optional<class_11368> readViewOpt = server.method_3760().method_14600(new class_11560(requestedProfile)).map(playerData -> class_11352.method_71417((class_8942)new class_8942.class_11340(LogUtils.getLogger()), (class_7225.class_7874)server.method_30611(), (class_2487)playerData));
            readViewOpt.ifPresent(arg_0 -> ((class_3222)requestedPlayer).method_5651(arg_0));
            if (readViewOpt.isPresent() && (dimension = (readView = readViewOpt.get()).method_71441("Dimension")).isPresent() && (world = server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_12829((String)((String)dimension.get()))))) != null) {
                ((EntityAccessor)requestedPlayer).callSetWorld((class_1937)world);
            }
        }
        return requestedPlayer;
    }

    static {
        SERVER_TIMER_CALLBACKS = new ArrayList();
    }

    public static enum AFKLevel implements class_3542
    {
        LOW("LOW"),
        MEDIUM("MEDIUM"),
        HIGH("HIGH");

        private final String id;

        private AFKLevel(String id) {
            this.id = id;
        }

        public String method_15434() {
            return this.id;
        }
    }
}

