/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.limitedafk.cca;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import net.borisshoes.limitedafk.LimitedAFK;
import net.borisshoes.limitedafk.callbacks.TickTimerCallback;
import net.borisshoes.limitedafk.cca.IPlayerProfileComponent;
import net.borisshoes.limitedafk.gui.CaptchaGui;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_5888;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import org.jetbrains.annotations.NotNull;

public class PlayerProfileComponent
implements IPlayerProfileComponent {
    private final class_1657 player;
    private final HashMap<String, Long> lastActionTimes = new HashMap();
    private final LinkedList<class_243> moves = new LinkedList();
    private final LinkedList<class_241> looks = new LinkedList();
    private long totalTime;
    private long activeTime;
    private long afkTime;
    private long lastUpdate;
    private long stateChangeTime;
    private long lastCaptcha;
    private long lastTitlePulse;
    private boolean afk;
    private LimitedAFK.AFKLevel overrideLevel;
    private boolean levelOverridden;

    public PlayerProfileComponent(class_1657 player) {
        this.player = player;
    }

    @Override
    public class_1657 getPlayer() {
        return this.player;
    }

    public void readData(class_11368 view) {
        this.lastActionTimes.clear();
        this.totalTime = view.method_71425("totalTime", 0L);
        this.activeTime = view.method_71425("activeTime", 0L);
        this.afkTime = view.method_71425("afkTime", 0L);
        this.lastUpdate = view.method_71425("lastUpdate", 0L);
        this.stateChangeTime = view.method_71425("stateChangeTime", 0L);
        this.afk = view.method_71433("isAfk", false);
        this.levelOverridden = view.method_71433("levelOverridden", false);
        try {
            this.overrideLevel = LimitedAFK.AFKLevel.valueOf(view.method_71428("afkLevel", ""));
        }
        catch (Exception e) {
            this.overrideLevel = (LimitedAFK.AFKLevel)((Object)LimitedAFK.config.getValue("defaultAfkDetectionLevel"));
        }
        class_2487 lastActionsTag = view.method_71426("lastActions", class_2487.field_25128).orElse(new class_2487());
        Set keys = lastActionsTag.method_10541();
        keys.forEach(key -> this.lastActionTimes.put((String)key, lastActionsTag.method_68080(key, 0L)));
    }

    public void writeData(class_11372 view) {
        view.method_71466("totalTime", this.totalTime);
        view.method_71466("activeTime", this.activeTime);
        view.method_71466("afkTime", this.afkTime);
        view.method_71466("lastUpdate", this.lastUpdate);
        view.method_71466("stateChangeTime", this.stateChangeTime);
        view.method_71472("isAfk", this.afk);
        view.method_71472("levelOverridden", this.levelOverridden);
        try {
            view.method_71469("afkLevel", this.overrideLevel.method_15434());
        }
        catch (Exception e) {
            view.method_71469("afkLevel", ((LimitedAFK.AFKLevel)((Object)LimitedAFK.config.getValue("defaultAfkDetectionLevel"))).method_15434());
        }
        class_2487 lastActionsTag = new class_2487();
        this.lastActionTimes.forEach((arg_0, arg_1) -> ((class_2487)lastActionsTag).method_10544(arg_0, arg_1));
        view.method_71468("lastActions", class_2487.field_25128, (Object)lastActionsTag);
    }

    @Override
    public long getTotalTime() {
        return this.totalTime;
    }

    @Override
    public long getActiveTime() {
        return this.activeTime;
    }

    @Override
    public long getAfkTime() {
        return this.afkTime;
    }

    @Override
    public HashMap<String, Long> getLastActionTimes() {
        return this.lastActionTimes;
    }

    @Override
    public long getLastActionTime(String action) {
        return this.lastActionTimes.getOrDefault(action, -1L);
    }

    @Override
    public void playerJoin() {
        long curTime = System.currentTimeMillis();
        this.updateActionTime("playerLook", curTime);
        this.updateActionTime("playerMove", curTime);
        this.updateActionTime("playerInteract", curTime);
        this.updateActionTime("playerAction", curTime);
        this.updateActionTime("selectSlot", curTime);
        this.updateActionTime("chatMessage", curTime);
        this.lastUpdate = curTime;
        this.stateChangeTime = curTime;
        this.afk = false;
    }

    private void checkMoveAndLook() {
        long curTime = System.currentTimeMillis();
        this.moves.add(this.player.method_73189());
        while (this.moves.size() > 10) {
            this.moves.remove();
        }
        this.looks.add(this.player.method_5802());
        while (this.looks.size() > 5) {
            this.looks.remove();
        }
        class_243 travelled = new class_243(0.0, 0.0, 0.0);
        for (int i = 0; i < this.moves.size() - 1; ++i) {
            class_243 move1 = this.moves.get(i);
            class_243 move2 = this.moves.get(i + 1);
            travelled = travelled.method_1019(move2.method_1020(move1));
        }
        if (travelled.method_1033() > 10.0) {
            this.updateActionTime("playerMove", curTime);
        }
        ArrayList<class_241> uniqueLooks = new ArrayList<class_241>();
        for (class_241 look : this.looks) {
            boolean found = false;
            for (class_241 uniqueLook : uniqueLooks) {
                if (look.field_1343 != uniqueLook.field_1343 || look.field_1342 != uniqueLook.field_1342) continue;
                found = true;
                break;
            }
            if (found) continue;
            uniqueLooks.add(look);
        }
        if (uniqueLooks.size() >= 3) {
            this.updateActionTime("playerLook", curTime);
        }
    }

    @Override
    public void update() {
        class_3222 serverPlayer;
        class_1657 class_16572;
        boolean curAfk;
        if (this.totalTime == 0L) {
            ++this.totalTime;
        }
        this.checkMoveAndLook();
        long curTime = System.currentTimeMillis();
        long millis = curTime - this.lastUpdate;
        long afkTimer = 1000L * (long)((Integer)LimitedAFK.config.getValue("afkTimer")).intValue();
        int afkCount = 0;
        boolean lookAfk = curTime - this.getLastActionTime("playerLook") < afkTimer && this.getLastActionTime("playerLook") > 0L;
        boolean moveAfk = curTime - this.getLastActionTime("playerMove") < afkTimer && this.getLastActionTime("playerMove") > 0L;
        boolean interactAfk = curTime - this.getLastActionTime("playerInteract") < afkTimer && this.getLastActionTime("playerInteract") > 0L;
        boolean actionAfk = curTime - this.getLastActionTime("playerAction") < afkTimer && this.getLastActionTime("playerAction") > 0L;
        boolean selectAfk = curTime - this.getLastActionTime("selectSlot") < afkTimer && this.getLastActionTime("selectSlot") > 0L;
        boolean chatAfk = curTime - this.getLastActionTime("chatMessage") < afkTimer && this.getLastActionTime("chatMessage") > 0L;
        afkCount += lookAfk ? 10 : 0;
        afkCount += moveAfk ? 4 : 0;
        afkCount += selectAfk ? 3 : 0;
        afkCount += interactAfk ? 1 : 0;
        afkCount += actionAfk ? 1 : 0;
        boolean bl = curAfk = (afkCount += chatAfk ? 1 : 0) < (this.getAfkLevel() == LimitedAFK.AFKLevel.LOW ? 15 : 17);
        if ((this.player.method_68878() || this.player.method_7325()) && ((Boolean)LimitedAFK.config.getValue("ignoreCreativeAndSpectator")).booleanValue()) {
            curAfk = false;
        } else if (this.getAfkLevel() == LimitedAFK.AFKLevel.HIGH && afkCount < 20 && (class_16572 = this.player) instanceof class_3222) {
            serverPlayer = (class_3222)class_16572;
            if (curTime - this.lastCaptcha > 1000L * (long)((Integer)LimitedAFK.config.getValue("captchaTimer")).intValue()) {
                this.lastCaptcha = curTime;
                CaptchaGui gui = new CaptchaGui(serverPlayer);
                gui.build();
                gui.open();
            }
        }
        if (curAfk && (class_16572 = this.player) instanceof class_3222) {
            serverPlayer = (class_3222)class_16572;
            if (curTime - this.lastTitlePulse > 30000L) {
                serverPlayer.field_13987.method_14364((class_2596)new class_5888(true));
                LimitedAFK.addTickTimerCallback(new TickTimerCallback(5, serverPlayer, () -> serverPlayer.field_13987.method_14364((class_2596)new class_5905(10, 600, 10))));
                LimitedAFK.addTickTimerCallback(new TickTimerCallback(10, serverPlayer, () -> serverPlayer.field_13987.method_14364((class_2596)new class_5904((class_2561)class_2561.method_43470((String)"You are AFK!").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067})))));
                this.lastTitlePulse = curTime;
            }
        }
        if (curAfk && !this.afk) {
            this.stateChangeTime = curTime;
            if (((Boolean)LimitedAFK.config.getValue("announceAfk")).booleanValue()) {
                this.player.method_73183().method_8503().method_3760().method_43514((class_2561)class_2561.method_43470((String)"").method_10852(this.player.method_5476()).method_27693(" is now AFK").method_27692(class_124.field_1068), false);
            }
        }
        if (!curAfk && this.afk) {
            this.stateChangeTime = curTime;
            if (((Boolean)LimitedAFK.config.getValue("announceAfk")).booleanValue()) {
                this.player.method_73183().method_8503().method_3760().method_43514((class_2561)class_2561.method_43470((String)"").method_10852(this.player.method_5476()).method_27693(" is no longer AFK").method_27692(class_124.field_1068), false);
            }
            if ((class_16572 = this.player) instanceof class_3222) {
                serverPlayer = (class_3222)class_16572;
                serverPlayer.field_13987.method_14364((class_2596)new class_5888(true));
            }
        }
        this.afk = curAfk;
        if (this.afk) {
            this.afkTime += millis;
            if (((Boolean)LimitedAFK.config.getValue("enabled")).booleanValue() && 100L * this.afkTime / this.totalTime >= (long)((Integer)LimitedAFK.config.getValue("allowedAfkPercentage")).intValue() && (class_16572 = this.player) instanceof class_3222) {
                serverPlayer = (class_3222)class_16572;
                serverPlayer.field_13987.method_52396((class_2561)class_2561.method_43470((String)"You have AFK'd too much"));
            }
        } else {
            this.activeTime += millis;
        }
        this.totalTime += millis;
        this.lastUpdate = curTime;
    }

    @Override
    public boolean updateActionTime(String action, long time) {
        boolean has = this.lastActionTimes.containsKey(action);
        this.lastActionTimes.put(action, time);
        return has;
    }

    @Override
    public boolean isAfk() {
        return this.afk;
    }

    @Override
    public void setAfk(boolean afk) {
        this.afk = afk;
    }

    @Override
    public long getStateChangeTime() {
        return this.stateChangeTime;
    }

    @Override
    public LimitedAFK.AFKLevel getAfkLevel() {
        return this.levelOverridden ? this.overrideLevel : (LimitedAFK.AFKLevel)((Object)LimitedAFK.config.getValue("defaultAfkDetectionLevel"));
    }

    @Override
    public void setAfkLevel(LimitedAFK.AFKLevel level) {
        this.levelOverridden = true;
        this.overrideLevel = level;
    }

    @Override
    public void resetLevel() {
        this.levelOverridden = false;
    }

    @Override
    public void captchaFail() {
        long curTime = System.currentTimeMillis();
        long afkTimeAgo = curTime - 1000L * (long)((Integer)LimitedAFK.config.getValue("afkTimer")).intValue();
        if (this.getLastActionTime("playerLook") > afkTimeAgo) {
            this.updateActionTime("playerLook", afkTimeAgo - 1L);
        }
        if (this.getLastActionTime("playerMove") > afkTimeAgo) {
            this.updateActionTime("playerMove", afkTimeAgo - 1L);
        }
        if (this.getLastActionTime("playerInteract") > afkTimeAgo) {
            this.updateActionTime("playerInteract", afkTimeAgo - 1L);
        }
        if (this.getLastActionTime("playerAction") > afkTimeAgo) {
            this.updateActionTime("playerAction", afkTimeAgo - 1L);
        }
        if (this.getLastActionTime("selectSlot") > afkTimeAgo) {
            this.updateActionTime("selectSlot", afkTimeAgo - 1L);
        }
        if (this.getLastActionTime("chatMessage") > afkTimeAgo) {
            this.updateActionTime("chatMessage", afkTimeAgo - 1L);
        }
    }

    @Override
    public void captchaSuccess() {
        long curTime = System.currentTimeMillis();
        this.updateActionTime("playerLook", curTime);
        this.updateActionTime("playerMove", curTime);
        this.updateActionTime("playerInteract", curTime);
        this.updateActionTime("playerAction", curTime);
        this.updateActionTime("selectSlot", curTime);
        this.updateActionTime("chatMessage", curTime);
    }

    @Override
    public int compareTo(@NotNull IPlayerProfileComponent o) {
        return Long.compare(o.getTotalTime(), this.totalTime);
    }
}

