/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.limitedafk.utils;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2588;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigUtils {
    public List<IConfigValue> values;
    private final File file;
    private final Logger logger;

    public ConfigUtils(File file, Logger logger, List<IConfigValue> values) {
        this.file = file;
        this.logger = logger;
        this.values = values;
        this.read();
        this.save();
    }

    public void read() {
        Properties props = new Properties();
        try (FileInputStream input = new FileInputStream(this.file);){
            this.logger.debug("Reading Limited AFK config...");
            props.load(input);
            for (IConfigValue value2 : this.values) {
                Object defaultValue = value2.defaultValue;
                try {
                    value2.value = value2.getFromProps(props);
                }
                catch (Exception e) {
                    value2.value = defaultValue;
                }
            }
        }
        catch (FileNotFoundException ignored) {
            this.logger.debug("Initialising Limited AFK config...");
            this.values.forEach(value -> {
                value.value = value.defaultValue;
            });
        }
        catch (IOException e) {
            this.logger.fatal("Failed to load Limited AFK config file!");
            e.printStackTrace();
        }
        catch (Exception e) {
            this.logger.fatal("Failed to parse Limited AFK config");
            e.printStackTrace();
        }
    }

    public void save() {
        Properties props = new Properties();
        this.values.forEach(value -> value.setToProps(props));
        this.logger.debug("Updating Limited AFK config...");
        try (FileOutputStream output = new FileOutputStream(this.file);){
            props.store(output, null);
        }
        catch (IOException e) {
            this.logger.fatal("Failed to load Limited AFK config file!");
            e.printStackTrace();
        }
    }

    public LiteralArgumentBuilder<class_2168> generateCommand() {
        LiteralArgumentBuilder out = (LiteralArgumentBuilder)class_2170.method_9247((String)"limitedafk").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"config").requires(source -> source.method_9259(4))).executes(ctx -> {
            this.values.stream().filter(v -> v.command != null).forEach(value -> ((class_2168)ctx.getSource()).method_9226(() -> class_5250.method_43477((class_7417)new class_2588(value.command.getterText, null, (Object[])new String[]{value.value.toString()})), false));
            return 1;
        }));
        this.values.stream().filter(v -> v.command != null).forEach(value -> out.then(class_2170.method_9247((String)"config").then(((LiteralArgumentBuilder)class_2170.method_9247((String)value.name).executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9226(() -> class_5250.method_43477((class_7417)new class_2588(value.command.getterText, null, (Object[])new String[]{value.value.toString()})), false);
            return 1;
        })).then(class_2170.method_9244((String)value.name, value.getArgumentType()).suggests(value::getSuggestions).executes(ctx -> {
            value.value = value.parseArgumentValue((CommandContext<class_2168>)ctx);
            ((class_2168)ctx.getSource()).method_9226(() -> class_5250.method_43477((class_7417)new class_2588(value.command.setterText, null, (Object[])new String[]{value.value.toString()})), true);
            this.save();
            return 1;
        })))));
        return out;
    }

    public Object getValue(String name) {
        return this.values.stream().filter(value -> value.name.equals(name)).findFirst().map(iConfigValue -> iConfigValue.value).orElse(null);
    }

    public static <K extends Enum<K>> CompletableFuture<Suggestions> getEnumSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder, Class<K> enumClass) {
        HashSet<String> options = new HashSet<String>();
        for (Enum k : EnumSet.allOf(enumClass)) {
            options.add(((class_3542)k).method_15434());
        }
        String start = builder.getRemaining().toLowerCase(Locale.ROOT);
        options.stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static <K extends Enum<K>> K parseEnum(String string, Class<K> enumClass) {
        Optional<Enum> opt = EnumSet.allOf(enumClass).stream().filter(en -> ((class_3542)en).method_15434().equals(string)).findFirst();
        return (K)((Enum)opt.orElse(null));
    }

    public static abstract class IConfigValue<T> {
        protected final T defaultValue;
        protected final String name;
        protected final String comment;
        protected final Command command;
        protected T value;

        public IConfigValue(@NotNull String name, T defaultValue, @Nullable String comment, @Nullable Command command) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.comment = comment;
            this.command = command;
        }

        public abstract T getFromProps(Properties var1);

        public void setToProps(Properties props) {
            props.setProperty(this.name, String.valueOf(this.value));
            if (this.comment != null) {
                props.setProperty(this.name + ".comment", this.comment);
            }
        }

        public abstract ArgumentType<?> getArgumentType();

        public abstract T parseArgumentValue(CommandContext<class_2168> var1);

        public abstract CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> var1, SuggestionsBuilder var2);
    }

    public static class Command {
        protected String setterText;
        protected String getterText;
        protected String errorText;

        public Command(String getterText, String setterText, @Nullable String errorText) {
            this.getterText = getterText;
            this.setterText = setterText;
            this.errorText = errorText;
        }

        public Command(String getterText, String setterText) {
            this(getterText, setterText, null);
        }
    }

    public static class EnumConfigValue<K extends Enum<K>>
    extends IConfigValue<K> {
        protected final K defaultValue;
        private final Class<K> typeClass;

        public EnumConfigValue(@NotNull String name, K defaultValue, @Nullable String comment, @Nullable Command command, Class<K> typeClass) {
            super(name, defaultValue, comment, command);
            this.defaultValue = defaultValue;
            this.typeClass = typeClass;
        }

        public EnumConfigValue(@NotNull String name, K defaultValue, @Nullable Command command, Class<K> typeClass) {
            this(name, defaultValue, null, command, typeClass);
        }

        @Override
        public K getFromProps(Properties props) {
            String property = props.getProperty(this.name);
            for (Enum k : EnumSet.allOf(this.typeClass)) {
                if (!((class_3542)k).method_15434().equalsIgnoreCase(property)) continue;
                return (K)k;
            }
            throw new IllegalArgumentException("Could not map " + property + " to enum " + this.typeClass.getName());
        }

        @Override
        public ArgumentType<String> getArgumentType() {
            return StringArgumentType.string();
        }

        @Override
        public K parseArgumentValue(CommandContext<class_2168> ctx) {
            String parsedString = StringArgumentType.getString(ctx, (String)this.name);
            return Enum.valueOf(this.typeClass, parsedString);
        }

        @Override
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
            HashSet<String> options = new HashSet<String>();
            for (Enum k : EnumSet.allOf(this.typeClass)) {
                options.add(((class_3542)k).method_15434());
            }
            String start = builder.getRemaining().toLowerCase(Locale.ROOT);
            options.stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }
    }

    public static class StringConfigValue
    extends IConfigValue<String> {
        protected final String defaultValue;
        protected final String[] options;

        public StringConfigValue(@NotNull String name, String defaultValue, @Nullable String comment, @Nullable Command command, String ... options) {
            super(name, defaultValue, comment, command);
            this.defaultValue = defaultValue;
            this.options = options;
        }

        @Override
        public String getFromProps(Properties props) {
            return props.getProperty(this.name);
        }

        @Override
        public ArgumentType<String> getArgumentType() {
            return StringArgumentType.greedyString();
        }

        @Override
        public String parseArgumentValue(CommandContext<class_2168> ctx) {
            return StringArgumentType.getString(ctx, (String)this.name);
        }

        @Override
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
            String start = builder.getRemaining().toLowerCase(Locale.ROOT);
            Arrays.stream(this.options).filter(s -> s.toLowerCase(Locale.ROOT).startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }
    }

    public static class BooleanConfigValue
    extends IConfigValue<Boolean> {
        protected final boolean defaultValue;

        public BooleanConfigValue(@NotNull String name, boolean defaultValue, @Nullable String comment, @Nullable Command command) {
            super(name, defaultValue, comment, command);
            this.defaultValue = defaultValue;
        }

        @Override
        public Boolean getFromProps(Properties props) {
            return Boolean.parseBoolean(props.getProperty(this.name));
        }

        @Override
        public ArgumentType<Boolean> getArgumentType() {
            return BoolArgumentType.bool();
        }

        @Override
        public Boolean parseArgumentValue(CommandContext<class_2168> ctx) {
            return BoolArgumentType.getBool(ctx, (String)this.name);
        }

        @Override
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
            HashSet<String> options = new HashSet<String>();
            options.add("true");
            options.add("false");
            String start = builder.getRemaining().toLowerCase(Locale.ROOT);
            options.stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }
    }

    public static class IntegerConfigValue
    extends IConfigValue<Integer> {
        protected final int defaultValue;
        private final IntLimits limits;

        public IntegerConfigValue(@NotNull String name, Integer defaultValue, IntLimits limits, @Nullable String comment, @Nullable Command command) {
            super(name, defaultValue, comment, command);
            this.defaultValue = defaultValue;
            this.limits = limits;
        }

        public IntegerConfigValue(@NotNull String name, Integer defaultValue, IntLimits limits, @Nullable Command command) {
            this(name, defaultValue, limits, null, command);
        }

        @Override
        public Integer getFromProps(Properties props) {
            return Integer.parseInt(props.getProperty(this.name));
        }

        @Override
        public ArgumentType<Integer> getArgumentType() {
            return IntegerArgumentType.integer((int)this.limits.min, (int)this.limits.max);
        }

        @Override
        public Integer parseArgumentValue(CommandContext<class_2168> ctx) {
            return IntegerArgumentType.getInteger(ctx, (String)this.name);
        }

        @Override
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
            if (this.limits.max - this.limits.min < 10000) {
                String start = builder.getRemaining().toLowerCase(Locale.ROOT);
                HashSet<String> nums = new HashSet<String>();
                for (int i = this.limits.min; i <= this.limits.max; ++i) {
                    nums.add(String.valueOf(i));
                }
                nums.stream().filter(s -> s.startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            }
            return builder.buildFuture();
        }

        public static class IntLimits {
            int min = Integer.MIN_VALUE;
            int max = Integer.MAX_VALUE;

            public IntLimits() {
            }

            public IntLimits(int min) {
                this.min = min;
            }

            public IntLimits(int min, int max) {
                this.min = min;
                this.max = max;
            }
        }
    }
}

