/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.blocktorch;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.mcreator.blocktorch.TourchMod;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="blocktorch", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BlockTorch {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Path CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("player_blocklist.json");
    public static BlockConfig config = new BlockConfig();
    private static final int REMINDER_INTERVAL = 6000;
    private static int tickCounter = 0;
    private static final Map<UUID, Integer> playerReminderCooldown = new HashMap<UUID, Integer>();

    public static PlayerSettings getPlayerSettings(Player player) {
        return BlockTorch.config.playerSettings.computeIfAbsent(player.getUUID(), k -> new PlayerSettings());
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() != InteractionHand.OFF_HAND) {
            return;
        }
        Player player = event.getEntity();
        if (player.isCreative()) {
            return;
        }
        PlayerSettings settings = BlockTorch.getPlayerSettings(player);
        if (!settings.enabled) {
            return;
        }
        ItemStack offhandItem = player.getOffhandItem();
        if (offhandItem.isEmpty()) {
            return;
        }
        if (BlockTorch.shouldBlock(offhandItem, settings)) {
            int lastReminder;
            event.setCanceled(true);
            event.setCancellationResult((InteractionResult)InteractionResult.FAIL);
            player.getInventory().setChanged();
            if (!player.level().isClientSide && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.containerMenu.broadcastChanges();
            }
            if (tickCounter - (lastReminder = playerReminderCooldown.getOrDefault(player.getUUID(), 0).intValue()) >= 6000) {
                playerReminderCooldown.put(player.getUUID(), tickCounter);
                player.displayClientMessage((Component)Component.literal((String)("\u00a74\u00a7l[BLOCKED] \u00a7cYou cannot place \u00a7e" + ForgeRegistries.ITEMS.getKey((Object)offhandItem.getItem()).toString() + " \u00a7cfrom your offhand!")), true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player != null && ++tickCounter % 6000 == 0) {
            Player player = event.player;
            PlayerSettings settings = BlockTorch.getPlayerSettings(player);
            if (settings.enabled && !settings.blockedItems.isEmpty()) {
                player.displayClientMessage((Component)Component.literal((String)("\u00a76\u00a7l[REMINDER] \u00a7eOffhand blocking is active. \u00a7aEnabled: \u00a72" + settings.enabled + "\u00a7e | \u00a7cBlocked items: \u00a74" + settings.blockedItems.size())), false);
            }
        }
    }

    private static boolean isValidItemId(String itemId) {
        return ResourceLocation.tryParse((String)itemId) != null;
    }

    public static String normalizeItemId(String input) {
        if (!input.contains(":")) {
            return "minecraft:" + input;
        }
        return input;
    }

    public static boolean shouldBlock(ItemStack stack, PlayerSettings settings) {
        String itemId = ForgeRegistries.ITEMS.getKey((Object)stack.getItem()).toString();
        return settings.blockedItems.contains(itemId);
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        SuggestionProvider itemSuggestions = (context, builder) -> SharedSuggestionProvider.suggest((Iterable)ForgeRegistries.ITEMS.getKeys().stream().map(ResourceLocation::toString).collect(Collectors.toList()), (SuggestionsBuilder)builder);
        SuggestionProvider blockedItemSuggestions = (context, builder) -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            PlayerSettings settings = BlockTorch.getPlayerSettings((Player)player);
            return SharedSuggestionProvider.suggest(settings.blockedItems, (SuggestionsBuilder)builder);
        };
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"blocktorch").then(Commands.literal((String)"info").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            BlockTorch.sendFeedback(source, "\u00a76\u00a7l=== \u00a7eNoPlacingTorch \u00a76\u00a7l===");
            BlockTorch.sendFeedback(source, "\u00a7bAuthor: \u00a73Lokirit");
            BlockTorch.sendFeedback(source, "\u00a7bVersion: \u00a731.0.2");
            BlockTorch.sendFeedback(source, "\u00a7aDescription: \u00a72Prevents placing items from offhand");
            BlockTorch.sendFeedback(source, "\u00a76\u00a7lCommands:");
            BlockTorch.sendFeedback(source, "\u00a7e/blocktorch info \u00a77- Show mod information");
            BlockTorch.sendFeedback(source, "\u00a7e/blocktorch list \u00a77- List blocked items");
            BlockTorch.sendFeedback(source, "\u00a7e/blocktorch clear \u00a77- Clear all blocked items");
            BlockTorch.sendFeedback(source, "\u00a7e/blocktorch add <item> \u00a77- Add item to block list");
            BlockTorch.sendFeedback(source, "\u00a7e/blocktorch toggle \u00a77- Toggle blocking");
            BlockTorch.sendFeedback(source, "\u00a7e/blocktorch del <item> \u00a77- Remove item from block list");
            return 1;
        }))).then(Commands.literal((String)"list").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            PlayerSettings settings = BlockTorch.getPlayerSettings((Player)player);
            if (settings.blockedItems.isEmpty()) {
                BlockTorch.sendFeedback((CommandSourceStack)context.getSource(), "\u00a76\u00a7l[LIST] \u00a7eYour block list is empty");
            } else {
                BlockTorch.sendFeedback((CommandSourceStack)context.getSource(), "\u00a76\u00a7l[LIST] \u00a7eBlocked items (\u00a7c" + settings.blockedItems.size() + "\u00a7e):");
                settings.blockedItems.forEach(item -> BlockTorch.sendFeedback((CommandSourceStack)context.getSource(), "\u00a78- \u00a77" + item));
            }
            return 1;
        }))).then(Commands.literal((String)"clear").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            PlayerSettings settings = BlockTorch.getPlayerSettings((Player)player);
            int count = settings.blockedItems.size();
            settings.blockedItems.clear();
            BlockTorch.saveConfig();
            BlockTorch.sendFeedback((CommandSourceStack)context.getSource(), "\u00a72\u00a7l[CLEARED] \u00a7aRemoved \u00a7e" + count + " \u00a7aitems from block list");
            return 1;
        }))).then(Commands.literal((String)"add").then(Commands.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).suggests(itemSuggestions).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            PlayerSettings settings = BlockTorch.getPlayerSettings((Player)player);
            String input = StringArgumentType.getString((CommandContext)context, (String)"item");
            String itemId = BlockTorch.normalizeItemId(input.trim());
            if (ResourceLocation.tryParse((String)itemId) == null) {
                BlockTorch.sendError((CommandSourceStack)context.getSource(), "\u00a74\u00a7l[ERROR] \u00a7cInvalid item format! Use 'namespace:item'");
                return 0;
            }
            ResourceLocation itemLoc = ResourceLocation.tryParse((String)itemId);
            if (itemLoc != null && ForgeRegistries.ITEMS.containsKey(itemLoc)) {
                settings.blockedItems.add(itemId);
                BlockTorch.saveConfig();
                BlockTorch.sendFeedback((CommandSourceStack)context.getSource(), "\u00a72\u00a7l[ADDED] \u00a7aAdded \u00a7e" + itemId + " \u00a7ato block list");
                return 1;
            }
            BlockTorch.sendError((CommandSourceStack)context.getSource(), "\u00a74\u00a7l[ERROR] \u00a7cItem not found!");
            return 0;
        })))).then(Commands.literal((String)"toggle").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            PlayerSettings settings = BlockTorch.getPlayerSettings((Player)player);
            settings.enabled = !settings.enabled;
            BlockTorch.saveConfig();
            String status = settings.enabled ? "\u00a72ENABLED" : "\u00a74DISABLED";
            BlockTorch.sendFeedback((CommandSourceStack)context.getSource(), "\u00a7fOffhand blocking: " + status);
            return 1;
        }))).then(Commands.literal((String)"del").then(Commands.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).suggests(blockedItemSuggestions).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            PlayerSettings settings = BlockTorch.getPlayerSettings((Player)player);
            String input = StringArgumentType.getString((CommandContext)context, (String)"item");
            String itemId = BlockTorch.normalizeItemId(input.trim());
            boolean removed = settings.blockedItems.remove(itemId);
            if (removed) {
                BlockTorch.saveConfig();
                BlockTorch.sendFeedback((CommandSourceStack)context.getSource(), "\u00a72\u00a7l[REMOVED] \u00a7aRemoved \u00a7e" + itemId + " \u00a7afrom block list");
                return 1;
            }
            BlockTorch.sendError((CommandSourceStack)context.getSource(), "\u00a74\u00a7l[ERROR] \u00a7cItem not in block list!");
            return 0;
        }))));
    }

    private static void sendFeedback(CommandSourceStack source, String message) {
        source.sendSuccess(() -> Component.literal((String)message), false);
    }

    private static void sendError(CommandSourceStack source, String message) {
        source.sendFailure((Component)Component.literal((String)message));
    }

    public static void saveConfig() {
        try {
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)config), new OpenOption[0]);
        }
        catch (IOException e) {
            TourchMod.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    static {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                config = (BlockConfig)GSON.fromJson(Files.readString(CONFIG_PATH), BlockConfig.class);
                BlockTorch.config.playerSettings.forEach((uuid, settings) -> {
                    HashSet<String> normalized = new HashSet<String>();
                    settings.blockedItems.forEach(item -> normalized.add(BlockTorch.normalizeItemId(item)));
                    settings.blockedItems = normalized;
                });
                BlockTorch.saveConfig();
            }
            catch (IOException e) {
                TourchMod.LOGGER.error("Failed to load config", (Throwable)e);
            }
        }
    }

    public static class BlockConfig {
        public Map<UUID, PlayerSettings> playerSettings = new HashMap<UUID, PlayerSettings>();
    }

    public static class PlayerSettings {
        public boolean enabled = true;
        public Set<String> blockedItems = new HashSet<String>();

        public PlayerSettings() {
            this.blockedItems.add("minecraft:torch");
            this.blockedItems.add("minecraft:soul_torch");
            this.blockedItems.add("minecraft:lantern");
            this.blockedItems.add("minecraft:soul_lantern");
        }
    }
}

