/*
 * Decompiled with CFR 0.152.
 */
package net.immortaldevs.bindcmd.config;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.immortaldevs.bindcmd.BindSource;
import net.immortaldevs.bindcmd.CommandBinding;
import net.immortaldevs.bindcmd.config.Config;
import net.immortaldevs.bindcmd.config.ModConfigScreen;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public final class BindingsListWidget
extends class_4265<BindingEntry> {
    final ModConfigScreen parent;
    private final class_7919 serverBindingTooltip = class_7919.method_47407((class_2561)class_2561.method_43471((String)"text.bindcmd.config.server_setting"));
    private final class_7919 worldBindingTooltip = class_7919.method_47407((class_2561)class_2561.method_43471((String)"text.bindcmd.config.world_setting"));

    public BindingsListWidget(ModConfigScreen parent, class_310 client) {
        super(client, parent.field_22789, parent.field_49503.method_57727(), parent.field_49503.method_48998(), 20);
        this.parent = parent;
        for (CommandBinding binding : Config.getBindings()) {
            this.method_25321((class_350.class_351)new BindingEntry(binding));
        }
    }

    public void update() {
        class_304.method_1426();
        this.updateChildren();
    }

    public void addBinding(CommandBinding binding) {
        this.method_25321((class_350.class_351)new BindingEntry(binding));
    }

    private void updateChildren() {
        for (BindingEntry entry : this.method_25396()) {
            entry.update();
        }
    }

    public int method_65507() {
        return super.method_65507() + 15;
    }

    public int method_25322() {
        return super.method_25322() + 32;
    }

    @Environment(value=EnvType.CLIENT)
    public class BindingEntry
    extends class_4265.class_4266<BindingEntry> {
        private final CommandBinding binding;
        private final class_4185 editButton;
        private final class_4185 deleteButton;
        private final class_342 inputField;
        private boolean duplicate = false;

        public BindingEntry(CommandBinding binding) {
            this.binding = binding;
            this.editButton = class_4185.method_46430((class_2561)class_2561.method_43473(), button -> this.editButtonPressed()).method_46434(0, 0, 75, 20).method_46431();
            this.deleteButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"text.bindcmd.config.remove"), button -> this.deleteButtonPressed()).method_46434(0, 0, 50, 20).method_46431();
            this.inputField = new class_342(class_310.method_1551().field_1772, 0, 0, 124, 16, binding.getKey().method_16007());
            this.inputField.method_1863(this::inputFieldChanged);
            this.inputField.method_1880(256);
            this.inputField.method_1852(binding.command);
            this.update();
        }

        private void inputFieldChanged(String text) {
            this.binding.command = text;
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float delta) {
            class_327 textRenderer = ((BindingsListWidget)BindingsListWidget.this).field_22740.field_1772;
            int textWidth = this.method_25368() - this.editButton.method_25368() - this.deleteButton.method_25368() - 3;
            boolean isClient = this.binding.getSource() == BindSource.CLIENT;
            class_7919 tooltip = null;
            if (this.binding.getSource() == BindSource.SERVER) {
                tooltip = BindingsListWidget.this.serverBindingTooltip;
            } else if (this.binding.getSource() == BindSource.WORLD) {
                tooltip = BindingsListWidget.this.worldBindingTooltip;
            }
            int x = this.method_46426();
            int y = this.method_46427();
            int height = this.method_25364();
            if (hovered || this.inputField.method_25370()) {
                this.inputField.method_46421(x - 4);
                this.inputField.method_46419(y + 4);
                this.inputField.method_25358(textWidth);
                this.inputField.method_47400(tooltip);
                this.inputField.method_1888(isClient);
                this.inputField.method_25394(context, mouseX, mouseY, delta);
            } else {
                int yPosition = y + height / 2 - 2;
                String text = this.cutString(this.binding.command, textRenderer, textWidth - 12);
                context.method_25303(textRenderer, text, x, yPosition, -1);
            }
            this.editButton.method_47400(tooltip);
            this.editButton.field_22763 = isClient;
            this.editButton.method_46421(x + this.method_25368() - this.editButton.method_25368() - this.deleteButton.method_25368() - 2);
            this.editButton.method_46419(y);
            this.deleteButton.method_47400(tooltip);
            this.deleteButton.field_22763 = isClient;
            this.deleteButton.method_46421(x + this.method_25368() - this.deleteButton.method_25368());
            this.deleteButton.method_46419(y);
            this.deleteButton.method_25394(context, mouseX, mouseY, delta);
            if (this.duplicate) {
                int j = this.editButton.method_46426() - 6;
                context.method_25294(j, y + 2, j + 3, y + height + 2, -65536);
            }
            this.editButton.method_25394(context, mouseX, mouseY, delta);
        }

        public List<? extends class_364> method_25396() {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(this.editButton);
            list.add(this.deleteButton);
            list.add(this.inputField);
            return list;
        }

        public List<? extends class_6379> method_37025() {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(this.editButton);
            list.add(this.deleteButton);
            list.add(this.inputField);
            return list;
        }

        public void update() {
            class_5250 key;
            this.editButton.method_25355(this.binding.getKey().method_16007());
            this.duplicate = false;
            class_5250 mutableText = class_2561.method_43473();
            if (!this.binding.getKey().method_1415()) {
                class_304[] allKeys;
                for (class_304 keyBinding : allKeys = ((BindingsListWidget)BindingsListWidget.this).field_22740.field_1690.field_1839) {
                    if (keyBinding == this.binding.getKey() || !this.binding.getKey().method_1435(keyBinding)) continue;
                    if (this.duplicate) {
                        mutableText = mutableText.method_27661().method_27693(", ");
                    }
                    this.duplicate = true;
                    mutableText = mutableText.method_27661().method_10852(keyBinding.method_16007());
                }
            }
            if (this.duplicate) {
                key = this.editButton.method_25369().method_27661().method_27692(class_124.field_1068);
                class_5250 tooltip = class_2561.method_43469((String)"controls.keybinds.duplicateKeybinds", (Object[])new Object[]{mutableText});
                this.editButton.method_25355((class_2561)class_2561.method_43470((String)"[ ").method_10852((class_2561)key).method_27693(" ]").method_27692(class_124.field_1061));
                this.editButton.method_47400(class_7919.method_47407((class_2561)tooltip));
            } else {
                this.editButton.method_47400(null);
            }
            if (BindingsListWidget.this.parent.getSelectedKeyBinding() == this.binding.getKey()) {
                key = this.editButton.method_25369().method_27661().method_27695(new class_124[]{class_124.field_1068, class_124.field_1073});
                this.editButton.method_25355((class_2561)class_2561.method_43470((String)"> ").method_10852((class_2561)key).method_27693(" <").method_27692(class_124.field_1054));
            }
        }

        private void editButtonPressed() {
            BindingsListWidget.this.parent.setSelectedBinding(this.binding);
            BindingsListWidget.this.update();
        }

        private void deleteButtonPressed() {
            this.binding.unbind();
            Config.remove(this.binding);
            BindingsListWidget list = BindingsListWidget.this;
            list.parent.clearSelectedBinding();
            list.method_25330((class_350.class_351)this);
            list.method_44382(list.method_44387() - 20.0);
            list.update();
        }

        private String cutString(String text, class_327 textRenderer, int maxWidth) {
            int width = textRenderer.method_1727(text);
            if (width <= maxWidth) {
                return text;
            }
            int len = text.length();
            while (width > maxWidth && len > 0) {
                width = textRenderer.method_1727(text.substring(0, --len));
            }
            return text.substring(0, len) + "\u2026";
        }
    }
}

