/*
 * Decompiled with CFR 0.152.
 */
package net.immortaldevs.bindcmd.config;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.immortaldevs.bindcmd.BindSource;
import net.immortaldevs.bindcmd.CommandBinding;
import net.immortaldevs.bindcmd.config.ConfigEntry;
import net.immortaldevs.bindcmd.config.ConfigLoader;
import net.minecraft.class_310;

public final class Config {
    private static final ConfigLoader loader = new ConfigLoader(class_310.method_1551().field_1697);
    private static List<CommandBinding> serverBindings = Collections.emptyList();
    private static List<CommandBinding> clientBindings = new ArrayList<CommandBinding>();

    public static List<CommandBinding> getBindings() {
        ArrayList<CommandBinding> result = new ArrayList<CommandBinding>(clientBindings.size() + serverBindings.size());
        result.addAll(clientBindings);
        result.addAll(serverBindings);
        return result;
    }

    public static void load() {
        clientBindings = Config.fromEntries(loader.read());
        if (clientBindings.isEmpty()) {
            Config.save(true);
        }
    }

    public static void loadWorldConfig(Path path) {
        if (path == null) {
            return;
        }
        List<ConfigEntry> data = new ConfigLoader(path.toFile()).read();
        serverBindings = Config.fromEntries(data, BindSource.WORLD);
    }

    public static void remove(CommandBinding binding) {
        clientBindings.remove(binding);
    }

    public static void add(CommandBinding binding) {
        clientBindings.add(binding);
    }

    public static void save() {
        Config.save(false);
    }

    public static void save(boolean backup) {
        loader.write(Config.toEntries(clientBindings), backup);
    }

    public static void setServerBindings(List<ConfigEntry> data) {
        serverBindings = Config.fromEntries(data, BindSource.SERVER);
    }

    public static void clearServerBindings() {
        serverBindings = Collections.emptyList();
    }

    private static List<ConfigEntry> toEntries(List<CommandBinding> data) {
        ArrayList<ConfigEntry> result = new ArrayList<ConfigEntry>(data.size());
        for (CommandBinding binding : data) {
            result.add(new ConfigEntry(binding.getTranslationKey(), binding.command));
        }
        return result;
    }

    private static List<CommandBinding> fromEntries(List<ConfigEntry> data) {
        return Config.fromEntries(data, BindSource.CLIENT);
    }

    private static List<CommandBinding> fromEntries(List<ConfigEntry> data, BindSource source) {
        ArrayList<CommandBinding> result = new ArrayList<CommandBinding>(data.size());
        for (ConfigEntry entry : data) {
            String key = entry.key();
            String command = entry.value();
            result.add(new CommandBinding(command, key, source));
        }
        return result;
    }
}

