/*
 * Decompiled with CFR 0.152.
 */
package net.immortaldevs.bindcmd.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.immortaldevs.bindcmd.config.ConfigEntry;

public final class ConfigLoader {
    private static final String CONFIG_DIR = "config";
    private static final String CONFIG_FILE = "config/bind_cmd.ini";
    private static final String CONFIG_BACKUP_FILE = "config/bind_cmd.ini.bak";
    private final File runDirectory;

    public ConfigLoader(File runDirectory) {
        this.runDirectory = runDirectory;
    }

    public List<ConfigEntry> read() {
        List<ConfigEntry> list;
        this.ensureConfigDirExists();
        File file = new File(this.runDirectory, CONFIG_FILE);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return Collections.emptyList();
        }
        FileInputStream stream = new FileInputStream(file);
        try {
            byte[] contentBytes = stream.readAllBytes();
            String content = new String(contentBytes, StandardCharsets.UTF_8);
            list = this.decode(content);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ignored) {
                return Collections.emptyList();
            }
        }
        stream.close();
        return list;
    }

    public void write(List<ConfigEntry> data, boolean backup) {
        this.ensureConfigDirExists();
        String fileName = backup ? CONFIG_BACKUP_FILE : CONFIG_FILE;
        File file = new File(this.runDirectory, fileName);
        String encoded = this.encode(data);
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(encoded.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void ensureConfigDirExists() {
        File configDir = new File(this.runDirectory, CONFIG_DIR);
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
    }

    private List<ConfigEntry> decode(String input) {
        String[] lines = input.split("\n");
        ArrayList<ConfigEntry> data = new ArrayList<ConfigEntry>();
        for (String line : lines) {
            String[] parts = line.split("=\"");
            if (parts.length != 2) continue;
            String translationKey = parts[0];
            String rawCommandPart = parts[1];
            if (rawCommandPart.isEmpty()) continue;
            String command = rawCommandPart.substring(0, rawCommandPart.length() - 1);
            data.add(new ConfigEntry(translationKey, command));
        }
        return data;
    }

    private String encode(List<ConfigEntry> data) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.size(); ++i) {
            ConfigEntry entry = data.get(i);
            sb.append(entry.key()).append("=\"").append(entry.value()).append("\"");
            if (i >= data.size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }
}

