/*
 * Decompiled with CFR 0.152.
 */
package com.furglitch.vendingblock.blockentity;

import com.furglitch.vendingblock.gui.display.DisplayBlockMenu;
import com.furglitch.vendingblock.registry.BlockEntityRegistry;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;

public class DisplayBlockEntity
extends BlockEntity
implements MenuProvider {
    private UUID ownerID;
    private String ownerUser;
    public final ItemStackHandler inventory = new ItemStackHandler(2){

        public void setStackInSlot(int slot, ItemStack stack) {
            if (slot == 0 && !stack.isEmpty() && stack.getCount() > 1) {
                ItemStack dropStack = stack.copy();
                dropStack.setCount(stack.getCount() - 1);
                stack.setCount(1);
                SimpleContainer dropInv = new SimpleContainer(new ItemStack[]{dropStack});
                Containers.dropContents((Level)DisplayBlockEntity.this.level, (BlockPos)DisplayBlockEntity.this.worldPosition, (Container)dropInv);
            }
            super.setStackInSlot(slot, stack);
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            if (slot == 0) {
                return 1;
            }
            return 64;
        }

        protected void onContentsChanged(int slot) {
            DisplayBlockEntity.this.setChanged();
            if (!DisplayBlockEntity.this.level.isClientSide()) {
                DisplayBlockEntity.this.level.sendBlockUpdated(DisplayBlockEntity.this.getBlockPos(), DisplayBlockEntity.this.getBlockState(), DisplayBlockEntity.this.getBlockState(), 3);
                DisplayBlockEntity.this.level.invalidateCapabilities(DisplayBlockEntity.this.getBlockPos());
            }
        }
    };

    public DisplayBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.DISPLAY_BE.get(), pos, state);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"menu.vendingblock.display.settings");
    }

    public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
        return new DisplayBlockMenu(id, inv, this);
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (i == 1) continue;
            inv.setItem(i, this.inventory.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void updateOwnershipInfo(Player player) {
        if (this.ownerUser != null && this.ownerID == null && this.ownerUser.equals(player.getName().getString())) {
            this.ownerID = player.getUUID();
            this.setChanged();
            if (!this.level.isClientSide()) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }
}

