/*
 * Decompiled with CFR 0.152.
 */
package com.furglitch.vendingblock.gui.admin;

import com.furglitch.vendingblock.gui.admin.VendorAdminMenu;
import com.furglitch.vendingblock.gui.components.CustomCheckbox;
import com.furglitch.vendingblock.gui.components.FilterSlot;
import com.furglitch.vendingblock.network.DiscardsPaymentPacket;
import com.furglitch.vendingblock.network.FilterSlotUpdatePacket;
import com.furglitch.vendingblock.network.InfiniteInventoryPacket;
import com.furglitch.vendingblock.network.OwnerChangePacket;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class VendorAdminScreen
extends AbstractContainerScreen<VendorAdminMenu> {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"vendingblock", (String)"textures/gui/container/vendor_admin.png");
    private static final ResourceLocation ARROW = ResourceLocation.fromNamespaceAndPath((String)"vendingblock", (String)"textures/gui/container/slot/arrow.png");
    private static final ResourceLocation FACADE = ResourceLocation.fromNamespaceAndPath((String)"vendingblock", (String)"textures/gui/container/slot/facade.png");
    private EditBox ownerField;
    private String initialOwnerValue;
    private CustomCheckbox infiniteCheckbox;
    private CustomCheckbox discardCheckbox;
    private boolean infiniteInit;
    private boolean discardInit;

    public VendorAdminScreen(VendorAdminMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
    }

    protected void init() {
        super.init();
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.ownerField = new EditBox(this.font, x + 25, y + 16, 90, 18, (Component)Component.translatable((String)"menu.vendingblock.admin.owner"));
        this.ownerField.setMaxLength(32);
        this.ownerField.setBordered(true);
        this.ownerField.setVisible(true);
        this.ownerField.setTextColor(0xFFFFFF);
        this.ownerField.setCanLoseFocus(true);
        this.ownerField.setFocused(false);
        String currentOwner = ((VendorAdminMenu)this.menu).blockEntity.getOwnerUser();
        if (currentOwner != null) {
            this.ownerField.setValue(currentOwner);
            this.initialOwnerValue = currentOwner;
        } else {
            this.initialOwnerValue = "";
        }
        this.addRenderableWidget((GuiEventListener)this.ownerField);
        boolean infiniteStatus = ((VendorAdminMenu)this.menu).blockEntity.isInfinite();
        this.infiniteCheckbox = CustomCheckbox.builder((Component)Component.literal((String)""), this.font).pos(x + 115, y + 16).size(18, 18).selected(infiniteStatus).build();
        this.infiniteCheckbox.setTooltip(Tooltip.create((Component)Component.translatable((String)"menu.vendingblock.tooltip.infinite")));
        this.infiniteInit = infiniteStatus;
        this.addRenderableWidget((GuiEventListener)this.infiniteCheckbox);
        boolean discardStatus = ((VendorAdminMenu)this.menu).blockEntity.isDiscarding();
        this.discardCheckbox = CustomCheckbox.builder((Component)Component.literal((String)""), this.font).pos(x + 133, y + 16).size(18, 18).selected(discardStatus).build();
        this.discardCheckbox.setTooltip(Tooltip.create((Component)Component.translatable((String)"menu.vendingblock.tooltip.discard")));
        this.discardInit = discardStatus;
        this.addRenderableWidget((GuiEventListener)this.discardCheckbox);
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(BACKGROUND, x, y, 0, 0, 176, 166);
        List<FilterSlot> filterSlots = this.getFilterSlots();
        if (this.isSlotEmpty(0, filterSlots)) {
            guiGraphics.blit(ARROW, x + 62, y + 53, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        if (this.isSlotEmpty(10, filterSlots)) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(x + 80 + 8), (float)(y + 53 + 8), 0.0f);
            guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(180.0f));
            guiGraphics.blit(ARROW, -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.pose().popPose();
        }
        if (this.isSlotEmpty(11, filterSlots)) {
            guiGraphics.blit(FACADE, x + 98, y + 53, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
        this.renderFilterSlotTooltips(pGuiGraphics, pMouseX, pMouseY);
    }

    private void renderFilterSlotTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        List<FilterSlot> filterSlots = this.getFilterSlots();
        if (this.isMouseOverSlot(mouseX, mouseY, x + 62, y + 53) && this.isSlotEmpty(0, filterSlots)) {
            MutableComponent tooltip = Component.translatable((String)"menu.vendingblock.tooltip.product");
            guiGraphics.renderTooltip(this.font, (Component)tooltip, mouseX, mouseY);
        } else if (this.isMouseOverSlot(mouseX, mouseY, x + 80, y + 53) && this.isSlotEmpty(10, filterSlots)) {
            MutableComponent tooltip = Component.translatable((String)"menu.vendingblock.tooltip.price");
            guiGraphics.renderTooltip(this.font, (Component)tooltip, mouseX, mouseY);
        } else if (this.isMouseOverSlot(mouseX, mouseY, x + 98, y + 53) && this.isSlotEmpty(11, filterSlots)) {
            MutableComponent tooltip = Component.translatable((String)"menu.vendingblock.tooltip.facade");
            guiGraphics.renderTooltip(this.font, (Component)tooltip, mouseX, mouseY);
        }
    }

    private boolean isSlotEmpty(int slotIndex, List<FilterSlot> filterSlots) {
        for (FilterSlot slot : filterSlots) {
            if (slot.getSlotIndex() != slotIndex) continue;
            return !slot.hasItem();
        }
        return true;
    }

    private boolean isMouseOverSlot(int mouseX, int mouseY, int slotX, int slotY) {
        return mouseX >= slotX && mouseX < slotX + 16 && mouseY >= slotY && mouseY < slotY + 16;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.getFocused() == this.ownerField) {
            if (pKeyCode == 257 || pKeyCode == 335) {
                this.sendOwnerChangeIfChanged();
                return true;
            }
            if (pKeyCode == 256) {
                this.ownerField.setFocused(false);
                this.setFocused(null);
                return super.keyPressed(pKeyCode, pScanCode, pModifiers);
            }
            if (this.ownerField.keyPressed(pKeyCode, pScanCode, pModifiers)) {
                return true;
            }
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        if (this.getFocused() == this.ownerField) {
            return this.ownerField.charTyped(pCodePoint, pModifiers);
        }
        return super.charTyped(pCodePoint, pModifiers);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.ownerField.mouseClicked(pMouseX, pMouseY, pButton)) {
            this.setFocused((GuiEventListener)this.ownerField);
            return true;
        }
        if (this.infiniteCheckbox.mouseClicked(pMouseX, pMouseY, pButton)) {
            return true;
        }
        if (this.getFocused() == this.ownerField) {
            this.ownerField.setFocused(false);
            this.setFocused(null);
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public void setFocused(GuiEventListener pListener) {
        super.setFocused(pListener);
        if (pListener == this.ownerField) {
            this.ownerField.setFocused(true);
        } else if (this.ownerField != null) {
            this.ownerField.setFocused(false);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        this.sendOwnerChangeIfChanged();
        this.sendInfiniteInventoryChangeIfChanged();
        this.sendDiscardsPaymentChangeIfChanged();
        super.onClose();
    }

    private void sendOwnerChangeIfChanged() {
        String newOwner = this.ownerField.getValue().trim();
        if (!newOwner.equals(this.initialOwnerValue)) {
            OwnerChangePacket packet = new OwnerChangePacket(((VendorAdminMenu)this.menu).blockEntity.getBlockPos(), newOwner);
            PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void sendInfiniteInventoryChangeIfChanged() {
        boolean newInfiniteInventory = this.infiniteCheckbox.selected();
        if (newInfiniteInventory != this.infiniteInit) {
            InfiniteInventoryPacket packet = new InfiniteInventoryPacket(((VendorAdminMenu)this.menu).blockEntity.getBlockPos(), newInfiniteInventory);
            PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void sendDiscardsPaymentChangeIfChanged() {
        boolean newDiscardsPayment = this.discardCheckbox.selected();
        if (newDiscardsPayment != this.discardInit) {
            DiscardsPaymentPacket packet = new DiscardsPaymentPacket(((VendorAdminMenu)this.menu).blockEntity.getBlockPos(), newDiscardsPayment);
            PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public List<FilterSlot> getFilterSlots() {
        ArrayList<FilterSlot> filterSlots = new ArrayList<FilterSlot>();
        for (Slot slot : ((VendorAdminMenu)this.menu).slots) {
            if (!(slot instanceof FilterSlot)) continue;
            FilterSlot filterSlot = (FilterSlot)slot;
            filterSlots.add(filterSlot);
        }
        return filterSlots;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double unused, double delta) {
        ItemStack stack;
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        int slot = -1;
        if (this.isMouseOverSlot((int)mouseX, (int)mouseY, x + 62, y + 53)) {
            slot = 0;
        } else if (this.isMouseOverSlot((int)mouseX, (int)mouseY, x + 80, y + 53)) {
            slot = 10;
        }
        if (!(slot != 0 && slot != 10 || (stack = ((VendorAdminMenu)this.menu).blockEntity.inventory.getStackInSlot(slot).copy()).isEmpty())) {
            int newCount = stack.getCount() + (delta < 0.0 ? -1 : 1);
            newCount = Math.max(1, Math.min(newCount, stack.getMaxStackSize()));
            stack.setCount(newCount);
            FilterSlotUpdatePacket packet = new FilterSlotUpdatePacket(((VendorAdminMenu)this.menu).blockEntity.getBlockPos(), slot, stack);
            PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return super.mouseScrolled(mouseX, mouseY, unused, delta);
    }
}

