/*
 * Decompiled with CFR 0.152.
 */
package com.furglitch.vendingblock;

import java.util.Arrays;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class Config {

    public static class Server {
        private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
        public static final ModConfigSpec.EnumValue<BreakLevel> BREAK_LEVEL = BUILDER.comment("Defines who besides the block owner can break the vending block.\n\nSee minecraft.wiki for more information on permission levels.").translation("config.vendingblock.server.breakLevel").defineEnum("breakLevel", (Enum)BreakLevel.GAMEMASTER);
        public static final ModConfigSpec.EnumValue<AnimationMode> ANIMATION_MODE = BUILDER.comment("Animation mode for vending block items\nApplies to all users who have selected 'SERVER_DEFAULT' (default) in their client settings.").translation("config.vendingblock.animation.mode").defineEnum("animationMode", (Enum)AnimationMode.ROTATION);
        public static final ModConfigSpec.ConfigValue<List<? extends String>> PRODUCT_BLACKLIST = BUILDER.comment("List of blacklisted facades\n\nExamples:\n- minecraft:oak_wood\n- stone\n- *stained_glass\n- #minecraft:planks\n- #c:glass_blocks\n\nServer restart required").translation("config.vendingblock.server.productBlacklist").defineListAllowEmpty("productBlacklist", Arrays.asList("vendingblock:vendor_key"), item -> item instanceof String);
        public static final ModConfigSpec.ConfigValue<List<? extends String>> FACADE_BLACKLIST = BUILDER.comment("List of blacklisted facades\n\nExamples:\n- minecraft:oak_wood\n- stone\n- *stained_glass\n- #minecraft:planks\n- #c:glass_blocks\n\nServer restart required").translation("config.vendingblock.server.facadeBlacklist").defineListAllowEmpty("facadeBlacklist", Arrays.asList("*copper_grate", "#c:bookshelves", "#c:glass_blocks", "#minecraft:leaves", "beacon", "cobweb", "glow_lichen", "mangrove_roots", "*piston", "sculk_vein", "vine"), item -> item instanceof String);
        public static final ModConfigSpec.BooleanValue VENDOR_KEY_IN_CREATIVE = BUILDER.comment("Whether the vendor key should appear in the creative mode tab (Server restart required)").translation("config.vendingblock.creative.keyInTab").define("vendorKeyInCreative", true);
        public static final ModConfigSpec SPEC = BUILDER.build();

        public static enum BreakLevel {
            SERVER_OWNER,
            ADMIN,
            GAMEMASTER,
            MODERATOR,
            BLOCK_OWNER_ONLY;

        }

        public static enum AnimationMode {
            STILL,
            BOBBING,
            ROTATION,
            BOBBING_ROTATION,
            FACING_PLAYER;

        }
    }

    public static class Client {
        private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
        public static final ModConfigSpec.EnumValue<AnimationMode> ANIMATION_MODE = BUILDER.comment("Animation mode for vending block items.\n\n'SERVER_DEFAULT' uses the server-side setting, which is 'ROTATION' unless changed by admins.").translation("config.vendingblock.animation.mode").defineEnum("clientAnimationMode", (Enum)AnimationMode.SERVER_DEFAULT);
        public static final ModConfigSpec.BooleanValue PURCHASE_MESSAGES;
        public static final ModConfigSpec.BooleanValue GIVEAWAY_MESSAGES;
        public static final ModConfigSpec.BooleanValue DONATION_MESSAGES;
        public static final ModConfigSpec.BooleanValue OUT_OF_STOCK_MESSAGES;
        public static final ModConfigSpec.BooleanValue FULL_STORAGE_MESSAGES;
        public static final ModConfigSpec SPEC;

        static {
            BUILDER.push("ownerNotifications");
            PURCHASE_MESSAGES = BUILDER.comment("Whether to receive messages when players purchase items from your vending blocks").translation("config.vendingblock.messages.purchase").define("purchaseMessages", true);
            GIVEAWAY_MESSAGES = BUILDER.comment("Whether to receive messages when players take free items from your vending blocks").translation("config.vendingblock.messages.giveaway").define("giveawayMessages", true);
            DONATION_MESSAGES = BUILDER.comment("Whether to receive messages when players donate items to your vending blocks").translation("config.vendingblock.messages.donation").define("donationMessages", true);
            OUT_OF_STOCK_MESSAGES = BUILDER.comment("Whether to receive messages when your vending blocks run out of stock").translation("config.vendingblock.messages.outOfStock").define("outOfStockMessages", true);
            FULL_STORAGE_MESSAGES = BUILDER.comment("Whether to receive messages when your vending blocks' storage becomes full").translation("config.vendingblock.messages.fullStorage").define("fullStorageMessages", true);
            BUILDER.pop();
            SPEC = BUILDER.build();
        }

        public static enum AnimationMode {
            SERVER_DEFAULT,
            STILL,
            BOBBING,
            ROTATION,
            BOBBING_ROTATION,
            FACING_PLAYER;

        }
    }
}

