/*
 * Decompiled with CFR 0.152.
 */
package com.furglitch.vendingblock.gui.hud;

import com.furglitch.vendingblock.blockentity.VendorBlockEntity;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

public class HintOverlay {
    private static final int ColorBCK = -1072294378;
    private static final int ColorBDR = -803858922;
    private static final int ColorTXT = -1;
    private static Component sellItemText = Component.literal((String)"");
    private static Component buyItemText = Component.literal((String)"");
    private static Component errorText = Component.literal((String)"");
    private static int saleType = 0;

    @SubscribeEvent
    public static void onRenderGUI(RenderGuiEvent.Post event) {
        if (ModList.get().isLoaded("jade")) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        HitResult hit = mc.hitResult;
        if (hit == null || hit.getType() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult blockHit = (BlockHitResult)hit;
        BlockEntity blockEntity = mc.level.getBlockEntity(blockHit.getBlockPos());
        if (!(blockEntity instanceof VendorBlockEntity)) {
            return;
        }
        VendorBlockEntity entity = (VendorBlockEntity)blockEntity;
        HintOverlay.renderHint(event.getGuiGraphics(), entity, mc);
    }

    private static void renderHint(GuiGraphics gui, VendorBlockEntity entity, Minecraft mc) {
        ItemStack sellItem = entity.inventory.getStackInSlot(0);
        ItemStack buyItem = entity.inventory.getStackInSlot(10);
        if (sellItem.isEmpty() && buyItem.isEmpty()) {
            return;
        }
        switch ((sellItem.isEmpty() ? 0 : 1) << 1 | (buyItem.isEmpty() ? 0 : 1)) {
            case 3: {
                saleType = 1;
                break;
            }
            case 2: {
                saleType = 2;
                break;
            }
            case 1: {
                saleType = 3;
                break;
            }
            default: {
                saleType = 0;
            }
        }
        if (entity.hasError) {
            errorText = HintOverlay.getErrorString(entity.errorCode);
        }
        String string = entity.getOwnerUser();
        Objects.requireNonNull(mc.font);
        HintDimensions dimensions = HintOverlay.calculateDimensions(mc, string, sellItem, buyItem, saleType, 9 + 4, entity.hasError);
        int margin = 8;
        int w = dimensions.width + margin * 2;
        int h = dimensions.height + margin * 2;
        int x = (mc.getWindow().getGuiScaledWidth() - w) / 2;
        int y = 8;
        String string2 = entity.getOwnerUser();
        Objects.requireNonNull(mc.font);
        HintOverlay.renderContent(gui, mc, string2, sellItem, buyItem, x, y + margin, w, 9 + 4, entity.hasError);
        HintOverlay.drawBackground(gui, x, y, w, h);
    }

    private static HintDimensions calculateDimensions(Minecraft mc, String owner, ItemStack sellItem, ItemStack buyItem, int saleType, int lineHeight, boolean error) {
        int maxWidth = 0;
        int totalHeight = 0;
        maxWidth = Math.max(maxWidth, mc.font.width(owner));
        totalHeight += lineHeight;
        switch (saleType) {
            case 1: {
                sellItemText = Component.translatable((String)"hint.vendingblock.sell");
                buyItemText = Component.translatable((String)"hint.vendingblock.buy");
                maxWidth = Math.max(maxWidth, mc.font.width(sellItemText.getString()));
                maxWidth = Math.max(maxWidth, mc.font.width(buyItemText.getString()));
                maxWidth = Math.max(maxWidth, HintOverlay.calculateItemDimensions((Minecraft)mc, (ItemStack)buyItem).width);
                maxWidth = Math.max(maxWidth, HintOverlay.calculateItemDimensions((Minecraft)mc, (ItemStack)sellItem).width);
                totalHeight = (int)((double)totalHeight + (double)lineHeight * 4.2);
                break;
            }
            case 2: {
                sellItemText = Component.translatable((String)"hint.vendingblock.giveaway");
                maxWidth = Math.max(maxWidth, mc.font.width(sellItemText.getString()));
                maxWidth = Math.max(maxWidth, HintOverlay.calculateItemDimensions((Minecraft)mc, (ItemStack)sellItem).width);
                totalHeight = (int)((double)totalHeight + (double)lineHeight * 2.1);
                break;
            }
            case 3: {
                buyItemText = Component.translatable((String)"hint.vendingblock.request");
                maxWidth = Math.max(maxWidth, mc.font.width(buyItemText.getString()));
                maxWidth = Math.max(maxWidth, HintOverlay.calculateItemDimensions((Minecraft)mc, (ItemStack)buyItem).width);
                totalHeight = (int)((double)totalHeight + (double)lineHeight * 2.1);
            }
        }
        if (error) {
            maxWidth = Math.max(maxWidth, mc.font.width(errorText.getString()));
            totalHeight += lineHeight / 2;
        }
        return new HintDimensions(maxWidth, totalHeight);
    }

    private static ItemDimensions calculateItemDimensions(Minecraft mc, ItemStack item) {
        String itemText = HintOverlay.formatItemText(item);
        int width = 20 + mc.font.width(itemText);
        return new ItemDimensions(width);
    }

    private static String formatItemText(ItemStack item) {
        Component itemName = item.getHoverName();
        return item.getCount() > 1 ? itemName.getString() + " x" + item.getCount() : itemName.getString();
    }

    private static void drawBackground(GuiGraphics gui, int x, int y, int w, int h) {
        gui.fill(x, y, x + w, y + h, -1072294378);
        gui.fill(x, y, x + w, y + 1, -803858922);
        gui.fill(x, y + h - 1, x + w, y + h, -803858922);
        gui.fill(x, y, x + 1, y + h, -803858922);
        gui.fill(x + w - 1, y, x + w, y + h, -803858922);
    }

    public static void renderContent(GuiGraphics gui, Minecraft mc, String owner, ItemStack sellItem, ItemStack buyItem, int x, int y, int w, int h, boolean error) {
        HintOverlay.drawText(gui, mc, owner, x, y, w, -1);
        y += h;
        switch (saleType) {
            case 1: {
                HintOverlay.drawText(gui, mc, sellItemText.getString(), x, y, w, -2130706433);
                y = (int)((double)y + (double)h * 1.2);
                HintOverlay.drawText(gui, mc, sellItem, x, y, w, -1);
                HintOverlay.drawText(gui, mc, buyItemText.getString(), x, y += h, w, -2130706433);
                y = (int)((double)y + (double)h * 1.2);
                HintOverlay.drawText(gui, mc, buyItem, x, y, w, -1);
                if (!error) break;
                HintOverlay.drawText(gui, mc, errorText.getString(), x, y += h, w, -4572100);
                break;
            }
            case 2: {
                HintOverlay.drawText(gui, mc, sellItemText.getString(), x, y, w, -2130706433);
                y = (int)((double)y + (double)h * 1.2);
                HintOverlay.drawText(gui, mc, sellItem, x, y, w, -1);
                if (!error) break;
                HintOverlay.drawText(gui, mc, errorText.getString(), x, y += h, w, -4572100);
                break;
            }
            case 3: {
                HintOverlay.drawText(gui, mc, buyItemText.getString(), x, y, w, -2130706433);
                y = (int)((double)y + (double)h * 1.2);
                HintOverlay.drawText(gui, mc, buyItem, x, y, w, -1);
                if (!error) break;
                HintOverlay.drawText(gui, mc, errorText.getString(), x, y += h, w, -4572100);
                break;
            }
            case 0: {
                if (!error) break;
                HintOverlay.drawText(gui, mc, errorText.getString(), x, y, w, -4572100);
            }
        }
    }

    private static void drawText(GuiGraphics gui, Minecraft mc, String text, int x, int y, int w, int color) {
        int txtW = mc.font.width(text);
        int txtX = x + (w - txtW) / 2;
        gui.drawString(mc.font, text, txtX, y, color);
    }

    private static void drawText(GuiGraphics gui, Minecraft mc, ItemStack item, int x, int y, int w, int color) {
        String text = HintOverlay.formatItemText(item);
        int txtW = mc.font.width(text);
        int totW = 20 + txtW;
        int txtX = x + (w - totW) / 2;
        gui.renderItem(item, txtX, y - 5);
        gui.drawString(mc.font, text, txtX + 20, y, color);
    }

    public static Component getErrorString(int code) {
        if (code == 1) {
            return Component.translatable((String)"hint.vendingblock.error.sold");
        }
        if (code == 2) {
            return Component.translatable((String)"hint.vendingblock.error.full");
        }
        if (code == 3) {
            return Component.translatable((String)"hint.vendingblock.error.empty");
        }
        return Component.literal((String)"");
    }

    private static class HintDimensions {
        final int width;
        final int height;

        HintDimensions(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }

    private static class ItemDimensions {
        final int width;

        ItemDimensions(int width) {
            this.width = width;
        }
    }
}

