/*
 * Decompiled with CFR 0.152.
 */
package com.furglitch.vendingblock.gui.trade;

import com.furglitch.vendingblock.gui.components.FilterSlot;
import com.furglitch.vendingblock.gui.trade.VendorBlockMenu;
import com.furglitch.vendingblock.network.FilterSlotUpdatePacket;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class VendorBlockScreen
extends AbstractContainerScreen<VendorBlockMenu> {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"vendingblock", (String)"textures/gui/container/vendor_trade.png");
    private static final ResourceLocation ARROW = ResourceLocation.fromNamespaceAndPath((String)"vendingblock", (String)"textures/gui/container/slot/arrow.png");
    private static final ResourceLocation FACADE = ResourceLocation.fromNamespaceAndPath((String)"vendingblock", (String)"textures/gui/container/slot/facade.png");

    public VendorBlockScreen(VendorBlockMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(BACKGROUND, x, y, 0, 0, 176, 166);
        List<FilterSlot> filterSlots = this.getFilterSlots();
        if (this.isSlotEmpty(0, filterSlots)) {
            guiGraphics.blit(ARROW, x + 26, y + 17, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        if (this.isSlotEmpty(10, filterSlots)) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(x + 26 + 8), (float)(y + 53 + 8), 0.0f);
            guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(180.0f));
            guiGraphics.blit(ARROW, -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.pose().popPose();
        }
        if (this.isSlotEmpty(11, filterSlots)) {
            guiGraphics.blit(FACADE, x + 134, y + 17, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
        this.renderFilterSlotTooltips(pGuiGraphics, pMouseX, pMouseY);
    }

    private void renderFilterSlotTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        List<FilterSlot> filterSlots = this.getFilterSlots();
        if (this.isMouseOverSlot(mouseX, mouseY, x + 26, y + 17) && this.isSlotEmpty(0, filterSlots)) {
            MutableComponent tooltip = Component.translatable((String)"menu.vendingblock.tooltip.product");
            guiGraphics.renderTooltip(this.font, (Component)tooltip, mouseX, mouseY);
        } else if (this.isMouseOverSlot(mouseX, mouseY, x + 26, y + 53) && this.isSlotEmpty(10, filterSlots)) {
            MutableComponent tooltip = Component.translatable((String)"menu.vendingblock.tooltip.price");
            guiGraphics.renderTooltip(this.font, (Component)tooltip, mouseX, mouseY);
        } else if (this.isMouseOverSlot(mouseX, mouseY, x + 134, y + 17) && this.isSlotEmpty(11, filterSlots)) {
            MutableComponent tooltip = Component.translatable((String)"menu.vendingblock.tooltip.facade");
            guiGraphics.renderTooltip(this.font, (Component)tooltip, mouseX, mouseY);
        }
    }

    private boolean isSlotEmpty(int slotIndex, List<FilterSlot> filterSlots) {
        for (FilterSlot slot : filterSlots) {
            if (slot.getSlotIndex() != slotIndex) continue;
            return !slot.hasItem();
        }
        return true;
    }

    private boolean isMouseOverSlot(int mouseX, int mouseY, int slotX, int slotY) {
        return mouseX >= slotX && mouseX < slotX + 16 && mouseY >= slotY && mouseY < slotY + 16;
    }

    public List<FilterSlot> getFilterSlots() {
        ArrayList<FilterSlot> filterSlots = new ArrayList<FilterSlot>();
        for (Slot slot : ((VendorBlockMenu)this.menu).slots) {
            if (!(slot instanceof FilterSlot)) continue;
            FilterSlot filterSlot = (FilterSlot)slot;
            filterSlots.add(filterSlot);
        }
        return filterSlots;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double unused, double delta) {
        ItemStack stack;
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        int slot = -1;
        if (this.isMouseOverSlot((int)mouseX, (int)mouseY, x + 26, y + 17)) {
            slot = 0;
        } else if (this.isMouseOverSlot((int)mouseX, (int)mouseY, x + 26, y + 53)) {
            slot = 10;
        }
        if (!(slot != 0 && slot != 10 || (stack = ((VendorBlockMenu)this.menu).blockEntity.inventory.getStackInSlot(slot).copy()).isEmpty())) {
            int newCount = stack.getCount() + (delta < 0.0 ? -1 : 1);
            newCount = Math.max(1, Math.min(newCount, stack.getMaxStackSize()));
            stack.setCount(newCount);
            FilterSlotUpdatePacket packet = new FilterSlotUpdatePacket(((VendorBlockMenu)this.menu).blockEntity.getBlockPos(), slot, stack);
            PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return super.mouseScrolled(mouseX, mouseY, unused, delta);
    }
}

