/*
 * Decompiled with CFR 0.152.
 */
package com.furglitch.vendingblock.blockentity;

import com.furglitch.vendingblock.blockentity.transaction.VendorBlockInventory;
import com.furglitch.vendingblock.gui.trade.VendorBlockMenu;
import com.furglitch.vendingblock.registry.BlockEntityRegistry;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class VendorBlockEntity
extends BlockEntity
implements MenuProvider {
    private UUID ownerID;
    private String ownerUser;
    public boolean infiniteInventory = false;
    public boolean hasError = false;
    public int errorCode = 0;
    public final ItemStackHandler inventory = new ItemStackHandler(12){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 64;
        }

        protected void onContentsChanged(int slot) {
            VendorBlockEntity.this.setChanged();
            if (!VendorBlockEntity.this.level.isClientSide()) {
                VendorBlockEntity.this.level.sendBlockUpdated(VendorBlockEntity.this.getBlockPos(), VendorBlockEntity.this.getBlockState(), VendorBlockEntity.this.getBlockState(), 3);
                VendorBlockEntity.this.level.invalidateCapabilities(VendorBlockEntity.this.getBlockPos());
                VendorBlockEntity.this.checkErrorState();
            }
        }
    };
    private final IItemHandler insertItemHandler = new IItemHandler(){

        public int getSlots() {
            return 9;
        }

        public ItemStack getStackInSlot(int slot) {
            return VendorBlockEntity.this.inventory.getStackInSlot(slot + 1);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return VendorBlockEntity.this.inventory.insertItem(slot + 1, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return VendorBlockEntity.this.inventory.getSlotLimit(slot + 1);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return VendorBlockEntity.this.inventory.isItemValid(slot + 1, stack);
        }
    };
    private final IItemHandler extractItemHandler = new IItemHandler(){

        public int getSlots() {
            return 9;
        }

        public ItemStack getStackInSlot(int slot) {
            return VendorBlockEntity.this.inventory.getStackInSlot(slot + 1);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack slotStack = VendorBlockEntity.this.inventory.getStackInSlot(slot + 1);
            if (slotStack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            ItemStack productTemplate = VendorBlockEntity.this.inventory.getStackInSlot(0);
            if (!productTemplate.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)productTemplate)) {
                return ItemStack.EMPTY;
            }
            return VendorBlockEntity.this.inventory.extractItem(slot + 1, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return VendorBlockEntity.this.inventory.getSlotLimit(slot + 1);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }
    };
    private final IItemHandler emptyItemHandler = new IItemHandler(this){

        public int getSlots() {
            return 0;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.EMPTY;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return 0;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }
    };

    public VendorBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.VENDOR_BE.get(), pos, state);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"menu.vendingblock.settings");
    }

    public void clearContents() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
        }
        this.setChanged();
    }

    public void setFilterContents(int type, ItemStack stack) {
        if (type == 1) {
            this.inventory.setStackInSlot(0, stack);
        } else if (type == 2) {
            this.inventory.setStackInSlot(10, stack);
        } else if (type == 3) {
            this.inventory.setStackInSlot(11, stack);
        }
    }

    public void getFilterContents(int type) {
        if (type == 1) {
            this.inventory.getStackInSlot(0);
        } else if (type == 2) {
            this.inventory.getStackInSlot(10);
        } else if (type == 3) {
            this.inventory.getStackInSlot(11);
        }
    }

    public IItemHandler getInsertItemHandler() {
        return this.insertItemHandler;
    }

    public IItemHandler getExtractItemHandler() {
        return this.extractItemHandler;
    }

    public IItemHandler getPublicItemHandler() {
        return this.emptyItemHandler;
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (i == 0 || i == 10 || i == 11) continue;
            inv.setItem(i, this.inventory.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    public void setOwner(Player player) {
        this.ownerID = player.getUUID();
        this.ownerUser = player.getName().getString();
        this.setChanged();
        if (!this.level.isClientSide()) {
            this.checkErrorState();
        }
    }

    public void setOwnerByUsername(String username) {
        ServerPlayer player = null;
        if (this.level != null && this.level.getServer() != null) {
            player = this.level.getServer().getPlayerList().getPlayerByName(username);
        }
        if (player != null) {
            this.ownerID = player.getUUID();
            this.ownerUser = player.getName().getString();
        } else if (this.ownerUser == null || !this.ownerUser.equals(username)) {
            this.ownerID = null;
            this.ownerUser = username;
        }
        this.setChanged();
        if (!this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            this.checkErrorState();
        }
    }

    public void updateOwnershipInfo(Player player) {
        if (this.ownerUser != null && this.ownerID == null && this.ownerUser.equals(player.getName().getString())) {
            this.ownerID = player.getUUID();
            this.setChanged();
            if (!this.level.isClientSide()) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
                this.checkErrorState();
            }
        }
    }

    public UUID getOwnerID() {
        return this.ownerID;
    }

    public String getOwnerUser() {
        return this.ownerUser;
    }

    public boolean hasOwner() {
        return this.ownerID != null || this.ownerUser != null;
    }

    public boolean isOwner(Player player) {
        if (this.ownerID != null && this.ownerID.equals(player.getUUID())) {
            return true;
        }
        if (this.ownerUser != null && this.ownerUser.equals(player.getName().getString())) {
            this.ownerID = player.getUUID();
            this.setChanged();
            return true;
        }
        return false;
    }

    public void setInfinite(boolean infiniteInventory) {
        this.infiniteInventory = infiniteInventory;
        this.setChanged();
        if (!this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            this.checkErrorState();
        }
    }

    public boolean isInfinite() {
        return this.infiniteInventory;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
        if (this.ownerID != null) {
            tag.putUUID("ownerID", this.ownerID);
        }
        if (this.ownerUser != null) {
            tag.putString("ownerUser", this.ownerUser);
        }
        tag.putBoolean("hasError", this.hasError);
        tag.putInt("errorCode", this.errorCode);
        tag.putBoolean("infiniteInventory", this.infiniteInventory);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
        if (tag.hasUUID("ownerID")) {
            this.ownerID = tag.getUUID("ownerID");
        }
        if (tag.contains("ownerUser")) {
            this.ownerUser = tag.getString("ownerUser");
        }
        if (tag.contains("hasError")) {
            this.hasError = tag.getBoolean("hasError");
        }
        if (tag.contains("errorCode")) {
            this.errorCode = tag.getInt("errorCode");
        }
        this.infiniteInventory = tag.getBoolean("infiniteInventory");
        if (this.level != null && !this.level.isClientSide()) {
            this.checkErrorState();
        }
    }

    public AbstractContainerMenu createMenu(int i, Inventory inv, Player player) {
        return new VendorBlockMenu(i, inv, this);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    public void checkErrorState() {
        ItemStack product = this.inventory.getStackInSlot(0);
        ItemStack price = this.inventory.getStackInSlot(10);
        boolean blockHasStock = VendorBlockInventory.checkStock(this, product);
        boolean blockHasSpace = VendorBlockInventory.checkStockSpace(this, product, price);
        this.updateErrorState(blockHasStock, blockHasSpace, product, price);
    }

    public void updateErrorState(boolean blockHasStock, boolean blockHasSpace, ItemStack product, ItemStack price) {
        this.hasError = false;
        this.errorCode = 0;
        if (product.isEmpty() && price.isEmpty()) {
            this.hasError = true;
            this.errorCode = 3;
        } else if (!blockHasStock) {
            this.hasError = true;
            this.errorCode = 1;
        } else if (!blockHasSpace) {
            this.hasError = true;
            this.errorCode = 2;
        }
        this.setChanged();
        if (!this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }
}

