/*
 * Decompiled with CFR 0.152.
 */
package com.furglitch.vendingblock.blockentity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.joml.Matrix4f;

public class VendorBlockBaseRenderer {
    private static final float TEXTURE_STRETCH = -1.0E-4f;

    public void renderTextureOverlay(Block block, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Level level, BlockPos pos) {
        ResourceLocation blockID = BuiltInRegistries.BLOCK.getKey((Object)block);
        ResourceLocation atlasLoc = ResourceLocation.withDefaultNamespace((String)"textures/atlas/blocks.png");
        TextureAtlasSprite sprite = this.getBlockTexture(blockID, Minecraft.getInstance().getModelManager().getAtlas(atlasLoc));
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.cutout());
        poseStack.pushPose();
        int tintColor = this.getBiomeColor(block, level, pos);
        this.renderCube(poseStack, vertexConsumer, 1.0E-4f, -1.0E-4f, -1.0E-4f, 1.0001f, 0.1251f, 1.0001f, sprite, packedLight, packedOverlay, tintColor);
        poseStack.popPose();
    }

    private void renderCube(PoseStack poseStack, VertexConsumer vertexConsumer, float x1, float y1, float z1, float x2, float y2, float z2, TextureAtlasSprite sprite, int packedLight, int packedOverlay, int tintColor) {
        Matrix4f matrix = poseStack.last().pose();
        float heightRatio = (y2 - y1) / 1.0f;
        float uMin = sprite.getU0() - -1.0E-4f;
        float uMax = sprite.getU1() + -1.0E-4f;
        float vMinStretched = sprite.getV1() - (sprite.getV1() - sprite.getV0()) * heightRatio - -1.0E-4f;
        float vMaxStretched = sprite.getV1() + -1.0E-4f;
        float vTopMin = sprite.getV0() - -1.0E-4f;
        float vTopMax = sprite.getV1() + -1.0E-4f;
        int red = tintColor >> 16 & 0xFF;
        int green = tintColor >> 8 & 0xFF;
        int blue = tintColor & 0xFF;
        this.addVertex(matrix, vertexConsumer, x1, y1, z1, uMin, vTopMin, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x2, y1, z1, uMax, vTopMin, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x2, y1, z2, uMax, vTopMax, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x1, y1, z2, uMin, vTopMax, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x1, y2, z2 + -2.0E-4f, uMin, vTopMax, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x2, y2, z2 + -2.0E-4f, uMax, vTopMax, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x2, y2, z1 + -2.0E-4f, uMax, vTopMin, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x1, y2, z1 + -2.0E-4f, uMin, vTopMin, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x1, y1, z1, uMax, vMaxStretched, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x1, y2, z1, uMax, vMinStretched, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x2, y2, z1, uMin, vMinStretched, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x2, y1, z1, uMin, vMaxStretched, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x2, y1, z2, uMax, vMaxStretched, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x2, y2, z2, uMax, vMinStretched, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x1, y2, z2, uMin, vMinStretched, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x1, y1, z2, uMin, vMaxStretched, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x1 + -2.0E-4f, y1, z2, uMax, vMaxStretched, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x1 + -2.0E-4f, y2, z2, uMax, vMinStretched, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x1 + -2.0E-4f, y2, z1, uMin, vMinStretched, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x1 + -2.0E-4f, y1, z1, uMin, vMaxStretched, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x2, y1, z1, uMax, vMaxStretched, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x2, y2, z1, uMax, vMinStretched, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x2, y2, z2, uMin, vMinStretched, packedLight, packedOverlay, red, green, blue);
        this.addVertex(matrix, vertexConsumer, x2, y1, z2, uMin, vMaxStretched, packedLight, packedOverlay, red, green, blue);
    }

    private void addVertex(Matrix4f matrix, VertexConsumer vertexConsumer, float x, float y, float z, float u, float v, int packedLight, int packedOverlay, int red, int green, int blue) {
        vertexConsumer.addVertex(matrix, x, y, z).setColor(red, green, blue, 255).setUv(u, v).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
    }

    private TextureAtlasSprite getBlockTexture(ResourceLocation blockID, TextureAtlas atlas) {
        String[] texturePatterns;
        for (String pattern : texturePatterns = new String[]{"block/" + blockID.getPath(), "block/" + blockID.getPath() + "_top", "block/" + blockID.getPath() + "_side", "block/" + blockID.getPath() + "_back", "block/" + blockID.getPath() + "_front", "block/" + blockID.getPath() + "_0", "block/" + blockID.getPath() + "_still", "block/" + blockID.getPath() + "_on", "block/" + blockID.getPath() + "_active"}) {
            ResourceLocation textureLoc = ResourceLocation.fromNamespaceAndPath((String)blockID.getNamespace(), (String)pattern);
            TextureAtlasSprite sprite = atlas.getSprite(textureLoc);
            if (sprite.contents().name().getPath().contains("missingno")) continue;
            return sprite;
        }
        ResourceLocation fallbackLoc = ResourceLocation.fromNamespaceAndPath((String)blockID.getNamespace(), (String)("block/" + blockID.getPath()));
        return atlas.getSprite(fallbackLoc);
    }

    private int getBiomeColor(Block block, Level level, BlockPos pos) {
        if (level == null) {
            return 0xFFFFFF;
        }
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)block);
        String blockPath = blockId.getPath();
        if (blockPath.contains("grass_block") || blockPath.contains("grass")) {
            return Minecraft.getInstance().getBlockColors().getColor(block.defaultBlockState(), (BlockAndTintGetter)level, pos, 0);
        }
        if (blockPath.contains("leaves")) {
            return Minecraft.getInstance().getBlockColors().getColor(block.defaultBlockState(), (BlockAndTintGetter)level, pos, 0);
        }
        return 0xFFFFFF;
    }
}

