/*
 * Decompiled with CFR 0.152.
 */
package com.furglitch.vendingblock.gui.admin;

import com.furglitch.vendingblock.gui.admin.VendorAdminMenu;
import com.furglitch.vendingblock.gui.components.CustomCheckbox;
import com.furglitch.vendingblock.gui.components.FilterSlot;
import com.furglitch.vendingblock.network.InfiniteInventoryPacket;
import com.furglitch.vendingblock.network.OwnerChangePacket;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.network.PacketDistributor;

public class VendorAdminScreen
extends AbstractContainerScreen<VendorAdminMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"vendingblock", (String)"textures/gui/vendingblock/admin.png");
    private EditBox ownerField;
    private String initialOwnerValue;
    private CustomCheckbox infiniteCheckbox;
    private boolean infiniteInit;

    public VendorAdminScreen(VendorAdminMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
    }

    protected void init() {
        super.init();
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.ownerField = new EditBox(this.font, x + 43, y + 16, 90, 18, (Component)Component.translatable((String)"menu.vendingblock.admin.owner"));
        this.ownerField.setMaxLength(32);
        this.ownerField.setBordered(true);
        this.ownerField.setVisible(true);
        this.ownerField.setTextColor(0xFFFFFF);
        this.ownerField.setCanLoseFocus(true);
        this.ownerField.setFocused(false);
        String currentOwner = ((VendorAdminMenu)this.menu).blockEntity.getOwnerUser();
        if (currentOwner != null) {
            this.ownerField.setValue(currentOwner);
            this.initialOwnerValue = currentOwner;
        } else {
            this.initialOwnerValue = "";
        }
        this.addRenderableWidget((GuiEventListener)this.ownerField);
        boolean infiniteStatus = ((VendorAdminMenu)this.menu).blockEntity.isInfinite();
        MutableComponent infiniteLabel = Component.translatable((String)"menu.vendingblock.admin.infinite");
        int checkboxSize = CustomCheckbox.checkboxSize;
        int spacing = 4;
        int labelWidth = this.font.width((FormattedText)infiniteLabel);
        int totalWidth = checkboxSize + spacing + labelWidth;
        int centeredX = (this.width - totalWidth) / 2;
        this.infiniteCheckbox = CustomCheckbox.customBuilder((Component)infiniteLabel, this.font).pos(centeredX, y + 39).selected(infiniteStatus).build();
        this.infiniteInit = infiniteStatus;
        this.addRenderableWidget((GuiEventListener)this.infiniteCheckbox);
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, 176, 166);
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.getFocused() == this.ownerField) {
            if (pKeyCode == 257 || pKeyCode == 335) {
                this.sendOwnerChangeIfChanged();
                return true;
            }
            if (pKeyCode == 256) {
                this.ownerField.setFocused(false);
                this.setFocused(null);
                return super.keyPressed(pKeyCode, pScanCode, pModifiers);
            }
            if (this.ownerField.keyPressed(pKeyCode, pScanCode, pModifiers)) {
                return true;
            }
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        if (this.getFocused() == this.ownerField) {
            return this.ownerField.charTyped(pCodePoint, pModifiers);
        }
        return super.charTyped(pCodePoint, pModifiers);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.ownerField.mouseClicked(pMouseX, pMouseY, pButton)) {
            this.setFocused((GuiEventListener)this.ownerField);
            return true;
        }
        if (this.infiniteCheckbox.mouseClicked(pMouseX, pMouseY, pButton)) {
            return true;
        }
        if (this.getFocused() == this.ownerField) {
            this.ownerField.setFocused(false);
            this.setFocused(null);
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public void setFocused(GuiEventListener pListener) {
        super.setFocused(pListener);
        if (pListener == this.ownerField) {
            this.ownerField.setFocused(true);
        } else if (this.ownerField != null) {
            this.ownerField.setFocused(false);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        this.sendOwnerChangeIfChanged();
        this.sendInfiniteInventoryChangeIfChanged();
        super.onClose();
    }

    private void sendOwnerChangeIfChanged() {
        String newOwner = this.ownerField.getValue().trim();
        if (!newOwner.equals(this.initialOwnerValue)) {
            OwnerChangePacket packet = new OwnerChangePacket(((VendorAdminMenu)this.menu).blockEntity.getBlockPos(), newOwner);
            PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void sendInfiniteInventoryChangeIfChanged() {
        boolean newInfiniteInventory = this.infiniteCheckbox.selected();
        if (newInfiniteInventory != this.infiniteInit) {
            InfiniteInventoryPacket packet = new InfiniteInventoryPacket(((VendorAdminMenu)this.menu).blockEntity.getBlockPos(), newInfiniteInventory);
            PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public List<FilterSlot> getFilterSlots() {
        ArrayList<FilterSlot> filterSlots = new ArrayList<FilterSlot>();
        for (Slot slot : ((VendorAdminMenu)this.menu).slots) {
            if (!(slot instanceof FilterSlot)) continue;
            FilterSlot filterSlot = (FilterSlot)slot;
            filterSlots.add(filterSlot);
        }
        return filterSlots;
    }
}

