/*
 * Decompiled with CFR 0.152.
 */
package com.furglitch.vendingblock.gui.components;

import com.furglitch.vendingblock.Config;
import com.furglitch.vendingblock.blockentity.VendorBlockEntity;
import com.furglitch.vendingblock.gui.chat.Messages;
import com.furglitch.vendingblock.network.FilterSlotUpdatePacket;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class FilterSlot
extends SlotItemHandler {
    private final VendorBlockEntity blockEntity;
    private final int slotIndex;
    private boolean triggeredByClick = false;

    public FilterSlot(IItemHandler handler, int index, int x, int y, VendorBlockEntity vendor) {
        super(handler, index, x, y);
        this.blockEntity = vendor;
        this.slotIndex = index;
    }

    public void set(ItemStack stack) {
        if (!stack.isEmpty()) {
            if (this.slotIndex == 11 && !this.isFullBlock(stack)) {
                return;
            }
            ItemStack filter = stack.copy();
            if (this.slotIndex == 11) {
                filter.setCount(1);
            }
            super.set(filter);
            if (this.slotIndex == 0) {
                this.blockEntity.setFilterContents(1, filter);
            } else if (this.slotIndex == 10) {
                this.blockEntity.setFilterContents(2, filter);
            } else if (this.slotIndex == 11) {
                this.blockEntity.setFilterContents(3, filter);
            }
            if (!this.triggeredByClick && this.blockEntity.getLevel() != null && this.blockEntity.getLevel().isClientSide()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new FilterSlotUpdatePacket(this.blockEntity.getBlockPos(), this.slotIndex, filter), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        } else {
            super.set(ItemStack.EMPTY);
            if (this.slotIndex == 0) {
                this.blockEntity.setFilterContents(1, ItemStack.EMPTY);
            } else if (this.slotIndex == 10) {
                this.blockEntity.setFilterContents(2, ItemStack.EMPTY);
            } else if (this.slotIndex == 11) {
                this.blockEntity.setFilterContents(3, ItemStack.EMPTY);
            }
            if (!this.triggeredByClick && this.blockEntity.getLevel() != null && this.blockEntity.getLevel().isClientSide()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new FilterSlotUpdatePacket(this.blockEntity.getBlockPos(), this.slotIndex, ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    private boolean isFullBlock(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        Block block = blockItem.getBlock();
        BlockState state = block.defaultBlockState();
        VoxelShape shape = state.getShape(null, null);
        VoxelShape fullCube = Shapes.block();
        return shape.equals(fullCube);
    }

    private boolean isBlacklisted(ItemStack stack) {
        Item item = stack.getItem();
        String itemId = item.toString();
        List blacklist = (List)Config.Server.PRODUCT_BLACKLIST.get();
        if (blacklist.contains(itemId)) {
            BlockPos pos = this.blockEntity.getBlockPos();
            Player player = this.blockEntity.getLevel().getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 100.0, false);
            if (player != null && !this.blockEntity.getLevel().isClientSide()) {
                player.sendSystemMessage(Messages.blacklisted(stack.getHoverName().getString()));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onClick(ItemStack cursorStack, boolean leftClick) {
        this.triggeredByClick = true;
        try {
            if (leftClick) {
                if (cursorStack.isEmpty()) {
                    this.set(ItemStack.EMPTY);
                } else {
                    if (this.slotIndex == 11 && !this.isFullBlock(cursorStack)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (this.isBlacklisted(cursorStack)) {
                        boolean bl = false;
                        return bl;
                    }
                    ItemStack slotStack = cursorStack.copy();
                    if (this.slotIndex == 11) {
                        slotStack.setCount(1);
                    } else {
                        slotStack.setCount(cursorStack.getCount());
                    }
                    this.set(slotStack);
                }
                boolean slotStack = true;
                return slotStack;
            }
            if (cursorStack.isEmpty()) {
                this.set(ItemStack.EMPTY);
            } else {
                if (this.slotIndex == 11 && !this.isFullBlock(cursorStack)) {
                    boolean slotStack = false;
                    return slotStack;
                }
                if (this.isBlacklisted(cursorStack)) {
                    boolean slotStack = false;
                    return slotStack;
                }
                ItemStack slotStack = cursorStack.copy();
                if (this.slotIndex == 11 || cursorStack.getItem() != this.getItem().getItem()) {
                    slotStack.setCount(1);
                } else {
                    slotStack.setCount(this.getItem().getCount() + 1);
                }
                this.set(slotStack);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.triggeredByClick = false;
        }
    }

    public void onTake(Player player, ItemStack stack) {
    }

    public ItemStack remove(int amount) {
        return ItemStack.EMPTY;
    }

    public boolean mayPickup(Player player) {
        return false;
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }
}

